/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.schedule;

import java.io.Serializable;
import java.time.LocalDateTime;
import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewScoped;
import javax.inject.Named;
import org.primefaces.event.ScheduleEntryMoveEvent;
import org.primefaces.event.ScheduleEntryResizeEvent;
import org.primefaces.event.SelectEvent;
import org.primefaces.model.DefaultScheduleEvent;
import org.primefaces.model.DefaultScheduleModel;
import org.primefaces.model.ScheduleEvent;
import org.primefaces.model.ScheduleModel;

@Named
@ViewScoped
public class Schedule001
implements Serializable {
    private static final long serialVersionUID = 2014707183985306105L;
    private ScheduleModel eventModel;
    private String locale = "en";

    @PostConstruct
    public void init() {
        this.eventModel = new DefaultScheduleModel();
        DefaultScheduleEvent event = DefaultScheduleEvent.builder().title("Champions League Match").startDate(this.previousDay8Pm()).endDate(this.previousDay11Pm()).description("Team A vs. Team B").build();
        this.eventModel.addEvent((ScheduleEvent)event);
        event = DefaultScheduleEvent.builder().title("Birthday Party").startDate(this.today1Pm()).endDate(this.today6Pm()).description("Aragon").overlapAllowed(true).build();
        this.eventModel.addEvent((ScheduleEvent)event);
        event = DefaultScheduleEvent.builder().title("Breakfast at Tiffanys").startDate(this.nextDay9Am()).endDate(this.nextDay11Am()).description("all you can eat").overlapAllowed(true).build();
        this.eventModel.addEvent((ScheduleEvent)event);
        event = DefaultScheduleEvent.builder().title("Plant the new garden stuff").startDate(this.theDayAfter3Pm()).endDate(this.fourDaysLater3pm()).description("Trees, flowers, ...").build();
        this.eventModel.addEvent((ScheduleEvent)event);
        DefaultScheduleEvent scheduleEventAllDay = DefaultScheduleEvent.builder().title("Holidays (AllDay)").startDate(this.sevenDaysLater0am()).endDate(this.eightDaysLater0am()).description("sleep as long as you want").allDay(true).build();
        this.eventModel.addEvent((ScheduleEvent)scheduleEventAllDay);
    }

    private LocalDateTime previousDay8Pm() {
        return LocalDateTime.now().minusDays(1L).withHour(20).withMinute(0).withSecond(0).withNano(0);
    }

    private LocalDateTime previousDay11Pm() {
        return LocalDateTime.now().minusDays(1L).withHour(23).withMinute(0).withSecond(0).withNano(0);
    }

    private LocalDateTime today1Pm() {
        return LocalDateTime.now().withHour(13).withMinute(0).withSecond(0).withNano(0);
    }

    private LocalDateTime theDayAfter3Pm() {
        return LocalDateTime.now().plusDays(1L).withHour(15).withMinute(0).withSecond(0).withNano(0);
    }

    private LocalDateTime today6Pm() {
        return LocalDateTime.now().withHour(18).withMinute(0).withSecond(0).withNano(0);
    }

    private LocalDateTime nextDay9Am() {
        return LocalDateTime.now().plusDays(1L).withHour(9).withMinute(0).withSecond(0).withNano(0);
    }

    private LocalDateTime nextDay11Am() {
        return LocalDateTime.now().plusDays(1L).withHour(11).withMinute(0).withSecond(0).withNano(0);
    }

    private LocalDateTime fourDaysLater3pm() {
        return LocalDateTime.now().plusDays(4L).withHour(15).withMinute(0).withSecond(0).withNano(0);
    }

    private LocalDateTime sevenDaysLater0am() {
        return LocalDateTime.now().plusDays(7L).withHour(0).withMinute(0).withSecond(0).withNano(0);
    }

    private LocalDateTime eightDaysLater0am() {
        return LocalDateTime.now().plusDays(7L).withHour(0).withMinute(0).withSecond(0).withNano(0);
    }

    public void onEventSelect(SelectEvent<ScheduleEvent> selectEvent) {
        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_INFO, "Event selected", ((ScheduleEvent)selectEvent.getObject()).getGroupId() + ": " + ((ScheduleEvent)selectEvent.getObject()).getTitle());
        this.addMessage(message);
    }

    public void onDateSelect(SelectEvent<LocalDateTime> selectEvent) {
        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_INFO, "Date selected", ((LocalDateTime)selectEvent.getObject()).toString());
        this.addMessage(message);
    }

    public void onEventMove(ScheduleEntryMoveEvent event) {
        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_INFO, "Event moved", "Delta:" + event.getDeltaAsDuration());
        this.addMessage(message);
    }

    public void onEventResize(ScheduleEntryResizeEvent event) {
        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_INFO, "Event resized", "Start-Delta:" + event.getDeltaStartAsDuration() + ", End-Delta: " + event.getDeltaEndAsDuration());
        this.addMessage(message);
    }

    public void english() {
        this.setLocale("en");
    }

    public void french() {
        this.setLocale("fr");
    }

    private void addMessage(FacesMessage message) {
        FacesContext.getCurrentInstance().addMessage(null, message);
    }

    public ScheduleModel getEventModel() {
        return this.eventModel;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setEventModel(ScheduleModel eventModel) {
        this.eventModel = eventModel;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Schedule001)) {
            return false;
        }
        Schedule001 other = (Schedule001)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ScheduleModel this$eventModel = this.getEventModel();
        ScheduleModel other$eventModel = other.getEventModel();
        if (this$eventModel == null ? other$eventModel != null : !this$eventModel.equals(other$eventModel)) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        return !(this$locale == null ? other$locale != null : !this$locale.equals(other$locale));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Schedule001;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScheduleModel $eventModel = this.getEventModel();
        result = result * 59 + ($eventModel == null ? 43 : $eventModel.hashCode());
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        return result;
    }

    public String toString() {
        return "Schedule001(eventModel=" + this.getEventModel() + ", locale=" + this.getLocale() + ")";
    }
}

