/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.treetable;

import java.io.Serializable;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.primefaces.integrationtests.general.utilities.TestUtils;
import org.primefaces.integrationtests.treetable.Document;
import org.primefaces.integrationtests.treetable.DocumentService;
import org.primefaces.model.TreeNode;

@Named
@ViewScoped
public class TreeTable004
implements Serializable {
    private static final long serialVersionUID = -3049074201208091926L;
    private TreeNode<Document> root;
    private TreeNode<Document>[] selectedNodes;
    @Inject
    private DocumentService service;

    @PostConstruct
    public void init() {
        this.root = this.service.createDocuments();
    }

    public void showSelectedNodes() {
        if (this.selectedNodes != null) {
            String selectedNodesStr = Arrays.stream(this.selectedNodes).map(n -> ((Document)n.getData()).getName()).collect(Collectors.joining(","));
            TestUtils.addMessage((String)"selected nodes", (String)selectedNodesStr);
        }
    }

    public TreeNode<Document> getRoot() {
        return this.root;
    }

    public TreeNode<Document>[] getSelectedNodes() {
        return this.selectedNodes;
    }

    public DocumentService getService() {
        return this.service;
    }

    public void setRoot(TreeNode<Document> root) {
        this.root = root;
    }

    public void setSelectedNodes(TreeNode<Document>[] selectedNodes) {
        this.selectedNodes = selectedNodes;
    }

    public void setService(DocumentService service) {
        this.service = service;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TreeTable004)) {
            return false;
        }
        TreeTable004 other = (TreeTable004)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        TreeNode this$root = this.getRoot();
        TreeNode other$root = other.getRoot();
        if (this$root == null ? other$root != null : !this$root.equals(other$root)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSelectedNodes(), other.getSelectedNodes())) {
            return false;
        }
        DocumentService this$service = this.getService();
        DocumentService other$service = other.getService();
        return !(this$service == null ? other$service != null : !this$service.equals(other$service));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TreeTable004;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TreeNode $root = this.getRoot();
        result = result * 59 + ($root == null ? 43 : $root.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSelectedNodes());
        DocumentService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        return result;
    }

    public String toString() {
        return "TreeTable004(root=" + this.getRoot() + ", selectedNodes=" + Arrays.deepToString(this.getSelectedNodes()) + ", service=" + this.getService() + ")";
    }
}

