/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.autocomplete;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.primefaces.integrationtests.general.model.Driver;
import org.primefaces.integrationtests.general.service.RealDriverService;
import org.primefaces.integrationtests.general.utilities.TestUtils;

@Named
@ViewScoped
public class AutoComplete005
implements Serializable {
    private static final long serialVersionUID = 5157497001324985194L;
    @Inject
    private RealDriverService service;
    private List<Driver> allDrivers;
    private List<Driver> selectedDrivers;
    private Driver selectedDriver;
    private boolean forceSelection = true;
    private boolean autoSelection = true;

    @PostConstruct
    public void init() {
        this.allDrivers = this.service.getDrivers();
    }

    public List<Driver> completeDriver(String query) {
        String queryLowerCase = query.toLowerCase();
        return this.allDrivers.stream().filter(d -> d.getName().toLowerCase().contains(queryLowerCase)).collect(Collectors.toList());
    }

    public void submit() {
        if (this.selectedDrivers != null && !this.selectedDrivers.isEmpty()) {
            String selectedDriversMsg = this.selectedDrivers.stream().map(d -> d.getId() + " - " + d.getName()).collect(Collectors.joining(", "));
            TestUtils.addMessage((String)"Selected Drivers", (String)selectedDriversMsg);
        }
        if (this.selectedDriver != null) {
            TestUtils.addMessage((String)"Selected Driver", (String)this.selectedDriver.toString());
        }
    }

    public void force() {
        this.setForceSelection(true);
    }

    public void unforce() {
        this.setForceSelection(false);
    }

    public void autoSelect() {
        this.setAutoSelection(true);
    }

    public void unAutoSelect() {
        this.setAutoSelection(false);
    }

    public RealDriverService getService() {
        return this.service;
    }

    public List<Driver> getAllDrivers() {
        return this.allDrivers;
    }

    public List<Driver> getSelectedDrivers() {
        return this.selectedDrivers;
    }

    public Driver getSelectedDriver() {
        return this.selectedDriver;
    }

    public boolean isForceSelection() {
        return this.forceSelection;
    }

    public boolean isAutoSelection() {
        return this.autoSelection;
    }

    public void setService(RealDriverService service) {
        this.service = service;
    }

    public void setAllDrivers(List<Driver> allDrivers) {
        this.allDrivers = allDrivers;
    }

    public void setSelectedDrivers(List<Driver> selectedDrivers) {
        this.selectedDrivers = selectedDrivers;
    }

    public void setSelectedDriver(Driver selectedDriver) {
        this.selectedDriver = selectedDriver;
    }

    public void setForceSelection(boolean forceSelection) {
        this.forceSelection = forceSelection;
    }

    public void setAutoSelection(boolean autoSelection) {
        this.autoSelection = autoSelection;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoComplete005)) {
            return false;
        }
        AutoComplete005 other = (AutoComplete005)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isForceSelection() != other.isForceSelection()) {
            return false;
        }
        if (this.isAutoSelection() != other.isAutoSelection()) {
            return false;
        }
        RealDriverService this$service = this.getService();
        RealDriverService other$service = other.getService();
        if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
            return false;
        }
        List this$allDrivers = this.getAllDrivers();
        List other$allDrivers = other.getAllDrivers();
        if (this$allDrivers == null ? other$allDrivers != null : !((Object)this$allDrivers).equals(other$allDrivers)) {
            return false;
        }
        List this$selectedDrivers = this.getSelectedDrivers();
        List other$selectedDrivers = other.getSelectedDrivers();
        if (this$selectedDrivers == null ? other$selectedDrivers != null : !((Object)this$selectedDrivers).equals(other$selectedDrivers)) {
            return false;
        }
        Driver this$selectedDriver = this.getSelectedDriver();
        Driver other$selectedDriver = other.getSelectedDriver();
        return !(this$selectedDriver == null ? other$selectedDriver != null : !this$selectedDriver.equals(other$selectedDriver));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AutoComplete005;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isForceSelection() ? 79 : 97);
        result = result * 59 + (this.isAutoSelection() ? 79 : 97);
        RealDriverService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        List $allDrivers = this.getAllDrivers();
        result = result * 59 + ($allDrivers == null ? 43 : ((Object)$allDrivers).hashCode());
        List $selectedDrivers = this.getSelectedDrivers();
        result = result * 59 + ($selectedDrivers == null ? 43 : ((Object)$selectedDrivers).hashCode());
        Driver $selectedDriver = this.getSelectedDriver();
        result = result * 59 + ($selectedDriver == null ? 43 : $selectedDriver.hashCode());
        return result;
    }

    public String toString() {
        return "AutoComplete005(service=" + this.getService() + ", allDrivers=" + this.getAllDrivers() + ", selectedDrivers=" + this.getSelectedDrivers() + ", selectedDriver=" + this.getSelectedDriver() + ", forceSelection=" + this.isForceSelection() + ", autoSelection=" + this.isAutoSelection() + ")";
    }
}

