/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.datatable;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.primefaces.integrationtests.datatable.ProgrammingLanguage;
import org.primefaces.integrationtests.datatable.ProgrammingLanguageService;
import org.primefaces.util.LangUtils;

@Named
@ViewScoped
public class DataTable019
implements Serializable {
    private static final long serialVersionUID = -7518459955779385834L;
    private List<ProgrammingLanguage> progLanguages;
    private List<ProgrammingLanguage> filteredProgLanguages;
    @Inject
    private ProgrammingLanguageService service;

    @PostConstruct
    public void init() {
        this.progLanguages = this.service.getLangs();
    }

    public boolean globalFilterFunction(Object value, Object filter, Locale locale) {
        String filterText;
        String string = filterText = filter == null ? null : filter.toString().trim().toLowerCase();
        if (LangUtils.isBlank((String)filterText)) {
            return true;
        }
        int filterInt = this.getInteger(filterText);
        ProgrammingLanguage lang = (ProgrammingLanguage)value;
        return lang.getName().toLowerCase().contains(filterText) || lang.getType().name().toLowerCase(locale).contains(filterText) || lang.getFirstAppeared() < filterInt || lang.getId() == filterInt;
    }

    public boolean columnFilterFunction(Object value, Object filter, Locale locale) {
        String filterText = Objects.toString(filter);
        if ("CUSTOM".equalsIgnoreCase(filterText)) {
            filterText = "INTERPRETED";
        }
        return Objects.equals(filterText, Objects.toString(value));
    }

    private int getInteger(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    public List<ProgrammingLanguage> getProgLanguages() {
        return this.progLanguages;
    }

    public List<ProgrammingLanguage> getFilteredProgLanguages() {
        return this.filteredProgLanguages;
    }

    public ProgrammingLanguageService getService() {
        return this.service;
    }

    public void setProgLanguages(List<ProgrammingLanguage> progLanguages) {
        this.progLanguages = progLanguages;
    }

    public void setFilteredProgLanguages(List<ProgrammingLanguage> filteredProgLanguages) {
        this.filteredProgLanguages = filteredProgLanguages;
    }

    public void setService(ProgrammingLanguageService service) {
        this.service = service;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataTable019)) {
            return false;
        }
        DataTable019 other = (DataTable019)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$progLanguages = this.getProgLanguages();
        List other$progLanguages = other.getProgLanguages();
        if (this$progLanguages == null ? other$progLanguages != null : !((Object)this$progLanguages).equals(other$progLanguages)) {
            return false;
        }
        List this$filteredProgLanguages = this.getFilteredProgLanguages();
        List other$filteredProgLanguages = other.getFilteredProgLanguages();
        if (this$filteredProgLanguages == null ? other$filteredProgLanguages != null : !((Object)this$filteredProgLanguages).equals(other$filteredProgLanguages)) {
            return false;
        }
        ProgrammingLanguageService this$service = this.getService();
        ProgrammingLanguageService other$service = other.getService();
        return !(this$service == null ? other$service != null : !this$service.equals(other$service));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataTable019;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $progLanguages = this.getProgLanguages();
        result = result * 59 + ($progLanguages == null ? 43 : ((Object)$progLanguages).hashCode());
        List $filteredProgLanguages = this.getFilteredProgLanguages();
        result = result * 59 + ($filteredProgLanguages == null ? 43 : ((Object)$filteredProgLanguages).hashCode());
        ProgrammingLanguageService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        return result;
    }

    public String toString() {
        return "DataTable019(progLanguages=" + this.getProgLanguages() + ", filteredProgLanguages=" + this.getFilteredProgLanguages() + ", service=" + this.getService() + ")";
    }
}

