/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.datatable;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.integrationtests.datatable.DataTable033;

@Named
@ViewScoped
public class DataTable033
implements Serializable {
    private static final long serialVersionUID = -7518459955779385834L;
    private String columnTemplate = "id name country date status activity";
    private List<ColumnModel> columns;
    private List<Customer> customers;
    private List<Customer> filteredCustomers;
    private Map<String, Class> validColumns;
    @Inject
    private CustomerService service;

    @PostConstruct
    public void init() {
        this.customers = this.service.getCustomers(10);
        this.validColumns = Stream.of(Customer.class.getDeclaredFields()).collect(Collectors.toMap(Field::getName, Field::getType));
        this.createDynamicColumns();
    }

    private void createDynamicColumns() {
        String[] columnKeys = this.columnTemplate.split(" ");
        this.columns = new ArrayList();
        for (String columnKey : columnKeys) {
            String key = columnKey.trim();
            if (!this.validColumns.containsKey(key)) continue;
            this.columns.add(new ColumnModel(columnKey.toUpperCase(), columnKey, (Class)this.validColumns.get(key)));
        }
    }

    public void updateColumns() {
        DataTable table = (DataTable)FacesContext.getCurrentInstance().getViewRoot().findComponent(":form:customers");
        table.resetColumns();
        this.createDynamicColumns();
    }

    public String getColumnTemplate() {
        return this.columnTemplate;
    }

    public List<ColumnModel> getColumns() {
        return this.columns;
    }

    public List<Customer> getCustomers() {
        return this.customers;
    }

    public List<Customer> getFilteredCustomers() {
        return this.filteredCustomers;
    }

    public Map<String, Class> getValidColumns() {
        return this.validColumns;
    }

    public CustomerService getService() {
        return this.service;
    }

    public void setColumnTemplate(String columnTemplate) {
        this.columnTemplate = columnTemplate;
    }

    public void setColumns(List<ColumnModel> columns) {
        this.columns = columns;
    }

    public void setCustomers(List<Customer> customers) {
        this.customers = customers;
    }

    public void setFilteredCustomers(List<Customer> filteredCustomers) {
        this.filteredCustomers = filteredCustomers;
    }

    public void setValidColumns(Map<String, Class> validColumns) {
        this.validColumns = validColumns;
    }

    public void setService(CustomerService service) {
        this.service = service;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataTable033)) {
            return false;
        }
        DataTable033 other = (DataTable033)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$columnTemplate = this.getColumnTemplate();
        String other$columnTemplate = other.getColumnTemplate();
        if (this$columnTemplate == null ? other$columnTemplate != null : !this$columnTemplate.equals(other$columnTemplate)) {
            return false;
        }
        List this$columns = this.getColumns();
        List other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        List this$customers = this.getCustomers();
        List other$customers = other.getCustomers();
        if (this$customers == null ? other$customers != null : !((Object)this$customers).equals(other$customers)) {
            return false;
        }
        List this$filteredCustomers = this.getFilteredCustomers();
        List other$filteredCustomers = other.getFilteredCustomers();
        if (this$filteredCustomers == null ? other$filteredCustomers != null : !((Object)this$filteredCustomers).equals(other$filteredCustomers)) {
            return false;
        }
        Map this$validColumns = this.getValidColumns();
        Map other$validColumns = other.getValidColumns();
        if (this$validColumns == null ? other$validColumns != null : !((Object)this$validColumns).equals(other$validColumns)) {
            return false;
        }
        CustomerService this$service = this.getService();
        CustomerService other$service = other.getService();
        return !(this$service == null ? other$service != null : !this$service.equals(other$service));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataTable033;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $columnTemplate = this.getColumnTemplate();
        result = result * 59 + ($columnTemplate == null ? 43 : $columnTemplate.hashCode());
        List $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        List $customers = this.getCustomers();
        result = result * 59 + ($customers == null ? 43 : ((Object)$customers).hashCode());
        List $filteredCustomers = this.getFilteredCustomers();
        result = result * 59 + ($filteredCustomers == null ? 43 : ((Object)$filteredCustomers).hashCode());
        Map $validColumns = this.getValidColumns();
        result = result * 59 + ($validColumns == null ? 43 : ((Object)$validColumns).hashCode());
        CustomerService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        return result;
    }

    public String toString() {
        return "DataTable033(columnTemplate=" + this.getColumnTemplate() + ", columns=" + this.getColumns() + ", customers=" + this.getCustomers() + ", filteredCustomers=" + this.getFilteredCustomers() + ", validColumns=" + this.getValidColumns() + ", service=" + this.getService() + ")";
    }
}

