/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.datatable;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.primefaces.integrationtests.datatable.ProgrammingLanguage;
import org.primefaces.integrationtests.datatable.ProgrammingLanguageLazySorter;
import org.primefaces.model.FilterMeta;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.MatchMode;
import org.primefaces.model.SortMeta;

public class ProgrammingLanguageLazyDataModel
extends LazyDataModel<ProgrammingLanguage> {
    private static final long serialVersionUID = -3415081263308946252L;
    protected List<ProgrammingLanguage> langs = new ArrayList();

    public ProgrammingLanguageLazyDataModel() {
        for (int i = 1; i <= 75; ++i) {
            this.langs.add(new ProgrammingLanguage(Integer.valueOf(i), "Language " + i, Integer.valueOf(1990 + i % 10), ProgrammingLanguage.ProgrammingLanguageType.COMPILED));
        }
    }

    public int count(Map<String, FilterMeta> filterBy) {
        List langsFiltered = this.sortAndFilterInternal(null, filterBy);
        return langsFiltered.size();
    }

    public List<ProgrammingLanguage> load(int first, int pageSize, Map<String, SortMeta> sortBy, Map<String, FilterMeta> filterBy) {
        List langsFiltered = this.sortAndFilterInternal(sortBy, filterBy);
        this.setRowCount(langsFiltered.size());
        return langsFiltered.stream().skip(first).limit(pageSize).collect(Collectors.toList());
    }

    protected List<ProgrammingLanguage> sortAndFilterInternal(Map<String, SortMeta> sortBy, Map<String, FilterMeta> filterBy) {
        Stream<Object> langsStream = this.langs.stream();
        if (filterBy != null && !filterBy.isEmpty()) {
            for (FilterMeta filterMeta : filterBy.values()) {
                if (filterMeta.getFilterValue() == null) continue;
                langsStream = langsStream.filter(lang -> {
                    if (meta.getField().equals("firstAppeared") && meta.getMatchMode() == MatchMode.GREATER_THAN_EQUALS) {
                        int filterValueInt = Integer.parseInt((String)meta.getFilterValue());
                        return lang.getFirstAppeared() >= filterValueInt;
                    }
                    if (meta.getField().equals("name")) {
                        return lang.getName().contains((String)meta.getFilterValue());
                    }
                    return true;
                });
            }
        }
        if (sortBy != null && !sortBy.isEmpty()) {
            for (SortMeta sortMeta : sortBy.values()) {
                langsStream = langsStream.sorted((Comparator<Object>)new ProgrammingLanguageLazySorter(sortMeta));
            }
        }
        return langsStream.collect(Collectors.toList());
    }

    public ProgrammingLanguage getRowData(String rowKey) {
        int rowKeyNumeric = Integer.parseInt(rowKey);
        return this.langs.stream().filter(lang -> lang.getId() == rowKeyNumeric).findFirst().get();
    }

    public String getRowKey(ProgrammingLanguage object) {
        return object.getId().toString();
    }

    public List<ProgrammingLanguage> getLangs() {
        return this.langs;
    }

    public void delete(ProgrammingLanguage language) {
        this.langs.remove(language);
    }
}

