/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.fileupload;

import java.io.Serializable;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.primefaces.event.FileUploadEvent;
import org.primefaces.event.FilesUploadEvent;
import org.primefaces.integrationtests.fileupload.FileUploadView;
import org.primefaces.model.file.UploadedFile;
import org.primefaces.model.file.UploadedFiles;

@Named
@RequestScoped
public class FileUploadHandler
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    private FileUploadView fileUploadView;
    private UploadedFile file;
    private UploadedFiles files;

    public void uploadFile() {
        if (this.file != null) {
            this.fileUploadView.doFileUpload(this.file);
        }
    }

    public void uploadFiles() {
        if (this.files != null) {
            for (UploadedFile f : this.files.getFiles()) {
                this.fileUploadView.doFileUpload(f);
            }
        }
    }

    public void handleFileUpload(FileUploadEvent event) {
        this.fileUploadView.doFileUpload(event.getFile());
    }

    public void handleFilesUpload(FilesUploadEvent event) {
        for (UploadedFile f : event.getFiles().getFiles()) {
            this.fileUploadView.doFileUpload(f);
        }
    }

    public FileUploadView getFileUploadView() {
        return this.fileUploadView;
    }

    public UploadedFile getFile() {
        return this.file;
    }

    public UploadedFiles getFiles() {
        return this.files;
    }

    public void setFileUploadView(FileUploadView fileUploadView) {
        this.fileUploadView = fileUploadView;
    }

    public void setFile(UploadedFile file) {
        this.file = file;
    }

    public void setFiles(UploadedFiles files) {
        this.files = files;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileUploadHandler)) {
            return false;
        }
        FileUploadHandler other = (FileUploadHandler)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        FileUploadView this$fileUploadView = this.getFileUploadView();
        FileUploadView other$fileUploadView = other.getFileUploadView();
        if (this$fileUploadView == null ? other$fileUploadView != null : !this$fileUploadView.equals(other$fileUploadView)) {
            return false;
        }
        UploadedFile this$file = this.getFile();
        UploadedFile other$file = other.getFile();
        if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
            return false;
        }
        UploadedFiles this$files = this.getFiles();
        UploadedFiles other$files = other.getFiles();
        return !(this$files == null ? other$files != null : !this$files.equals(other$files));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileUploadHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FileUploadView $fileUploadView = this.getFileUploadView();
        result = result * 59 + ($fileUploadView == null ? 43 : $fileUploadView.hashCode());
        UploadedFile $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        UploadedFiles $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : $files.hashCode());
        return result;
    }

    public String toString() {
        return "FileUploadHandler(fileUploadView=" + this.getFileUploadView() + ", file=" + this.getFile() + ", files=" + this.getFiles() + ")";
    }
}

