/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.dataexporter;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.export.DataTableExporter;
import org.primefaces.component.export.ExporterOptions;
import org.primefaces.component.export.ExporterUtils;
import org.primefaces.util.EscapeUtils;

public class TextExporter
extends DataTableExporter<PrintWriter, ExporterOptions> {
    public TextExporter() {
        super(null, Collections.emptySet(), false);
    }

    protected PrintWriter createDocument(FacesContext context) throws IOException {
        try {
            OutputStreamWriter osw = new OutputStreamWriter(this.os(), this.exportConfiguration.getEncodingType());
            return new PrintWriter(osw);
        }
        catch (UnsupportedEncodingException e) {
            throw new FacesException((Throwable)e);
        }
    }

    protected void exportTable(FacesContext context, DataTable table, int index) throws IOException {
        ((PrintWriter)this.document).append("").append(table.getId()).append("\n");
        super.exportTable(context, (UIComponent)table, index);
        ((PrintWriter)this.document).append("").append(table.getId());
    }

    protected void preRowExport(FacesContext context, DataTable table) {
        ((PrintWriter)this.document).append("\t").append(table.getVar()).append("\n");
    }

    protected void exportCellValue(FacesContext context, DataTable table, UIColumn col, String text, int index) {
        String columnTag = ExporterUtils.getColumnExportTag((FacesContext)context, (UIColumn)col);
        ((PrintWriter)this.document).append("\t\t").append(columnTag).append(": ").append(EscapeUtils.forXml((String)text)).append("\n");
    }

    public String getContentType() {
        return "text/plain";
    }

    public String getFileExtension() {
        return ".txt";
    }
}

