/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.datatable;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.data.FilterEvent;
import org.primefaces.integrationtests.datatable.ProgrammingLanguage;
import org.primefaces.integrationtests.datatable.ProgrammingLanguageService;
import org.primefaces.integrationtests.general.utilities.TestUtils;

@Named
@ViewScoped
public class DataTable009
implements Serializable {
    private static final long serialVersionUID = -7518459955779385834L;
    private List<ProgrammingLanguage> progLanguages;
    private List<ProgrammingLanguage> filteredProgLanguages;
    private List<Integer> allYearsSince1990;
    @Inject
    private ProgrammingLanguageService service;

    @PostConstruct
    public void init() {
        this.progLanguages = this.service.getLangs();
        this.allYearsSince1990 = new ArrayList();
        for (int year = 1990; year <= LocalDate.now().getYear(); ++year) {
            this.allYearsSince1990.add(year);
        }
    }

    public void filterListener(FilterEvent filterEvent) {
        filterEvent.getFilterBy().values().stream().filter(filterMeta -> filterMeta.getFilterValue() != null).forEach(filterMeta -> TestUtils.addMessage((String)("FilterValue for " + filterMeta.getField()), (String)filterMeta.getFilterValue().toString()));
        DataTable dataTable = (DataTable)filterEvent.getSource();
        String filterValuesFlat = "null";
        if (dataTable.getFilteredValue() != null) {
            List filteredProgLanguagesAtEvent = dataTable.getFilteredValue();
            filterValuesFlat = filteredProgLanguagesAtEvent.stream().map(ProgrammingLanguage::getName).collect(Collectors.joining(","));
        }
        TestUtils.addMessage((String)"FilteredValue(s)", (String)filterValuesFlat);
    }

    public void reportFilteredProgLanguages() {
        String filterValuesFlat = "null";
        if (this.filteredProgLanguages != null) {
            filterValuesFlat = this.filteredProgLanguages.stream().map(ProgrammingLanguage::getName).collect(Collectors.joining(","));
        }
        TestUtils.addMessage((String)"FilteredValue(s)", (String)filterValuesFlat);
    }

    public List<Integer> firstAppearedYearsWithProgLanguages() {
        return this.progLanguages.stream().map(p -> p.getFirstAppeared()).distinct().sorted().collect(Collectors.toList());
    }

    public void addJsfImplMessage() {
        TestUtils.addJsfImplMessage();
    }

    public List<ProgrammingLanguage> getProgLanguages() {
        return this.progLanguages;
    }

    public List<ProgrammingLanguage> getFilteredProgLanguages() {
        return this.filteredProgLanguages;
    }

    public List<Integer> getAllYearsSince1990() {
        return this.allYearsSince1990;
    }

    public ProgrammingLanguageService getService() {
        return this.service;
    }

    public void setProgLanguages(List<ProgrammingLanguage> progLanguages) {
        this.progLanguages = progLanguages;
    }

    public void setFilteredProgLanguages(List<ProgrammingLanguage> filteredProgLanguages) {
        this.filteredProgLanguages = filteredProgLanguages;
    }

    public void setAllYearsSince1990(List<Integer> allYearsSince1990) {
        this.allYearsSince1990 = allYearsSince1990;
    }

    public void setService(ProgrammingLanguageService service) {
        this.service = service;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataTable009)) {
            return false;
        }
        DataTable009 other = (DataTable009)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$progLanguages = this.getProgLanguages();
        List other$progLanguages = other.getProgLanguages();
        if (this$progLanguages == null ? other$progLanguages != null : !((Object)this$progLanguages).equals(other$progLanguages)) {
            return false;
        }
        List this$filteredProgLanguages = this.getFilteredProgLanguages();
        List other$filteredProgLanguages = other.getFilteredProgLanguages();
        if (this$filteredProgLanguages == null ? other$filteredProgLanguages != null : !((Object)this$filteredProgLanguages).equals(other$filteredProgLanguages)) {
            return false;
        }
        List this$allYearsSince1990 = this.getAllYearsSince1990();
        List other$allYearsSince1990 = other.getAllYearsSince1990();
        if (this$allYearsSince1990 == null ? other$allYearsSince1990 != null : !((Object)this$allYearsSince1990).equals(other$allYearsSince1990)) {
            return false;
        }
        ProgrammingLanguageService this$service = this.getService();
        ProgrammingLanguageService other$service = other.getService();
        return !(this$service == null ? other$service != null : !this$service.equals(other$service));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataTable009;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $progLanguages = this.getProgLanguages();
        result = result * 59 + ($progLanguages == null ? 43 : ((Object)$progLanguages).hashCode());
        List $filteredProgLanguages = this.getFilteredProgLanguages();
        result = result * 59 + ($filteredProgLanguages == null ? 43 : ((Object)$filteredProgLanguages).hashCode());
        List $allYearsSince1990 = this.getAllYearsSince1990();
        result = result * 59 + ($allYearsSince1990 == null ? 43 : ((Object)$allYearsSince1990).hashCode());
        ProgrammingLanguageService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        return result;
    }

    public String toString() {
        return "DataTable009(progLanguages=" + this.getProgLanguages() + ", filteredProgLanguages=" + this.getFilteredProgLanguages() + ", allYearsSince1990=" + this.getAllYearsSince1990() + ", service=" + this.getService() + ")";
    }
}

