/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.datepicker;

import java.io.Serializable;
import java.time.LocalDate;
import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.view.ViewScoped;
import javax.inject.Named;
import org.primefaces.event.DateViewChangeEvent;
import org.primefaces.event.SelectEvent;
import org.primefaces.model.datepicker.DateMetadata;
import org.primefaces.model.datepicker.DateMetadataModel;
import org.primefaces.model.datepicker.DefaultDateMetadata;
import org.primefaces.model.datepicker.DefaultDateMetadataModel;

@Named
@ViewScoped
public class DatePicker011
implements Serializable {
    private static final long serialVersionUID = 1L;
    private LocalDate date0;
    private LocalDate date1;
    private LocalDate date2;
    private LocalDate date3;
    private LocalDate date4;
    private LocalDate date5;
    private LocalDate date6;
    private LocalDate date7;
    private DateMetadataModel model;
    private DateMetadataModel modelLazy;

    @PostConstruct
    public void init() {
        DefaultDateMetadata disabled = DefaultDateMetadata.builder().disabled(true).styleClass("tst-disabled").build();
        DefaultDateMetadata begin = DefaultDateMetadata.builder().styleClass("tst-begin").build();
        DefaultDateMetadata end = DefaultDateMetadata.builder().styleClass("tst-end").build();
        LocalDate start = LocalDate.now().withDayOfMonth(1);
        this.model = new DefaultDateMetadataModel();
        this.model.add(start.minusMonths(1L).plusDays(1L), (DateMetadata)disabled);
        this.model.add(start, (DateMetadata)disabled);
        this.model.add(start.plusMonths(1L).plusDays(2L), (DateMetadata)disabled);
        this.model.add(start.plusDays(1L), (DateMetadata)begin);
        this.model.add(start.plusDays(2L), (DateMetadata)end);
        this.modelLazy = new /* Unavailable Anonymous Inner Class!! */;
    }

    public void onDateSelect(SelectEvent event) {
        String summary = "dateSelect " + event.getObject();
        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_INFO, summary, null);
        FacesContext.getCurrentInstance().addMessage(null, message);
    }

    public void onViewChange(DateViewChangeEvent event) {
        String summary = "viewChange Year: " + event.getYear() + ", month: " + (event.getMonth() + 1);
        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_INFO, summary, null);
        FacesContext.getCurrentInstance().addMessage(null, message);
    }

    public void onClose(AjaxBehaviorEvent event) {
        String summary = "close";
        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_INFO, summary, null);
        FacesContext.getCurrentInstance().addMessage(null, message);
    }

    public void onSelect(AjaxBehaviorEvent event) {
    }

    public LocalDate getDate0() {
        return this.date0;
    }

    public LocalDate getDate1() {
        return this.date1;
    }

    public LocalDate getDate2() {
        return this.date2;
    }

    public LocalDate getDate3() {
        return this.date3;
    }

    public LocalDate getDate4() {
        return this.date4;
    }

    public LocalDate getDate5() {
        return this.date5;
    }

    public LocalDate getDate6() {
        return this.date6;
    }

    public LocalDate getDate7() {
        return this.date7;
    }

    public DateMetadataModel getModel() {
        return this.model;
    }

    public DateMetadataModel getModelLazy() {
        return this.modelLazy;
    }

    public void setDate0(LocalDate date0) {
        this.date0 = date0;
    }

    public void setDate1(LocalDate date1) {
        this.date1 = date1;
    }

    public void setDate2(LocalDate date2) {
        this.date2 = date2;
    }

    public void setDate3(LocalDate date3) {
        this.date3 = date3;
    }

    public void setDate4(LocalDate date4) {
        this.date4 = date4;
    }

    public void setDate5(LocalDate date5) {
        this.date5 = date5;
    }

    public void setDate6(LocalDate date6) {
        this.date6 = date6;
    }

    public void setDate7(LocalDate date7) {
        this.date7 = date7;
    }

    public void setModel(DateMetadataModel model) {
        this.model = model;
    }

    public void setModelLazy(DateMetadataModel modelLazy) {
        this.modelLazy = modelLazy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatePicker011)) {
            return false;
        }
        DatePicker011 other = (DatePicker011)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        LocalDate this$date0 = this.getDate0();
        LocalDate other$date0 = other.getDate0();
        if (this$date0 == null ? other$date0 != null : !((Object)this$date0).equals(other$date0)) {
            return false;
        }
        LocalDate this$date1 = this.getDate1();
        LocalDate other$date1 = other.getDate1();
        if (this$date1 == null ? other$date1 != null : !((Object)this$date1).equals(other$date1)) {
            return false;
        }
        LocalDate this$date2 = this.getDate2();
        LocalDate other$date2 = other.getDate2();
        if (this$date2 == null ? other$date2 != null : !((Object)this$date2).equals(other$date2)) {
            return false;
        }
        LocalDate this$date3 = this.getDate3();
        LocalDate other$date3 = other.getDate3();
        if (this$date3 == null ? other$date3 != null : !((Object)this$date3).equals(other$date3)) {
            return false;
        }
        LocalDate this$date4 = this.getDate4();
        LocalDate other$date4 = other.getDate4();
        if (this$date4 == null ? other$date4 != null : !((Object)this$date4).equals(other$date4)) {
            return false;
        }
        LocalDate this$date5 = this.getDate5();
        LocalDate other$date5 = other.getDate5();
        if (this$date5 == null ? other$date5 != null : !((Object)this$date5).equals(other$date5)) {
            return false;
        }
        LocalDate this$date6 = this.getDate6();
        LocalDate other$date6 = other.getDate6();
        if (this$date6 == null ? other$date6 != null : !((Object)this$date6).equals(other$date6)) {
            return false;
        }
        LocalDate this$date7 = this.getDate7();
        LocalDate other$date7 = other.getDate7();
        if (this$date7 == null ? other$date7 != null : !((Object)this$date7).equals(other$date7)) {
            return false;
        }
        DateMetadataModel this$model = this.getModel();
        DateMetadataModel other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        DateMetadataModel this$modelLazy = this.getModelLazy();
        DateMetadataModel other$modelLazy = other.getModelLazy();
        return !(this$modelLazy == null ? other$modelLazy != null : !this$modelLazy.equals(other$modelLazy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DatePicker011;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDate $date0 = this.getDate0();
        result = result * 59 + ($date0 == null ? 43 : ((Object)$date0).hashCode());
        LocalDate $date1 = this.getDate1();
        result = result * 59 + ($date1 == null ? 43 : ((Object)$date1).hashCode());
        LocalDate $date2 = this.getDate2();
        result = result * 59 + ($date2 == null ? 43 : ((Object)$date2).hashCode());
        LocalDate $date3 = this.getDate3();
        result = result * 59 + ($date3 == null ? 43 : ((Object)$date3).hashCode());
        LocalDate $date4 = this.getDate4();
        result = result * 59 + ($date4 == null ? 43 : ((Object)$date4).hashCode());
        LocalDate $date5 = this.getDate5();
        result = result * 59 + ($date5 == null ? 43 : ((Object)$date5).hashCode());
        LocalDate $date6 = this.getDate6();
        result = result * 59 + ($date6 == null ? 43 : ((Object)$date6).hashCode());
        LocalDate $date7 = this.getDate7();
        result = result * 59 + ($date7 == null ? 43 : ((Object)$date7).hashCode());
        DateMetadataModel $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        DateMetadataModel $modelLazy = this.getModelLazy();
        result = result * 59 + ($modelLazy == null ? 43 : $modelLazy.hashCode());
        return result;
    }

    public String toString() {
        return "DatePicker011(date0=" + this.getDate0() + ", date1=" + this.getDate1() + ", date2=" + this.getDate2() + ", date3=" + this.getDate3() + ", date4=" + this.getDate4() + ", date5=" + this.getDate5() + ", date6=" + this.getDate6() + ", date7=" + this.getDate7() + ", model=" + this.getModel() + ", modelLazy=" + this.getModelLazy() + ")";
    }
}

