/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.datepicker;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.faces.view.ViewScoped;
import javax.inject.Named;
import org.primefaces.integrationtests.general.utilities.TestUtils;

@Named
@ViewScoped
public class DatePicker015
implements Serializable {
    private static final long serialVersionUID = 1L;
    private LocalDateTime german;
    private LocalDateTime spanish;
    private LocalDateTime english;

    @PostConstruct
    public void init() {
        this.german = LocalDateTime.of(2020, 2, 10, 1, 16, 4);
        this.spanish = LocalDateTime.of(2021, 4, 13, 5, 21, 19);
        this.english = LocalDateTime.of(2022, 5, 30, 17, 7, 12);
    }

    public void submit() {
        TestUtils.addMessage((String)"German", (String)this.german.format(DateTimeFormatter.ofPattern("MM/dd/yyyy hh:mm a").withLocale(Locale.GERMAN)));
        TestUtils.addMessage((String)"Spanish", (String)this.spanish.format(DateTimeFormatter.ofPattern("MM/dd/yyyy hh:mm a").withLocale(new Locale("es"))));
        TestUtils.addMessage((String)"English", (String)this.english.format(DateTimeFormatter.ofPattern("MM/dd/yyyy hh:mm a").withLocale(Locale.ENGLISH)));
    }

    public LocalDateTime getGerman() {
        return this.german;
    }

    public LocalDateTime getSpanish() {
        return this.spanish;
    }

    public LocalDateTime getEnglish() {
        return this.english;
    }

    public void setGerman(LocalDateTime german) {
        this.german = german;
    }

    public void setSpanish(LocalDateTime spanish) {
        this.spanish = spanish;
    }

    public void setEnglish(LocalDateTime english) {
        this.english = english;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatePicker015)) {
            return false;
        }
        DatePicker015 other = (DatePicker015)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        LocalDateTime this$german = this.getGerman();
        LocalDateTime other$german = other.getGerman();
        if (this$german == null ? other$german != null : !((Object)this$german).equals(other$german)) {
            return false;
        }
        LocalDateTime this$spanish = this.getSpanish();
        LocalDateTime other$spanish = other.getSpanish();
        if (this$spanish == null ? other$spanish != null : !((Object)this$spanish).equals(other$spanish)) {
            return false;
        }
        LocalDateTime this$english = this.getEnglish();
        LocalDateTime other$english = other.getEnglish();
        return !(this$english == null ? other$english != null : !((Object)this$english).equals(other$english));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DatePicker015;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDateTime $german = this.getGerman();
        result = result * 59 + ($german == null ? 43 : ((Object)$german).hashCode());
        LocalDateTime $spanish = this.getSpanish();
        result = result * 59 + ($spanish == null ? 43 : ((Object)$spanish).hashCode());
        LocalDateTime $english = this.getEnglish();
        result = result * 59 + ($english == null ? 43 : ((Object)$english).hashCode());
        return result;
    }

    public String toString() {
        return "DatePicker015(german=" + this.getGerman() + ", spanish=" + this.getSpanish() + ", english=" + this.getEnglish() + ")";
    }
}

