/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.fileupload;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewScoped;
import javax.inject.Named;
import org.primefaces.component.fileupload.FileUpload;
import org.primefaces.integrationtests.fileupload.FileUploadView;
import org.primefaces.model.file.UploadedFile;

@Named
@ViewScoped
public class FileUploadView
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FILE_UPLOAD_ID = "form:fileupload";
    private List<UploadFile> uploadedFiles = Collections.synchronizedList(new ArrayList());
    private String _allowTypes;

    public void doFileUpload(UploadedFile uf) {
        UploadFile file = new UploadFile(uf);
        try {
            this.readFile(uf);
        }
        catch (Exception ex) {
            file.setErrorMessage(ex.getMessage());
        }
        this.uploadedFiles.add(file);
    }

    private void readFile(UploadedFile uf) throws IOException {
        byte[] buf = new byte[(int)uf.getSize() + 1];
        int len = uf.getInputStream().read(buf);
        if (Math.max(0, len) != (int)uf.getSize()) {
            throw new IllegalStateException("unexpected file size " + uf.getSize() + " <> " + len);
        }
        if (!this.isAllowedType(uf.getFileName())) {
            throw new IllegalStateException("unexpected file type " + uf.getFileName());
        }
    }

    private boolean isAllowedType(String fileName) {
        String allowTypes = this.getAllowTypes();
        return allowTypes == null || allowTypes.length() < 3 || Pattern.compile(allowTypes.substring(1, allowTypes.length() - 1)).matcher(fileName).find();
    }

    private String getAllowTypes() {
        FacesContext ctx;
        UIComponent component;
        if (this._allowTypes == null && (component = (ctx = FacesContext.getCurrentInstance()).getViewRoot().findComponent(FILE_UPLOAD_ID)) instanceof FileUpload) {
            this._allowTypes = ((FileUpload)component).getAllowTypes();
        }
        return this._allowTypes;
    }

    public List<UploadFile> getUploadedFiles() {
        return this.uploadedFiles;
    }

    public String get_allowTypes() {
        return this._allowTypes;
    }

    public void setUploadedFiles(List<UploadFile> uploadedFiles) {
        this.uploadedFiles = uploadedFiles;
    }

    public void set_allowTypes(String _allowTypes) {
        this._allowTypes = _allowTypes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileUploadView)) {
            return false;
        }
        FileUploadView other = (FileUploadView)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$uploadedFiles = this.getUploadedFiles();
        List other$uploadedFiles = other.getUploadedFiles();
        if (this$uploadedFiles == null ? other$uploadedFiles != null : !((Object)this$uploadedFiles).equals(other$uploadedFiles)) {
            return false;
        }
        String this$_allowTypes = this.get_allowTypes();
        String other$_allowTypes = other.get_allowTypes();
        return !(this$_allowTypes == null ? other$_allowTypes != null : !this$_allowTypes.equals(other$_allowTypes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileUploadView;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $uploadedFiles = this.getUploadedFiles();
        result = result * 59 + ($uploadedFiles == null ? 43 : ((Object)$uploadedFiles).hashCode());
        String $_allowTypes = this.get_allowTypes();
        result = result * 59 + ($_allowTypes == null ? 43 : $_allowTypes.hashCode());
        return result;
    }

    public String toString() {
        return "FileUploadView(uploadedFiles=" + this.getUploadedFiles() + ", _allowTypes=" + this.get_allowTypes() + ")";
    }
}

