/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.tree;

import java.io.Serializable;
import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.primefaces.integrationtests.tree.TreeNodeService;
import org.primefaces.model.TreeNode;
import org.primefaces.util.LangUtils;

@Named
@ViewScoped
public class Tree005
implements Serializable {
    @Inject
    private TreeNodeService treeNodeService;
    private TreeNode<String> root;

    @PostConstruct
    public void init() {
        this.root = this.treeNodeService.createNodes();
    }

    public boolean customFilter(TreeNode treeNode, Object filter, Locale locale) {
        if (treeNode.getData() == null || filter == null) {
            return true;
        }
        String filterText = filter.toString().trim().toLowerCase(locale);
        if (LangUtils.isBlank((String)filterText)) {
            return true;
        }
        return ((String)treeNode.getData()).toLowerCase(locale).contains(filterText);
    }

    public TreeNodeService getTreeNodeService() {
        return this.treeNodeService;
    }

    public TreeNode<String> getRoot() {
        return this.root;
    }

    public void setTreeNodeService(TreeNodeService treeNodeService) {
        this.treeNodeService = treeNodeService;
    }

    public void setRoot(TreeNode<String> root) {
        this.root = root;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tree005)) {
            return false;
        }
        Tree005 other = (Tree005)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        TreeNodeService this$treeNodeService = this.getTreeNodeService();
        TreeNodeService other$treeNodeService = other.getTreeNodeService();
        if (this$treeNodeService == null ? other$treeNodeService != null : !this$treeNodeService.equals(other$treeNodeService)) {
            return false;
        }
        TreeNode this$root = this.getRoot();
        TreeNode other$root = other.getRoot();
        return !(this$root == null ? other$root != null : !this$root.equals(other$root));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Tree005;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TreeNodeService $treeNodeService = this.getTreeNodeService();
        result = result * 59 + ($treeNodeService == null ? 43 : $treeNodeService.hashCode());
        TreeNode $root = this.getRoot();
        result = result * 59 + ($root == null ? 43 : $root.hashCode());
        return result;
    }

    public String toString() {
        return "Tree005(treeNodeService=" + this.getTreeNodeService() + ", root=" + this.getRoot() + ")";
    }
}

