/*
 * Decompiled with CFR 0.152.
 */
package org.progressify.spring;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.progressify.spring.jsbuilder.Builder;
import org.progressify.spring.jsbuilder.Comment;
import org.progressify.spring.jsbuilder.ImportStatement;
import org.progressify.spring.jsbuilder.PreCacheStatement;
import org.progressify.spring.jsbuilder.RegisterRouteStatement;
import org.progressify.spring.processors.BaseProcessor;
import org.progressify.spring.processors.ConfigResult;
import org.progressify.spring.processors.PreCacheResult;
import org.progressify.spring.processors.ProcessorFactory;
import org.progressify.spring.processors.Result;
import org.progressify.spring.processors.StrategyResult;

public class PWAProcessor
extends AbstractProcessor {
    private Logger log;

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        this.log = Logger.getLogger("org.progressify.spring");
        String logLevel = env.getOptions().get("logLevel");
        if ("INFO".equals(logLevel)) {
            this.log.setLevel(Level.INFO);
        } else {
            this.log.setLevel(Level.SEVERE);
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.log.info("\n\n---- PWAProcessor start processing this round ----");
        if (annotations.isEmpty()) {
            this.log.info("---- PWAProcessor found no annotations to process. Exiting ! ----\n\n");
            return true;
        }
        ArrayList<Result> results = new ArrayList<Result>();
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                BaseProcessor processor = ProcessorFactory.getProcessor(typeElement.toString());
                Result result = processor.process(typeElement, element);
                if (result == null) continue;
                results.add(result);
            }
        }
        this.build(results);
        this.log.info("---- PWAProcessor end processing this round ----\n\n");
        return true;
    }

    private void build(List<Result> results) {
        Builder b = new Builder(this.getResourcesDirectory("src/main/resources/static"), "sw.js");
        b.addFirst(Comment.getDefaultComment());
        b.add(new ImportStatement());
        for (Result result : results) {
            if (result instanceof StrategyResult) {
                StrategyResult sr = (StrategyResult)result;
                List<String> values = sr.getValueList();
                for (String val : values) {
                    b.add(new Comment(sr.getComment(), true));
                    RegisterRouteStatement rStmt = new RegisterRouteStatement(sr.getKey(), val, sr.getCacheName(), sr.getNetworkTimeoutSeconds());
                    rStmt.setCacheQueryIgnoreMethod(sr.getCacheQueryIgnoreMethod());
                    rStmt.setCacheQueryIgnoreSearch(sr.getCacheQueryIgnoreSearch());
                    rStmt.setCacheQueryIgnoreVary(sr.getCacheQueryIgnoreVary());
                    b.add(rStmt);
                }
                continue;
            }
            if (result instanceof ConfigResult) {
                ConfigResult cr = (ConfigResult)result;
                if (cr.getSwDirectory() != null) {
                    b.setDirectory(this.getResourcesDirectory(cr.getSwDirectory()));
                }
                if (cr.getSwFileName() == null) continue;
                b.setFileName(cr.getSwFileName());
                continue;
            }
            if (!(result instanceof PreCacheResult)) continue;
            PreCacheResult pr = (PreCacheResult)result;
            PreCacheStatement prStmt = new PreCacheStatement(pr);
            b.add(prStmt);
        }
        try {
            b.flushToFile();
        }
        catch (Exception excp) {
            this.log.info("SEVERE : Exception caught");
            excp.printStackTrace();
        }
    }

    private String getResourcesDirectory(String dirLocation) {
        String multiModuleProjectDirectory = System.getProperty("maven.multiModuleProjectDirectory");
        this.log.info("Found maven.multiModuleProjectDirectory to be :" + multiModuleProjectDirectory);
        return multiModuleProjectDirectory + File.separator + dirLocation;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> s = new HashSet<String>();
        s.addAll(ProcessorFactory.strategies);
        s.addAll(ProcessorFactory.configs);
        s.addAll(ProcessorFactory.precache);
        return s;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }
}

