/*
 * Decompiled with CFR 0.152.
 */
package org.progressify.spring.jsbuilder;

import java.util.HashMap;
import java.util.Map;
import org.progressify.spring.jsbuilder.Statement;

public class RegisterRouteStatement
implements Statement {
    private String strategy;
    private String path;
    private String cacheName;
    private Integer networkTimeoutSeconds;
    private Boolean cacheQueryIgnoreSearch = false;
    private Boolean cacheQueryIgnoreMethod = false;
    private Boolean cacheQueryIgnoreVary = false;
    private static Map<String, String> annMapper = new HashMap<String, String>();

    public RegisterRouteStatement() {
    }

    public Integer getNetworkTimeoutSeconds() {
        return this.networkTimeoutSeconds;
    }

    public void setNetworkTimeoutSeconds(Integer networkTimeoutSeconds) {
        this.networkTimeoutSeconds = networkTimeoutSeconds;
    }

    public Boolean getCacheQueryIgnoreVary() {
        return this.cacheQueryIgnoreVary;
    }

    public void setCacheQueryIgnoreVary(Boolean cacheQueryIgnoreVary) {
        this.cacheQueryIgnoreVary = cacheQueryIgnoreVary;
    }

    public Boolean getCacheQueryIgnoreMethod() {
        return this.cacheQueryIgnoreMethod;
    }

    public void setCacheQueryIgnoreMethod(Boolean cacheQueryIgnoreMethod) {
        this.cacheQueryIgnoreMethod = cacheQueryIgnoreMethod;
    }

    public Boolean getCacheQueryIgnoreSearch() {
        return this.cacheQueryIgnoreSearch;
    }

    public void setCacheQueryIgnoreSearch(Boolean cacheQueryIgnoreSearch) {
        this.cacheQueryIgnoreSearch = cacheQueryIgnoreSearch;
    }

    public RegisterRouteStatement(String strategy, String path, String cacheName, Integer networkTimeoutSeconds) {
        this.strategy = strategy;
        this.path = path;
        this.cacheName = cacheName;
        this.networkTimeoutSeconds = networkTimeoutSeconds;
    }

    @Override
    public String getJsString() {
        StringBuilder stmtBuffer = new StringBuilder();
        stmtBuffer.append("workbox.routing.registerRoute(");
        stmtBuffer.append("\n\tnew RegExp('" + this.path + "'),");
        stmtBuffer.append("\n\tnew " + annMapper.get(this.strategy) + "({");
        StringBuilder routeConfig = new StringBuilder();
        if (this.cacheName != null) {
            routeConfig.append("\n\t\tcacheName: '" + this.cacheName + "',");
        }
        if (this.networkTimeoutSeconds != null) {
            routeConfig.append("\n\t\tnetworkTimeoutSeconds: " + this.networkTimeoutSeconds.toString() + ",");
        }
        if (this.cacheQueryIgnoreSearch.booleanValue() || this.cacheQueryIgnoreMethod.booleanValue() || this.cacheQueryIgnoreVary.booleanValue()) {
            routeConfig.append("\n\t\tmatchOptions: {");
            StringBuilder igOptions = new StringBuilder();
            if (this.cacheQueryIgnoreSearch.booleanValue()) {
                igOptions.append("ignoreSearch:true,");
            }
            if (this.cacheQueryIgnoreMethod.booleanValue()) {
                igOptions.append("ignoreMethod:true,");
            }
            if (this.cacheQueryIgnoreVary.booleanValue()) {
                igOptions.append("ignoreVary:true,");
            }
            routeConfig.append(igOptions.toString().replaceAll(",$", ""));
            routeConfig.append("},");
        }
        stmtBuffer.append(routeConfig.toString().replaceAll(",$", ""));
        stmtBuffer.append("\n\t})");
        stmtBuffer.append("\n);\n");
        return stmtBuffer.toString();
    }

    static {
        annMapper.put("org.progressify.spring.annotations.NetworkOnly", "workbox.strategies.NetworkOnly");
        annMapper.put("org.progressify.spring.annotations.NetworkFirst", "workbox.strategies.NetworkFirst");
        annMapper.put("org.progressify.spring.annotations.CacheOnly", "workbox.strategies.CacheOnly");
        annMapper.put("org.progressify.spring.annotations.CacheFirst", "workbox.strategies.CacheFirst");
        annMapper.put("org.progressify.spring.annotations.StaleWhileRevalidate", "workbox.strategies.StaleWhileRevalidate");
    }
}

