/*
 * Decompiled with CFR 0.152.
 */
package org.progressify.spring.processors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.progressify.spring.processors.BaseProcessor;
import org.progressify.spring.processors.Result;
import org.progressify.spring.processors.StrategyResult;

public class StrategyProcessor
extends BaseProcessor {
    @Override
    public Result process(TypeElement annotation, Element element) {
        StrategyResult result = null;
        List<String> paths = null;
        String thisAnnotation = annotation.toString();
        int networkTimeoutSeconds = -1;
        Map pOptions = null;
        this.log.info("Processing element : " + element.getEnclosingElement() + " : " + element.getSimpleName() + " annotated by:" + thisAnnotation);
        List<? extends AnnotationMirror> mirrors = element.getAnnotationMirrors();
        block8: for (AnnotationMirror annotationMirror : mirrors) {
            String mirrorAnnotationType;
            switch (mirrorAnnotationType = annotationMirror.getAnnotationType().toString()) {
                case "org.springframework.web.bind.annotation.GetMapping": {
                    paths = this.processSpringGetMappingAnnotation(annotationMirror);
                    continue block8;
                }
                case "org.springframework.web.bind.annotation.RequestMapping": {
                    paths = this.processSpringRequestMappingAnnotation(annotationMirror);
                    continue block8;
                }
            }
            if (!thisAnnotation.equals(annotationMirror.getAnnotationType().toString())) continue;
            pOptions = this.processProgressifyAnnotation(thisAnnotation, annotationMirror);
        }
        if (paths != null) {
            String comment = "Route added based on annotation found at " + element.getEnclosingElement() + " : " + element.getSimpleName();
            result = new StrategyResult(annotation.toString(), paths, comment);
            if (pOptions.containsKey("cacheName")) {
                result.setCacheName((String)pOptions.get("cacheName"));
            }
            if (pOptions.containsKey("networkTimeoutSeconds")) {
                result.setNetworkTimeoutSeconds((Integer)pOptions.get("networkTimeoutSeconds"));
            }
            if (pOptions.containsKey("cacheQueryIgnoreSearch") && ((Boolean)pOptions.get("cacheQueryIgnoreSearch")).booleanValue()) {
                result.setCacheQueryIgnoreSearch(true);
            }
            if (pOptions.containsKey("cacheQueryIgnoreMethod") && ((Boolean)pOptions.get("cacheQueryIgnoreMethod")).booleanValue()) {
                result.setCacheQueryIgnoreMethod(true);
            }
            if (pOptions.containsKey("cacheQueryIgnoreVary") && ((Boolean)pOptions.get("cacheQueryIgnoreVary")).booleanValue()) {
                result.setCacheQueryIgnoreVary(true);
            }
        } else {
            this.log.info("No Spring annotation found for element : " + element.getEnclosingElement() + " : " + element.getSimpleName() + " annotated by: " + thisAnnotation + " .Hence ignoring");
        }
        return result;
    }

    private List<String> processSpringGetMappingAnnotation(AnnotationMirror mirror) {
        ArrayList<String> paths = new ArrayList<String>();
        Map<? extends ExecutableElement, ? extends AnnotationValue> m = mirror.getElementValues();
        Set<? extends ExecutableElement> s = m.keySet();
        for (ExecutableElement executableElement : s) {
            if (!"value".equals(executableElement.getSimpleName().toString()) && !"path".equals(executableElement.getSimpleName().toString())) continue;
            AnnotationValue val = m.get(executableElement);
            List listOfValues = (List)val.getValue();
            for (AnnotationValue eachValue : listOfValues) {
                String value = (String)eachValue.getValue();
                paths.add(value);
            }
        }
        return paths;
    }

    private List<String> processSpringRequestMappingAnnotation(AnnotationMirror mirror) {
        ArrayList<String> paths = new ArrayList<String>();
        this.log.info("\n\n\nINSIDE processSpringRequestMappingAnnotation");
        Map<? extends ExecutableElement, ? extends AnnotationValue> m = mirror.getElementValues();
        Set<? extends ExecutableElement> s = m.keySet();
        for (ExecutableElement executableElement : s) {
            if (!"value".equals(executableElement.getSimpleName().toString()) && !"path".equals(executableElement.getSimpleName().toString())) continue;
            AnnotationValue val = m.get(executableElement);
            List listOfValues = (List)val.getValue();
            for (AnnotationValue eachValue : listOfValues) {
                String value = (String)eachValue.getValue();
                paths.add(value);
            }
        }
        return paths;
    }

    private Map processProgressifyAnnotation(String thisAnnotation, AnnotationMirror mirror) {
        HashMap pOptions = new HashMap();
        Map<? extends ExecutableElement, ? extends AnnotationValue> m = mirror.getElementValues();
        Set<? extends ExecutableElement> s = m.keySet();
        for (ExecutableElement executableElement : s) {
            this.extractMemberAndPutInMap("cacheName", executableElement, m, pOptions);
            this.extractMemberAndPutInMap("networkTimeoutSeconds", executableElement, m, pOptions);
            this.extractMemberAndPutInMap("cacheQueryIgnoreSearch", executableElement, m, pOptions);
            this.extractMemberAndPutInMap("cacheQueryIgnoreMethod", executableElement, m, pOptions);
            this.extractMemberAndPutInMap("cacheQueryIgnoreVary", executableElement, m, pOptions);
        }
        return pOptions;
    }

    private void extractMemberAndPutInMap(String memberName, ExecutableElement e, Map elementVals, Map map) {
        if (memberName.equals(e.getSimpleName().toString())) {
            AnnotationValue val = (AnnotationValue)elementVals.get(e);
            map.put(memberName, val.getValue());
        }
    }
}

