/*
 * Decompiled with CFR 0.152.
 */
package org.project_kessel.clients;

import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.CompositeChannelCredentials;
import io.grpc.Grpc;
import io.grpc.InsecureChannelCredentials;
import io.grpc.ManagedChannel;
import io.grpc.TlsChannelCredentials;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.project_kessel.clients.authn.AuthenticationConfig;
import org.project_kessel.clients.authn.CallCredentialsFactory;

public final class ChannelManager {
    private static final Hashtable<String, ChannelManager> channelManagers = new Hashtable();
    private final HashMap<String, ManagedChannel> insecureChannels = new HashMap();
    private final HashMap<String, ManagedChannel> secureChannels = new HashMap();

    public static ChannelManager getInstance(String channelManagerKey) {
        if (!channelManagers.containsKey(channelManagerKey)) {
            channelManagers.put(channelManagerKey, new ChannelManager());
        }
        return channelManagers.get(channelManagerKey);
    }

    public synchronized Channel forInsecureClients(String targetUrl) {
        if (!this.insecureChannels.containsKey(targetUrl)) {
            ManagedChannel channel = Grpc.newChannelBuilder((String)targetUrl, (ChannelCredentials)InsecureChannelCredentials.create()).build();
            this.insecureChannels.put(targetUrl, channel);
        }
        return (Channel)this.insecureChannels.get(targetUrl);
    }

    public synchronized Channel forInsecureClients(String targetUrl, AuthenticationConfig authnConfig) throws RuntimeException {
        if (!this.insecureChannels.containsKey(targetUrl)) {
            try {
                ManagedChannel channel = Grpc.newChannelBuilder((String)targetUrl, (ChannelCredentials)CompositeChannelCredentials.create((ChannelCredentials)InsecureChannelCredentials.create(), (CallCredentials)CallCredentialsFactory.create(authnConfig))).build();
                this.insecureChannels.put(targetUrl, channel);
            }
            catch (CallCredentialsFactory.CallCredentialsCreationException e) {
                throw new RuntimeException(e);
            }
        }
        return (Channel)this.insecureChannels.get(targetUrl);
    }

    public synchronized Channel forSecureClients(String targetUrl) {
        if (!this.secureChannels.containsKey(targetUrl)) {
            ChannelCredentials tlsChannelCredentials = TlsChannelCredentials.create();
            ManagedChannel channel = Grpc.newChannelBuilder((String)targetUrl, (ChannelCredentials)tlsChannelCredentials).build();
            this.secureChannels.put(targetUrl, channel);
        }
        return (Channel)this.secureChannels.get(targetUrl);
    }

    public synchronized Channel forSecureClients(String targetUrl, AuthenticationConfig authnConfig) {
        if (!this.secureChannels.containsKey(targetUrl)) {
            ChannelCredentials tlsChannelCredentials = TlsChannelCredentials.create();
            try {
                ManagedChannel channel = Grpc.newChannelBuilder((String)targetUrl, (ChannelCredentials)CompositeChannelCredentials.create((ChannelCredentials)tlsChannelCredentials, (CallCredentials)CallCredentialsFactory.create(authnConfig))).build();
                this.secureChannels.put(targetUrl, channel);
            }
            catch (CallCredentialsFactory.CallCredentialsCreationException e) {
                throw new RuntimeException(e);
            }
        }
        return (Channel)this.secureChannels.get(targetUrl);
    }

    public synchronized void shutdownAll() {
        for (ManagedChannel channel : this.insecureChannels.values()) {
            channel.shutdown();
        }
        this.insecureChannels.clear();
        for (ManagedChannel channel : this.secureChannels.values()) {
            channel.shutdown();
        }
        this.secureChannels.clear();
    }

    public synchronized void shutdownChannel(Channel channelToShutdown) {
        Map.Entry<String, ManagedChannel> entry;
        Iterator<Map.Entry<String, ManagedChannel>> iter = this.insecureChannels.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            if (entry.getValue() != channelToShutdown) continue;
            entry.getValue().shutdown();
            iter.remove();
            return;
        }
        iter = this.secureChannels.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            if (entry.getValue() != channelToShutdown) continue;
            entry.getValue().shutdown();
            iter.remove();
            return;
        }
    }
}

