/*
 * Decompiled with CFR 0.152.
 */
package org.project_kessel.clients.authn.oidc.client;

import io.grpc.CallCredentials;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.project_kessel.clients.authn.AuthenticationConfig;
import org.project_kessel.clients.authn.oidc.client.OIDCClientCredentialsAuthenticationConfig;
import org.project_kessel.clients.authn.oidc.client.OIDCClientCredentialsMinter;

public class OIDCClientCredentialsCallCredentials
extends CallCredentials {
    static final Metadata.Key<String> authorizationKey = Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final OIDCClientCredentialsAuthenticationConfig.OIDCClientCredentialsConfig clientCredentialsConfig;
    private final OIDCClientCredentialsMinter minter;
    private final AtomicReference<OIDCClientCredentialsMinter.BearerHeader> storedBearerHeaderRef = new AtomicReference();

    public OIDCClientCredentialsCallCredentials(AuthenticationConfig authnConfig) throws OIDCClientCredentialsCallCredentialsException {
        this.clientCredentialsConfig = OIDCClientCredentialsCallCredentials.validateAndExtractConfig(authnConfig);
        Optional<String> minterImpl = this.clientCredentialsConfig.oidcClientCredentialsMinterImplementation();
        try {
            this.minter = minterImpl.isPresent() ? OIDCClientCredentialsMinter.forName(minterImpl.get()) : OIDCClientCredentialsMinter.forDefaultImplementation();
        }
        catch (OIDCClientCredentialsMinter.OIDCClientCredentialsMinterException e) {
            throw new OIDCClientCredentialsCallCredentialsException("Couldn't create GrpcCallCredentials because minter impl not instantiated.", e);
        }
    }

    OIDCClientCredentialsCallCredentials(OIDCClientCredentialsAuthenticationConfig.OIDCClientCredentialsConfig clientCredentialsConfig, OIDCClientCredentialsMinter minter) {
        this.clientCredentialsConfig = clientCredentialsConfig;
        this.minter = minter;
    }

    static OIDCClientCredentialsAuthenticationConfig.OIDCClientCredentialsConfig validateAndExtractConfig(AuthenticationConfig authnConfig) throws OIDCClientCredentialsCallCredentialsException {
        if (!(authnConfig instanceof OIDCClientCredentialsAuthenticationConfig)) {
            throw new OIDCClientCredentialsCallCredentialsException("ClientCredentialsConfig is required for OIDC client credentials authentication method.");
        }
        OIDCClientCredentialsAuthenticationConfig oidcClientCredentialsAuthenticationConfig = (OIDCClientCredentialsAuthenticationConfig)authnConfig;
        if (oidcClientCredentialsAuthenticationConfig.clientCredentialsConfig() == null) {
            throw new OIDCClientCredentialsCallCredentialsException("ClientCredentialsConfig cannot be null.");
        }
        if (oidcClientCredentialsAuthenticationConfig.clientCredentialsConfig().issuer() == null) {
            throw new OIDCClientCredentialsCallCredentialsException("ClientCredentialsConfig Issuer must not be null.");
        }
        if (oidcClientCredentialsAuthenticationConfig.clientCredentialsConfig().clientId() == null) {
            throw new OIDCClientCredentialsCallCredentialsException("ClientCredentialsConfig Client id must not be null.");
        }
        if (oidcClientCredentialsAuthenticationConfig.clientCredentialsConfig().clientSecret() == null) {
            throw new OIDCClientCredentialsCallCredentialsException("ClientCredentialsConfig Client secret must not be null.");
        }
        return oidcClientCredentialsAuthenticationConfig.clientCredentialsConfig();
    }

    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
        appExecutor.execute(() -> {
            try {
                AtomicReference<OIDCClientCredentialsMinter.BearerHeader> atomicReference = this.storedBearerHeaderRef;
                synchronized (atomicReference) {
                    if (this.storedBearerHeaderRef.get() == null || this.storedBearerHeaderRef.get().isExpired()) {
                        this.storedBearerHeaderRef.set(this.minter.authenticateAndRetrieveAuthorizationHeader(this.clientCredentialsConfig));
                    }
                    Metadata headers = new Metadata();
                    headers.put(authorizationKey, (Object)this.storedBearerHeaderRef.get().getAuthorizationHeader());
                    applier.apply(headers);
                }
            }
            catch (Exception e) {
                applier.fail(Status.UNAUTHENTICATED.withCause((Throwable)e));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushStoredCredentials() {
        AtomicReference<OIDCClientCredentialsMinter.BearerHeader> atomicReference = this.storedBearerHeaderRef;
        synchronized (atomicReference) {
            this.storedBearerHeaderRef.set(null);
        }
    }

    public static class OIDCClientCredentialsCallCredentialsException
    extends Exception {
        public OIDCClientCredentialsCallCredentialsException(String message) {
            super(message);
        }

        public OIDCClientCredentialsCallCredentialsException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

