/*
 * Decompiled with CFR 0.152.
 */
package org.project_kessel.clients.authn.oidc.client;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDateTime;
import java.util.Optional;
import org.project_kessel.clients.authn.oidc.client.OIDCClientCredentialsAuthenticationConfig;
import org.project_kessel.clients.authn.oidc.client.nimbus.NimbusOIDCClientCredentialsMinter;

public abstract class OIDCClientCredentialsMinter {
    private static final Class<?> defaultMinter = NimbusOIDCClientCredentialsMinter.class;

    public static OIDCClientCredentialsMinter forDefaultImplementation() throws OIDCClientCredentialsMinterException {
        return OIDCClientCredentialsMinter.forClass(defaultMinter);
    }

    public static OIDCClientCredentialsMinter forClass(Class<?> minterClass) throws OIDCClientCredentialsMinterException {
        try {
            Constructor<?> constructor = minterClass.getConstructor(new Class[0]);
            return (OIDCClientCredentialsMinter)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new OIDCClientCredentialsMinterException("Can't create instance of OIDC client credentials minter", e);
        }
    }

    public static OIDCClientCredentialsMinter forName(String name) throws OIDCClientCredentialsMinterException {
        try {
            Class<?> minterImplClass = Class.forName(name);
            return OIDCClientCredentialsMinter.forClass(minterImplClass);
        }
        catch (ClassNotFoundException e) {
            throw new OIDCClientCredentialsMinterException("Can't find the specified OIDC client credentials minter implementation", e);
        }
    }

    public static Optional<LocalDateTime> getExpiryDateFromExpiresIn(long expiresIn) {
        long bufferSeconds;
        Optional<Object> expiryTime = expiresIn != 0L ? (expiresIn < (bufferSeconds = 60L) ? Optional.empty() : Optional.of(LocalDateTime.now().plusSeconds(expiresIn).minusSeconds(bufferSeconds))) : Optional.empty();
        return expiryTime;
    }

    public static Class<?> getDefaultMinterImplementation() {
        return defaultMinter;
    }

    public abstract BearerHeader authenticateAndRetrieveAuthorizationHeader(OIDCClientCredentialsAuthenticationConfig.OIDCClientCredentialsConfig var1) throws OIDCClientCredentialsMinterException;

    public static class OIDCClientCredentialsMinterException
    extends Exception {
        public OIDCClientCredentialsMinterException(String message) {
            super(message);
        }

        public OIDCClientCredentialsMinterException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class BearerHeader {
        private final String authorizationHeader;
        private final Optional<LocalDateTime> expiry;

        public BearerHeader(String authorizationHeader, Optional<LocalDateTime> expiry) {
            this.authorizationHeader = authorizationHeader;
            this.expiry = expiry;
        }

        public String getAuthorizationHeader() {
            return this.authorizationHeader;
        }

        public boolean isExpired() {
            return this.expiry.map(t -> t.isBefore(LocalDateTime.now())).orElse(true);
        }
    }
}

