/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.ast.AstException;
import lombok.ast.Expression;
import lombok.ast.Message;
import lombok.ast.MessageKey;
import lombok.ast.Node;
import lombok.ast.Position;
import lombok.ast.libs.com.google.common.collect.Lists;
import lombok.ast.libs.com.google.common.collect.Maps;
import lombok.ast.printer.SourcePrinter;
import lombok.ast.printer.TextFormatter;

abstract class AbstractNode
implements Node {
    private Position position = Position.UNPLACED;
    private Node parent;
    private List<Node> danglings;
    private Map<String, Position> conversionPositions;
    private Map<MessageKey, Message> messagesMap;
    private List<Message> messages;

    AbstractNode() {
    }

    @Override
    public boolean isGenerated() {
        return this.position.getGeneratedBy() != null;
    }

    @Override
    public Node getGeneratedBy() {
        return this.position.getGeneratedBy();
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public List<Node> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public boolean replace(Node replacement) throws AstException {
        if (this.getParent() == null) {
            return false;
        }
        return this.parent.replaceChild(this, replacement);
    }

    @Override
    public void unparent() {
        if (this.parent != null) {
            this.parent.detach(this);
        }
    }

    protected AbstractNode adopt(AbstractNode child) throws IllegalStateException {
        child.ensureParentless();
        child.parent = this;
        return child;
    }

    protected void ensureParentless() throws IllegalStateException {
        if (this.parent == null) {
            return;
        }
        throw new IllegalStateException(String.format("I (%s) already have a parent, so you can't add me to something else; clone or unparent me first.", this.getClass().getName()));
    }

    protected void disown(AbstractNode child) throws IllegalStateException {
        this.ensureParentage(child);
        child.parent = null;
    }

    protected void ensureParentage(AbstractNode child) throws IllegalStateException {
        if (child.parent == this) {
            return;
        }
        throw new IllegalStateException(String.format("Can't disown child of type %s - it isn't my child (I'm a %s)", child.getClass().getName(), this.getClass().getName()));
    }

    @Override
    public Node setPosition(Position position) {
        if (position == null) {
            throw new NullPointerException("position");
        }
        this.position = position;
        return this;
    }

    @Override
    public String toString() {
        TextFormatter formatter = new TextFormatter();
        SourcePrinter printer = new SourcePrinter(formatter);
        this.accept(printer);
        return formatter.finish();
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) {
        return false;
    }

    @Override
    public boolean detach(Node child) {
        return false;
    }

    void addDanglingNode(Node dangling) {
        if (dangling == null) {
            return;
        }
        if (this.danglings == null) {
            this.danglings = Lists.newArrayList();
        }
        this.danglings.add(dangling);
    }

    void removeDanglingNode(Node dangling) {
        if (this.danglings != null) {
            this.danglings.remove(dangling);
        }
    }

    List<Node> getDanglingNodes() {
        return this.danglings == null ? Collections.emptyList() : Collections.unmodifiableList(this.danglings);
    }

    void addConversionPositionInfo(String key, Position position) {
        if (this.conversionPositions == null) {
            this.conversionPositions = Maps.newHashMap();
        }
        this.conversionPositions.put(key, position);
    }

    Position getConversionPositionInfo(String key) {
        if (this.conversionPositions == null) {
            return null;
        }
        return this.conversionPositions.get(key);
    }

    @Override
    public Node addMessage(Message message) {
        if (this.messagesMap == null) {
            this.messagesMap = Maps.newHashMap();
            this.messages = Lists.newArrayList();
        }
        if (message.getKey() == null) {
            this.messages.add(message);
        } else if (!this.messagesMap.containsKey(message.getKey())) {
            this.messagesMap.put(message.getKey(), message);
            this.messages.add(message);
        }
        return this;
    }

    @Override
    public boolean hasMessage(String key) {
        if (this.messagesMap == null) {
            return false;
        }
        return this.messagesMap.containsKey(key);
    }

    @Override
    public List<Message> getMessages() {
        return this.messages == null ? Collections.emptyList() : Collections.unmodifiableList(this.messages);
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    static abstract class WithParens
    extends AbstractNode
    implements Expression {
        private List<Position> parensPositions = Lists.newArrayList();

        WithParens() {
        }

        @Override
        public boolean needsParentheses() {
            return false;
        }

        @Override
        public List<Position> astParensPositions() {
            return this.parensPositions;
        }

        @Override
        public int getParens() {
            return this.parensPositions.size();
        }

        @Override
        public int getIntendedParens() {
            return this.parensPositions.size();
        }
    }
}

