/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.ecj;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.ast.AlternateConstructorInvocation;
import lombok.ast.Annotation;
import lombok.ast.AnnotationDeclaration;
import lombok.ast.AnnotationElement;
import lombok.ast.AnnotationMethodDeclaration;
import lombok.ast.AnnotationValueArray;
import lombok.ast.ArrayAccess;
import lombok.ast.ArrayCreation;
import lombok.ast.ArrayDimension;
import lombok.ast.ArrayInitializer;
import lombok.ast.Assert;
import lombok.ast.AstVisitor;
import lombok.ast.BinaryExpression;
import lombok.ast.BinaryOperator;
import lombok.ast.Block;
import lombok.ast.BooleanLiteral;
import lombok.ast.Break;
import lombok.ast.Case;
import lombok.ast.Cast;
import lombok.ast.Catch;
import lombok.ast.CharLiteral;
import lombok.ast.ClassDeclaration;
import lombok.ast.ClassLiteral;
import lombok.ast.Comment;
import lombok.ast.CompilationUnit;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.ConstructorInvocation;
import lombok.ast.Continue;
import lombok.ast.ConversionPositionInfo;
import lombok.ast.Default;
import lombok.ast.DoWhile;
import lombok.ast.EmptyDeclaration;
import lombok.ast.EmptyStatement;
import lombok.ast.EnumConstant;
import lombok.ast.EnumDeclaration;
import lombok.ast.EnumTypeBody;
import lombok.ast.Expression;
import lombok.ast.ExpressionStatement;
import lombok.ast.FloatingPointLiteral;
import lombok.ast.For;
import lombok.ast.ForEach;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.Identifier;
import lombok.ast.If;
import lombok.ast.ImportDeclaration;
import lombok.ast.InlineIfExpression;
import lombok.ast.InstanceInitializer;
import lombok.ast.InstanceOf;
import lombok.ast.IntegralLiteral;
import lombok.ast.InterfaceDeclaration;
import lombok.ast.JavadocContainer;
import lombok.ast.KeywordModifier;
import lombok.ast.LabelledStatement;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Modifiers;
import lombok.ast.Node;
import lombok.ast.NullLiteral;
import lombok.ast.PackageDeclaration;
import lombok.ast.Position;
import lombok.ast.RawListAccessor;
import lombok.ast.Return;
import lombok.ast.Select;
import lombok.ast.Statement;
import lombok.ast.StaticInitializer;
import lombok.ast.StrictListAccessor;
import lombok.ast.StringLiteral;
import lombok.ast.Super;
import lombok.ast.SuperConstructorInvocation;
import lombok.ast.Switch;
import lombok.ast.Synchronized;
import lombok.ast.This;
import lombok.ast.Throw;
import lombok.ast.Try;
import lombok.ast.TypeBody;
import lombok.ast.TypeDeclaration;
import lombok.ast.TypeMember;
import lombok.ast.TypeReference;
import lombok.ast.TypeReferencePart;
import lombok.ast.TypeVariable;
import lombok.ast.UnaryExpression;
import lombok.ast.UnaryOperator;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;
import lombok.ast.While;
import lombok.ast.grammar.Source;
import lombok.ast.grammar.SourceStructure;
import lombok.ast.libs.com.google.common.collect.Lists;
import lombok.ast.libs.com.google.common.collect.Maps;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.AND_AND_Expression;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.AssertStatement;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.BreakStatement;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.ContinueStatement;
import org.eclipse.jdt.internal.compiler.ast.DoStatement;
import org.eclipse.jdt.internal.compiler.ast.DoubleLiteral;
import org.eclipse.jdt.internal.compiler.ast.EqualExpression;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.ExtendedStringLiteral;
import org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.FloatLiteral;
import org.eclipse.jdt.internal.compiler.ast.ForStatement;
import org.eclipse.jdt.internal.compiler.ast.ForeachStatement;
import org.eclipse.jdt.internal.compiler.ast.IfStatement;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.InstanceOfExpression;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.IntLiteralMinValue;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.LabeledStatement;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LongLiteral;
import org.eclipse.jdt.internal.compiler.ast.LongLiteralMinValue;
import org.eclipse.jdt.internal.compiler.ast.MarkerAnnotation;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.eclipse.jdt.internal.compiler.ast.OR_OR_Expression;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.PostfixExpression;
import org.eclipse.jdt.internal.compiler.ast.PrefixExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedSuperReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.StringLiteralConcatenation;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.ThrowStatement;
import org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.WhileStatement;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.JavadocParser;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class EcjTreeBuilder {
    private static final int VISIBILITY_MASK = 7;
    static final char[] PACKAGE_INFO = "package-info".toCharArray();
    private final Map<Node, Collection<SourceStructure>> sourceStructures;
    private List<? extends ASTNode> result = null;
    private final String rawInput;
    private final ProblemReporter reporter;
    private final ProblemReporter silentProblemReporter;
    private final CompilationResult compilationResult;
    private final CompilerOptions options;
    private final EnumSet<BubblingFlags> bubblingFlags = EnumSet.noneOf(BubblingFlags.class);
    private final EnumSet<BubblingFlags> AUTO_REMOVABLE_BUBBLING_FLAGS = EnumSet.of(BubblingFlags.LOCALTYPE);
    private static final IProblemFactory SILENT_PROBLEM_FACTORY = new IProblemFactory(){

        public String getLocalizedMessage(int problemId, int elaborationId, String[] messageArguments) {
            return null;
        }

        public String getLocalizedMessage(int problemId, String[] messageArguments) {
            return null;
        }

        public Locale getLocale() {
            return Locale.getDefault();
        }

        public CategorizedProblem createProblem(char[] originatingFileName, int problemId, String[] problemArguments, int elaborationId, String[] messageArguments, int severity, int startPosition, int endPosition, int lineNumber, int columnNumber) {
            return null;
        }

        public CategorizedProblem createProblem(char[] originatingFileName, int problemId, String[] problemArguments, String[] messageArguments, int severity, int startPosition, int endPosition, int lineNumber, int columnNumber) {
            return null;
        }
    };
    private static final EnumMap<UnaryOperator, Integer> UNARY_OPERATORS = Maps.newEnumMap(UnaryOperator.class);
    private static final EnumMap<BinaryOperator, Integer> BINARY_OPERATORS;
    private final AstVisitor visitor = new ForwardingAstVisitor(){

        @Override
        public boolean visitCompilationUnit(CompilationUnit node) {
            int sourceLength = EcjTreeBuilder.this.rawInput == null ? 0 : EcjTreeBuilder.this.rawInput.length();
            CompilationUnitDeclaration cud = new CompilationUnitDeclaration(EcjTreeBuilder.this.reporter, EcjTreeBuilder.this.compilationResult, sourceLength);
            cud.bits |= 0x10;
            cud.currentPackage = (ImportReference)EcjTreeBuilder.this.toTree(node.astPackageDeclaration());
            cud.imports = (ImportReference[])EcjTreeBuilder.this.toArray(ImportReference.class, node.astImportDeclarations());
            cud.types = (org.eclipse.jdt.internal.compiler.ast.TypeDeclaration[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.TypeDeclaration.class, node.astTypeDeclarations());
            if (CharOperation.equals((char[])PACKAGE_INFO, (char[])cud.getMainTypeName())) {
                Comment javadoc;
                org.eclipse.jdt.internal.compiler.ast.TypeDeclaration[] newTypes;
                if (cud.types == null) {
                    newTypes = new org.eclipse.jdt.internal.compiler.ast.TypeDeclaration[1];
                } else {
                    newTypes = new org.eclipse.jdt.internal.compiler.ast.TypeDeclaration[cud.types.length + 1];
                    System.arraycopy(cud.types, 0, newTypes, 1, cud.types.length);
                }
                org.eclipse.jdt.internal.compiler.ast.TypeDeclaration decl = new org.eclipse.jdt.internal.compiler.ast.TypeDeclaration(EcjTreeBuilder.this.compilationResult);
                decl.name = (char[])PACKAGE_INFO.clone();
                decl.modifiers = 512;
                newTypes[0] = decl;
                cud.types = newTypes;
                PackageDeclaration pkgDeclaration = node.astPackageDeclaration();
                Comment comment = javadoc = pkgDeclaration == null ? null : pkgDeclaration.astJavadoc();
                if (javadoc != null) {
                    boolean markDep = javadoc.isMarkedDeprecated();
                    cud.javadoc = (Javadoc)EcjTreeBuilder.this.toTree(javadoc);
                    if (markDep) {
                        decl.modifiers |= 0x100000;
                    }
                    decl.javadoc = cud.javadoc;
                }
            }
            EcjTreeBuilder.this.bubblingFlags.remove((Object)BubblingFlags.ASSERT);
            EcjTreeBuilder.this.bubblingFlags.removeAll(EcjTreeBuilder.this.AUTO_REMOVABLE_BUBBLING_FLAGS);
            if (!EcjTreeBuilder.this.bubblingFlags.isEmpty()) {
                throw new RuntimeException("Unhandled bubbling flags left: " + EcjTreeBuilder.this.bubblingFlags);
            }
            return this.set((Node)node, (ASTNode)cud);
        }

        private boolean set(Node node, ASTNode value) {
            if (EcjTreeBuilder.this.result != null) {
                throw new IllegalStateException("result is already set");
            }
            if (node instanceof Expression) {
                int parens = ((Expression)node).getIntendedParens();
                value.bits |= parens << 21 & 0x1FE00000;
                EcjTreeBuilder.posParen(value, node);
            }
            if (value instanceof NameReference) {
                this.updateRestrictionFlags(node, (NameReference)value);
            }
            ArrayList<ASTNode> result = Lists.newArrayList();
            if (value != null) {
                result.add(value);
            }
            EcjTreeBuilder.this.result = result;
            return true;
        }

        private boolean set(Node node, List<? extends ASTNode> values) {
            if (values.isEmpty()) {
                System.err.printf("Node '%s' (%s) did not produce any results\n", node, node.getClass().getSimpleName());
            }
            if (EcjTreeBuilder.this.result != null) {
                throw new IllegalStateException("result is already set");
            }
            EcjTreeBuilder.this.result = values;
            return true;
        }

        private int calculateExplicitDeclarations(Iterable<Statement> statements) {
            int explicitDeclarations = 0;
            if (statements != null) {
                for (Statement s : statements) {
                    if (s instanceof VariableDeclaration) {
                        ++explicitDeclarations;
                    }
                    if (!(s instanceof ClassDeclaration)) continue;
                    ++explicitDeclarations;
                }
            }
            return explicitDeclarations;
        }

        @Override
        public boolean visitPackageDeclaration(PackageDeclaration node) {
            long[] pos = EcjTreeBuilder.partsToPosArray(node.rawParts());
            ImportReference pkg = new ImportReference(this.chain(node.astParts()), pos, true, 0);
            pkg.annotations = (org.eclipse.jdt.internal.compiler.ast.Annotation[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.Annotation.class, node.astAnnotations());
            pkg.declarationSourceStart = EcjTreeBuilder.jstart(node);
            pkg.declarationSourceEnd = pkg.declarationEnd = EcjTreeBuilder.end(node);
            return this.set((Node)node, (ASTNode)pkg);
        }

        @Override
        public boolean visitImportDeclaration(ImportDeclaration node) {
            int staticFlag = node.astStaticImport() ? 8 : 0;
            long[] pos = EcjTreeBuilder.partsToPosArray(node.rawParts());
            ImportReference imp = new ImportReference(this.chain(node.astParts()), pos, node.astStarImport(), staticFlag);
            imp.declarationSourceStart = EcjTreeBuilder.start(node);
            imp.declarationSourceEnd = imp.declarationEnd = EcjTreeBuilder.end(node);
            return this.set((Node)node, (ASTNode)imp);
        }

        @Override
        public boolean visitClassDeclaration(ClassDeclaration node) {
            org.eclipse.jdt.internal.compiler.ast.TypeDeclaration decl = this.createTypeBody(node.astBody().astMembers(), node, true, 0, new FieldDeclaration[0]);
            decl.annotations = (org.eclipse.jdt.internal.compiler.ast.Annotation[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.Annotation.class, node.astModifiers().astAnnotations());
            decl.superclass = (org.eclipse.jdt.internal.compiler.ast.TypeReference)EcjTreeBuilder.this.toTree(node.astExtending());
            decl.superInterfaces = (org.eclipse.jdt.internal.compiler.ast.TypeReference[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.TypeReference.class, node.astImplementing());
            this.markTypeReferenceIsSuperType(decl);
            decl.typeParameters = (TypeParameter[])EcjTreeBuilder.this.toArray(TypeParameter.class, node.astTypeVariables());
            decl.name = EcjTreeBuilder.this.toName(node.astName());
            this.updateTypeBits(node.getParent(), decl, false);
            this.setupJavadoc((ASTNode)decl, node);
            return this.set((Node)node, (ASTNode)decl);
        }

        private void updateTypeBits(Node parent, org.eclipse.jdt.internal.compiler.ast.TypeDeclaration decl, boolean isEnum) {
            if (parent == null) {
                return;
            }
            if (parent instanceof CompilationUnit) {
                char[] mainTypeName = new CompilationUnitDeclaration(EcjTreeBuilder.this.reporter, EcjTreeBuilder.this.compilationResult, 0).getMainTypeName();
                if (!CharOperation.equals((char[])decl.name, (char[])mainTypeName)) {
                    decl.bits |= 0x1000;
                }
                return;
            }
            if (parent instanceof TypeBody || parent instanceof EnumTypeBody) {
                decl.bits |= 0x400;
                return;
            }
            decl.bits |= 0x100;
            EcjTreeBuilder.this.bubblingFlags.add(BubblingFlags.LOCALTYPE);
        }

        private void markTypeReferenceIsSuperType(org.eclipse.jdt.internal.compiler.ast.TypeDeclaration decl) {
            if (decl.superclass != null) {
                decl.superclass.bits |= 0x10;
            }
            if (decl.superInterfaces != null) {
                for (org.eclipse.jdt.internal.compiler.ast.TypeReference t : decl.superInterfaces) {
                    t.bits |= 0x10;
                }
            }
        }

        @Override
        public boolean visitInterfaceDeclaration(InterfaceDeclaration node) {
            org.eclipse.jdt.internal.compiler.ast.TypeDeclaration decl = this.createTypeBody(node.astBody().astMembers(), node, false, 512, new FieldDeclaration[0]);
            decl.annotations = (org.eclipse.jdt.internal.compiler.ast.Annotation[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.Annotation.class, node.astModifiers().astAnnotations());
            decl.superInterfaces = (org.eclipse.jdt.internal.compiler.ast.TypeReference[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.TypeReference.class, node.astExtending());
            this.markTypeReferenceIsSuperType(decl);
            decl.typeParameters = (TypeParameter[])EcjTreeBuilder.this.toArray(TypeParameter.class, node.astTypeVariables());
            decl.name = EcjTreeBuilder.this.toName(node.astName());
            this.updateTypeBits(node.getParent(), decl, false);
            this.setupJavadoc((ASTNode)decl, node);
            return this.set((Node)node, (ASTNode)decl);
        }

        @Override
        public boolean visitEnumDeclaration(EnumDeclaration node) {
            FieldDeclaration[] fields = null;
            if (node.astBody() != null) {
                fields = (FieldDeclaration[])EcjTreeBuilder.this.toArray(FieldDeclaration.class, node.astBody().astConstants());
            }
            org.eclipse.jdt.internal.compiler.ast.TypeDeclaration decl = this.createTypeBody(node.astBody().astMembers(), node, true, 16384, fields);
            decl.annotations = (org.eclipse.jdt.internal.compiler.ast.Annotation[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.Annotation.class, node.astModifiers().astAnnotations());
            decl.superInterfaces = (org.eclipse.jdt.internal.compiler.ast.TypeReference[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.TypeReference.class, node.astImplementing());
            this.markTypeReferenceIsSuperType(decl);
            decl.name = EcjTreeBuilder.this.toName(node.astName());
            this.updateTypeBits(node.getParent(), decl, true);
            this.setupJavadoc((ASTNode)decl, node);
            return this.set((Node)node, (ASTNode)decl);
        }

        @Override
        public boolean visitEnumConstant(EnumConstant node) {
            AllocationExpression init;
            FieldDeclaration decl = new FieldDeclaration();
            decl.annotations = (org.eclipse.jdt.internal.compiler.ast.Annotation[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.Annotation.class, node.astAnnotations());
            decl.name = EcjTreeBuilder.this.toName(node.astName());
            decl.sourceStart = EcjTreeBuilder.start(node.astName());
            decl.sourceEnd = EcjTreeBuilder.end(node.astName());
            decl.declarationSourceStart = decl.modifiersSourceStart = EcjTreeBuilder.jstart(node);
            decl.declarationSourceEnd = decl.declarationEnd = EcjTreeBuilder.end(node);
            Position ecjDeclarationSourcePos = ConversionPositionInfo.getConversionPositionInfo(node, "declarationSource");
            if (ecjDeclarationSourcePos != null) {
                decl.declarationSourceEnd = ecjDeclarationSourcePos.getEnd() - 1;
            }
            if (node.astBody() == null) {
                init = new AllocationExpression();
                init.enumConstant = decl;
            } else {
                org.eclipse.jdt.internal.compiler.ast.TypeDeclaration type = this.createTypeBody(node.astBody().astMembers(), null, false, 0, new FieldDeclaration[0]);
                type.sourceStart = type.sourceEnd = EcjTreeBuilder.start(node.astBody());
                --type.bodyEnd;
                type.declarationSourceStart = type.sourceStart;
                type.declarationSourceEnd = EcjTreeBuilder.end(node);
                type.name = CharOperation.NO_CHAR;
                type.bits &= 0xFFFFFBFF;
                decl.bits |= 2;
                type.bits |= 0x300;
                init = new QualifiedAllocationExpression(type);
                init.enumConstant = decl;
            }
            init.arguments = (org.eclipse.jdt.internal.compiler.ast.Expression[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.Expression.class, node.astArguments());
            decl.initialization = init;
            if (EcjTreeBuilder.this.bubblingFlags.remove((Object)BubblingFlags.LOCALTYPE)) {
                decl.bits |= 2;
            }
            this.setupJavadoc((ASTNode)decl, node);
            return this.set((Node)node, (ASTNode)decl);
        }

        @Override
        public boolean visitAnnotationDeclaration(AnnotationDeclaration node) {
            org.eclipse.jdt.internal.compiler.ast.TypeDeclaration decl = this.createTypeBody(node.astBody().astMembers(), node, false, 8704, new FieldDeclaration[0]);
            decl.annotations = (org.eclipse.jdt.internal.compiler.ast.Annotation[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.Annotation.class, node.astModifiers().astAnnotations());
            decl.name = EcjTreeBuilder.this.toName(node.astName());
            this.updateTypeBits(node.getParent(), decl, false);
            this.setupJavadoc((ASTNode)decl, node);
            return this.set((Node)node, (ASTNode)decl);
        }

        private void setupJavadoc(ASTNode node, JavadocContainer container) {
            if (container != null && container.rawJavadoc() instanceof Comment) {
                AbstractMethodDeclaration decl;
                Comment javadoc = (Comment)container.rawJavadoc();
                boolean markDep = javadoc.isMarkedDeprecated();
                if (node instanceof AbstractMethodDeclaration) {
                    decl = (AbstractMethodDeclaration)node;
                    decl.javadoc = (Javadoc)EcjTreeBuilder.this.toTree(javadoc);
                    if (markDep) {
                        decl.modifiers |= 0x100000;
                    }
                }
                if (node instanceof FieldDeclaration) {
                    decl = (FieldDeclaration)node;
                    decl.javadoc = (Javadoc)EcjTreeBuilder.this.toTree(javadoc);
                    if (markDep) {
                        decl.modifiers |= 0x100000;
                    }
                }
                if (node instanceof org.eclipse.jdt.internal.compiler.ast.TypeDeclaration) {
                    decl = (org.eclipse.jdt.internal.compiler.ast.TypeDeclaration)node;
                    decl.javadoc = (Javadoc)EcjTreeBuilder.this.toTree(javadoc);
                    if (markDep) {
                        decl.modifiers |= 0x100000;
                    }
                }
            }
        }

        @Override
        public boolean visitConstructorDeclaration(ConstructorDeclaration node) {
            org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration decl = new org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration(EcjTreeBuilder.this.compilationResult);
            decl.bodyStart = EcjTreeBuilder.start(node.rawBody()) + 1;
            decl.bodyEnd = EcjTreeBuilder.end(node.rawBody()) - 1;
            decl.declarationSourceStart = EcjTreeBuilder.jstart(node);
            decl.declarationSourceEnd = EcjTreeBuilder.end(node);
            decl.sourceStart = EcjTreeBuilder.start(node.astTypeName());
            Position ecjPos = ConversionPositionInfo.getConversionPositionInfo(node, "signature");
            int n = decl.sourceEnd = ecjPos == null ? EcjTreeBuilder.this.posOfStructure(node, ")", false) - 1 : ecjPos.getEnd() - 1;
            if (!node.rawThrownTypeReferences().isEmpty()) {
                decl.sourceEnd = EcjTreeBuilder.end(node.rawThrownTypeReferences().last());
            }
            decl.annotations = (org.eclipse.jdt.internal.compiler.ast.Annotation[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.Annotation.class, node.astModifiers().astAnnotations());
            decl.modifiers = this.toModifiers(node.astModifiers());
            decl.typeParameters = (TypeParameter[])EcjTreeBuilder.this.toArray(TypeParameter.class, node.astTypeVariables());
            decl.arguments = (Argument[])EcjTreeBuilder.this.toArray(Argument.class, node.astParameters());
            decl.thrownExceptions = (org.eclipse.jdt.internal.compiler.ast.TypeReference[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.TypeReference.class, node.astThrownTypeReferences());
            decl.statements = (org.eclipse.jdt.internal.compiler.ast.Statement[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.Statement.class, node.astBody().astContents());
            decl.selector = EcjTreeBuilder.this.toName(node.astTypeName());
            this.setupJavadoc((ASTNode)decl, node);
            if (decl.statements == null || decl.statements.length == 0 || !(decl.statements[0] instanceof ExplicitConstructorCall)) {
                decl.constructorCall = new ExplicitConstructorCall(1);
                decl.constructorCall.sourceStart = decl.sourceStart;
                decl.constructorCall.sourceEnd = decl.sourceEnd;
            } else {
                decl.constructorCall = (ExplicitConstructorCall)decl.statements[0];
                if (decl.statements.length > 1) {
                    org.eclipse.jdt.internal.compiler.ast.Statement[] newStatements = new org.eclipse.jdt.internal.compiler.ast.Statement[decl.statements.length - 1];
                    System.arraycopy(decl.statements, 1, newStatements, 0, newStatements.length);
                    decl.statements = newStatements;
                } else {
                    decl.statements = null;
                }
            }
            if (EcjTreeBuilder.this.bubblingFlags.remove((Object)BubblingFlags.LOCALTYPE)) {
                decl.bits |= 2;
            }
            if (this.isUndocumented(node.astBody())) {
                decl.bits |= 8;
            }
            this.setupJavadoc((ASTNode)decl, node);
            return this.set((Node)node, (ASTNode)decl);
        }

        @Override
        public boolean visitMethodDeclaration(MethodDeclaration node) {
            org.eclipse.jdt.internal.compiler.ast.MethodDeclaration decl = new org.eclipse.jdt.internal.compiler.ast.MethodDeclaration(EcjTreeBuilder.this.compilationResult);
            decl.declarationSourceStart = EcjTreeBuilder.jstart(node);
            decl.declarationSourceEnd = EcjTreeBuilder.end(node);
            decl.sourceStart = EcjTreeBuilder.start(node.astMethodName());
            boolean setOriginalPosOnType = false;
            Position ecjPos = ConversionPositionInfo.getConversionPositionInfo(node, "signature");
            int n = decl.sourceEnd = ecjPos == null ? EcjTreeBuilder.this.posOfStructure(node, ")", false) - 1 : ecjPos.getEnd() - 1;
            if (EcjTreeBuilder.this.countStructure(node, "]") > 0) {
                decl.sourceEnd = EcjTreeBuilder.this.posOfStructure(node, "]", false) - 1;
                setOriginalPosOnType = true;
            }
            if (!node.rawThrownTypeReferences().isEmpty()) {
                decl.sourceEnd = EcjTreeBuilder.end(node.rawThrownTypeReferences().last());
            }
            if (node.rawBody() == null) {
                decl.bodyStart = decl.sourceEnd + 1;
                decl.bodyEnd = EcjTreeBuilder.end(node) - 1;
            } else {
                decl.bodyStart = EcjTreeBuilder.start(node.rawBody()) + 1;
                decl.bodyEnd = EcjTreeBuilder.end(node.rawBody()) - 1;
            }
            decl.annotations = (org.eclipse.jdt.internal.compiler.ast.Annotation[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.Annotation.class, node.astModifiers().astAnnotations());
            decl.modifiers = this.toModifiers(node.astModifiers());
            decl.returnType = (org.eclipse.jdt.internal.compiler.ast.TypeReference)EcjTreeBuilder.this.toTree(node.astReturnTypeReference());
            if (setOriginalPosOnType && decl.returnType instanceof ArrayTypeReference) {
                ((ArrayTypeReference)decl.returnType).originalSourceEnd = EcjTreeBuilder.end(node.rawReturnTypeReference());
            }
            decl.typeParameters = (TypeParameter[])EcjTreeBuilder.this.toArray(TypeParameter.class, node.astTypeVariables());
            decl.arguments = (Argument[])EcjTreeBuilder.this.toArray(Argument.class, node.astParameters());
            decl.selector = EcjTreeBuilder.this.toName(node.astMethodName());
            decl.thrownExceptions = (org.eclipse.jdt.internal.compiler.ast.TypeReference[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.TypeReference.class, node.astThrownTypeReferences());
            if (node.astBody() == null) {
                decl.modifiers |= 0x1000000;
            } else {
                decl.statements = (org.eclipse.jdt.internal.compiler.ast.Statement[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.Statement.class, node.astBody().astContents());
                decl.explicitDeclarations = this.calculateExplicitDeclarations(node.astBody().astContents());
            }
            if (EcjTreeBuilder.this.bubblingFlags.remove((Object)BubblingFlags.LOCALTYPE)) {
                decl.bits |= 2;
            }
            if (EcjTreeBuilder.isExplicitlyAbstract(node.astModifiers())) {
                EcjTreeBuilder.this.bubblingFlags.add(BubblingFlags.ABSTRACT_METHOD);
            }
            if (this.isUndocumented(node.astBody())) {
                decl.bits |= 8;
            }
            this.setupJavadoc((ASTNode)decl, node);
            return this.set((Node)node, (ASTNode)decl);
        }

        @Override
        public boolean visitAnnotationMethodDeclaration(AnnotationMethodDeclaration node) {
            org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration decl = new org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration(EcjTreeBuilder.this.compilationResult);
            decl.modifiers = this.toModifiers(node.astModifiers()) + 0x1000000;
            decl.declarationSourceStart = EcjTreeBuilder.jstart(node);
            decl.declarationSourceEnd = EcjTreeBuilder.end(node);
            decl.sourceStart = EcjTreeBuilder.start(node.astMethodName());
            boolean setOriginalPosOnType = false;
            Position ecjSigPos = ConversionPositionInfo.getConversionPositionInfo(node, "signature");
            Position ecjExtDimPos = ConversionPositionInfo.getConversionPositionInfo(node, "extendedDimensions");
            if (ecjSigPos != null && ecjExtDimPos != null) {
                decl.sourceEnd = ecjSigPos.getEnd() - 1;
                decl.extendedDimensions = ecjExtDimPos.getStart();
            } else {
                decl.sourceEnd = EcjTreeBuilder.this.posOfStructure(node, ")", false) - 1;
                decl.extendedDimensions = EcjTreeBuilder.this.countStructure(node, "]");
                if (decl.extendedDimensions > 0) {
                    decl.sourceEnd = EcjTreeBuilder.this.posOfStructure(node, "]", false) - 1;
                    setOriginalPosOnType = true;
                }
            }
            decl.bodyStart = EcjTreeBuilder.end(node);
            decl.bodyEnd = EcjTreeBuilder.end(node);
            if (node.astDefaultValue() != null) {
                decl.modifiers |= 0x20000;
            }
            decl.annotations = (org.eclipse.jdt.internal.compiler.ast.Annotation[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.Annotation.class, node.astModifiers().astAnnotations());
            decl.defaultValue = EcjTreeBuilder.this.toExpression(node.astDefaultValue());
            decl.selector = EcjTreeBuilder.this.toName(node.astMethodName());
            decl.returnType = (org.eclipse.jdt.internal.compiler.ast.TypeReference)EcjTreeBuilder.this.toTree(node.astReturnTypeReference());
            if (setOriginalPosOnType && decl.returnType instanceof ArrayTypeReference) {
                ((ArrayTypeReference)decl.returnType).originalSourceEnd = EcjTreeBuilder.end(node.rawReturnTypeReference());
            }
            if (EcjTreeBuilder.isExplicitlyAbstract(node.astModifiers())) {
                EcjTreeBuilder.this.bubblingFlags.add(BubblingFlags.ABSTRACT_METHOD);
            }
            this.setupJavadoc((ASTNode)decl, node);
            return this.set((Node)node, (ASTNode)decl);
        }

        private org.eclipse.jdt.internal.compiler.ast.TypeDeclaration createTypeBody(StrictListAccessor<TypeMember, ?> members, TypeDeclaration type, boolean canHaveConstructor, int extraModifiers, FieldDeclaration ... initialFields) {
            org.eclipse.jdt.internal.compiler.ast.TypeDeclaration decl = new org.eclipse.jdt.internal.compiler.ast.TypeDeclaration(EcjTreeBuilder.this.compilationResult);
            decl.modifiers = (type == null ? 0 : this.toModifiers(type.astModifiers())) | extraModifiers;
            if (members.isEmpty() && this.isUndocumented(members.owner())) {
                decl.bits |= 8;
            }
            if (type != null) {
                decl.sourceStart = EcjTreeBuilder.start(type.astName());
                decl.sourceEnd = EcjTreeBuilder.end(type.astName());
                decl.declarationSourceStart = EcjTreeBuilder.jstart(type);
                decl.declarationSourceEnd = EcjTreeBuilder.end(type);
                decl.modifiersSourceStart = !(type instanceof AnnotationDeclaration) || !type.astModifiers().isEmpty() || type.rawJavadoc() != null ? EcjTreeBuilder.jstart(type.astModifiers()) : -1;
            }
            decl.bodyStart = EcjTreeBuilder.start(members.owner()) + 1;
            decl.bodyEnd = EcjTreeBuilder.end(members.owner());
            boolean hasExplicitConstructor = false;
            ArrayList<Object> methods = Lists.newArrayList();
            ArrayList<FieldDeclaration> fields = Lists.newArrayList();
            ArrayList<org.eclipse.jdt.internal.compiler.ast.TypeDeclaration> types = Lists.newArrayList();
            if (initialFields != null) {
                fields.addAll(Arrays.asList(initialFields));
            }
            for (TypeMember member : members) {
                AbstractMethodDeclaration method;
                if (member instanceof ConstructorDeclaration) {
                    hasExplicitConstructor = true;
                    method = (AbstractMethodDeclaration)EcjTreeBuilder.this.toTree(member);
                    methods.add(method);
                    continue;
                }
                if (member instanceof MethodDeclaration || member instanceof AnnotationMethodDeclaration) {
                    method = (AbstractMethodDeclaration)EcjTreeBuilder.this.toTree(member);
                    methods.add(method);
                    continue;
                }
                if (member instanceof VariableDeclaration) {
                    for (FieldDeclaration field : EcjTreeBuilder.this.toList(FieldDeclaration.class, member)) {
                        fields.add(field);
                    }
                    continue;
                }
                if (member instanceof StaticInitializer) {
                    fields.add((FieldDeclaration)EcjTreeBuilder.this.toTree(member));
                    continue;
                }
                if (member instanceof InstanceInitializer) {
                    fields.add((FieldDeclaration)EcjTreeBuilder.this.toTree(member));
                    continue;
                }
                if (member instanceof TypeDeclaration) {
                    org.eclipse.jdt.internal.compiler.ast.TypeDeclaration innerType = (org.eclipse.jdt.internal.compiler.ast.TypeDeclaration)EcjTreeBuilder.this.toTree(member);
                    if (innerType == null) continue;
                    innerType.enclosingType = decl;
                    types.add(innerType);
                    continue;
                }
                throw new RuntimeException("Unhandled member type " + member.getClass().getSimpleName());
            }
            if (!hasExplicitConstructor && canHaveConstructor) {
                org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration defaultConstructor = new org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration(EcjTreeBuilder.this.compilationResult);
                defaultConstructor.bits |= 0x80;
                defaultConstructor.constructorCall = new ExplicitConstructorCall(1);
                defaultConstructor.modifiers = decl.modifiers & 7;
                defaultConstructor.selector = EcjTreeBuilder.this.toName(type.astName());
                defaultConstructor.declarationSourceStart = defaultConstructor.constructorCall.sourceStart = EcjTreeBuilder.start(type.astName());
                defaultConstructor.sourceStart = defaultConstructor.constructorCall.sourceStart;
                defaultConstructor.constructorCall.sourceEnd = defaultConstructor.declarationSourceEnd = EcjTreeBuilder.end(type.astName());
                defaultConstructor.bodyEnd = defaultConstructor.declarationSourceEnd;
                defaultConstructor.sourceEnd = defaultConstructor.declarationSourceEnd;
                methods.add(0, defaultConstructor);
            }
            decl.memberTypes = (org.eclipse.jdt.internal.compiler.ast.TypeDeclaration[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.TypeDeclaration.class, types);
            decl.methods = (AbstractMethodDeclaration[])EcjTreeBuilder.this.toArray(AbstractMethodDeclaration.class, methods);
            decl.fields = (FieldDeclaration[])EcjTreeBuilder.this.toArray(FieldDeclaration.class, fields);
            if (EcjTreeBuilder.this.bubblingFlags.contains((Object)BubblingFlags.ASSERT)) {
                decl.bits |= 1;
            }
            if (EcjTreeBuilder.this.bubblingFlags.remove((Object)BubblingFlags.ABSTRACT_METHOD)) {
                decl.bits |= 0x800;
            }
            decl.addClinit();
            return decl;
        }

        @Override
        public boolean visitExpressionStatement(ExpressionStatement node) {
            org.eclipse.jdt.internal.compiler.ast.Statement statement = EcjTreeBuilder.this.toStatement(node.astExpression());
            try {
                Field f = statement.getClass().getField("statementEnd");
                f.set(statement, EcjTreeBuilder.end(node));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.set((Node)node, (ASTNode)statement);
        }

        @Override
        public boolean visitConstructorInvocation(ConstructorInvocation node) {
            AllocationExpression inv;
            if (node.astQualifier() != null || node.astAnonymousClassBody() != null) {
                if (node.astAnonymousClassBody() != null) {
                    org.eclipse.jdt.internal.compiler.ast.TypeDeclaration decl = this.createTypeBody(node.astAnonymousClassBody().astMembers(), null, false, 0, new FieldDeclaration[0]);
                    Position ecjSigPos = ConversionPositionInfo.getConversionPositionInfo(node, "signature");
                    decl.sourceStart = ecjSigPos == null ? EcjTreeBuilder.start(node.rawTypeReference()) : ecjSigPos.getStart();
                    decl.sourceEnd = ecjSigPos == null ? EcjTreeBuilder.this.posOfStructure(node, ")", false) - 1 : ecjSigPos.getEnd() - 1;
                    decl.declarationSourceStart = decl.sourceStart;
                    decl.declarationSourceEnd = EcjTreeBuilder.end(node);
                    decl.name = CharOperation.NO_CHAR;
                    decl.bits |= 0x300;
                    EcjTreeBuilder.this.bubblingFlags.add(BubblingFlags.LOCALTYPE);
                    inv = new QualifiedAllocationExpression(decl);
                } else {
                    inv = new QualifiedAllocationExpression();
                }
                if (node.astQualifier() != null) {
                    ((QualifiedAllocationExpression)inv).enclosingInstance = EcjTreeBuilder.this.toExpression(node.astQualifier());
                }
            } else {
                inv = new AllocationExpression();
            }
            if (!node.astConstructorTypeArguments().isEmpty()) {
                inv.typeArguments = (org.eclipse.jdt.internal.compiler.ast.TypeReference[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.TypeReference.class, node.astConstructorTypeArguments());
            }
            inv.type = (org.eclipse.jdt.internal.compiler.ast.TypeReference)EcjTreeBuilder.this.toTree(node.astTypeReference());
            inv.arguments = (org.eclipse.jdt.internal.compiler.ast.Expression[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.Expression.class, node.astArguments());
            inv.sourceStart = EcjTreeBuilder.start(node);
            inv.sourceEnd = EcjTreeBuilder.end(node);
            return this.set((Node)node, (ASTNode)inv);
        }

        @Override
        public boolean visitAlternateConstructorInvocation(AlternateConstructorInvocation node) {
            ExplicitConstructorCall inv = new ExplicitConstructorCall(3);
            inv.sourceStart = EcjTreeBuilder.this.posOfStructure(node, "this", true);
            inv.sourceEnd = EcjTreeBuilder.end(node);
            if (!node.astConstructorTypeArguments().isEmpty()) {
                inv.typeArguments = (org.eclipse.jdt.internal.compiler.ast.TypeReference[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.TypeReference.class, node.astConstructorTypeArguments());
                Position ecjTypeArgsPos = ConversionPositionInfo.getConversionPositionInfo(node, "typeArguments");
                inv.typeArgumentsSourceStart = ecjTypeArgsPos == null ? EcjTreeBuilder.this.posOfStructure(node, "<", true) : ecjTypeArgsPos.getStart();
            }
            inv.arguments = (org.eclipse.jdt.internal.compiler.ast.Expression[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.Expression.class, node.astArguments());
            return this.set((Node)node, (ASTNode)inv);
        }

        @Override
        public boolean visitSuperConstructorInvocation(SuperConstructorInvocation node) {
            ExplicitConstructorCall inv = new ExplicitConstructorCall(2);
            inv.sourceStart = EcjTreeBuilder.start(node);
            inv.sourceEnd = EcjTreeBuilder.end(node);
            if (!node.astConstructorTypeArguments().isEmpty()) {
                inv.typeArguments = (org.eclipse.jdt.internal.compiler.ast.TypeReference[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.TypeReference.class, node.astConstructorTypeArguments());
                Position ecjTypeArgsPos = ConversionPositionInfo.getConversionPositionInfo(node, "typeArguments");
                inv.typeArgumentsSourceStart = ecjTypeArgsPos == null ? EcjTreeBuilder.this.posOfStructure(node, "<", true) : ecjTypeArgsPos.getStart();
            }
            inv.arguments = (org.eclipse.jdt.internal.compiler.ast.Expression[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.Expression.class, node.astArguments());
            inv.qualification = EcjTreeBuilder.this.toExpression(node.astQualifier());
            return this.set((Node)node, (ASTNode)inv);
        }

        @Override
        public boolean visitMethodInvocation(MethodInvocation node) {
            MessageSend inv = new MessageSend();
            inv.sourceStart = EcjTreeBuilder.start(node);
            inv.sourceEnd = EcjTreeBuilder.end(node);
            inv.nameSourcePosition = EcjTreeBuilder.pos(node.astName());
            inv.arguments = (org.eclipse.jdt.internal.compiler.ast.Expression[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.Expression.class, node.astArguments());
            inv.receiver = EcjTreeBuilder.this.toExpression(node.astOperand());
            if (inv.receiver instanceof NameReference) {
                inv.receiver.bits |= 4;
            }
            if (inv.receiver == null) {
                inv.receiver = new ThisReference(0, 0);
                inv.receiver.bits |= 4;
            }
            if (!node.astMethodTypeArguments().isEmpty()) {
                inv.typeArguments = (org.eclipse.jdt.internal.compiler.ast.TypeReference[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.TypeReference.class, node.astMethodTypeArguments());
            }
            inv.selector = EcjTreeBuilder.this.toName(node.astName());
            return this.set((Node)node, (ASTNode)inv);
        }

        @Override
        public boolean visitSuper(Super node) {
            if (node.astQualifier() == null) {
                return this.set((Node)node, (ASTNode)new SuperReference(EcjTreeBuilder.start(node), EcjTreeBuilder.end(node)));
            }
            return this.set((Node)node, (ASTNode)new QualifiedSuperReference((org.eclipse.jdt.internal.compiler.ast.TypeReference)EcjTreeBuilder.this.toTree(node.astQualifier()), EcjTreeBuilder.start(node), EcjTreeBuilder.end(node)));
        }

        @Override
        public boolean visitUnaryExpression(UnaryExpression node) {
            if (node.astOperator() == UnaryOperator.UNARY_MINUS && node.astOperand() instanceof IntegralLiteral && node.astOperand().getParens() == 0) {
                IntegralLiteral lit = (IntegralLiteral)node.astOperand();
                if (!lit.astMarkedAsLong() && lit.astIntValue() == Integer.MIN_VALUE) {
                    IntLiteralMinValue minLiteral = new IntLiteralMinValue();
                    minLiteral.sourceStart = EcjTreeBuilder.start(node);
                    minLiteral.sourceEnd = EcjTreeBuilder.end(node);
                    return this.set((Node)node, (ASTNode)minLiteral);
                }
                if (lit.astMarkedAsLong() && lit.astLongValue() == Long.MIN_VALUE) {
                    LongLiteralMinValue minLiteral = new LongLiteralMinValue();
                    minLiteral.sourceStart = EcjTreeBuilder.start(node);
                    minLiteral.sourceEnd = EcjTreeBuilder.end(node);
                    return this.set((Node)node, (ASTNode)minLiteral);
                }
            }
            org.eclipse.jdt.internal.compiler.ast.Expression operand = EcjTreeBuilder.this.toExpression(node.astOperand());
            int ecjOperator = (Integer)UNARY_OPERATORS.get((Object)node.astOperator());
            switch (node.astOperator()) {
                case PREFIX_INCREMENT: 
                case PREFIX_DECREMENT: {
                    return this.set((Node)node, (ASTNode)new PrefixExpression(operand, (org.eclipse.jdt.internal.compiler.ast.Expression)IntLiteral.One, ecjOperator, EcjTreeBuilder.start(node)));
                }
                case POSTFIX_INCREMENT: 
                case POSTFIX_DECREMENT: {
                    return this.set((Node)node, (ASTNode)new PostfixExpression(operand, (org.eclipse.jdt.internal.compiler.ast.Expression)IntLiteral.One, ecjOperator, EcjTreeBuilder.end(node)));
                }
            }
            org.eclipse.jdt.internal.compiler.ast.UnaryExpression expr = new org.eclipse.jdt.internal.compiler.ast.UnaryExpression(EcjTreeBuilder.this.toExpression(node.astOperand()), ecjOperator);
            expr.sourceStart = EcjTreeBuilder.start(node);
            expr.sourceEnd = EcjTreeBuilder.end(node);
            return this.set((Node)node, (ASTNode)expr);
        }

        @Override
        public boolean visitBinaryExpression(BinaryExpression node) {
            org.eclipse.jdt.internal.compiler.ast.Expression stringConcatExpr;
            org.eclipse.jdt.internal.compiler.ast.Expression lhs = EcjTreeBuilder.this.toExpression(node.astLeft());
            org.eclipse.jdt.internal.compiler.ast.Expression rhs = EcjTreeBuilder.this.toExpression(node.astRight());
            if (node.astOperator() == BinaryOperator.ASSIGN) {
                return this.set((Node)node, EcjTreeBuilder.posParen((ASTNode)new Assignment(lhs, rhs, EcjTreeBuilder.end(node)), node));
            }
            int ecjOperator = (Integer)BINARY_OPERATORS.get((Object)node.astOperator());
            if (node.astOperator().isAssignment()) {
                return this.set((Node)node, EcjTreeBuilder.posParen((ASTNode)new CompoundAssignment(lhs, rhs, ecjOperator, EcjTreeBuilder.end(node)), node));
            }
            if (node.astOperator() == BinaryOperator.EQUALS || node.astOperator() == BinaryOperator.NOT_EQUALS) {
                return this.set((Node)node, EcjTreeBuilder.posParen((ASTNode)new EqualExpression(lhs, rhs, ecjOperator), node));
            }
            if (node.astOperator() == BinaryOperator.LOGICAL_AND) {
                return this.set((Node)node, EcjTreeBuilder.posParen((ASTNode)new AND_AND_Expression(lhs, rhs, ecjOperator), node));
            }
            if (node.astOperator() == BinaryOperator.LOGICAL_OR) {
                return this.set((Node)node, EcjTreeBuilder.posParen((ASTNode)new OR_OR_Expression(lhs, rhs, ecjOperator), node));
            }
            if (node.astOperator() == BinaryOperator.PLUS && node.astLeft().getParens() == 0 && (stringConcatExpr = (org.eclipse.jdt.internal.compiler.ast.Expression)EcjTreeBuilder.posParen((ASTNode)this.tryStringConcat(lhs, rhs), node)) != null) {
                return this.set((Node)node, (ASTNode)stringConcatExpr);
            }
            return this.set((Node)node, EcjTreeBuilder.posParen((ASTNode)new org.eclipse.jdt.internal.compiler.ast.BinaryExpression(lhs, rhs, ecjOperator), node));
        }

        private org.eclipse.jdt.internal.compiler.ast.Expression tryStringConcat(org.eclipse.jdt.internal.compiler.ast.Expression lhs, org.eclipse.jdt.internal.compiler.ast.Expression rhs) {
            if (((EcjTreeBuilder)EcjTreeBuilder.this).options.parseLiteralExpressionsAsConstants) {
                if (lhs instanceof ExtendedStringLiteral) {
                    if (rhs instanceof org.eclipse.jdt.internal.compiler.ast.CharLiteral) {
                        return ((ExtendedStringLiteral)lhs).extendWith((org.eclipse.jdt.internal.compiler.ast.CharLiteral)rhs);
                    }
                    if (rhs instanceof org.eclipse.jdt.internal.compiler.ast.StringLiteral) {
                        return ((ExtendedStringLiteral)lhs).extendWith((org.eclipse.jdt.internal.compiler.ast.StringLiteral)rhs);
                    }
                } else if (lhs instanceof org.eclipse.jdt.internal.compiler.ast.StringLiteral) {
                    if (rhs instanceof org.eclipse.jdt.internal.compiler.ast.CharLiteral) {
                        return new ExtendedStringLiteral((org.eclipse.jdt.internal.compiler.ast.StringLiteral)lhs, (org.eclipse.jdt.internal.compiler.ast.CharLiteral)rhs);
                    }
                    if (rhs instanceof org.eclipse.jdt.internal.compiler.ast.StringLiteral) {
                        return new ExtendedStringLiteral((org.eclipse.jdt.internal.compiler.ast.StringLiteral)lhs, (org.eclipse.jdt.internal.compiler.ast.StringLiteral)rhs);
                    }
                }
            } else if (lhs instanceof StringLiteralConcatenation) {
                if (rhs instanceof org.eclipse.jdt.internal.compiler.ast.StringLiteral) {
                    return ((StringLiteralConcatenation)lhs).extendsWith((org.eclipse.jdt.internal.compiler.ast.StringLiteral)rhs);
                }
            } else if (lhs instanceof org.eclipse.jdt.internal.compiler.ast.StringLiteral && rhs instanceof org.eclipse.jdt.internal.compiler.ast.StringLiteral) {
                return new StringLiteralConcatenation((org.eclipse.jdt.internal.compiler.ast.StringLiteral)lhs, (org.eclipse.jdt.internal.compiler.ast.StringLiteral)rhs);
            }
            return null;
        }

        @Override
        public boolean visitCast(Cast node) {
            org.eclipse.jdt.internal.compiler.ast.Expression typeRef = EcjTreeBuilder.this.toExpression(node.astTypeReference());
            org.eclipse.jdt.internal.compiler.ast.Expression operand = EcjTreeBuilder.this.toExpression(node.astOperand());
            CastExpression expr = this.createCastExpression(typeRef, operand);
            Position ecjTypePos = ConversionPositionInfo.getConversionPositionInfo(node, "type");
            typeRef.sourceStart = ecjTypePos == null ? EcjTreeBuilder.this.posOfStructure(node, "(", true) + 1 : ecjTypePos.getStart();
            typeRef.sourceEnd = ecjTypePos == null ? EcjTreeBuilder.this.posOfStructure(node, ")", 0, false) - 2 : ecjTypePos.getEnd() - 1;
            expr.sourceStart = EcjTreeBuilder.start(node);
            expr.sourceEnd = EcjTreeBuilder.end(node);
            return this.set((Node)node, (ASTNode)expr);
        }

        private CastExpression createCastExpression(org.eclipse.jdt.internal.compiler.ast.Expression typeRef, org.eclipse.jdt.internal.compiler.ast.Expression operand) {
            try {
                return (CastExpression)CastExpression.class.getConstructors()[0].newInstance(operand, typeRef);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        @Override
        public boolean visitInstanceOf(InstanceOf node) {
            return this.set((Node)node, (ASTNode)new InstanceOfExpression(EcjTreeBuilder.this.toExpression(node.astObjectReference()), (org.eclipse.jdt.internal.compiler.ast.TypeReference)EcjTreeBuilder.this.toTree(node.astTypeReference())));
        }

        @Override
        public boolean visitInlineIfExpression(InlineIfExpression node) {
            return this.set((Node)node, (ASTNode)new ConditionalExpression(EcjTreeBuilder.this.toExpression(node.astCondition()), EcjTreeBuilder.this.toExpression(node.astIfTrue()), EcjTreeBuilder.this.toExpression(node.astIfFalse())));
        }

        @Override
        public boolean visitSelect(Select node) {
            ArrayList<Identifier> selects = Lists.newArrayList();
            ArrayList<Long> pos = Lists.newArrayList();
            Select current = node;
            while (true) {
                selects.add(current.astIdentifier());
                pos.add(EcjTreeBuilder.pos(current.astIdentifier()));
                if (!(current.astOperand() instanceof Select)) break;
                current = (Select)current.astOperand();
            }
            if (current.astOperand() instanceof VariableReference) {
                selects.add(((VariableReference)current.astOperand()).astIdentifier());
                pos.add(EcjTreeBuilder.pos(current.rawOperand()));
                Collections.reverse(selects);
                long[] posArray = new long[pos.size()];
                for (int i = 0; i < posArray.length; ++i) {
                    posArray[i] = (Long)pos.get(posArray.length - i - 1);
                }
                char[][] tokens = this.chain(selects, selects.size());
                QualifiedNameReference ref = new QualifiedNameReference(tokens, posArray, EcjTreeBuilder.start(node), EcjTreeBuilder.end(node));
                return this.set((Node)node, (ASTNode)ref);
            }
            FieldReference ref = new FieldReference(EcjTreeBuilder.this.toName(node.astIdentifier()), EcjTreeBuilder.pos(node));
            ref.nameSourcePosition = EcjTreeBuilder.pos(node.astIdentifier());
            ref.receiver = EcjTreeBuilder.this.toExpression(node.astOperand());
            return this.set((Node)node, (ASTNode)ref);
        }

        @Override
        public boolean visitTypeReference(TypeReference node) {
            Wildcard wildcard = null;
            ArrayTypeReference ref = null;
            switch (node.astWildcard()) {
                case UNBOUND: {
                    wildcard = new Wildcard(0);
                    wildcard.sourceStart = EcjTreeBuilder.start(node);
                    wildcard.sourceEnd = EcjTreeBuilder.end(node);
                    return this.set((Node)node, (ASTNode)wildcard);
                }
                case EXTENDS: {
                    wildcard = new Wildcard(1);
                    break;
                }
                case SUPER: {
                    wildcard = new Wildcard(2);
                }
            }
            char[][] qualifiedName = null;
            char[] singleName = null;
            boolean qualified = node.astParts().size() != 1;
            int dims = node.astArrayDimensions();
            org.eclipse.jdt.internal.compiler.ast.TypeReference[][] params = new org.eclipse.jdt.internal.compiler.ast.TypeReference[node.astParts().size()][];
            boolean hasGenerics = false;
            if (!qualified) {
                singleName = EcjTreeBuilder.this.toName(node.astParts().first().astIdentifier());
            } else {
                ArrayList<Identifier> identifiers = Lists.newArrayList();
                for (TypeReferencePart part : node.astParts()) {
                    identifiers.add(part.astIdentifier());
                }
                qualifiedName = this.chain(identifiers, identifiers.size());
            }
            int ctr = 0;
            for (TypeReferencePart part : node.astParts()) {
                params[ctr] = new org.eclipse.jdt.internal.compiler.ast.TypeReference[part.astTypeArguments().size()];
                int ctr2 = 0;
                boolean partHasGenerics = false;
                for (TypeReference x : part.astTypeArguments()) {
                    hasGenerics = true;
                    partHasGenerics = true;
                    params[ctr][ctr2++] = (org.eclipse.jdt.internal.compiler.ast.TypeReference)EcjTreeBuilder.this.toTree(x);
                }
                if (!partHasGenerics) {
                    params[ctr] = null;
                }
                ++ctr;
            }
            if (!qualified) {
                if (!hasGenerics) {
                    if (dims == 0) {
                        ref = new SingleTypeReference(singleName, EcjTreeBuilder.partsToPosArray(node.rawParts())[0]);
                    } else {
                        ref = new ArrayTypeReference(singleName, dims, 0L);
                        ref.sourceStart = EcjTreeBuilder.start(node);
                        ref.sourceEnd = EcjTreeBuilder.end(node);
                        ref.originalSourceEnd = EcjTreeBuilder.end(node.rawParts().last());
                    }
                } else {
                    ref = new ParameterizedSingleTypeReference(singleName, params[0], dims, EcjTreeBuilder.partsToPosArray(node.rawParts())[0]);
                    if (dims > 0) {
                        ref.sourceEnd = EcjTreeBuilder.end(node);
                    }
                }
            } else if (!hasGenerics) {
                if (dims == 0) {
                    long[] pos = EcjTreeBuilder.partsToPosArray(node.rawParts());
                    ref = new QualifiedTypeReference(qualifiedName, pos);
                } else {
                    long[] pos = EcjTreeBuilder.partsToPosArray(node.rawParts());
                    ref = new ArrayQualifiedTypeReference(qualifiedName, dims, pos);
                    ref.sourceEnd = EcjTreeBuilder.end(node);
                }
            } else {
                long[] pos = EcjTreeBuilder.partsToPosArray(node.rawParts());
                ref = new ParameterizedQualifiedTypeReference(qualifiedName, (org.eclipse.jdt.internal.compiler.ast.TypeReference[][])params, dims, pos);
                if (dims > 0) {
                    ref.sourceEnd = EcjTreeBuilder.end(node);
                }
            }
            if (wildcard != null) {
                wildcard.bound = ref;
                ref = wildcard;
                ref.sourceStart = EcjTreeBuilder.start(node);
                ref.sourceEnd = wildcard.bound.sourceEnd;
            }
            return this.set((Node)node, (ASTNode)ref);
        }

        @Override
        public boolean visitTypeVariable(TypeVariable node) {
            TypeParameter param = new TypeParameter();
            param.declarationSourceStart = EcjTreeBuilder.start(node);
            param.declarationSourceEnd = EcjTreeBuilder.end(node);
            param.sourceStart = EcjTreeBuilder.start(node.astName());
            param.sourceEnd = EcjTreeBuilder.end(node.astName());
            param.name = EcjTreeBuilder.this.toName(node.astName());
            if (!node.astExtending().isEmpty()) {
                org.eclipse.jdt.internal.compiler.ast.TypeReference[] p;
                for (org.eclipse.jdt.internal.compiler.ast.TypeReference t : p = (org.eclipse.jdt.internal.compiler.ast.TypeReference[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.TypeReference.class, node.astExtending())) {
                    t.bits |= 0x10;
                }
                param.type = p[0];
                if (p.length > 1) {
                    param.bounds = new org.eclipse.jdt.internal.compiler.ast.TypeReference[p.length - 1];
                    System.arraycopy(p, 1, param.bounds, 0, p.length - 1);
                }
                param.declarationSourceEnd = p[p.length - 1].sourceEnd;
            }
            return this.set((Node)node, (ASTNode)param);
        }

        @Override
        public boolean visitStaticInitializer(StaticInitializer node) {
            Initializer init = new Initializer((org.eclipse.jdt.internal.compiler.ast.Block)EcjTreeBuilder.this.toTree(node.astBody()), 8);
            init.declarationSourceStart = EcjTreeBuilder.start(node);
            init.sourceStart = EcjTreeBuilder.start(node.astBody());
            init.sourceEnd = init.declarationSourceEnd = EcjTreeBuilder.end(node);
            init.bodyStart = init.sourceStart + 1;
            init.bodyEnd = init.sourceEnd - 1;
            return this.set((Node)node, (ASTNode)init);
        }

        @Override
        public boolean visitInstanceInitializer(InstanceInitializer node) {
            Initializer init = new Initializer((org.eclipse.jdt.internal.compiler.ast.Block)EcjTreeBuilder.this.toTree(node.astBody()), 0);
            if (EcjTreeBuilder.this.bubblingFlags.remove((Object)BubblingFlags.LOCALTYPE)) {
                init.bits |= 2;
            }
            init.sourceStart = init.declarationSourceStart = EcjTreeBuilder.start(node);
            init.sourceEnd = init.declarationSourceEnd = EcjTreeBuilder.end(node);
            init.bodyStart = init.sourceStart + 1;
            init.bodyEnd = init.sourceEnd - 1;
            return this.set((Node)node, (ASTNode)init);
        }

        @Override
        public boolean visitIntegralLiteral(IntegralLiteral node) {
            if (node.astMarkedAsLong()) {
                return this.set((Node)node, (ASTNode)new LongLiteral(node.rawValue().toCharArray(), EcjTreeBuilder.start(node), EcjTreeBuilder.end(node)));
            }
            return this.set((Node)node, (ASTNode)new IntLiteral(node.rawValue().toCharArray(), EcjTreeBuilder.start(node), EcjTreeBuilder.end(node)));
        }

        @Override
        public boolean visitFloatingPointLiteral(FloatingPointLiteral node) {
            if (node.astMarkedAsFloat()) {
                return this.set((Node)node, (ASTNode)new FloatLiteral(node.rawValue().toCharArray(), EcjTreeBuilder.start(node), EcjTreeBuilder.end(node)));
            }
            return this.set((Node)node, (ASTNode)new DoubleLiteral(node.rawValue().toCharArray(), EcjTreeBuilder.start(node), EcjTreeBuilder.end(node)));
        }

        @Override
        public boolean visitBooleanLiteral(BooleanLiteral node) {
            return this.set((Node)node, (ASTNode)(node.astValue() != false ? new TrueLiteral(EcjTreeBuilder.start(node), EcjTreeBuilder.end(node)) : new FalseLiteral(EcjTreeBuilder.start(node), EcjTreeBuilder.end(node))));
        }

        @Override
        public boolean visitNullLiteral(NullLiteral node) {
            return this.set((Node)node, (ASTNode)new org.eclipse.jdt.internal.compiler.ast.NullLiteral(EcjTreeBuilder.start(node), EcjTreeBuilder.end(node)));
        }

        @Override
        public boolean visitVariableReference(VariableReference node) {
            SingleNameReference ref = new SingleNameReference(EcjTreeBuilder.this.toName(node.astIdentifier()), EcjTreeBuilder.pos(node));
            return this.set((Node)node, (ASTNode)ref);
        }

        @Override
        public boolean visitIdentifier(Identifier node) {
            SingleNameReference ref = new SingleNameReference(EcjTreeBuilder.this.toName(node), EcjTreeBuilder.pos(node));
            return this.set((Node)node, (ASTNode)ref);
        }

        @Override
        public boolean visitCharLiteral(CharLiteral node) {
            return this.set((Node)node, (ASTNode)new org.eclipse.jdt.internal.compiler.ast.CharLiteral(node.rawValue().toCharArray(), EcjTreeBuilder.start(node), EcjTreeBuilder.end(node)));
        }

        @Override
        public boolean visitStringLiteral(StringLiteral node) {
            return this.set((Node)node, (ASTNode)new org.eclipse.jdt.internal.compiler.ast.StringLiteral(node.astValue().toCharArray(), EcjTreeBuilder.start(node), EcjTreeBuilder.end(node), 0));
        }

        @Override
        public boolean visitBlock(Block node) {
            org.eclipse.jdt.internal.compiler.ast.Block block = new org.eclipse.jdt.internal.compiler.ast.Block(0);
            block.statements = (org.eclipse.jdt.internal.compiler.ast.Statement[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.Statement.class, node.astContents());
            if (block.statements == null) {
                if (this.isUndocumented(node)) {
                    block.bits |= 8;
                }
            } else {
                block.explicitDeclarations = this.calculateExplicitDeclarations(node.astContents());
            }
            block.sourceStart = EcjTreeBuilder.start(node);
            block.sourceEnd = EcjTreeBuilder.end(node);
            return this.set((Node)node, (ASTNode)block);
        }

        @Override
        public boolean visitAnnotationValueArray(AnnotationValueArray node) {
            org.eclipse.jdt.internal.compiler.ast.ArrayInitializer init = new org.eclipse.jdt.internal.compiler.ast.ArrayInitializer();
            init.sourceStart = EcjTreeBuilder.start(node);
            init.sourceEnd = EcjTreeBuilder.end(node);
            init.expressions = (org.eclipse.jdt.internal.compiler.ast.Expression[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.Expression.class, node.astValues());
            return this.set((Node)node, (ASTNode)init);
        }

        @Override
        public boolean visitArrayInitializer(ArrayInitializer node) {
            org.eclipse.jdt.internal.compiler.ast.ArrayInitializer init = new org.eclipse.jdt.internal.compiler.ast.ArrayInitializer();
            init.sourceStart = EcjTreeBuilder.start(node);
            init.sourceEnd = EcjTreeBuilder.end(node);
            init.expressions = (org.eclipse.jdt.internal.compiler.ast.Expression[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.Expression.class, node.astExpressions());
            return this.set((Node)node, (ASTNode)init);
        }

        @Override
        public boolean visitArrayCreation(ArrayCreation node) {
            ArrayAllocationExpression aae = new ArrayAllocationExpression();
            aae.sourceStart = EcjTreeBuilder.start(node);
            aae.sourceEnd = EcjTreeBuilder.end(node);
            aae.type = (org.eclipse.jdt.internal.compiler.ast.TypeReference)EcjTreeBuilder.this.toTree(node.astComponentTypeReference());
            aae.type.bits |= 0x40000000;
            int i = 0;
            org.eclipse.jdt.internal.compiler.ast.Expression[] dimensions = new org.eclipse.jdt.internal.compiler.ast.Expression[node.astDimensions().size()];
            for (ArrayDimension dim : node.astDimensions()) {
                dimensions[i++] = (org.eclipse.jdt.internal.compiler.ast.Expression)EcjTreeBuilder.this.toTree(dim.astDimension());
            }
            aae.dimensions = dimensions;
            aae.initializer = (org.eclipse.jdt.internal.compiler.ast.ArrayInitializer)EcjTreeBuilder.this.toTree(node.astInitializer());
            return this.set((Node)node, (ASTNode)aae);
        }

        @Override
        public boolean visitArrayDimension(ArrayDimension node) {
            return this.set((Node)node, (ASTNode)EcjTreeBuilder.this.toExpression(node.astDimension()));
        }

        @Override
        public boolean visitThis(This node) {
            if (node.astQualifier() == null) {
                return this.set((Node)node, (ASTNode)new ThisReference(EcjTreeBuilder.start(node), EcjTreeBuilder.end(node)));
            }
            return this.set((Node)node, (ASTNode)new QualifiedThisReference((org.eclipse.jdt.internal.compiler.ast.TypeReference)EcjTreeBuilder.this.toTree(node.astQualifier()), EcjTreeBuilder.start(node), EcjTreeBuilder.end(node)));
        }

        @Override
        public boolean visitClassLiteral(ClassLiteral node) {
            return this.set((Node)node, (ASTNode)new ClassLiteralAccess(EcjTreeBuilder.end(node), (org.eclipse.jdt.internal.compiler.ast.TypeReference)EcjTreeBuilder.this.toTree(node.astTypeReference())));
        }

        @Override
        public boolean visitArrayAccess(ArrayAccess node) {
            ArrayReference ref = new ArrayReference(EcjTreeBuilder.this.toExpression(node.astOperand()), EcjTreeBuilder.this.toExpression(node.astIndexExpression()));
            ref.sourceEnd = EcjTreeBuilder.end(node);
            return this.set((Node)node, (ASTNode)ref);
        }

        @Override
        public boolean visitAssert(Assert node) {
            EcjTreeBuilder.this.bubblingFlags.add(BubblingFlags.ASSERT);
            if (node.astMessage() == null) {
                return this.set((Node)node, (ASTNode)new AssertStatement(EcjTreeBuilder.this.toExpression(node.astAssertion()), EcjTreeBuilder.start(node)));
            }
            return this.set((Node)node, (ASTNode)new AssertStatement(EcjTreeBuilder.this.toExpression(node.astMessage()), EcjTreeBuilder.this.toExpression(node.astAssertion()), EcjTreeBuilder.start(node)));
        }

        @Override
        public boolean visitDoWhile(DoWhile node) {
            return this.set((Node)node, (ASTNode)new DoStatement(EcjTreeBuilder.this.toExpression(node.astCondition()), EcjTreeBuilder.this.toStatement(node.astStatement()), EcjTreeBuilder.start(node), EcjTreeBuilder.end(node)));
        }

        @Override
        public boolean visitContinue(Continue node) {
            return this.set((Node)node, (ASTNode)new ContinueStatement(EcjTreeBuilder.this.toName(node.astLabel()), EcjTreeBuilder.start(node), EcjTreeBuilder.end(node)));
        }

        @Override
        public boolean visitBreak(Break node) {
            return this.set((Node)node, (ASTNode)new BreakStatement(EcjTreeBuilder.this.toName(node.astLabel()), EcjTreeBuilder.start(node), EcjTreeBuilder.end(node)));
        }

        @Override
        public boolean visitForEach(ForEach node) {
            ForeachStatement forEach = new ForeachStatement((LocalDeclaration)EcjTreeBuilder.this.toTree(node.astVariable()), EcjTreeBuilder.start(node));
            forEach.sourceEnd = EcjTreeBuilder.end(node);
            forEach.collection = EcjTreeBuilder.this.toExpression(node.astIterable());
            forEach.action = EcjTreeBuilder.this.toStatement(node.astStatement());
            return this.set((Node)node, (ASTNode)forEach);
        }

        @Override
        public boolean visitVariableDeclaration(VariableDeclaration node) {
            List list = EcjTreeBuilder.this.toList(AbstractVariableDeclaration.class, node.astDefinition());
            if (list.size() > 0) {
                this.setupJavadoc((ASTNode)list.get(0), node);
            }
            return this.set((Node)node, list);
        }

        @Override
        public boolean visitVariableDefinition(VariableDefinition node) {
            ArrayList<AbstractVariableDeclaration> values = Lists.newArrayList();
            org.eclipse.jdt.internal.compiler.ast.Annotation[] annotations = (org.eclipse.jdt.internal.compiler.ast.Annotation[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.Annotation.class, node.astModifiers().astAnnotations());
            int modifiers = this.toModifiers(node.astModifiers());
            org.eclipse.jdt.internal.compiler.ast.TypeReference base = (org.eclipse.jdt.internal.compiler.ast.TypeReference)EcjTreeBuilder.this.toTree(node.astTypeReference());
            AbstractVariableDeclaration prevDecl = null;
            AbstractVariableDeclaration firstDecl = null;
            for (VariableDefinitionEntry entry : node.astVariables()) {
                VariableKind kind = VariableKind.kind(node);
                AbstractVariableDeclaration decl = kind.create();
                decl.annotations = annotations;
                decl.initialization = EcjTreeBuilder.this.toExpression(entry.astInitializer());
                decl.modifiers = modifiers;
                decl.name = EcjTreeBuilder.this.toName(entry.astName());
                if (entry.astArrayDimensions() == 0 && !node.astVarargs()) {
                    decl.type = base;
                } else if (entry.astArrayDimensions() > 0 || node.astVarargs()) {
                    decl.type = (org.eclipse.jdt.internal.compiler.ast.TypeReference)EcjTreeBuilder.this.toTree(entry.getEffectiveTypeReference());
                    decl.type.sourceStart = base.sourceStart;
                    Position ecjTypeSourcePos = ConversionPositionInfo.getConversionPositionInfo(entry, "typeSourcePos");
                    if (ecjTypeSourcePos != null) {
                        decl.type.sourceEnd = ecjTypeSourcePos.getEnd() - 1;
                    } else {
                        decl.type.sourceEnd = firstDecl == null && (base.dimensions() > 0 || node.getParent() instanceof ForEach) ? EcjTreeBuilder.this.posOfStructure(entry, "]", false) - 1 : (firstDecl != null ? firstDecl.type.sourceEnd : base.sourceEnd);
                        if (kind == VariableKind.FIELD && base instanceof ArrayQualifiedTypeReference) {
                            long[] poss = ((ArrayQualifiedTypeReference)base).sourcePositions;
                            decl.type.sourceEnd = (int)poss[poss.length - 1];
                        }
                    }
                    if (node.astVarargs()) {
                        if (decl.type instanceof ArrayTypeReference) {
                            ((ArrayTypeReference)decl.type).originalSourceEnd = decl.type.sourceEnd;
                        }
                        Position ecjTyperefPos = ConversionPositionInfo.getConversionPositionInfo(node, "typeref");
                        decl.type.sourceEnd = ecjTyperefPos == null ? EcjTreeBuilder.this.posOfStructure(node, "...", false) - 1 : ecjTyperefPos.getEnd() - 1;
                    } else {
                        if (decl.type instanceof ArrayTypeReference) {
                            ((ArrayTypeReference)decl.type).originalSourceEnd = decl.type.sourceEnd;
                        }
                        if (decl.type instanceof ArrayQualifiedTypeReference) {
                            ((ArrayQualifiedTypeReference)decl.type).sourcePositions = (long[])((QualifiedTypeReference)base).sourcePositions.clone();
                        }
                    }
                }
                if (node.astVarargs()) {
                    decl.type.bits |= 0x4000;
                }
                if (decl instanceof FieldDeclaration && EcjTreeBuilder.this.bubblingFlags.remove((Object)BubblingFlags.LOCALTYPE)) {
                    decl.bits |= 2;
                }
                decl.sourceStart = EcjTreeBuilder.start(entry.astName());
                decl.sourceEnd = EcjTreeBuilder.end(entry.astName());
                decl.declarationSourceStart = EcjTreeBuilder.jstart(node);
                switch (kind) {
                    case LOCAL: {
                        int end = node.getParent() instanceof VariableDeclaration ? EcjTreeBuilder.end(node.getParent()) : (entry.rawInitializer() != null ? EcjTreeBuilder.end(entry.rawInitializer()) : EcjTreeBuilder.end(entry.astName()));
                        decl.declarationSourceEnd = decl.declarationEnd = end;
                        Position ecjDeclarationSourcePos = ConversionPositionInfo.getConversionPositionInfo(entry, "declarationSource");
                        if (ecjDeclarationSourcePos == null) break;
                        decl.declarationSourceEnd = ecjDeclarationSourcePos.getEnd() - 1;
                        break;
                    }
                    case ARGUMENT: {
                        decl.declarationSourceEnd = decl.declarationEnd = EcjTreeBuilder.end(entry.astName());
                        Position ecjDeclarationSourcePos = ConversionPositionInfo.getConversionPositionInfo(entry, "declarationSource");
                        if (ecjDeclarationSourcePos == null) break;
                        decl.declarationSourceEnd = ecjDeclarationSourcePos.getEnd() - 1;
                        break;
                    }
                    case FIELD: {
                        decl.declarationSourceEnd = decl.declarationEnd = EcjTreeBuilder.end(node.getParent());
                        Position ecjDeclarationSourcePos = ConversionPositionInfo.getConversionPositionInfo(entry, "declarationSource");
                        Position ecjPart1Pos = ConversionPositionInfo.getConversionPositionInfo(entry, "varDeclPart1");
                        Position ecjPart2Pos = ConversionPositionInfo.getConversionPositionInfo(entry, "varDeclPart2");
                        if (ecjDeclarationSourcePos != null) {
                            decl.declarationSourceEnd = ecjDeclarationSourcePos.getEnd() - 1;
                        }
                        ((FieldDeclaration)decl).endPart1Position = ecjPart1Pos == null ? EcjTreeBuilder.end(node.rawTypeReference()) + 1 : ecjPart1Pos.getEnd() - 1;
                        int n = ((FieldDeclaration)decl).endPart2Position = ecjPart2Pos == null ? EcjTreeBuilder.end(node.getParent()) : ecjPart2Pos.getEnd() - 1;
                        if (ecjPart2Pos != null || !(prevDecl instanceof FieldDeclaration)) break;
                        ((FieldDeclaration)prevDecl).endPart2Position = EcjTreeBuilder.start(entry) - 1;
                    }
                }
                values.add(decl);
                prevDecl = decl;
                if (firstDecl != null) continue;
                firstDecl = decl;
            }
            return this.set((Node)node, values);
        }

        @Override
        public boolean visitIf(If node) {
            if (node.astElseStatement() == null) {
                return this.set((Node)node, (ASTNode)new IfStatement(EcjTreeBuilder.this.toExpression(node.astCondition()), EcjTreeBuilder.this.toStatement(node.astStatement()), EcjTreeBuilder.start(node), EcjTreeBuilder.end(node)));
            }
            return this.set((Node)node, (ASTNode)new IfStatement(EcjTreeBuilder.this.toExpression(node.astCondition()), EcjTreeBuilder.this.toStatement(node.astStatement()), EcjTreeBuilder.this.toStatement(node.astElseStatement()), EcjTreeBuilder.start(node), EcjTreeBuilder.end(node)));
        }

        @Override
        public boolean visitLabelledStatement(LabelledStatement node) {
            return this.set((Node)node, (ASTNode)new LabeledStatement(EcjTreeBuilder.this.toName(node.astLabel()), EcjTreeBuilder.this.toStatement(node.astStatement()), EcjTreeBuilder.pos(node.astLabel()), EcjTreeBuilder.end(node)));
        }

        @Override
        public boolean visitFor(For node) {
            if (node.isVariableDeclarationBased()) {
                return this.set((Node)node, (ASTNode)new ForStatement((org.eclipse.jdt.internal.compiler.ast.Statement[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.Statement.class, node.astVariableDeclaration()), EcjTreeBuilder.this.toExpression(node.astCondition()), (org.eclipse.jdt.internal.compiler.ast.Statement[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.Statement.class, node.astUpdates()), EcjTreeBuilder.this.toStatement(node.astStatement()), true, EcjTreeBuilder.start(node), EcjTreeBuilder.end(node)));
            }
            return this.set((Node)node, (ASTNode)new ForStatement((org.eclipse.jdt.internal.compiler.ast.Statement[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.Statement.class, node.astExpressionInits()), EcjTreeBuilder.this.toExpression(node.astCondition()), (org.eclipse.jdt.internal.compiler.ast.Statement[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.Statement.class, node.astUpdates()), EcjTreeBuilder.this.toStatement(node.astStatement()), false, EcjTreeBuilder.start(node), EcjTreeBuilder.end(node)));
        }

        @Override
        public boolean visitSwitch(Switch node) {
            SwitchStatement value = new SwitchStatement();
            value.sourceStart = EcjTreeBuilder.start(node);
            value.sourceEnd = EcjTreeBuilder.end(node);
            value.blockStart = EcjTreeBuilder.start(node.rawBody());
            value.expression = EcjTreeBuilder.this.toExpression(node.astCondition());
            value.statements = (org.eclipse.jdt.internal.compiler.ast.Statement[])EcjTreeBuilder.this.toArray(org.eclipse.jdt.internal.compiler.ast.Statement.class, node.astBody().astContents());
            if (value.statements == null) {
                if (this.isUndocumented(node.astBody())) {
                    value.bits |= 8;
                }
            } else {
                value.explicitDeclarations = this.calculateExplicitDeclarations(node.astBody().astContents());
            }
            return this.set((Node)node, (ASTNode)value);
        }

        @Override
        public boolean visitSynchronized(Synchronized node) {
            return this.set((Node)node, (ASTNode)new SynchronizedStatement(EcjTreeBuilder.this.toExpression(node.astLock()), (org.eclipse.jdt.internal.compiler.ast.Block)EcjTreeBuilder.this.toTree(node.astBody()), EcjTreeBuilder.start(node), EcjTreeBuilder.end(node)));
        }

        @Override
        public boolean visitTry(Try node) {
            TryStatement tryStatement = new TryStatement();
            tryStatement.sourceStart = EcjTreeBuilder.start(node);
            tryStatement.sourceEnd = EcjTreeBuilder.end(node);
            tryStatement.tryBlock = (org.eclipse.jdt.internal.compiler.ast.Block)EcjTreeBuilder.this.toTree(node.astBody());
            int catchSize = node.astCatches().size();
            if (catchSize > 0) {
                tryStatement.catchArguments = new Argument[catchSize];
                tryStatement.catchBlocks = new org.eclipse.jdt.internal.compiler.ast.Block[catchSize];
                int i = 0;
                for (Catch c : node.astCatches()) {
                    tryStatement.catchArguments[i] = (Argument)EcjTreeBuilder.this.toTree(c.astExceptionDeclaration());
                    tryStatement.catchBlocks[i] = (org.eclipse.jdt.internal.compiler.ast.Block)EcjTreeBuilder.this.toTree(c.astBody());
                    ++i;
                }
            }
            tryStatement.finallyBlock = (org.eclipse.jdt.internal.compiler.ast.Block)EcjTreeBuilder.this.toTree(node.astFinally());
            return this.set((Node)node, (ASTNode)tryStatement);
        }

        @Override
        public boolean visitThrow(Throw node) {
            return this.set((Node)node, (ASTNode)new ThrowStatement(EcjTreeBuilder.this.toExpression(node.astThrowable()), EcjTreeBuilder.start(node), EcjTreeBuilder.end(node)));
        }

        @Override
        public boolean visitWhile(While node) {
            return this.set((Node)node, (ASTNode)new WhileStatement(EcjTreeBuilder.this.toExpression(node.astCondition()), EcjTreeBuilder.this.toStatement(node.astStatement()), EcjTreeBuilder.start(node), EcjTreeBuilder.end(node)));
        }

        @Override
        public boolean visitReturn(Return node) {
            return this.set((Node)node, (ASTNode)new ReturnStatement(EcjTreeBuilder.this.toExpression(node.astValue()), EcjTreeBuilder.start(node), EcjTreeBuilder.end(node)));
        }

        @Override
        public boolean visitAnnotation(Annotation node) {
            boolean isEcjNormal;
            org.eclipse.jdt.internal.compiler.ast.TypeReference type = (org.eclipse.jdt.internal.compiler.ast.TypeReference)EcjTreeBuilder.this.toTree(node.astAnnotationTypeReference());
            boolean bl = isEcjNormal = Position.UNPLACED == ConversionPositionInfo.getConversionPositionInfo(node, "isNormalAnnotation");
            if (node.astElements().isEmpty() && EcjTreeBuilder.this.countStructure(node, "(") == 0 && !isEcjNormal) {
                MarkerAnnotation ann = new MarkerAnnotation(type, EcjTreeBuilder.start(node));
                ann.declarationSourceEnd = EcjTreeBuilder.end(node);
                return this.set((Node)node, (ASTNode)ann);
            }
            MemberValuePair[] values = (MemberValuePair[])EcjTreeBuilder.this.toArray(MemberValuePair.class, node.astElements());
            if (values != null && values.length == 1 && values[0].name == null) {
                SingleMemberAnnotation ann = new SingleMemberAnnotation(type, EcjTreeBuilder.start(node));
                ann.declarationSourceEnd = EcjTreeBuilder.end(node);
                ann.memberValue = values[0].value;
                return this.set((Node)node, (ASTNode)ann);
            }
            NormalAnnotation ann = new NormalAnnotation(type, EcjTreeBuilder.start(node));
            ann.declarationSourceEnd = EcjTreeBuilder.end(node);
            ann.memberValuePairs = values;
            return this.set((Node)node, (ASTNode)ann);
        }

        @Override
        public boolean visitAnnotationElement(AnnotationElement node) {
            MemberValuePair pair = new MemberValuePair(EcjTreeBuilder.this.toName(node.astName()), EcjTreeBuilder.start(node), EcjTreeBuilder.end(node.astName()), null);
            pair.value = EcjTreeBuilder.this.toExpression(node.astValue());
            if (pair.name != null && pair.value instanceof org.eclipse.jdt.internal.compiler.ast.ArrayInitializer) {
                pair.value.bits |= 1;
            }
            return this.set((Node)node, (ASTNode)pair);
        }

        @Override
        public boolean visitCase(Case node) {
            return this.set((Node)node, (ASTNode)new CaseStatement(EcjTreeBuilder.this.toExpression(node.astCondition()), EcjTreeBuilder.end(node.rawCondition()), EcjTreeBuilder.start(node)));
        }

        @Override
        public boolean visitDefault(Default node) {
            return this.set((Node)node, (ASTNode)new CaseStatement(null, EcjTreeBuilder.this.posOfStructure(node, "default", false) - 1, EcjTreeBuilder.start(node)));
        }

        @Override
        public boolean visitComment(Comment node) {
            Identifier identifier;
            if (!node.isJavadoc()) {
                throw new RuntimeException("Only javadoc expected here");
            }
            Node parent = node.getParent();
            Node node2 = parent = parent == null ? null : parent.getParent();
            while (parent != null && !(parent instanceof TypeDeclaration)) {
                parent = parent.getParent();
            }
            String typeName = null;
            if (parent instanceof TypeDeclaration && (identifier = ((TypeDeclaration)parent).astName()) != null) {
                typeName = identifier.astValue();
            }
            if (typeName == null) {
                typeName = EcjTreeBuilder.getTypeNameFromFileName(EcjTreeBuilder.this.compilationResult.getFileName());
            }
            return this.set((Node)node, (ASTNode)new JustJavadocParser(EcjTreeBuilder.this.silentProblemReporter, typeName).parse(EcjTreeBuilder.this.rawInput, node.getPosition().getStart(), node.getPosition().getEnd()));
        }

        @Override
        public boolean visitEmptyStatement(EmptyStatement node) {
            return this.set((Node)node, (ASTNode)new org.eclipse.jdt.internal.compiler.ast.EmptyStatement(EcjTreeBuilder.start(node), EcjTreeBuilder.end(node)));
        }

        @Override
        public boolean visitEmptyDeclaration(EmptyDeclaration node) {
            return this.set((Node)node, (ASTNode)null);
        }

        private int toModifiers(Modifiers modifiers) {
            return modifiers.getExplicitModifierFlags();
        }

        @Override
        public boolean visitNode(Node node) {
            throw new UnsupportedOperationException(String.format("Unhandled node '%s' (%s)", node, node.getClass().getSimpleName()));
        }

        private char[][] chain(StrictListAccessor<Identifier, ?> parts) {
            return this.chain(parts, parts.size());
        }

        private char[][] chain(Iterable<Identifier> parts, int size) {
            char[][] c = new char[size][];
            int i = 0;
            for (Identifier part : parts) {
                c[i++] = part.astValue().toCharArray();
            }
            return c;
        }

        private void updateRestrictionFlags(Node node, NameReference ref) {
            ref.bits &= 0xFFFFFFF8;
            ref.bits |= 3;
            if (node.getParent() instanceof MethodInvocation && ((MethodInvocation)node.getParent()).astOperand() == node) {
                ref.bits |= 4;
            }
            if (node.getParent() instanceof Select && ((Select)node.getParent()).astOperand() == node) {
                ref.bits |= 4;
            }
        }

        private boolean isUndocumented(Node block) {
            if (block == null) {
                return false;
            }
            if (EcjTreeBuilder.this.rawInput == null) {
                return false;
            }
            Position pos = block.getPosition();
            if (pos.isUnplaced() || pos.size() < 3) {
                return true;
            }
            String content = EcjTreeBuilder.this.rawInput.substring(pos.getStart() + 1, pos.getEnd() - 1);
            return content.trim().isEmpty();
        }
    };

    public EcjTreeBuilder(Source source, CompilerOptions options) {
        this(source, EcjTreeBuilder.createDefaultProblemReporter(options), EcjTreeBuilder.createSilentProblemReporter(options), new CompilationResult(source.getName().toCharArray(), 0, 0, 0));
    }

    public EcjTreeBuilder(String rawInput, String name, CompilerOptions options) {
        this(rawInput, EcjTreeBuilder.createDefaultProblemReporter(options), EcjTreeBuilder.createSilentProblemReporter(options), new CompilationResult(name.toCharArray(), 0, 0, 0));
    }

    private static ProblemReporter createDefaultProblemReporter(CompilerOptions options) {
        return new ProblemReporter(new IErrorHandlingPolicy(){

            public boolean proceedOnErrors() {
                return true;
            }

            public boolean stopOnFirstError() {
                return false;
            }
        }, options, (IProblemFactory)new DefaultProblemFactory(Locale.ENGLISH));
    }

    private static ProblemReporter createSilentProblemReporter(CompilerOptions options) {
        return new ProblemReporter(new IErrorHandlingPolicy(){

            public boolean proceedOnErrors() {
                return true;
            }

            public boolean stopOnFirstError() {
                return false;
            }
        }, options, SILENT_PROBLEM_FACTORY);
    }

    public EcjTreeBuilder(Source source, ProblemReporter reporter, ProblemReporter silentProblemReporter, CompilationResult compilationResult) {
        this.options = reporter.options;
        this.sourceStructures = source.getSourceStructures();
        this.rawInput = source.getRawInput();
        this.reporter = reporter;
        this.silentProblemReporter = silentProblemReporter;
        this.compilationResult = compilationResult;
    }

    public EcjTreeBuilder(String rawInput, ProblemReporter reporter, ProblemReporter silentProblemReporter, CompilationResult compilationResult) {
        this.options = reporter.options;
        this.sourceStructures = null;
        this.rawInput = rawInput;
        this.reporter = reporter;
        this.silentProblemReporter = silentProblemReporter;
        this.compilationResult = compilationResult;
    }

    private EcjTreeBuilder(EcjTreeBuilder parent) {
        this.reporter = parent.reporter;
        this.silentProblemReporter = parent.silentProblemReporter;
        this.options = parent.options;
        this.rawInput = parent.rawInput;
        this.compilationResult = parent.compilationResult;
        this.sourceStructures = parent.sourceStructures;
    }

    private EcjTreeBuilder create() {
        return new EcjTreeBuilder(this);
    }

    private org.eclipse.jdt.internal.compiler.ast.Expression toExpression(Node node) {
        return (org.eclipse.jdt.internal.compiler.ast.Expression)this.toTree(node);
    }

    private org.eclipse.jdt.internal.compiler.ast.Statement toStatement(Node node) {
        return (org.eclipse.jdt.internal.compiler.ast.Statement)this.toTree(node);
    }

    private ASTNode toTree(Node node) {
        if (node == null) {
            return null;
        }
        EcjTreeBuilder newBuilder = this.create();
        node.accept(newBuilder.visitor);
        this.bubblingFlags.addAll(newBuilder.bubblingFlags);
        try {
            return newBuilder.get();
        }
        catch (RuntimeException e) {
            System.err.printf("Node '%s' (%s) did not produce any results\n", node, node.getClass().getSimpleName());
            throw e;
        }
    }

    private char[] toName(Identifier node) {
        if (node == null) {
            return null;
        }
        return node.astValue().toCharArray();
    }

    private <T extends ASTNode> T[] toArray(Class<T> type, List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        ASTNode[] emptyArray = (ASTNode[])Array.newInstance(type, 0);
        return list.toArray(emptyArray);
    }

    private <T extends ASTNode> T[] toArray(Class<T> type, Node node) {
        return this.toArray(type, this.toList(type, node));
    }

    private <T extends ASTNode> T[] toArray(Class<T> type, StrictListAccessor<?, ?> accessor) {
        ArrayList<T> list = Lists.newArrayList();
        for (Node node : accessor) {
            EcjTreeBuilder newBuilder = this.create();
            node.accept(newBuilder.visitor);
            this.bubblingFlags.addAll(newBuilder.bubblingFlags);
            List<? extends ASTNode> values = newBuilder.getAll();
            for (ASTNode aSTNode : values) {
                if (aSTNode != null && !type.isInstance(aSTNode)) {
                    throw new ClassCastException(aSTNode.getClass().getName() + " cannot be cast to " + type.getName());
                }
                list.add(type.cast(aSTNode));
            }
        }
        return this.toArray(type, list);
    }

    private <T extends ASTNode> List<T> toList(Class<T> type, Node node) {
        if (node == null) {
            return Lists.newArrayList();
        }
        EcjTreeBuilder newBuilder = this.create();
        node.accept(newBuilder.visitor);
        this.bubblingFlags.addAll(newBuilder.bubblingFlags);
        List<? extends ASTNode> all = newBuilder.getAll();
        return Lists.newArrayList(all);
    }

    public void visit(Node node) {
        node.accept(this.visitor);
    }

    public ASTNode get() {
        if (this.result.isEmpty()) {
            return null;
        }
        if (this.result.size() == 1) {
            return this.result.get(0);
        }
        throw new RuntimeException("Expected only one result but got " + this.result.size());
    }

    public List<? extends ASTNode> getAll() {
        return this.result;
    }

    private static <T extends ASTNode> T posParen(T in, Node node) {
        List<Position> parensPositions;
        if (in == null) {
            return null;
        }
        if (node instanceof Expression && !(parensPositions = ((Expression)node).astParensPositions()).isEmpty()) {
            in.sourceStart = parensPositions.get(parensPositions.size() - 1).getStart();
            in.sourceEnd = parensPositions.get(parensPositions.size() - 1).getEnd() - 1;
        }
        return in;
    }

    private static boolean isExplicitlyAbstract(Modifiers m) {
        for (KeywordModifier keyword : m.astKeywords()) {
            if (!"abstract".equals(keyword.astName())) continue;
            return true;
        }
        return false;
    }

    private static int jstart(Node node) {
        Node javadoc;
        if (node == null) {
            return 0;
        }
        int start = EcjTreeBuilder.start(node);
        if (node instanceof JavadocContainer && (javadoc = ((JavadocContainer)node).rawJavadoc()) != null) {
            return Math.min(start, EcjTreeBuilder.start(javadoc));
        }
        if (node instanceof VariableDefinition && node.getParent() instanceof VariableDeclaration && (javadoc = ((JavadocContainer)node.getParent()).rawJavadoc()) != null) {
            return Math.min(start, EcjTreeBuilder.start(javadoc));
        }
        if (node instanceof Modifiers && node.getParent() instanceof JavadocContainer && (javadoc = ((JavadocContainer)node.getParent()).rawJavadoc()) != null) {
            return Math.min(start, EcjTreeBuilder.start(javadoc));
        }
        return start;
    }

    private static int start(Node node) {
        if (node == null || node.getPosition().isUnplaced()) {
            return 0;
        }
        return node.getPosition().getStart();
    }

    private static int end(Node node) {
        if (node == null || node.getPosition().isUnplaced()) {
            return 0;
        }
        return node.getPosition().getEnd() - 1;
    }

    private static long pos(Node n) {
        return (long)EcjTreeBuilder.start(n) << 32 | (long)EcjTreeBuilder.end(n);
    }

    private static long[] partsToPosArray(RawListAccessor<?, ?> parts) {
        long[] pos = new long[parts.size()];
        int idx = 0;
        for (Node n : parts) {
            if (n instanceof TypeReferencePart) {
                pos[idx++] = EcjTreeBuilder.pos(((TypeReferencePart)n).astIdentifier());
                continue;
            }
            pos[idx++] = EcjTreeBuilder.pos(n);
        }
        return pos;
    }

    private int countStructure(Node node, String structure) {
        int result = 0;
        if (this.sourceStructures != null && this.sourceStructures.containsKey(node)) {
            for (SourceStructure struct : this.sourceStructures.get(node)) {
                if (!structure.equals(struct.getContent())) continue;
                ++result;
            }
        }
        return result;
    }

    private int posOfStructure(Node node, String structure, boolean atStart) {
        return this.posOfStructure(node, structure, atStart ? 0 : Integer.MAX_VALUE, atStart);
    }

    private int posOfStructure(Node node, String structure, int idx, boolean atStart) {
        int start = node.getPosition().getStart();
        int end = node.getPosition().getEnd();
        Integer result = null;
        if (this.sourceStructures != null && this.sourceStructures.containsKey(node)) {
            for (SourceStructure struct : this.sourceStructures.get(node)) {
                if (!structure.equals(struct.getContent())) continue;
                result = atStart ? struct.getPosition().getStart() : struct.getPosition().getEnd();
                if (idx-- > 0) continue;
                break;
            }
        }
        if (result != null) {
            return result;
        }
        return atStart ? start : end;
    }

    private static String getTypeNameFromFileName(char[] fileName) {
        String f = new String(fileName);
        int start = Math.max(f.lastIndexOf(47), f.lastIndexOf(92));
        int end = f.lastIndexOf(46);
        if (end == -1) {
            end = f.length();
        }
        return f.substring(start + 1, end);
    }

    static {
        UNARY_OPERATORS.put(UnaryOperator.BINARY_NOT, 12);
        UNARY_OPERATORS.put(UnaryOperator.LOGICAL_NOT, 11);
        UNARY_OPERATORS.put(UnaryOperator.UNARY_PLUS, 14);
        UNARY_OPERATORS.put(UnaryOperator.PREFIX_INCREMENT, 14);
        UNARY_OPERATORS.put(UnaryOperator.UNARY_MINUS, 13);
        UNARY_OPERATORS.put(UnaryOperator.PREFIX_DECREMENT, 13);
        UNARY_OPERATORS.put(UnaryOperator.POSTFIX_INCREMENT, 14);
        UNARY_OPERATORS.put(UnaryOperator.POSTFIX_DECREMENT, 13);
        BINARY_OPERATORS = Maps.newEnumMap(BinaryOperator.class);
        BINARY_OPERATORS.put(BinaryOperator.PLUS_ASSIGN, 14);
        BINARY_OPERATORS.put(BinaryOperator.MINUS_ASSIGN, 13);
        BINARY_OPERATORS.put(BinaryOperator.MULTIPLY_ASSIGN, 15);
        BINARY_OPERATORS.put(BinaryOperator.DIVIDE_ASSIGN, 9);
        BINARY_OPERATORS.put(BinaryOperator.REMAINDER_ASSIGN, 16);
        BINARY_OPERATORS.put(BinaryOperator.AND_ASSIGN, 2);
        BINARY_OPERATORS.put(BinaryOperator.XOR_ASSIGN, 8);
        BINARY_OPERATORS.put(BinaryOperator.OR_ASSIGN, 3);
        BINARY_OPERATORS.put(BinaryOperator.SHIFT_LEFT_ASSIGN, 10);
        BINARY_OPERATORS.put(BinaryOperator.SHIFT_RIGHT_ASSIGN, 17);
        BINARY_OPERATORS.put(BinaryOperator.BITWISE_SHIFT_RIGHT_ASSIGN, 19);
        BINARY_OPERATORS.put(BinaryOperator.LOGICAL_OR, 1);
        BINARY_OPERATORS.put(BinaryOperator.LOGICAL_AND, 0);
        BINARY_OPERATORS.put(BinaryOperator.BITWISE_OR, 3);
        BINARY_OPERATORS.put(BinaryOperator.BITWISE_XOR, 8);
        BINARY_OPERATORS.put(BinaryOperator.BITWISE_AND, 2);
        BINARY_OPERATORS.put(BinaryOperator.EQUALS, 18);
        BINARY_OPERATORS.put(BinaryOperator.NOT_EQUALS, 29);
        BINARY_OPERATORS.put(BinaryOperator.GREATER, 6);
        BINARY_OPERATORS.put(BinaryOperator.GREATER_OR_EQUAL, 7);
        BINARY_OPERATORS.put(BinaryOperator.LESS, 4);
        BINARY_OPERATORS.put(BinaryOperator.LESS_OR_EQUAL, 5);
        BINARY_OPERATORS.put(BinaryOperator.SHIFT_LEFT, 10);
        BINARY_OPERATORS.put(BinaryOperator.SHIFT_RIGHT, 17);
        BINARY_OPERATORS.put(BinaryOperator.BITWISE_SHIFT_RIGHT, 19);
        BINARY_OPERATORS.put(BinaryOperator.PLUS, 14);
        BINARY_OPERATORS.put(BinaryOperator.MINUS, 13);
        BINARY_OPERATORS.put(BinaryOperator.MULTIPLY, 15);
        BINARY_OPERATORS.put(BinaryOperator.DIVIDE, 9);
        BINARY_OPERATORS.put(BinaryOperator.REMAINDER, 16);
    }

    private static class JustJavadocParser
    extends JavadocParser {
        private static final char[] GENERIC_JAVA_CLASS_SUFFIX = "class Y{}".toCharArray();

        JustJavadocParser(ProblemReporter reporter, String mainTypeName) {
            super(JustJavadocParser.makeDummyParser(reporter, mainTypeName));
        }

        private static Parser makeDummyParser(ProblemReporter reporter, String mainTypeName) {
            Parser parser = new Parser(reporter, false);
            CompilationResult cr = new CompilationResult((mainTypeName + ".java").toCharArray(), 0, 1, 0);
            parser.compilationUnit = new CompilationUnitDeclaration(reporter, cr, 0);
            return parser;
        }

        Javadoc parse(String rawInput, int from, int to) {
            char[] rawContent = new char[to + GENERIC_JAVA_CLASS_SUFFIX.length];
            Arrays.fill(rawContent, 0, from, ' ');
            System.arraycopy(rawInput.substring(from, to).toCharArray(), 0, rawContent, from, to - from);
            System.arraycopy(GENERIC_JAVA_CLASS_SUFFIX, 0, rawContent, to, GENERIC_JAVA_CLASS_SUFFIX.length);
            this.sourceLevel = 0x320000L;
            this.scanner.setSource(rawContent);
            this.source = rawContent;
            this.javadocStart = from;
            this.javadocEnd = to;
            this.reportProblems = true;
            this.docComment = new Javadoc(this.javadocStart, this.javadocEnd);
            this.commentParse();
            this.docComment.valuePositions = -1L;
            --this.docComment.sourceEnd;
            return this.docComment;
        }
    }

    private static enum VariableKind {
        UNSUPPORTED{

            @Override
            AbstractVariableDeclaration create() {
                throw new UnsupportedOperationException();
            }
        }
        ,
        FIELD{

            @Override
            AbstractVariableDeclaration create() {
                return new FieldDeclaration();
            }
        }
        ,
        LOCAL{

            @Override
            AbstractVariableDeclaration create() {
                return new LocalDeclaration(null, 0, 0);
            }
        }
        ,
        ARGUMENT{

            @Override
            AbstractVariableDeclaration create() {
                return new Argument(null, 0L, null, 0);
            }
        };


        abstract AbstractVariableDeclaration create();

        static VariableKind kind(VariableDefinition node) {
            Node parent = node.getParent();
            if (parent instanceof VariableDeclaration) {
                if (parent.getParent() instanceof TypeBody || parent.getParent() instanceof EnumTypeBody) {
                    return FIELD;
                }
                return LOCAL;
            }
            if (parent instanceof For || parent instanceof ForEach) {
                return LOCAL;
            }
            if (parent instanceof Catch || parent instanceof MethodDeclaration || parent instanceof ConstructorDeclaration) {
                return ARGUMENT;
            }
            return UNSUPPORTED;
        }
    }

    private static enum BubblingFlags {
        ASSERT,
        LOCALTYPE,
        ABSTRACT_METHOD;

    }
}

