/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.ecj;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import lombok.ast.AbstractNode;
import lombok.ast.AlternateConstructorInvocation;
import lombok.ast.Annotation;
import lombok.ast.AnnotationDeclaration;
import lombok.ast.AnnotationElement;
import lombok.ast.AnnotationMethodDeclaration;
import lombok.ast.AnnotationValue;
import lombok.ast.ArrayAccess;
import lombok.ast.ArrayCreation;
import lombok.ast.ArrayDimension;
import lombok.ast.ArrayInitializer;
import lombok.ast.Assert;
import lombok.ast.BinaryExpression;
import lombok.ast.BinaryOperator;
import lombok.ast.Block;
import lombok.ast.BooleanLiteral;
import lombok.ast.Break;
import lombok.ast.Case;
import lombok.ast.Cast;
import lombok.ast.Catch;
import lombok.ast.CharLiteral;
import lombok.ast.ClassDeclaration;
import lombok.ast.ClassLiteral;
import lombok.ast.Comment;
import lombok.ast.CompilationUnit;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.ConstructorInvocation;
import lombok.ast.Continue;
import lombok.ast.ConversionPositionInfo;
import lombok.ast.Default;
import lombok.ast.DoWhile;
import lombok.ast.EmptyStatement;
import lombok.ast.EnumConstant;
import lombok.ast.EnumDeclaration;
import lombok.ast.EnumTypeBody;
import lombok.ast.Expression;
import lombok.ast.ExpressionStatement;
import lombok.ast.FloatingPointLiteral;
import lombok.ast.For;
import lombok.ast.ForEach;
import lombok.ast.Identifier;
import lombok.ast.If;
import lombok.ast.ImportDeclaration;
import lombok.ast.InlineIfExpression;
import lombok.ast.InstanceInitializer;
import lombok.ast.InstanceOf;
import lombok.ast.IntegralLiteral;
import lombok.ast.InterfaceDeclaration;
import lombok.ast.KeywordModifier;
import lombok.ast.LabelledStatement;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Modifiers;
import lombok.ast.Node;
import lombok.ast.NormalTypeBody;
import lombok.ast.NullLiteral;
import lombok.ast.PackageDeclaration;
import lombok.ast.Position;
import lombok.ast.RawListAccessor;
import lombok.ast.Return;
import lombok.ast.Select;
import lombok.ast.Statement;
import lombok.ast.StaticInitializer;
import lombok.ast.StrictListAccessor;
import lombok.ast.StringLiteral;
import lombok.ast.Super;
import lombok.ast.SuperConstructorInvocation;
import lombok.ast.Switch;
import lombok.ast.Synchronized;
import lombok.ast.This;
import lombok.ast.Throw;
import lombok.ast.Try;
import lombok.ast.TypeDeclaration;
import lombok.ast.TypeReference;
import lombok.ast.TypeReferencePart;
import lombok.ast.TypeVariable;
import lombok.ast.UnaryExpression;
import lombok.ast.UnaryOperator;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;
import lombok.ast.While;
import lombok.ast.WildcardKind;
import lombok.ast.ecj.EcjTreeBuilder;
import lombok.ast.ecj.EcjTreeVisitor;
import lombok.ast.libs.com.google.common.collect.ImmutableMap;
import lombok.ast.libs.com.google.common.collect.Lists;
import lombok.ast.libs.com.google.common.collect.Maps;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AND_AND_Expression;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.AssertStatement;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.BreakStatement;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.Clinit;
import org.eclipse.jdt.internal.compiler.ast.CombinedBinaryExpression;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.ContinueStatement;
import org.eclipse.jdt.internal.compiler.ast.DoStatement;
import org.eclipse.jdt.internal.compiler.ast.DoubleLiteral;
import org.eclipse.jdt.internal.compiler.ast.EqualExpression;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.ExtendedStringLiteral;
import org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.FloatLiteral;
import org.eclipse.jdt.internal.compiler.ast.ForStatement;
import org.eclipse.jdt.internal.compiler.ast.ForeachStatement;
import org.eclipse.jdt.internal.compiler.ast.IfStatement;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.InstanceOfExpression;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.IntLiteralMinValue;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.LabeledStatement;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LongLiteral;
import org.eclipse.jdt.internal.compiler.ast.LongLiteralMinValue;
import org.eclipse.jdt.internal.compiler.ast.MarkerAnnotation;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.eclipse.jdt.internal.compiler.ast.OR_OR_Expression;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.PostfixExpression;
import org.eclipse.jdt.internal.compiler.ast.PrefixExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedSuperReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.StringLiteralConcatenation;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.ThrowStatement;
import org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.WhileStatement;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;

public class EcjTreeConverter {
    private List<? extends Node> result = null;
    private Map<FlagKey, Object> params = ImmutableMap.of();
    private String rawInput;
    private static final Comparator<ASTNode> ASTNODE_ORDER = new Comparator<ASTNode>(){

        @Override
        public int compare(ASTNode nodeOne, ASTNode nodeTwo) {
            return nodeOne.sourceStart - nodeTwo.sourceStart;
        }
    };
    private final EcjTreeVisitor visitor = new EcjTreeVisitor(){

        @Override
        public void visitCompilationUnitDeclaration(CompilationUnitDeclaration node) {
            PackageDeclaration lombokJavadoc;
            CompilationUnit unit = new CompilationUnit();
            unit.rawPackageDeclaration(EcjTreeConverter.this.toTree((ASTNode)node.currentPackage, new FlagKey[]{FlagKey.IMPORTDECLARATION_IS_PACKAGE}));
            if (node.javadoc != null && (lombokJavadoc = unit.astPackageDeclaration()) != null) {
                lombokJavadoc.rawJavadoc(EcjTreeConverter.this.toTree((ASTNode)node.javadoc, new FlagKey[0]));
            }
            EcjTreeConverter.this.fillList((ASTNode[])node.imports, unit.rawImportDeclarations(), new FlagKey[0]);
            org.eclipse.jdt.internal.compiler.ast.TypeDeclaration[] newTypes = null;
            if (node.types != null && node.types.length > 0 && CharOperation.equals((char[])EcjTreeBuilder.PACKAGE_INFO, (char[])node.types[0].name)) {
                newTypes = new org.eclipse.jdt.internal.compiler.ast.TypeDeclaration[node.types.length - 1];
                System.arraycopy(node.types, 1, newTypes, 0, node.types.length - 1);
            } else {
                newTypes = node.types;
            }
            EcjTreeConverter.this.fillList((ASTNode[])newTypes, unit.rawTypeDeclarations(), new FlagKey[0]);
            EcjTreeConverter.this.set((ASTNode)node, unit);
        }

        @Override
        public void visitImportReference(ImportReference node) {
            if (EcjTreeConverter.this.hasFlag(FlagKey.IMPORTDECLARATION_IS_PACKAGE)) {
                PackageDeclaration pkg = new PackageDeclaration();
                EcjTreeConverter.this.fillIdentifiers(node.tokens, node.sourcePositions, pkg.astParts());
                EcjTreeConverter.this.fillList((ASTNode[])node.annotations, pkg.rawAnnotations(), new FlagKey[0]);
                pkg.setPosition(EcjTreeConverter.this.toPosition(node.declarationSourceStart, node.declarationSourceEnd));
                EcjTreeConverter.this.set((ASTNode)node, pkg);
                return;
            }
            ImportDeclaration imp = new ImportDeclaration();
            EcjTreeConverter.this.fillIdentifiers(node.tokens, node.sourcePositions, imp.astParts());
            imp.astStarImport((node.bits & 0x20000) != 0);
            imp.astStaticImport((node.modifiers & 8) != 0);
            imp.setPosition(EcjTreeConverter.this.toPosition(node.declarationSourceStart, node.declarationSourceEnd));
            EcjTreeConverter.this.set((ASTNode)node, imp);
        }

        @Override
        public void visitInitializer(Initializer node) {
            if ((node.modifiers & 8) != 0) {
                StaticInitializer staticInit = new StaticInitializer();
                staticInit.astBody((Block)EcjTreeConverter.this.toTree((ASTNode)node.block, new FlagKey[0]));
                staticInit.setPosition(EcjTreeConverter.this.toPosition(node.declarationSourceStart, node.sourceEnd));
                EcjTreeConverter.this.set((ASTNode)node, staticInit);
                return;
            }
            InstanceInitializer instanceInit = new InstanceInitializer();
            instanceInit.astBody((Block)EcjTreeConverter.this.toTree((ASTNode)node.block, new FlagKey[0]));
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, instanceInit));
        }

        @Override
        public void visitTypeDeclaration(org.eclipse.jdt.internal.compiler.ast.TypeDeclaration node) {
            TypeDeclaration decl = null;
            switch (org.eclipse.jdt.internal.compiler.ast.TypeDeclaration.kind((int)node.modifiers)) {
                case 1: {
                    ClassDeclaration cDecl = new ClassDeclaration();
                    cDecl.rawExtending(EcjTreeConverter.this.toTree((ASTNode)node.superclass, new FlagKey[0]));
                    cDecl.astBody(this.createNormalTypeBody(node));
                    EcjTreeConverter.this.fillList((ASTNode[])node.superInterfaces, cDecl.rawImplementing(), new FlagKey[0]);
                    EcjTreeConverter.this.fillList((ASTNode[])node.typeParameters, cDecl.rawTypeVariables(), new FlagKey[0]);
                    decl = cDecl;
                    break;
                }
                case 2: {
                    InterfaceDeclaration iDecl = new InterfaceDeclaration();
                    iDecl.astBody(this.createNormalTypeBody(node));
                    EcjTreeConverter.this.fillList((ASTNode[])node.superInterfaces, iDecl.rawExtending(), new FlagKey[0]);
                    EcjTreeConverter.this.fillList((ASTNode[])node.typeParameters, iDecl.rawTypeVariables(), new FlagKey[0]);
                    decl = iDecl;
                    break;
                }
                case 3: {
                    EnumDeclaration eDecl = new EnumDeclaration();
                    EnumTypeBody enumTypeBody = this.createEnumTypeBody(node);
                    EcjTreeConverter.this.fillList((ASTNode[])node.superInterfaces, eDecl.rawImplementing(), new FlagKey[0]);
                    eDecl.astBody(enumTypeBody);
                    decl = eDecl;
                    break;
                }
                case 4: {
                    AnnotationDeclaration aDecl = new AnnotationDeclaration();
                    aDecl.astBody(this.createNormalTypeBody(node));
                    decl = aDecl;
                    break;
                }
            }
            decl.astJavadoc((Comment)EcjTreeConverter.this.toTree((ASTNode)node.javadoc, new FlagKey[0]));
            decl.astModifiers(EcjTreeConverter.this.toModifiers(node.modifiers, node.annotations, node.modifiersSourceStart, node.declarationSourceStart));
            decl.astName(EcjTreeConverter.this.toIdentifier(node.name, node.sourceStart, node.sourceEnd));
            decl.setPosition(EcjTreeConverter.this.toPosition(node.declarationSourceStart, node.declarationSourceEnd));
            EcjTreeConverter.this.set((ASTNode)node, decl);
        }

        private EnumTypeBody createEnumTypeBody(org.eclipse.jdt.internal.compiler.ast.TypeDeclaration node) {
            EnumTypeBody body = new EnumTypeBody();
            List<ASTNode> orderedList = this.createOrderedMemberList(node);
            ArrayList<FieldDeclaration> enumConstants = new ArrayList<FieldDeclaration>();
            if (node.fields != null) {
                for (FieldDeclaration field : node.fields) {
                    if (!this.isEnumConstant(field)) continue;
                    enumConstants.add(field);
                }
            }
            EcjTreeConverter.this.fillList(orderedList.toArray(new ASTNode[0]), body.rawMembers(), new FlagKey[0]);
            EcjTreeConverter.this.fillList(enumConstants.toArray(new ASTNode[0]), body.rawConstants(), new FlagKey[]{FlagKey.AS_ENUM});
            body.setPosition(EcjTreeConverter.this.toPosition(node.bodyStart - 1, node.bodyEnd));
            return body;
        }

        private boolean isEnumConstant(FieldDeclaration field) {
            return field.type == null && !(field instanceof Initializer);
        }

        private List<ASTNode> createOrderedMemberList(org.eclipse.jdt.internal.compiler.ast.TypeDeclaration node) {
            ArrayList<ASTNode> orderedList = new ArrayList<ASTNode>();
            ArrayList<FieldDeclaration> nonEnumConstants = new ArrayList<FieldDeclaration>();
            if (node.fields != null) {
                for (FieldDeclaration field : node.fields) {
                    if (this.isEnumConstant(field)) continue;
                    nonEnumConstants.add(field);
                }
            }
            EcjTreeConverter.this.fillUtilityList(orderedList, nonEnumConstants.toArray(new ASTNode[0]));
            EcjTreeConverter.this.fillUtilityList(orderedList, (ASTNode[])node.methods);
            EcjTreeConverter.this.fillUtilityList(orderedList, (ASTNode[])node.memberTypes);
            Collections.sort(orderedList, ASTNODE_ORDER);
            return orderedList;
        }

        private NormalTypeBody createNormalTypeBody(org.eclipse.jdt.internal.compiler.ast.TypeDeclaration node) {
            NormalTypeBody body = new NormalTypeBody();
            List<ASTNode> orderedList = this.createOrderedMemberList(node);
            EcjTreeConverter.this.fillList(orderedList.toArray(new ASTNode[0]), body.rawMembers(), new FlagKey[0]);
            body.setPosition(EcjTreeConverter.this.toPosition(node.bodyStart - 1, node.bodyEnd));
            return body;
        }

        @Override
        public void visitTypeParameter(TypeParameter node) {
            TypeVariable var = new TypeVariable();
            var.astName(EcjTreeConverter.this.toIdentifier(node.name, node.sourceStart, node.sourceEnd));
            var.astExtending().addToEnd(new TypeReference[]{(TypeReference)EcjTreeConverter.this.toTree((ASTNode)node.type, new FlagKey[0])});
            EcjTreeConverter.this.fillList((ASTNode[])node.bounds, var.rawExtending(), new FlagKey[0]);
            EcjTreeConverter.this.setPosition((ASTNode)node, var);
            EcjTreeConverter.this.set((ASTNode)node, var);
        }

        @Override
        public void visitEmptyStatement(org.eclipse.jdt.internal.compiler.ast.EmptyStatement node) {
            EmptyStatement statement = new EmptyStatement();
            EcjTreeConverter.this.setPosition((ASTNode)node, statement);
            EcjTreeConverter.this.set((ASTNode)node, statement);
        }

        @Override
        public void visitLocalDeclaration(LocalDeclaration node) {
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.toVariableDefinition((List<AbstractVariableDeclaration>)Arrays.asList(node), EcjTreeConverter.this.params));
        }

        @Override
        public void visitFieldDeclaration(FieldDeclaration node) {
            if (EcjTreeConverter.this.hasFlag(FlagKey.AS_ENUM)) {
                if (node.initialization instanceof AllocationExpression) {
                    this.handleEnumConstant(node);
                } else {
                    EcjTreeConverter.this.set((ASTNode)node, null);
                }
                return;
            }
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.toVariableDefinition((List<AbstractVariableDeclaration>)Arrays.asList(node), new FlagKey[0]));
        }

        @Override
        public void visitFieldReference(FieldReference node) {
            Select select = new Select();
            select.astIdentifier(EcjTreeConverter.this.toIdentifier(node.token, node.nameSourcePosition));
            select.astOperand((Expression)EcjTreeConverter.this.toTree((ASTNode)node.receiver, new FlagKey[0]));
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, select));
        }

        private void handleEnumConstant(FieldDeclaration node) {
            AllocationExpression init = (AllocationExpression)node.initialization;
            EnumConstant constant = new EnumConstant();
            constant.astJavadoc((Comment)EcjTreeConverter.this.toTree((ASTNode)node.javadoc, new FlagKey[0]));
            constant.astName(EcjTreeConverter.this.toIdentifier(node.name, node.sourceStart, node.sourceEnd));
            EcjTreeConverter.this.fillList((ASTNode[])init.arguments, constant.rawArguments(), new FlagKey[0]);
            EcjTreeConverter.this.fillList((ASTNode[])node.annotations, constant.rawAnnotations(), new FlagKey[0]);
            if (node.initialization instanceof QualifiedAllocationExpression) {
                QualifiedAllocationExpression qualifiedNode = (QualifiedAllocationExpression)node.initialization;
                NormalTypeBody body = this.createNormalTypeBody(qualifiedNode.anonymousType);
                body.setPosition(new Position(body.getPosition().getStart(), body.getPosition().getEnd() + 1));
                constant.astBody(body);
            }
            ConversionPositionInfo.setConversionPositionInfo(constant, "declarationSource", EcjTreeConverter.this.toPosition(node.declarationSourceStart, node.declarationSourceEnd));
            constant.setPosition(EcjTreeConverter.this.toPosition(node.declarationSourceStart, node.declarationEnd));
            EcjTreeConverter.this.set((ASTNode)node, constant);
        }

        @Override
        public void visitBlock(org.eclipse.jdt.internal.compiler.ast.Block node) {
            Block lombokNode = EcjTreeConverter.this.toBlock(node.statements);
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, lombokNode));
        }

        @Override
        public void visitSingleTypeReference(SingleTypeReference node) {
            TypeReference ref = new TypeReference();
            ref.astParts().addToEnd(new TypeReferencePart[]{this.createSingleTypeReferencePart(node)});
            EcjTreeConverter.this.setPosition((ASTNode)node, ref);
            EcjTreeConverter.this.set((ASTNode)node, ref);
        }

        private TypeReferencePart createSingleTypeReferencePart(SingleTypeReference node) {
            TypeReferencePart part = new TypeReferencePart();
            part.astIdentifier(EcjTreeConverter.this.toIdentifier(node.token, node.sourceStart, node.sourceEnd));
            part.setPosition(part.astIdentifier().getPosition());
            return part;
        }

        private void fillTypeReferenceParts(char[][] tokens, long[] positions, StrictListAccessor<TypeReferencePart, ?> list) {
            if (tokens == null) {
                return;
            }
            if (tokens.length != positions.length) {
                throw new IllegalStateException("bug");
            }
            for (int i = 0; i < tokens.length; ++i) {
                TypeReferencePart part = new TypeReferencePart();
                part.astIdentifier(EcjTreeConverter.this.toIdentifier(tokens[i], positions[i]));
                list.addToEnd(new TypeReferencePart[]{part});
            }
        }

        @Override
        public void visitQualifiedTypeReference(QualifiedTypeReference node) {
            TypeReference ref = new TypeReference();
            this.fillTypeReferenceParts(node.tokens, node.sourcePositions, ref.astParts());
            EcjTreeConverter.this.set((ASTNode)node, ref);
        }

        private void fillTypeReferenceParts(char[][] tokens, long[] positions, org.eclipse.jdt.internal.compiler.ast.TypeReference[][] typeArguments, StrictListAccessor<TypeReferencePart, ?> list) {
            if (tokens == null) {
                return;
            }
            if (tokens.length != positions.length) {
                throw new IllegalStateException("bug");
            }
            for (int i = 0; i < typeArguments.length; ++i) {
                org.eclipse.jdt.internal.compiler.ast.TypeReference[] typeReferences = typeArguments[i];
                TypeReferencePart part = this.createTypeReferencePart(tokens[i], positions[i], typeReferences);
                list.addToEnd(new TypeReferencePart[]{part});
            }
        }

        private TypeReferencePart createTypeReferencePart(char[] token, long pos) {
            return this.createTypeReferencePart(token, pos, null);
        }

        private TypeReferencePart createTypeReferencePart(char[] token, long pos, org.eclipse.jdt.internal.compiler.ast.TypeReference[] typeReferences) {
            TypeReferencePart part = new TypeReferencePart();
            part.astIdentifier(EcjTreeConverter.this.toIdentifier(token, pos));
            if (typeReferences != null) {
                EcjTreeConverter.this.fillList((ASTNode[])typeReferences, part.rawTypeArguments(), new FlagKey[0]);
            }
            part.setPosition(EcjTreeConverter.this.toPosition(pos));
            return part;
        }

        @Override
        public void visitParameterizedQualifiedTypeReference(ParameterizedQualifiedTypeReference node) {
            TypeReference ref = new TypeReference();
            ref.astArrayDimensions(node.dimensions());
            this.fillTypeReferenceParts(node.tokens, node.sourcePositions, node.typeArguments, ref.astParts());
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, ref));
        }

        @Override
        public void visitWildcard(Wildcard node) {
            TypeReference ref = (TypeReference)EcjTreeConverter.this.toTree((ASTNode)node.bound, new FlagKey[0]);
            if (ref == null) {
                ref = new TypeReference();
            }
            switch (node.kind) {
                case 0: {
                    ref.astWildcard(WildcardKind.UNBOUND);
                    break;
                }
                case 1: {
                    ref.astWildcard(WildcardKind.EXTENDS);
                    break;
                }
                case 2: {
                    ref.astWildcard(WildcardKind.SUPER);
                }
            }
            EcjTreeConverter.this.setPosition((ASTNode)node, ref);
            EcjTreeConverter.this.set((ASTNode)node, ref);
        }

        @Override
        public void visitParameterizedSingleTypeReference(ParameterizedSingleTypeReference node) {
            TypeReference ref = new TypeReference();
            TypeReferencePart part = new TypeReferencePart();
            part.astIdentifier(EcjTreeConverter.this.toIdentifier(node.token, node.sourceStart, node.sourceEnd));
            ref.astParts().addToEnd(new TypeReferencePart[]{part});
            EcjTreeConverter.this.fillList((ASTNode[])node.typeArguments, part.rawTypeArguments(), new FlagKey[0]);
            ref.astArrayDimensions(node.dimensions());
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, ref));
        }

        @Override
        public void visitArrayTypeReference(ArrayTypeReference node) {
            TypeReference ref = new TypeReference();
            ref.astArrayDimensions((node.bits & 0x4000) == 0 ? node.dimensions : node.dimensions - 1);
            TypeReferencePart part = new TypeReferencePart();
            part.astIdentifier(EcjTreeConverter.this.toIdentifier(node.token, node.sourceStart, node.sourceEnd));
            ref.astParts().addToEnd(new TypeReferencePart[]{part});
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, ref));
        }

        @Override
        public void visitArrayQualifiedTypeReference(ArrayQualifiedTypeReference node) {
            TypeReference ref = new TypeReference();
            this.fillTypeReferenceParts(node.tokens, node.sourcePositions, ref.astParts());
            ref.astArrayDimensions(node.dimensions());
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, ref));
        }

        private Node addUnaryMinusAsParent(boolean condition, Expression expression) {
            if (condition) {
                return new UnaryExpression().astOperand(expression).astOperator(UnaryOperator.UNARY_MINUS);
            }
            return expression;
        }

        @Override
        public void visitIntLiteral(IntLiteral node) {
            String rawValue = String.valueOf(node.source());
            boolean negative = rawValue.startsWith("-");
            IntegralLiteral integral = new IntegralLiteral().rawValue(negative ? rawValue.substring(1) : rawValue);
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, this.addUnaryMinusAsParent(negative, integral)));
        }

        @Override
        public void visitIntLiteralMinValue(IntLiteralMinValue node) {
            this.visitIntLiteral((IntLiteral)node);
        }

        @Override
        public void visitLongLiteral(LongLiteral node) {
            String rawValue = String.valueOf(node.source());
            boolean negative = rawValue.startsWith("-");
            IntegralLiteral integral = new IntegralLiteral().rawValue(negative ? rawValue.substring(1) : rawValue);
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, this.addUnaryMinusAsParent(negative, integral)));
        }

        @Override
        public void visitLongLiteralMinValue(LongLiteralMinValue node) {
            this.visitLongLiteral((LongLiteral)node);
        }

        @Override
        public void visitFloatLiteral(FloatLiteral node) {
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, new FloatingPointLiteral().rawValue(String.valueOf(node.source()))));
        }

        @Override
        public void visitDoubleLiteral(DoubleLiteral node) {
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, new FloatingPointLiteral().rawValue(String.valueOf(node.source()))));
        }

        @Override
        public void visitTrueLiteral(TrueLiteral node) {
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, new BooleanLiteral().astValue(true)));
        }

        @Override
        public void visitFalseLiteral(FalseLiteral node) {
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, new BooleanLiteral().astValue(false)));
        }

        @Override
        public void visitNullLiteral(org.eclipse.jdt.internal.compiler.ast.NullLiteral node) {
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, new NullLiteral()));
        }

        @Override
        public void visitCharLiteral(org.eclipse.jdt.internal.compiler.ast.CharLiteral node) {
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, new CharLiteral().rawValue(String.valueOf(node.source()))));
        }

        @Override
        public void visitStringLiteral(org.eclipse.jdt.internal.compiler.ast.StringLiteral node) {
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, new StringLiteral().astValue(String.valueOf(node.source()))));
        }

        @Override
        public void visitStringLiteralConcatenation(StringLiteralConcatenation node) {
            Node lombokAggregator = null;
            if (node.literals != null) {
                for (int i = 0; i < node.counter; ++i) {
                    Node lombokElemNode = EcjTreeConverter.this.toTree((ASTNode)node.literals[i], new FlagKey[0]);
                    if (lombokAggregator != null) {
                        Position newPos = lombokElemNode.getPosition().withoutGeneratedBy();
                        lombokAggregator = new BinaryExpression().astOperator(BinaryOperator.PLUS).rawLeft(lombokAggregator).rawRight(lombokElemNode);
                        lombokAggregator.setPosition(newPos);
                        continue;
                    }
                    lombokAggregator = lombokElemNode;
                }
            }
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, lombokAggregator));
        }

        @Override
        public void visitExtendedStringLiteral(ExtendedStringLiteral node) {
            this.visitStringLiteral((org.eclipse.jdt.internal.compiler.ast.StringLiteral)node);
        }

        @Override
        public void visitSingleNameReference(SingleNameReference node) {
            if (EcjTreeConverter.this.hasFlag(FlagKey.NAMEREFERENCE_IS_TYPE)) {
                EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, new TypeReference().astParts().addToEnd(new TypeReferencePart[]{this.createTypeReferencePart(node.token, EcjTreeConverter.this.toLong(node.sourceStart, node.sourceEnd))})));
                return;
            }
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, new VariableReference().astIdentifier(EcjTreeConverter.this.toIdentifier(node.token, node.sourceStart, node.sourceEnd))));
        }

        org.eclipse.jdt.internal.compiler.ast.TypeReference getTypeFromCast(CastExpression node) {
            Object expr;
            try {
                expr = CASTEXPRESSION_TYPE_FIELD.get(node);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Lombok is not compatible with this version of eclipse", e);
            }
            if (expr instanceof QualifiedNameReference) {
                QualifiedNameReference name = (QualifiedNameReference)expr;
                return new QualifiedTypeReference(name.tokens, name.sourcePositions);
            }
            if (expr instanceof SingleNameReference) {
                SingleNameReference name = (SingleNameReference)expr;
                return new SingleTypeReference(name.token, (long)name.sourceStart << 32 | (long)name.sourceEnd);
            }
            return (org.eclipse.jdt.internal.compiler.ast.TypeReference)expr;
        }

        @Override
        public void visitCastExpression(CastExpression node) {
            org.eclipse.jdt.internal.compiler.ast.TypeReference ref = this.getTypeFromCast(node);
            Node result = EcjTreeConverter.this.toTree((ASTNode)ref, new FlagKey[]{FlagKey.NAMEREFERENCE_IS_TYPE});
            Cast cast = new Cast().astTypeReference((TypeReference)result);
            cast.astOperand((Expression)EcjTreeConverter.this.toTree((ASTNode)node.expression, new FlagKey[0]));
            ConversionPositionInfo.setConversionPositionInfo(cast, "type", EcjTreeConverter.this.toPosition(ref.sourceStart, ref.sourceEnd));
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, cast));
        }

        @Override
        public void visitThisReference(ThisReference node) {
            EcjTreeConverter.this.set((ASTNode)node, node.isImplicitThis() ? null : (This)EcjTreeConverter.this.setPosition((ASTNode)node, new This()));
        }

        @Override
        public void visitQualifiedThisReference(QualifiedThisReference node) {
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, new This().astQualifier((TypeReference)EcjTreeConverter.this.toTree((ASTNode)node.qualification, new FlagKey[0]))));
        }

        @Override
        public void visitSuperReference(SuperReference node) {
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, new Super()));
        }

        @Override
        public void visitQualifiedSuperReference(QualifiedSuperReference node) {
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, new Super().astQualifier((TypeReference)EcjTreeConverter.this.toTree((ASTNode)node.qualification, new FlagKey[0]))));
        }

        @Override
        public void visitClassLiteralAccess(ClassLiteralAccess node) {
            ClassLiteral literal = new ClassLiteral().astTypeReference((TypeReference)EcjTreeConverter.this.toTree((ASTNode)node.type, new FlagKey[0]));
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, literal));
        }

        @Override
        public void visitArrayAllocationExpression(ArrayAllocationExpression node) {
            ArrayCreation creation = new ArrayCreation();
            creation.astInitializer((ArrayInitializer)EcjTreeConverter.this.toTree((ASTNode)node.initializer, new FlagKey[0]));
            EcjTreeConverter.this.fillDimensions(node.dimensions, creation.rawDimensions());
            creation.astComponentTypeReference((TypeReference)EcjTreeConverter.this.toTree((ASTNode)node.type, new FlagKey[0]));
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, creation));
        }

        @Override
        public void visitArrayInitializer(org.eclipse.jdt.internal.compiler.ast.ArrayInitializer node) {
            ArrayInitializer init = new ArrayInitializer();
            EcjTreeConverter.this.fillList((ASTNode[])node.expressions, init.rawExpressions(), new FlagKey[0]);
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, init));
        }

        @Override
        public void visitAssignment(Assignment node) {
            BinaryExpression bin = new BinaryExpression();
            bin.astLeft((Expression)EcjTreeConverter.this.toTree((ASTNode)node.lhs, new FlagKey[0]));
            bin.astRight((Expression)EcjTreeConverter.this.toTree((ASTNode)node.expression, new FlagKey[0]));
            bin.astOperator(BinaryOperator.ASSIGN);
            EcjTreeConverter.this.setPosition((ASTNode)node, bin);
            EcjTreeConverter.this.set((ASTNode)node, bin);
        }

        @Override
        public void visitArrayReference(ArrayReference node) {
            ArrayAccess access = new ArrayAccess();
            access.astOperand((Expression)EcjTreeConverter.this.toTree((ASTNode)node.receiver, new FlagKey[0]));
            access.astIndexExpression((Expression)EcjTreeConverter.this.toTree((ASTNode)node.position, new FlagKey[0]));
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, access));
        }

        @Override
        public void visitUnaryExpression(org.eclipse.jdt.internal.compiler.ast.UnaryExpression node) {
            UnaryExpression unary = new UnaryExpression();
            int operatorId = (node.bits & 0xFC0) >> 6;
            unary.astOperator(GENERIC_UNARY_OPERATORS.get(operatorId));
            unary.astOperand((Expression)EcjTreeConverter.this.toTree((ASTNode)node.expression, new FlagKey[0]));
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, unary));
        }

        @Override
        public void visitPrefixExpression(PrefixExpression node) {
            UnaryExpression unary = this.fillUnaryOperator((CompoundAssignment)node, new UnaryExpression());
            unary.astOperand((Expression)EcjTreeConverter.this.toTree((ASTNode)node.lhs, new FlagKey[0]));
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, unary));
        }

        @Override
        public void visitPostfixExpression(PostfixExpression node) {
            UnaryExpression unary = this.fillUnaryOperator((CompoundAssignment)node, new UnaryExpression());
            unary.astOperand((Expression)EcjTreeConverter.this.toTree((ASTNode)node.lhs, new FlagKey[0]));
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, unary));
        }

        @Override
        public void visitBinaryExpression(org.eclipse.jdt.internal.compiler.ast.BinaryExpression node) {
            BinaryExpression bin = new BinaryExpression();
            int operatorId = (node.bits & 0xFC0) >> 6;
            bin.astOperator(GENERIC_BINARY_OPERATORS.get(operatorId));
            bin.astLeft((Expression)EcjTreeConverter.this.toTree((ASTNode)node.left, new FlagKey[0]));
            bin.astRight((Expression)EcjTreeConverter.this.toTree((ASTNode)node.right, new FlagKey[0]));
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, bin));
        }

        @Override
        public void visitCombinedBinaryExpression(CombinedBinaryExpression node) {
            this.visitBinaryExpression((org.eclipse.jdt.internal.compiler.ast.BinaryExpression)node);
        }

        @Override
        public void visitCompoundAssignment(CompoundAssignment node) {
            BinaryExpression bin = new BinaryExpression();
            int operatorId = node.operator;
            bin.astOperator(ASSIGN_BINARY_OPERATORS.get(operatorId));
            bin.astLeft((Expression)EcjTreeConverter.this.toTree((ASTNode)node.lhs, new FlagKey[0]));
            bin.astRight((Expression)EcjTreeConverter.this.toTree((ASTNode)node.expression, new FlagKey[0]));
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, bin));
        }

        @Override
        public void visitEqualExpression(EqualExpression node) {
            this.visitBinaryExpression((org.eclipse.jdt.internal.compiler.ast.BinaryExpression)node);
        }

        @Override
        public void visitInstanceOfExpression(InstanceOfExpression node) {
            InstanceOf instanceOf = new InstanceOf();
            instanceOf.astObjectReference((Expression)EcjTreeConverter.this.toTree((ASTNode)node.expression, new FlagKey[0]));
            instanceOf.astTypeReference((TypeReference)EcjTreeConverter.this.toTree((ASTNode)node.type, new FlagKey[0]));
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, instanceOf));
        }

        @Override
        public void visitAND_AND_Expression(AND_AND_Expression node) {
            this.visitBinaryExpression((org.eclipse.jdt.internal.compiler.ast.BinaryExpression)node);
        }

        @Override
        public void visitOR_OR_Expression(OR_OR_Expression node) {
            this.visitBinaryExpression((org.eclipse.jdt.internal.compiler.ast.BinaryExpression)node);
        }

        @Override
        public void visitConditionalExpression(ConditionalExpression node) {
            InlineIfExpression inlineIf = new InlineIfExpression().astCondition((Expression)EcjTreeConverter.this.toTree((ASTNode)node.condition, new FlagKey[0])).astIfTrue((Expression)EcjTreeConverter.this.toTree((ASTNode)node.valueIfTrue, new FlagKey[0])).astIfFalse((Expression)EcjTreeConverter.this.toTree((ASTNode)node.valueIfFalse, new FlagKey[0]));
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, inlineIf));
        }

        @Override
        public void visitAllocationExpression(AllocationExpression node) {
            ConstructorInvocation constr = new ConstructorInvocation();
            constr.astTypeReference((TypeReference)EcjTreeConverter.this.toTree((ASTNode)node.type, new FlagKey[0]));
            EcjTreeConverter.this.fillList((ASTNode[])node.arguments, constr.rawArguments(), new FlagKey[0]);
            EcjTreeConverter.this.fillList((ASTNode[])node.typeArguments, constr.rawConstructorTypeArguments(), new FlagKey[0]);
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, constr));
        }

        @Override
        public void visitQualifiedAllocationExpression(QualifiedAllocationExpression node) {
            ConstructorInvocation constr = new ConstructorInvocation();
            constr.astTypeReference((TypeReference)EcjTreeConverter.this.toTree((ASTNode)node.type, new FlagKey[0]));
            if (node.anonymousType != null) {
                NormalTypeBody body = this.createNormalTypeBody(node.anonymousType);
                ConversionPositionInfo.setConversionPositionInfo(constr, "signature", EcjTreeConverter.this.toPosition(node.anonymousType.sourceStart, node.anonymousType.sourceEnd));
                constr.astAnonymousClassBody(body);
            }
            if (node.enclosingInstance != null) {
                constr.rawQualifier(EcjTreeConverter.this.toTree((ASTNode)node.enclosingInstance, new FlagKey[0]));
            }
            EcjTreeConverter.this.fillList((ASTNode[])node.arguments, constr.rawArguments(), new FlagKey[0]);
            EcjTreeConverter.this.fillList((ASTNode[])node.typeArguments, constr.rawConstructorTypeArguments(), new FlagKey[0]);
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, constr));
        }

        private Expression toSelect(char[][] tokens, long[] positions) {
            if (tokens.length < 2) {
                return null;
            }
            if (tokens.length != positions.length) {
                throw new IllegalStateException("bug");
            }
            Identifier current0 = EcjTreeConverter.this.toIdentifier(tokens[0], positions[0]);
            AbstractNode current = new VariableReference().astIdentifier(current0);
            current.setPosition(current0.getPosition());
            for (int i = 1; i < tokens.length; ++i) {
                Select select = new Select().astIdentifier(EcjTreeConverter.this.toIdentifier(tokens[i], positions[i]));
                select.astOperand((Expression)((Object)current));
                current = select;
            }
            return current;
        }

        @Override
        public void visitQualifiedNameReference(QualifiedNameReference node) {
            if (EcjTreeConverter.this.hasFlag(FlagKey.NAMEREFERENCE_IS_TYPE)) {
                TypeReference ref = new TypeReference();
                this.fillTypeReferenceParts(node.tokens, node.sourcePositions, ref.astParts());
                EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, ref));
                return;
            }
            Expression select = this.toSelect(node.tokens, node.sourcePositions);
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, select));
        }

        @Override
        public void visitMessageSend(MessageSend node) {
            MethodInvocation inv = new MethodInvocation();
            EcjTreeConverter.this.fillList((ASTNode[])node.arguments, inv.rawArguments(), new FlagKey[0]);
            EcjTreeConverter.this.fillList((ASTNode[])node.typeArguments, inv.rawMethodTypeArguments(), new FlagKey[0]);
            inv.astOperand((Expression)EcjTreeConverter.this.toTree((ASTNode)node.receiver, new FlagKey[0]));
            inv.astName(EcjTreeConverter.this.toIdentifier(node.selector, node.nameSourcePosition));
            EcjTreeConverter.this.setPosition((ASTNode)node, inv);
            EcjTreeConverter.this.set((ASTNode)node, inv);
        }

        @Override
        public void visitAssertStatement(AssertStatement node) {
            Assert asrt = new Assert();
            asrt.astAssertion((Expression)EcjTreeConverter.this.toTree((ASTNode)node.assertExpression, new FlagKey[0]));
            asrt.astMessage((Expression)EcjTreeConverter.this.toTree((ASTNode)node.exceptionArgument, new FlagKey[0]));
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, asrt));
        }

        @Override
        public void visitDoStatement(DoStatement node) {
            DoWhile doWhile = new DoWhile();
            doWhile.astCondition((Expression)EcjTreeConverter.this.toTree((ASTNode)node.condition, new FlagKey[0]));
            doWhile.astStatement((Statement)EcjTreeConverter.this.toTree((ASTNode)node.action, new FlagKey[]{FlagKey.AS_STATEMENT}));
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, doWhile));
        }

        @Override
        public void visitForeachStatement(ForeachStatement node) {
            ForEach forEach = new ForEach();
            forEach.astIterable((Expression)EcjTreeConverter.this.toTree((ASTNode)node.collection, new FlagKey[0]));
            forEach.astVariable((VariableDefinition)EcjTreeConverter.this.toTree((ASTNode)node.elementVariable, new FlagKey[]{FlagKey.AS_DEFINITION}));
            forEach.astStatement((Statement)EcjTreeConverter.this.toTree((ASTNode)node.action, new FlagKey[]{FlagKey.AS_STATEMENT}));
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, forEach));
        }

        @Override
        public void visitIfStatement(IfStatement node) {
            If ifStatement = new If().astCondition((Expression)EcjTreeConverter.this.toTree((ASTNode)node.condition, new FlagKey[0]));
            ifStatement.astStatement((Statement)EcjTreeConverter.this.toTree((ASTNode)node.thenStatement, new FlagKey[]{FlagKey.AS_STATEMENT}));
            ifStatement.astElseStatement((Statement)EcjTreeConverter.this.toTree((ASTNode)node.elseStatement, new FlagKey[]{FlagKey.AS_STATEMENT}));
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, ifStatement));
        }

        @Override
        public void visitForStatement(ForStatement node) {
            For forStat = new For();
            forStat.astCondition((Expression)EcjTreeConverter.this.toTree((ASTNode)node.condition, new FlagKey[0]));
            forStat.astStatement((Statement)EcjTreeConverter.this.toTree((ASTNode)node.action, new FlagKey[]{FlagKey.AS_STATEMENT}));
            EcjTreeConverter.this.fillList((ASTNode[])node.increments, forStat.rawUpdates(), new FlagKey[0]);
            if (node.initializations != null && node.initializations.length > 0 && node.initializations[0] instanceof LocalDeclaration) {
                ArrayList<AbstractVariableDeclaration> decls = Lists.newArrayList();
                for (org.eclipse.jdt.internal.compiler.ast.Statement initialization : node.initializations) {
                    if (!(initialization instanceof AbstractVariableDeclaration)) continue;
                    decls.add((AbstractVariableDeclaration)initialization);
                }
                forStat.astVariableDeclaration((VariableDefinition)EcjTreeConverter.this.toVariableDefinition((List<AbstractVariableDeclaration>)decls, new FlagKey[]{FlagKey.AS_DEFINITION}));
            } else {
                EcjTreeConverter.this.fillList((ASTNode[])node.initializations, forStat.rawExpressionInits(), new FlagKey[0]);
            }
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, forStat));
        }

        @Override
        public void visitLabeledStatement(LabeledStatement node) {
            LabelledStatement label = new LabelledStatement();
            label.astLabel(EcjTreeConverter.this.toIdentifier(node.label, node.sourceStart, node.labelEnd));
            label.astStatement((Statement)EcjTreeConverter.this.toTree((ASTNode)node.statement, new FlagKey[]{FlagKey.AS_STATEMENT}));
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, label));
        }

        @Override
        public void visitContinueStatement(ContinueStatement node) {
            Continue cnt = new Continue();
            if (node.label != null) {
                cnt.astLabel(EcjTreeConverter.this.toIdentifier(node.label, node.sourceStart, node.sourceEnd));
            }
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, cnt));
        }

        @Override
        public void visitBreakStatement(BreakStatement node) {
            Break brk = new Break();
            if (node.label != null) {
                brk.astLabel(EcjTreeConverter.this.toIdentifier(node.label, node.sourceStart, node.sourceEnd));
            }
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, brk));
        }

        @Override
        public void visitSwitchStatement(SwitchStatement node) {
            Switch switchStat = new Switch();
            switchStat.astCondition((Expression)EcjTreeConverter.this.toTree((ASTNode)node.expression, new FlagKey[0]));
            switchStat.astBody(EcjTreeConverter.this.toBlock(node.statements));
            switchStat.astBody().setPosition(EcjTreeConverter.this.toPosition(node.blockStart, node.sourceEnd));
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, switchStat));
        }

        @Override
        public void visitCaseStatement(CaseStatement node) {
            if (node.constantExpression == null) {
                Default defaultStat = new Default();
                EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, defaultStat));
                return;
            }
            Case caseStat = new Case();
            caseStat.astCondition((Expression)EcjTreeConverter.this.toTree((ASTNode)node.constantExpression, new FlagKey[0]));
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, caseStat));
        }

        @Override
        public void visitSynchronizedStatement(SynchronizedStatement node) {
            Synchronized synch = new Synchronized();
            synch.astLock((Expression)EcjTreeConverter.this.toTree((ASTNode)node.expression, new FlagKey[0]));
            synch.astBody((Block)EcjTreeConverter.this.toTree((ASTNode)node.block, new FlagKey[0]));
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, synch));
        }

        @Override
        public void visitTryStatement(TryStatement node) {
            Try tryStat = new Try();
            tryStat.astBody((Block)EcjTreeConverter.this.toTree((ASTNode)node.tryBlock, new FlagKey[0]));
            tryStat.astFinally((Block)EcjTreeConverter.this.toTree((ASTNode)node.finallyBlock, new FlagKey[0]));
            this.toCatches(node.catchArguments, node.catchBlocks, tryStat.astCatches());
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, tryStat));
        }

        private void toCatches(Argument[] catchArguments, org.eclipse.jdt.internal.compiler.ast.Block[] catchBlocks, StrictListAccessor<Catch, Try> astCatches) {
            if (catchArguments == null || catchBlocks == null || catchBlocks.length != catchArguments.length) {
                return;
            }
            for (int i = 0; i < catchBlocks.length; ++i) {
                Catch cat = new Catch();
                VariableDefinition catchArg = (VariableDefinition)EcjTreeConverter.this.toTree((ASTNode)catchArguments[i], new FlagKey[0]);
                catchArg.setPosition(EcjTreeConverter.this.toPosition(catchArguments[i].declarationSourceStart, catchArguments[i].sourceEnd));
                cat.astExceptionDeclaration(catchArg);
                cat.astBody((Block)EcjTreeConverter.this.toTree((ASTNode)catchBlocks[i], new FlagKey[0]));
                astCatches.addToEnd(new Catch[]{cat});
            }
        }

        @Override
        public void visitArgument(Argument node) {
            VariableDefinition varDef = (VariableDefinition)EcjTreeConverter.this.toVariableDefinition((List<AbstractVariableDeclaration>)Arrays.asList(node), new FlagKey[]{FlagKey.NO_VARDECL_FOLDING, FlagKey.AS_DEFINITION});
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, varDef));
        }

        @Override
        public void visitThrowStatement(ThrowStatement node) {
            Throw throwStat = new Throw();
            throwStat.astThrowable((Expression)EcjTreeConverter.this.toTree((ASTNode)node.exception, new FlagKey[0]));
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, throwStat));
        }

        @Override
        public void visitWhileStatement(WhileStatement node) {
            While whileStat = new While();
            whileStat.astCondition((Expression)EcjTreeConverter.this.toTree((ASTNode)node.condition, new FlagKey[0]));
            whileStat.astStatement((Statement)EcjTreeConverter.this.toTree((ASTNode)node.action, new FlagKey[]{FlagKey.AS_STATEMENT}));
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, whileStat));
        }

        @Override
        public void visitConstructorDeclaration(org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration node) {
            if ((node.bits & 0x80) != 0) {
                EcjTreeConverter.this.set((ASTNode)node, null);
                return;
            }
            ConstructorDeclaration constr = new ConstructorDeclaration();
            constr.astTypeName(EcjTreeConverter.this.toIdentifier(node.selector, node.sourceStart, node.sourceEnd));
            Block block = EcjTreeConverter.this.toBlock(node.statements);
            block.setPosition(EcjTreeConverter.this.toPosition(node.bodyStart - 1, node.bodyEnd + 1));
            block.astContents().addToStart(new Statement[]{(Statement)EcjTreeConverter.this.toTree((ASTNode)node.constructorCall, new FlagKey[]{FlagKey.AS_STATEMENT})});
            constr.astBody(block);
            constr.astJavadoc((Comment)EcjTreeConverter.this.toTree((ASTNode)node.javadoc, new FlagKey[0]));
            constr.astModifiers(EcjTreeConverter.this.toModifiers(node.modifiers, node.annotations, node.modifiersSourceStart, node.declarationSourceStart));
            EcjTreeConverter.this.fillList((ASTNode[])node.arguments, constr.rawParameters(), new FlagKey[]{FlagKey.AS_DEFINITION, FlagKey.NO_VARDECL_FOLDING});
            EcjTreeConverter.this.fillList((ASTNode[])node.typeParameters, constr.rawTypeVariables(), new FlagKey[0]);
            EcjTreeConverter.this.fillList((ASTNode[])node.thrownExceptions, constr.rawThrownTypeReferences(), new FlagKey[0]);
            ConversionPositionInfo.setConversionPositionInfo(constr, "signature", EcjTreeConverter.this.toPosition(node.sourceStart, node.sourceEnd));
            constr.setPosition(EcjTreeConverter.this.toPosition(node.declarationSourceStart, node.declarationSourceEnd));
            EcjTreeConverter.this.set((ASTNode)node, constr);
        }

        @Override
        public void visitExplicitConstructorCall(ExplicitConstructorCall node) {
            if (node.isImplicitSuper()) {
                EcjTreeConverter.this.set((ASTNode)node, null);
                return;
            }
            if (node.isSuperAccess()) {
                SuperConstructorInvocation sup = new SuperConstructorInvocation();
                EcjTreeConverter.this.fillList((ASTNode[])node.arguments, sup.rawArguments(), new FlagKey[0]);
                EcjTreeConverter.this.fillList((ASTNode[])node.typeArguments, sup.rawConstructorTypeArguments(), new FlagKey[0]);
                sup.astQualifier((Expression)EcjTreeConverter.this.toTree((ASTNode)node.qualification, new FlagKey[0]));
                ConversionPositionInfo.setConversionPositionInfo(sup, "typeArguments", EcjTreeConverter.this.toPosition(node.typeArgumentsSourceStart, node.sourceEnd));
                EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, sup));
                return;
            }
            AlternateConstructorInvocation inv = new AlternateConstructorInvocation();
            EcjTreeConverter.this.fillList((ASTNode[])node.arguments, inv.rawArguments(), new FlagKey[0]);
            EcjTreeConverter.this.fillList((ASTNode[])node.typeArguments, inv.rawConstructorTypeArguments(), new FlagKey[0]);
            ConversionPositionInfo.setConversionPositionInfo(inv, "typeArguments", EcjTreeConverter.this.toPosition(node.typeArgumentsSourceStart, node.sourceEnd));
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, inv));
        }

        @Override
        public void visitMethodDeclaration(org.eclipse.jdt.internal.compiler.ast.MethodDeclaration node) {
            boolean semiColonBody;
            MethodDeclaration decl = new MethodDeclaration();
            decl.astMethodName(EcjTreeConverter.this.toIdentifier(node.selector, node.sourceStart, node.sourceEnd));
            decl.astJavadoc((Comment)EcjTreeConverter.this.toTree((ASTNode)node.javadoc, new FlagKey[0]));
            Modifiers modifiers = EcjTreeConverter.this.toModifiers(node.modifiers, node.annotations, node.modifiersSourceStart, node.declarationSourceStart);
            decl.astModifiers(modifiers);
            decl.astReturnTypeReference((TypeReference)EcjTreeConverter.this.toTree((ASTNode)node.returnType, new FlagKey[0]));
            boolean bl = semiColonBody = (node.modifiers & 0x1000000) != 0;
            if (!(modifiers.isAbstract() || node.isNative() || semiColonBody)) {
                Block block = EcjTreeConverter.this.toBlock(node.statements);
                block.setPosition(EcjTreeConverter.this.toPosition(node.bodyStart - 1, node.bodyEnd + 1));
                decl.astBody(block);
            }
            EcjTreeConverter.this.fillList((ASTNode[])node.arguments, decl.rawParameters(), new FlagKey[]{FlagKey.AS_DEFINITION, FlagKey.NO_VARDECL_FOLDING});
            EcjTreeConverter.this.fillList((ASTNode[])node.typeParameters, decl.rawTypeVariables(), new FlagKey[0]);
            EcjTreeConverter.this.fillList((ASTNode[])node.thrownExceptions, decl.rawThrownTypeReferences(), new FlagKey[0]);
            ConversionPositionInfo.setConversionPositionInfo(decl, "signature", EcjTreeConverter.this.toPosition(node.sourceStart, node.sourceEnd));
            decl.setPosition(EcjTreeConverter.this.toPosition(node.declarationSourceStart, node.declarationSourceEnd));
            EcjTreeConverter.this.set((ASTNode)node, decl);
        }

        @Override
        public void visitAnnotationMethodDeclaration(org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration node) {
            AnnotationMethodDeclaration decl = new AnnotationMethodDeclaration();
            decl.astMethodName(EcjTreeConverter.this.toIdentifier(node.selector, node.sourceStart, node.sourceEnd));
            decl.astJavadoc((Comment)EcjTreeConverter.this.toTree((ASTNode)node.javadoc, new FlagKey[0]));
            decl.astModifiers(EcjTreeConverter.this.toModifiers(node.modifiers, node.annotations, node.modifiersSourceStart, node.declarationSourceStart));
            decl.astReturnTypeReference((TypeReference)EcjTreeConverter.this.toTree((ASTNode)node.returnType, new FlagKey[0]));
            decl.astDefaultValue((Expression)EcjTreeConverter.this.toTree((ASTNode)node.defaultValue, new FlagKey[0]));
            ConversionPositionInfo.setConversionPositionInfo(decl, "signature", EcjTreeConverter.this.toPosition(node.sourceStart, node.sourceEnd));
            ConversionPositionInfo.setConversionPositionInfo(decl, "extendedDimensions", new Position(node.extendedDimensions, -1));
            decl.setPosition(EcjTreeConverter.this.toPosition(node.declarationSourceStart, node.declarationSourceEnd));
            EcjTreeConverter.this.set((ASTNode)node, decl);
        }

        @Override
        public void visitReturnStatement(ReturnStatement node) {
            Return returnStat = new Return();
            returnStat.astValue((Expression)EcjTreeConverter.this.toTree((ASTNode)node.expression, new FlagKey[0]));
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, returnStat));
        }

        @Override
        public void visitClinit(Clinit node) {
            EcjTreeConverter.this.set((ASTNode)node, null);
        }

        @Override
        public void visitMarkerAnnotation(MarkerAnnotation node) {
            Annotation annot = this.createAnnotation((org.eclipse.jdt.internal.compiler.ast.Annotation)node);
            annot.setPosition(EcjTreeConverter.this.toPosition(node.sourceStart, node.declarationSourceEnd));
            EcjTreeConverter.this.set((ASTNode)node, annot);
        }

        @Override
        public void visitSingleMemberAnnotation(SingleMemberAnnotation node) {
            Annotation annot = this.createAnnotation((org.eclipse.jdt.internal.compiler.ast.Annotation)node);
            AnnotationElement element = new AnnotationElement();
            element.astValue((AnnotationValue)EcjTreeConverter.this.toTree((ASTNode)node.memberValue, new FlagKey[0]));
            annot.astElements().addToEnd(new AnnotationElement[]{element});
            annot.setPosition(EcjTreeConverter.this.toPosition(node.sourceStart, node.declarationSourceEnd));
            EcjTreeConverter.this.set((ASTNode)node, annot);
        }

        @Override
        public void visitNormalAnnotation(NormalAnnotation node) {
            Annotation annot = this.createAnnotation((org.eclipse.jdt.internal.compiler.ast.Annotation)node);
            EcjTreeConverter.this.fillList((ASTNode[])node.memberValuePairs, annot.rawElements(), new FlagKey[0]);
            annot.setPosition(EcjTreeConverter.this.toPosition(node.sourceStart, node.declarationSourceEnd));
            EcjTreeConverter.this.setConversionStructInfo(annot, "isNormalAnnotation");
            EcjTreeConverter.this.set((ASTNode)node, annot);
        }

        private Annotation createAnnotation(org.eclipse.jdt.internal.compiler.ast.Annotation node) {
            Annotation annotation = new Annotation();
            annotation.astAnnotationTypeReference((TypeReference)EcjTreeConverter.this.toTree((ASTNode)node.type, new FlagKey[0]));
            return annotation;
        }

        @Override
        public void visitMemberValuePair(MemberValuePair node) {
            AnnotationElement element = new AnnotationElement();
            element.astName(EcjTreeConverter.this.toIdentifier(node.name, node.sourceStart, node.sourceEnd));
            element.astValue((AnnotationValue)EcjTreeConverter.this.toTree((ASTNode)node.value, new FlagKey[0]));
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, element));
        }

        @Override
        public void visitJavadoc(Javadoc node) {
            if (node == null) {
                EcjTreeConverter.this.set((ASTNode)node, null);
                return;
            }
            Comment comment = new Comment();
            comment.astBlockComment(true);
            if (EcjTreeConverter.this.rawInput != null) {
                comment.astContent(EcjTreeConverter.this.rawInput.substring(node.sourceStart + 2, node.sourceEnd - 1));
            } else {
                String reconstructed = node.toString();
                comment.astContent(reconstructed.substring(2, reconstructed.length() - 2));
            }
            EcjTreeConverter.this.set((ASTNode)node, EcjTreeConverter.this.setPosition((ASTNode)node, comment));
        }

        private UnaryExpression fillUnaryOperator(CompoundAssignment ecjNode, UnaryExpression node) {
            if (ecjNode instanceof PrefixExpression) {
                return node.astOperator(UNARY_PREFIX_OPERATORS.get(ecjNode.operator));
            }
            if (ecjNode instanceof PostfixExpression) {
                return node.astOperator(UNARY_POSTFIX_OPERATORS.get(ecjNode.operator));
            }
            return node;
        }
    };
    static final Field CASTEXPRESSION_TYPE_FIELD;
    static final Map<Integer, UnaryOperator> UNARY_PREFIX_OPERATORS;
    static final Map<Integer, UnaryOperator> UNARY_POSTFIX_OPERATORS;
    static final Map<Integer, UnaryOperator> GENERIC_UNARY_OPERATORS;
    static final Map<Integer, BinaryOperator> GENERIC_BINARY_OPERATORS;
    static final Map<Integer, BinaryOperator> ASSIGN_BINARY_OPERATORS;

    private boolean hasFlag(FlagKey key) {
        return this.params.containsKey((Object)key);
    }

    private Object getFlag(FlagKey key) {
        return this.params.get((Object)key);
    }

    public List<? extends Node> getAll() {
        return this.result;
    }

    public Node get() {
        if (this.result.isEmpty()) {
            return null;
        }
        if (this.result.size() == 1) {
            return this.result.get(0);
        }
        throw new RuntimeException("Expected only one result but got " + this.result.size());
    }

    private void set(ASTNode node, Node value) {
        if (this.result != null) {
            throw new IllegalStateException("result is already set");
        }
        if (value instanceof Expression && this.hasFlag(FlagKey.AS_STATEMENT)) {
            ExpressionStatement stat = new ExpressionStatement();
            stat.astExpression((Expression)value);
            int start = node.sourceStart;
            int end = node.sourceEnd;
            try {
                end = (Integer)node.getClass().getField("statementEnd").get(node);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.set(node, stat.setPosition(this.toPosition(start, end)));
            return;
        }
        if (value instanceof Expression) {
            int parenCount = (node.bits & 0x1FE00000) >> 21;
            for (int i = 0; i < parenCount; ++i) {
                ((Expression)value).astParensPositions().add(value.getPosition());
            }
        }
        ArrayList<? extends Node> result = Lists.newArrayList();
        if (value != null) {
            result.add(value);
        }
        this.result = result;
    }

    private void set(ASTNode node, List<? extends Node> values) {
        if (values.isEmpty()) {
            System.err.printf("Node '%s' (%s) did not produce any results\n", node, node.getClass().getSimpleName());
        }
        if (this.result != null) {
            throw new IllegalStateException("result is already set");
        }
        this.result = values;
    }

    private Node toTree(ASTNode node, FlagKey ... keys) {
        EnumMap<FlagKey, Object> map = Maps.newEnumMap(FlagKey.class);
        for (FlagKey key : keys) {
            map.put(key, (Object)key);
        }
        return this.toTree(node, map);
    }

    private Node toTree(ASTNode node, Map<FlagKey, Object> params) {
        if (node == null) {
            return null;
        }
        EcjTreeConverter newConverter = new EcjTreeConverter();
        if (params != null) {
            newConverter.params = params;
        }
        newConverter.visit(this.rawInput, node);
        try {
            return newConverter.get();
        }
        catch (RuntimeException e) {
            System.err.printf("Node '%s' (%s) did not produce any results\n", node, node.getClass().getSimpleName());
            throw e;
        }
    }

    private void setConversionStructInfo(Node lombokNode, String key) {
        ConversionPositionInfo.setConversionPositionInfo(lombokNode, key, Position.UNPLACED);
    }

    private void fillList(ASTNode[] nodes, RawListAccessor<?, ?> list, FlagKey ... keys) {
        EnumMap<FlagKey, Object> map = Maps.newEnumMap(FlagKey.class);
        for (FlagKey key : keys) {
            map.put(key, (Object)key);
        }
        this.fillList(nodes, list, map);
    }

    private void fillList(ASTNode[] nodes, RawListAccessor<?, ?> list, Map<FlagKey, Object> params) {
        if (nodes == null) {
            return;
        }
        ArrayList<AbstractVariableDeclaration> varDeclQueue = new ArrayList<AbstractVariableDeclaration>();
        boolean fold = !params.containsKey((Object)FlagKey.NO_VARDECL_FOLDING);
        for (ASTNode node : nodes) {
            if ((node instanceof FieldDeclaration || node instanceof LocalDeclaration) && ((AbstractVariableDeclaration)node).type != null) {
                if (fold && (varDeclQueue.isEmpty() || ((AbstractVariableDeclaration)varDeclQueue.get((int)0)).type.sourceStart == ((AbstractVariableDeclaration)node).type.sourceStart)) {
                    varDeclQueue.add((AbstractVariableDeclaration)node);
                    continue;
                }
                if (!varDeclQueue.isEmpty()) {
                    list.addToEnd(this.toVariableDefinition(varDeclQueue, params));
                }
                varDeclQueue.clear();
                varDeclQueue.add((AbstractVariableDeclaration)node);
                continue;
            }
            if (!varDeclQueue.isEmpty()) {
                list.addToEnd(this.toVariableDefinition(varDeclQueue, params));
            }
            varDeclQueue.clear();
            list.addToEnd(this.toTree(node, params));
        }
        if (!varDeclQueue.isEmpty()) {
            list.addToEnd(this.toVariableDefinition(varDeclQueue, params));
        }
    }

    private void fillUtilityList(List<ASTNode> list, ASTNode ... nodes) {
        if (nodes == null || nodes.length == 0) {
            return;
        }
        for (ASTNode statement : nodes) {
            if (statement == null) continue;
            list.add(statement);
        }
    }

    public void visit(String rawInput, ASTNode node) {
        this.rawInput = rawInput;
        this.visitor.visitEcjNode(node);
    }

    private Node toVariableDefinition(List<AbstractVariableDeclaration> decls, FlagKey ... keys) {
        EnumMap<FlagKey, Object> map = Maps.newEnumMap(FlagKey.class);
        for (FlagKey key : keys) {
            map.put(key, (Object)key);
        }
        return this.toVariableDefinition(decls, map);
    }

    private Node toVariableDefinition(List<AbstractVariableDeclaration> decls, Map<FlagKey, Object> params) {
        VariableDefinition def = this.createVariableDefinition(decls, params);
        AbstractVariableDeclaration first = decls.get(0);
        def.setPosition(this.toPosition(first.declarationSourceStart, first.sourceEnd));
        if (params.containsKey((Object)FlagKey.AS_DEFINITION)) {
            return def;
        }
        VariableDeclaration decl = new VariableDeclaration();
        if (first instanceof FieldDeclaration) {
            decl.astJavadoc((Comment)this.toTree((ASTNode)((FieldDeclaration)first).javadoc, new FlagKey[0]));
        }
        decl.astDefinition(def);
        decl.setPosition(this.toPosition(first.declarationSourceStart, first.declarationEnd));
        return decl;
    }

    private VariableDefinition createVariableDefinition(List<AbstractVariableDeclaration> decls, Map<FlagKey, Object> params) {
        int dims = Integer.MAX_VALUE;
        org.eclipse.jdt.internal.compiler.ast.TypeReference winner = null;
        for (AbstractVariableDeclaration decl : decls) {
            org.eclipse.jdt.internal.compiler.ast.TypeReference tr = decl.type;
            int newDims = tr.dimensions();
            if (newDims < dims) {
                dims = newDims;
                winner = tr;
            }
            if (dims != 0) continue;
            break;
        }
        AbstractVariableDeclaration first = decls.get(0);
        VariableDefinition varDef = new VariableDefinition();
        varDef.astModifiers(this.toModifiers(first.modifiers, first.annotations, first.modifiersSourceStart, first.declarationSourceStart));
        varDef.astTypeReference((TypeReference)this.toTree((ASTNode)winner, new FlagKey[0]));
        if ((first.type.bits & 0x4000) != 0) {
            varDef.astVarargs(true);
            ConversionPositionInfo.setConversionPositionInfo(varDef, "typeref", this.toPosition(first.type.sourceStart, first.type.sourceEnd));
        }
        for (AbstractVariableDeclaration decl : decls) {
            VariableDefinitionEntry varDefEntry = new VariableDefinitionEntry();
            if (first instanceof FieldDeclaration) {
                ConversionPositionInfo.setConversionPositionInfo(varDefEntry, "varDeclPart1", this.toPosition(decl.sourceStart, ((FieldDeclaration)decl).endPart1Position));
                ConversionPositionInfo.setConversionPositionInfo(varDefEntry, "varDeclPart2", this.toPosition(decl.sourceStart, ((FieldDeclaration)decl).endPart2Position));
            }
            ConversionPositionInfo.setConversionPositionInfo(varDefEntry, "declarationSource", this.toPosition(decl.declarationSourceStart, decl.declarationSourceEnd));
            ConversionPositionInfo.setConversionPositionInfo(varDefEntry, "typeSourcePos", this.toPosition(decl.type.sourceStart, decl.type.sourceEnd));
            varDefEntry.astInitializer((Expression)this.toTree((ASTNode)decl.initialization, new FlagKey[0]));
            varDefEntry.astName(this.toIdentifier(decl.name, decl.sourceStart, decl.sourceEnd));
            int delta = decl.type.dimensions() - winner.dimensions();
            varDefEntry.astArrayDimensions(delta);
            varDef.astVariables().addToEnd(new VariableDefinitionEntry[]{varDefEntry});
        }
        return varDef;
    }

    private Identifier toIdentifier(char[] token, long pos) {
        return this.toIdentifier(token, this.toPosition(pos));
    }

    private Identifier toIdentifier(char[] token, int start, int end) {
        return this.toIdentifier(token, this.toPosition(start, end));
    }

    private Identifier toIdentifier(char[] token, Position pos) {
        Identifier id = Identifier.of(token == null ? "" : new String(token));
        id.setPosition(pos);
        return id;
    }

    private Position toPosition(int start, int end) {
        return new Position(start, end + 1);
    }

    private Position toPosition(long pos) {
        return new Position((int)(pos >> 32), (int)(pos & 0xFFFFFFFFL) + 1);
    }

    private long toLong(int start, int end) {
        return (long)start << 32 | 0xFFFFFFFFL & (long)end;
    }

    private Modifiers toModifiers(int modifiers, org.eclipse.jdt.internal.compiler.ast.Annotation[] annotations, int start, int end) {
        Modifiers m = new Modifiers();
        for (KeywordModifier mod : KeywordModifier.fromReflectModifiers(modifiers)) {
            m.astKeywords().addToEnd(new KeywordModifier[]{mod});
        }
        this.fillList((ASTNode[])annotations, m.rawAnnotations(), new FlagKey[0]);
        m.setPosition(new Position(start, end));
        return m;
    }

    private Block toBlock(org.eclipse.jdt.internal.compiler.ast.Statement[] statements) {
        Block block = new Block();
        this.fillList((ASTNode[])statements, block.rawContents(), FlagKey.AS_STATEMENT);
        return block;
    }

    private void fillDimensions(org.eclipse.jdt.internal.compiler.ast.Expression[] nodes, RawListAccessor<ArrayDimension, ArrayCreation> list) {
        if (nodes == null) {
            return;
        }
        for (org.eclipse.jdt.internal.compiler.ast.Expression node : nodes) {
            list.addToEnd(new ArrayDimension().astDimension((Expression)this.toTree((ASTNode)node, new FlagKey[0])));
        }
    }

    private void fillIdentifiers(char[][] tokens, long[] positions, StrictListAccessor<Identifier, ?> list) {
        if (tokens == null) {
            return;
        }
        if (positions.length != tokens.length) {
            throw new IllegalStateException("bug");
        }
        for (int i = 0; i < positions.length; ++i) {
            list.addToEnd(new Identifier[]{this.toIdentifier(tokens[i], positions[i])});
        }
    }

    private <N extends Node> N setPosition(ASTNode node, N lombokNode) {
        lombokNode.setPosition(this.toPosition(node.sourceStart, node.sourceEnd));
        return lombokNode;
    }

    static {
        try {
            CASTEXPRESSION_TYPE_FIELD = CastExpression.class.getDeclaredField("type");
            CASTEXPRESSION_TYPE_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("This version of eclipse does not have CastExpression.type. Lombok is not compatible with this version.", e);
        }
        UNARY_PREFIX_OPERATORS = Maps.newHashMap();
        UNARY_PREFIX_OPERATORS.put(14, UnaryOperator.PREFIX_INCREMENT);
        UNARY_PREFIX_OPERATORS.put(13, UnaryOperator.PREFIX_DECREMENT);
        UNARY_POSTFIX_OPERATORS = Maps.newHashMap();
        UNARY_POSTFIX_OPERATORS.put(14, UnaryOperator.POSTFIX_INCREMENT);
        UNARY_POSTFIX_OPERATORS.put(13, UnaryOperator.POSTFIX_DECREMENT);
        GENERIC_UNARY_OPERATORS = Maps.newHashMap();
        GENERIC_UNARY_OPERATORS.put(12, UnaryOperator.BINARY_NOT);
        GENERIC_UNARY_OPERATORS.put(11, UnaryOperator.LOGICAL_NOT);
        GENERIC_UNARY_OPERATORS.put(14, UnaryOperator.UNARY_PLUS);
        GENERIC_UNARY_OPERATORS.put(13, UnaryOperator.UNARY_MINUS);
        GENERIC_BINARY_OPERATORS = Maps.newHashMap();
        GENERIC_BINARY_OPERATORS.put(1, BinaryOperator.LOGICAL_OR);
        GENERIC_BINARY_OPERATORS.put(0, BinaryOperator.LOGICAL_AND);
        GENERIC_BINARY_OPERATORS.put(3, BinaryOperator.BITWISE_OR);
        GENERIC_BINARY_OPERATORS.put(8, BinaryOperator.BITWISE_XOR);
        GENERIC_BINARY_OPERATORS.put(2, BinaryOperator.BITWISE_AND);
        GENERIC_BINARY_OPERATORS.put(18, BinaryOperator.EQUALS);
        GENERIC_BINARY_OPERATORS.put(29, BinaryOperator.NOT_EQUALS);
        GENERIC_BINARY_OPERATORS.put(6, BinaryOperator.GREATER);
        GENERIC_BINARY_OPERATORS.put(7, BinaryOperator.GREATER_OR_EQUAL);
        GENERIC_BINARY_OPERATORS.put(4, BinaryOperator.LESS);
        GENERIC_BINARY_OPERATORS.put(5, BinaryOperator.LESS_OR_EQUAL);
        GENERIC_BINARY_OPERATORS.put(10, BinaryOperator.SHIFT_LEFT);
        GENERIC_BINARY_OPERATORS.put(17, BinaryOperator.SHIFT_RIGHT);
        GENERIC_BINARY_OPERATORS.put(19, BinaryOperator.BITWISE_SHIFT_RIGHT);
        GENERIC_BINARY_OPERATORS.put(14, BinaryOperator.PLUS);
        GENERIC_BINARY_OPERATORS.put(13, BinaryOperator.MINUS);
        GENERIC_BINARY_OPERATORS.put(15, BinaryOperator.MULTIPLY);
        GENERIC_BINARY_OPERATORS.put(9, BinaryOperator.DIVIDE);
        GENERIC_BINARY_OPERATORS.put(16, BinaryOperator.REMAINDER);
        ASSIGN_BINARY_OPERATORS = Maps.newHashMap();
        ASSIGN_BINARY_OPERATORS.put(14, BinaryOperator.PLUS_ASSIGN);
        ASSIGN_BINARY_OPERATORS.put(13, BinaryOperator.MINUS_ASSIGN);
        ASSIGN_BINARY_OPERATORS.put(15, BinaryOperator.MULTIPLY_ASSIGN);
        ASSIGN_BINARY_OPERATORS.put(9, BinaryOperator.DIVIDE_ASSIGN);
        ASSIGN_BINARY_OPERATORS.put(16, BinaryOperator.REMAINDER_ASSIGN);
        ASSIGN_BINARY_OPERATORS.put(2, BinaryOperator.AND_ASSIGN);
        ASSIGN_BINARY_OPERATORS.put(8, BinaryOperator.XOR_ASSIGN);
        ASSIGN_BINARY_OPERATORS.put(3, BinaryOperator.OR_ASSIGN);
        ASSIGN_BINARY_OPERATORS.put(10, BinaryOperator.SHIFT_LEFT_ASSIGN);
        ASSIGN_BINARY_OPERATORS.put(17, BinaryOperator.SHIFT_RIGHT_ASSIGN);
        ASSIGN_BINARY_OPERATORS.put(19, BinaryOperator.BITWISE_SHIFT_RIGHT_ASSIGN);
    }

    private static enum FlagKey {
        IMPORTDECLARATION_IS_PACKAGE,
        NAMEREFERENCE_IS_TYPE,
        AS_STATEMENT,
        AS_DEFINITION,
        AS_ENUM,
        NO_VARDECL_FOLDING;

    }
}

