/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.grammar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import lombok.ast.Comment;
import lombok.ast.Expression;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.JavadocContainer;
import lombok.ast.Node;
import lombok.ast.Position;
import lombok.ast.grammar.ParseProblem;
import lombok.ast.grammar.ParserGroup;
import lombok.ast.grammar.ProfilerParseRunner;
import lombok.ast.grammar.SourceStructure;
import lombok.ast.grammar.TemporaryNode;
import lombok.ast.libs.com.google.common.collect.ImmutableList;
import lombok.ast.libs.com.google.common.collect.LinkedListMultimap;
import lombok.ast.libs.com.google.common.collect.ListMultimap;
import lombok.ast.libs.com.google.common.collect.Lists;
import lombok.ast.libs.com.google.common.collect.MapMaker;
import lombok.ast.libs.com.google.common.collect.Maps;
import lombok.ast.libs.org.parboiled.Context;
import lombok.ast.libs.org.parboiled.RecoveringParseRunner;
import lombok.ast.libs.org.parboiled.errors.ParseError;
import lombok.ast.libs.org.parboiled.support.ParsingResult;

public class Source {
    private final String name;
    private final String rawInput;
    private List<Node> nodes;
    private List<ParseProblem> problems;
    private List<Comment> comments;
    private boolean parsed;
    private ParsingResult<Node> parsingResult;
    private TreeMap<Integer, Integer> positionDeltas;
    private Map<lombok.ast.libs.org.parboiled.Node<Node>, Node> registeredStructures;
    private Map<lombok.ast.libs.org.parboiled.Node<Node>, List<Comment>> registeredComments;
    private String preprocessed;
    private Map<Node, Collection<SourceStructure>> cachedSourceStructures;
    private List<Integer> lineEndings;

    public Source(String rawInput, String name) {
        this.rawInput = rawInput;
        this.name = name;
        this.clear();
    }

    public List<Node> getNodes() {
        this.parseCompilationUnit();
        if (!this.parsed) {
            throw new IllegalStateException("Code hasn't been parsed yet.");
        }
        return this.nodes;
    }

    public List<ParseProblem> getProblems() {
        this.parseCompilationUnit();
        return this.problems;
    }

    public void clear() {
        this.nodes = Lists.newArrayList();
        this.problems = Lists.newArrayList();
        this.comments = Lists.newArrayList();
        this.lineEndings = ImmutableList.of();
        this.parsed = false;
        this.parsingResult = null;
        this.positionDeltas = Maps.newTreeMap();
        this.registeredComments = new MapMaker().weakKeys().makeMap();
        this.registeredStructures = new MapMaker().weakKeys().makeMap();
        this.cachedSourceStructures = null;
    }

    public String getOverviewProfileInformation() {
        this.clear();
        this.preProcess();
        ParserGroup group = new ParserGroup(this);
        ProfilerParseRunner runner = new ProfilerParseRunner(group.structures.compilationUnitEoi(), this.preprocessed);
        this.parsingResult = runner.run();
        StringBuilder out = new StringBuilder();
        out.append(runner.getOverviewReport());
        this.postProcess();
        return out.toString();
    }

    public List<String> getDetailedProfileInformation(int top) {
        this.clear();
        this.preProcess();
        ParserGroup group = new ParserGroup(this);
        ProfilerParseRunner runner = new ProfilerParseRunner(group.structures.compilationUnitEoi(), this.preprocessed);
        this.parsingResult = runner.run();
        ArrayList<String> result = Lists.newArrayList();
        result.add(runner.getOverviewReport());
        result.addAll(runner.getExtendedReport(top));
        this.postProcess();
        return result;
    }

    private List<Integer> calculateLineEndings() {
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean atCR = false;
        for (int i = 0; i < this.rawInput.length(); ++i) {
            char c = this.rawInput.charAt(i);
            if (c == '\n' && !atCR) {
                builder.add((Object)i);
            }
            boolean bl = atCR = c == '\r';
            if (!atCR) continue;
            builder.add((Object)i);
        }
        return builder.build();
    }

    public void parseCompilationUnit() {
        if (this.parsed) {
            return;
        }
        this.preProcess();
        ParserGroup group = new ParserGroup(this);
        this.parsingResult = RecoveringParseRunner.run(group.structures.compilationUnitEoi(), this.preprocessed);
        this.postProcess();
    }

    public void parseMember() {
        if (this.parsed) {
            return;
        }
        this.preProcess();
        ParserGroup group = new ParserGroup(this);
        this.parsingResult = RecoveringParseRunner.run(group.structures.typeBodyMember(), this.preprocessed);
        this.postProcess();
    }

    public void parseStatement() {
        if (this.parsed) {
            return;
        }
        this.preProcess();
        ParserGroup group = new ParserGroup(this);
        this.parsingResult = RecoveringParseRunner.run(group.statements.anyStatement(), this.preprocessed);
        this.postProcess();
    }

    public void parseExpression() {
        if (this.parsed) {
            return;
        }
        this.preProcess();
        ParserGroup group = new ParserGroup(this);
        this.parsingResult = RecoveringParseRunner.run(group.expressions.anyExpression(), this.preprocessed);
        this.postProcess();
    }

    public void parseVariableDefinition() {
        if (this.parsed) {
            return;
        }
        this.preProcess();
        ParserGroup group = new ParserGroup(this);
        this.parsingResult = RecoveringParseRunner.run(group.structures.variableDefinition(), this.preprocessed);
        this.postProcess();
    }

    private void postProcess() {
        for (ParseError error : this.parsingResult.parseErrors) {
            int errStart = error.getStartIndex();
            int errEnd = error.getEndIndex();
            this.problems.add(new ParseProblem(new Position(this.mapPosition(errStart), this.mapPosition(errEnd)), error.toString()));
        }
        if (this.parsingResult.parseTreeRoot != null) {
            this.nodes.add((Node)this.parsingResult.parseTreeRoot.getValue());
            this.gatherComments(this.parsingResult.parseTreeRoot);
        }
        this.comments = Collections.unmodifiableList(this.comments);
        this.nodes = Collections.unmodifiableList(this.nodes);
        this.problems = Collections.unmodifiableList(this.problems);
        this.rtrimPositions(this.nodes, this.comments);
        this.associateJavadoc(this.comments, this.nodes);
        this.fixPositions(this.nodes);
        this.fixPositions(this.comments);
        this.parsed = true;
    }

    void registerStructure(Node node, lombok.ast.libs.org.parboiled.Node<Node> pNode) {
        this.registeredStructures.put(pNode, node);
    }

    public Map<Node, Collection<SourceStructure>> getSourceStructures() {
        if (this.cachedSourceStructures != null) {
            return this.cachedSourceStructures;
        }
        this.parseCompilationUnit();
        LinkedListMultimap<Node, SourceStructure> map = LinkedListMultimap.create();
        lombok.ast.libs.org.parboiled.Node<Node> pNode = this.parsingResult.parseTreeRoot;
        this.buildSourceStructures(pNode, null, map);
        Map<Node, Collection<SourceStructure>> result = map.asMap();
        for (Collection structures : result.values()) {
            for (SourceStructure structure : structures) {
                structure.setPosition(new Position(this.mapPosition(structure.getPosition().getStart()), this.mapPosition(structure.getPosition().getEnd())));
            }
        }
        this.cachedSourceStructures = result;
        return this.cachedSourceStructures;
    }

    private void addSourceStructure(ListMultimap<Node, SourceStructure> map, Node node, SourceStructure structure) {
        if (structure.getPosition().size() > 0 && structure.getContent().trim().length() > 0 && !structure.getPosition().equals(node.getPosition())) {
            map.put(node, structure);
        }
    }

    private void buildSourceStructures(lombok.ast.libs.org.parboiled.Node<Node> pNode, Node owner, ListMultimap<Node, SourceStructure> map) {
        block6: {
            block4: {
                SourceStructure structure;
                block7: {
                    block5: {
                        Node target = this.registeredStructures.remove(pNode);
                        if (target == null && !pNode.getChildren().isEmpty()) break block4;
                        int start = pNode.getStartIndex();
                        int end = pNode.getEndIndex();
                        String text = this.preprocessed.substring(start, end);
                        structure = new SourceStructure(new Position(start, end), text);
                        if (target == null) break block5;
                        this.addSourceStructure(map, target, structure);
                        break block6;
                    }
                    if (pNode.getValue() == null || pNode.getValue() instanceof TemporaryNode) break block7;
                    this.addSourceStructure(map, pNode.getValue(), structure);
                    break block6;
                }
                if (owner == null) break block6;
                this.addSourceStructure(map, owner, structure);
                break block6;
            }
            Node possibleOwner = pNode.getValue();
            if (possibleOwner instanceof TemporaryNode) {
                possibleOwner = null;
            }
            for (lombok.ast.libs.org.parboiled.Node child : pNode.getChildren()) {
                if (child.getValue() == null || child.getValue() instanceof TemporaryNode || child.getValue() != possibleOwner) continue;
                possibleOwner = null;
            }
            if (possibleOwner != null) {
                owner = possibleOwner;
            }
            for (lombok.ast.libs.org.parboiled.Node child : pNode.getChildren()) {
                this.buildSourceStructures(child, owner, map);
            }
        }
    }

    private void rtrimPositions(List<Node> nodes, List<Comment> comments) {
        final boolean[] whitespace = new boolean[this.preprocessed.length()];
        for (Comment comment : comments) {
            Position p = comment.getPosition();
            if (p.isUnplaced()) continue;
            for (int i = p.getStart(); i < p.getEnd(); ++i) {
                whitespace[i] = true;
            }
        }
        char[] chars = this.preprocessed.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (!Character.isWhitespace(chars[i])) continue;
            whitespace[i] = true;
        }
        for (Node node : nodes) {
            node.accept(new ForwardingAstVisitor(){

                @Override
                public boolean visitNode(Node node) {
                    int end;
                    int start;
                    int trimmed;
                    Position p = node.getPosition();
                    if (p.isUnplaced()) {
                        return false;
                    }
                    for (trimmed = Math.min(whitespace.length, p.getEnd()); trimmed > 0 && whitespace[trimmed - 1]; --trimmed) {
                    }
                    if (p.getEnd() - p.getStart() == 0) {
                        end = node.getParent() != null ? (start = Math.min(node.getParent().getPosition().getEnd(), Math.max(node.getParent().getPosition().getStart(), p.getStart()))) : (start = p.getStart());
                    } else {
                        start = p.getStart();
                        end = Math.max(trimmed, start);
                    }
                    node.setPosition(new Position(start, end));
                    return false;
                }
            });
        }
    }

    private void fixPositions(List<? extends Node> nodes) {
        for (Node node : nodes) {
            node.accept(new ForwardingAstVisitor(){

                @Override
                public boolean visitNode(Node node) {
                    List<Position> list;
                    Position p = node.getPosition();
                    if (!p.isUnplaced()) {
                        node.setPosition(new Position(Source.this.mapPosition(p.getStart()), Source.this.mapPosition(p.getEnd())));
                    }
                    if (node instanceof Expression && (list = ((Expression)node).astParensPositions()) != null) {
                        ListIterator<Position> li = list.listIterator();
                        while (li.hasNext()) {
                            Position parenPos = li.next();
                            if (parenPos.isUnplaced()) continue;
                            parenPos = new Position(Source.this.mapPosition(parenPos.getStart()), Source.this.mapPosition(parenPos.getEnd()));
                            li.set(parenPos);
                        }
                    }
                    return false;
                }
            });
        }
    }

    private void associateJavadoc(List<Comment> comments, List<Node> nodes) {
        final TreeMap startPosMap = Maps.newTreeMap();
        for (Node node : nodes) {
            node.accept(new ForwardingAstVisitor(){

                @Override
                public boolean visitNode(Node node) {
                    if (node.isGenerated()) {
                        return false;
                    }
                    int startPos = node.getPosition().getStart();
                    Node current = (Node)startPosMap.get(startPos);
                    if (current == null || !(current instanceof JavadocContainer)) {
                        startPosMap.put(startPos, node);
                    }
                    return false;
                }
            });
        }
        for (Comment comment : comments) {
            JavadocContainer jc;
            Node assoc;
            SortedMap tailMap;
            if (!comment.isJavadoc() || (tailMap = startPosMap.tailMap(comment.getPosition().getEnd())).isEmpty() || !((assoc = (Node)tailMap.values().iterator().next()) instanceof JavadocContainer) || (jc = (JavadocContainer)assoc).rawJavadoc() != null && jc.rawJavadoc().getPosition().getEnd() >= comment.getPosition().getEnd()) continue;
            jc.rawJavadoc(comment);
        }
    }

    void registerComment(Context<Node> context, Comment c) {
        List<Comment> list = this.registeredComments.get(context);
        if (list == null) {
            list = Lists.newArrayList();
            this.registeredComments.put(context.getSubNodes().get(0), list);
        }
        list.add(c);
    }

    private boolean gatherComments(lombok.ast.libs.org.parboiled.Node<Node> parsed) {
        Iterator<Comment> i$;
        boolean foundComments = false;
        for (lombok.ast.libs.org.parboiled.Node child : parsed.getChildren()) {
            foundComments |= this.gatherComments(child);
        }
        List<Comment> cmts = this.registeredComments.get(parsed);
        if (cmts != null && (i$ = cmts.iterator()).hasNext()) {
            Comment c = i$.next();
            this.comments.add(c);
            return true;
        }
        return foundComments;
    }

    private void setPositionDelta(int position, int delta) {
        Integer i = this.positionDeltas.get(position);
        if (i == null) {
            i = 0;
        }
        this.positionDeltas.put(position, i + delta);
    }

    public List<Integer> getLineEndingsTable() {
        return this.lineEndings;
    }

    public long lineColumn(int index) {
        int pos;
        int line;
        int oldIdx = 0;
        for (line = 0; line < this.lineEndings.size() && (pos = this.lineEndings.get(line).intValue()) <= index; ++line) {
            oldIdx = pos;
        }
        return (long)line << 32 | (long)(index - oldIdx);
    }

    int mapPosition(int position) {
        int out = position;
        Iterator i$ = this.positionDeltas.headMap(position, true).values().iterator();
        while (i$.hasNext()) {
            int delta = (Integer)i$.next();
            out += delta;
        }
        return out;
    }

    private String preProcess() {
        this.preprocessed = this.rawInput;
        this.lineEndings = this.calculateLineEndings();
        this.applyBackslashU();
        return this.preprocessed;
    }

    private void applyBackslashU() {
        StringBuilder buffer = new StringBuilder();
        StringBuilder out = new StringBuilder();
        int state = 0;
        int idx = 0;
        block4: for (char c : this.preprocessed.toCharArray()) {
            ++idx;
            switch (state) {
                case 0: {
                    if (c != '\\') {
                        out.append(c);
                        continue block4;
                    }
                    state = 1;
                    continue block4;
                }
                case 1: {
                    if (c != 'u') {
                        out.append('\\');
                        out.append(c);
                        state = 0;
                        continue block4;
                    }
                    buffer.setLength(0);
                    buffer.append("\\u");
                    state = 2;
                    continue block4;
                }
                default: {
                    buffer.append(c);
                    if (c == 'u') continue block4;
                    if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
                        if (++state != 6) continue block4;
                        out.append((char)Integer.parseInt(buffer.substring(buffer.length() - 4), 16));
                        int delta = buffer.length() - 1;
                        this.setPositionDelta(idx - delta, delta);
                        buffer.setLength(0);
                        state = 0;
                        continue block4;
                    }
                    this.problems.add(new ParseProblem(new Position(idx - buffer.length(), idx), "Invalid backslash-u escape: \\u is supposed to be followed by 4 hex digits."));
                    out.append(buffer.toString());
                    state = 0;
                }
            }
        }
        this.preprocessed = out.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getRawInput() {
        return this.rawInput;
    }
}

