/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.javac;

import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import lombok.ast.AlternateConstructorInvocation;
import lombok.ast.Annotation;
import lombok.ast.AnnotationDeclaration;
import lombok.ast.AnnotationElement;
import lombok.ast.AnnotationMethodDeclaration;
import lombok.ast.AnnotationValueArray;
import lombok.ast.ArrayAccess;
import lombok.ast.ArrayCreation;
import lombok.ast.ArrayDimension;
import lombok.ast.ArrayInitializer;
import lombok.ast.Assert;
import lombok.ast.AstVisitor;
import lombok.ast.BinaryExpression;
import lombok.ast.BinaryOperator;
import lombok.ast.Block;
import lombok.ast.BooleanLiteral;
import lombok.ast.Break;
import lombok.ast.Case;
import lombok.ast.Cast;
import lombok.ast.Catch;
import lombok.ast.CharLiteral;
import lombok.ast.ClassDeclaration;
import lombok.ast.ClassLiteral;
import lombok.ast.Comment;
import lombok.ast.CompilationUnit;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.ConstructorInvocation;
import lombok.ast.Continue;
import lombok.ast.ConversionPositionInfo;
import lombok.ast.Default;
import lombok.ast.DoWhile;
import lombok.ast.EmptyDeclaration;
import lombok.ast.EmptyStatement;
import lombok.ast.EnumConstant;
import lombok.ast.EnumDeclaration;
import lombok.ast.EnumTypeBody;
import lombok.ast.Expression;
import lombok.ast.ExpressionStatement;
import lombok.ast.FloatingPointLiteral;
import lombok.ast.For;
import lombok.ast.ForEach;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.Identifier;
import lombok.ast.If;
import lombok.ast.ImportDeclaration;
import lombok.ast.InlineIfExpression;
import lombok.ast.InstanceInitializer;
import lombok.ast.InstanceOf;
import lombok.ast.IntegralLiteral;
import lombok.ast.InterfaceDeclaration;
import lombok.ast.JavadocContainer;
import lombok.ast.KeywordModifier;
import lombok.ast.LabelledStatement;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Modifiers;
import lombok.ast.Node;
import lombok.ast.NormalTypeBody;
import lombok.ast.NullLiteral;
import lombok.ast.PackageDeclaration;
import lombok.ast.Position;
import lombok.ast.Return;
import lombok.ast.Select;
import lombok.ast.Statement;
import lombok.ast.StaticInitializer;
import lombok.ast.StrictListAccessor;
import lombok.ast.StringLiteral;
import lombok.ast.Super;
import lombok.ast.SuperConstructorInvocation;
import lombok.ast.Switch;
import lombok.ast.Synchronized;
import lombok.ast.This;
import lombok.ast.Throw;
import lombok.ast.Try;
import lombok.ast.TypeReference;
import lombok.ast.TypeReferencePart;
import lombok.ast.TypeVariable;
import lombok.ast.UnaryExpression;
import lombok.ast.UnaryOperator;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;
import lombok.ast.While;
import lombok.ast.WildcardKind;
import lombok.ast.grammar.Source;
import lombok.ast.grammar.SourceStructure;
import lombok.ast.libs.com.google.common.collect.BiMap;
import lombok.ast.libs.com.google.common.collect.ImmutableBiMap;
import lombok.ast.libs.com.google.common.collect.Lists;
import lombok.ast.libs.com.google.common.collect.Maps;

public class JcTreeBuilder {
    private final TreeMaker treeMaker;
    private final Name.Table table;
    private final Map<Node, Collection<SourceStructure>> sourceStructures;
    private final Map<JCTree, Integer> endPosTable;
    private List<? extends JCTree> result = null;
    private final AstVisitor visitor = new ForwardingAstVisitor(){
        private static final long ENUM_CONSTANT_FLAGS = 16409L;

        @Override
        public boolean visitNode(Node node) {
            throw new UnsupportedOperationException(String.format("Unhandled node '%s' (%s)", node, node.getClass().getSimpleName()));
        }

        @Override
        public boolean visitCompilationUnit(CompilationUnit node) {
            List preamble = JcTreeBuilder.this.toList(JCTree.class, node.astPackageDeclaration());
            List imports = JcTreeBuilder.this.toList(JCTree.class, node.astImportDeclarations());
            List types = JcTreeBuilder.this.toList(JCTree.class, node.astTypeDeclarations());
            List<JCTree.JCAnnotation> annotations = List.nil();
            JCTree.JCExpression pid = null;
            for (JCTree elem : preamble) {
                if (elem instanceof JCTree.JCAnnotation) {
                    annotations = annotations.append((JCTree.JCAnnotation)elem);
                    continue;
                }
                if (elem instanceof JCTree.JCExpression && pid == null) {
                    pid = (JCTree.JCExpression)elem;
                    continue;
                }
                throw new RuntimeException("Unexpected element in preamble: " + elem);
            }
            JCTree.JCCompilationUnit topLevel = JcTreeBuilder.this.treeMaker.TopLevel(annotations, pid, imports.appendList(types));
            topLevel.endPositions = JcTreeBuilder.this.endPosTable;
            if (JcTreeBuilder.hasConversionStructureInfo(node, "converted")) {
                return JcTreeBuilder.this.posSet(node, topLevel);
            }
            int start = Integer.MAX_VALUE;
            int end = node.getPosition().getEnd();
            if (node.astPackageDeclaration() != null) {
                start = Math.min(start, node.astPackageDeclaration().getPosition().getStart());
            }
            if (!node.astImportDeclarations().isEmpty()) {
                start = Math.min(start, node.rawImportDeclarations().first().getPosition().getStart());
            }
            if (!node.astTypeDeclarations().isEmpty()) {
                start = Math.min(start, node.rawTypeDeclarations().first().getPosition().getStart());
            }
            if (start == Integer.MAX_VALUE) {
                start = node.getPosition().getStart();
            }
            return JcTreeBuilder.this.set(node, JcTreeBuilder.this.setPos(start, end, topLevel));
        }

        @Override
        public boolean visitPackageDeclaration(PackageDeclaration node) {
            List<JCTree> defs = List.nil();
            for (Annotation annotation : node.astAnnotations()) {
                defs = defs.append(JcTreeBuilder.this.toTree(annotation));
            }
            defs = defs.append(JcTreeBuilder.this.chain(node.astParts()));
            JcTreeBuilder.this.set(defs);
            return true;
        }

        @Override
        public boolean visitImportDeclaration(ImportDeclaration node) {
            JCTree.JCExpression name = JcTreeBuilder.this.chain(node.astParts());
            if (node.astStarImport()) {
                Position jcDotStarPos = ConversionPositionInfo.getConversionPositionInfo(node, ".*");
                int start = jcDotStarPos == null ? JcTreeBuilder.this.posOfStructure(node, ".", true) : jcDotStarPos.getStart();
                int end = jcDotStarPos == null ? JcTreeBuilder.this.posOfStructure(node, "*", false) : jcDotStarPos.getEnd();
                name = (JCTree.JCExpression)JcTreeBuilder.this.setPos(start, end, JcTreeBuilder.this.treeMaker.Select(name, ((JcTreeBuilder)JcTreeBuilder.this).table.asterisk));
            }
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.Import(name, node.astStaticImport()));
        }

        @Override
        public boolean visitClassDeclaration(ClassDeclaration node) {
            int start = JcTreeBuilder.this.posOfStructure(node, "class", true);
            int end = node.getPosition().getEnd();
            return JcTreeBuilder.this.set(node, JcTreeBuilder.this.setPos(start, end, JcTreeBuilder.this.treeMaker.ClassDef((JCTree.JCModifiers)JcTreeBuilder.this.toTree(node.astModifiers()), JcTreeBuilder.this.toName(node.astName()), JcTreeBuilder.this.toList(JCTree.JCTypeParameter.class, node.astTypeVariables()), JcTreeBuilder.this.toTree(node.astExtending()), JcTreeBuilder.this.toList(JCTree.JCExpression.class, node.astImplementing()), node.astBody() == null ? List.nil() : JcTreeBuilder.this.toList(JCTree.class, node.astBody().astMembers()))));
        }

        @Override
        public boolean visitInterfaceDeclaration(InterfaceDeclaration node) {
            JCTree.JCModifiers modifiers = (JCTree.JCModifiers)JcTreeBuilder.this.toTree(node.astModifiers());
            modifiers.flags |= 0x200L;
            int start = JcTreeBuilder.this.posOfStructure(node, "interface", true);
            int end = node.getPosition().getEnd();
            return JcTreeBuilder.this.set(node, JcTreeBuilder.this.setPos(start, end, JcTreeBuilder.this.treeMaker.ClassDef(modifiers, JcTreeBuilder.this.toName(node.astName()), JcTreeBuilder.this.toList(JCTree.JCTypeParameter.class, node.astTypeVariables()), null, JcTreeBuilder.this.toList(JCTree.JCExpression.class, node.astExtending()), node.astBody() == null ? List.nil() : JcTreeBuilder.this.toList(JCTree.class, node.astBody().astMembers()))));
        }

        @Override
        public boolean visitEmptyStatement(EmptyStatement node) {
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.Skip());
        }

        @Override
        public boolean visitEnumDeclaration(EnumDeclaration node) {
            JCTree.JCModifiers modifiers = (JCTree.JCModifiers)JcTreeBuilder.this.toTree(node.astModifiers());
            modifiers.flags |= 0x4000L;
            int start = JcTreeBuilder.this.posOfStructure(node, "enum", true);
            int end = node.getPosition().getEnd();
            return JcTreeBuilder.this.set(node, JcTreeBuilder.this.setPos(start, end, JcTreeBuilder.this.treeMaker.ClassDef(modifiers, JcTreeBuilder.this.toName(node.astName()), List.nil(), null, JcTreeBuilder.this.toList(JCTree.JCExpression.class, node.astImplementing()), node.astBody() == null ? List.nil() : JcTreeBuilder.this.toList(JCTree.class, node.astBody()))));
        }

        @Override
        public boolean visitEnumTypeBody(EnumTypeBody node) {
            List constants = JcTreeBuilder.this.toList(JCTree.class, node.astConstants());
            List members = JcTreeBuilder.this.toList(JCTree.class, node.astMembers());
            JcTreeBuilder.this.set(List.nil().appendList(constants).appendList(members));
            return true;
        }

        @Override
        public boolean visitEnumConstant(EnumConstant node) {
            int start;
            JCTree.JCIdent parentType1 = JcTreeBuilder.this.treeMaker.Ident(JcTreeBuilder.this.toName(((EnumDeclaration)node.getParent().getParent()).astName()));
            JCTree.JCIdent parentType2 = JcTreeBuilder.this.treeMaker.Ident(JcTreeBuilder.this.toName(((EnumDeclaration)node.getParent().getParent()).astName()));
            JCTree.JCClassDecl body = (JCTree.JCClassDecl)JcTreeBuilder.this.toTree(node.astBody());
            if (body != null) {
                body.mods.flags |= 0x4008L;
            }
            JCTree.JCNewClass newClass = JcTreeBuilder.this.treeMaker.NewClass(null, List.<JCTree.JCExpression>nil(), parentType1, JcTreeBuilder.this.toList(JCTree.JCExpression.class, node.astArguments()), body);
            Position jcNewClassPos = ConversionPositionInfo.getConversionPositionInfo(node, "newClass");
            int n = start = jcNewClassPos == null ? JcTreeBuilder.this.posOfStructure(node, "(", true) : jcNewClassPos.getStart();
            int end = jcNewClassPos == null ? (body != null ? node.getPosition().getEnd() : JcTreeBuilder.this.posOfStructure(node, ")", false)) : jcNewClassPos.getEnd();
            boolean posIsSet = false;
            if (jcNewClassPos == null && start > node.astName().getPosition().getStart()) {
                JcTreeBuilder.this.setPos(start, end, newClass);
                posIsSet = true;
            }
            if (jcNewClassPos != null && start != node.getPosition().getStart()) {
                JcTreeBuilder.this.setPos(start, end, newClass);
                posIsSet = true;
            }
            if (body != null) {
                body.pos = node.getPosition().getStart();
            }
            if (!posIsSet && body != null) {
                JcTreeBuilder.this.setPos(node.astBody(), newClass);
            }
            JCTree.JCModifiers mods = JcTreeBuilder.this.treeMaker.Modifiers(16409L, JcTreeBuilder.this.toList(JCTree.JCAnnotation.class, node.astAnnotations()));
            if (!node.astAnnotations().isEmpty()) {
                int modStart = node.astAnnotations().first().getPosition().getStart();
                int modEnd = node.astAnnotations().last().getPosition().getEnd();
                JcTreeBuilder.this.setPos(modStart, modEnd, mods);
            }
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.VarDef(mods, JcTreeBuilder.this.toName(node.astName()), parentType2, newClass));
        }

        @Override
        public boolean visitNormalTypeBody(NormalTypeBody node) {
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.ClassDef(JcTreeBuilder.this.treeMaker.Modifiers(0L), ((JcTreeBuilder)JcTreeBuilder.this).table.empty, List.nil(), null, List.nil(), JcTreeBuilder.this.toList(JCTree.class, node.astMembers())));
        }

        @Override
        public boolean visitExpressionStatement(ExpressionStatement node) {
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.Exec(JcTreeBuilder.this.toExpression(node.astExpression())));
        }

        @Override
        public boolean visitIntegralLiteral(IntegralLiteral node) {
            if (node.astMarkedAsLong()) {
                return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.Literal(5, node.astLongValue()));
            }
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.Literal(4, node.astIntValue()));
        }

        @Override
        public boolean visitFloatingPointLiteral(FloatingPointLiteral node) {
            if (node.astMarkedAsFloat()) {
                return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.Literal(6, Float.valueOf(node.astFloatValue())));
            }
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.Literal(7, node.astDoubleValue()));
        }

        @Override
        public boolean visitBooleanLiteral(BooleanLiteral node) {
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.Literal(8, node.astValue() != false ? 1 : 0));
        }

        @Override
        public boolean visitCharLiteral(CharLiteral node) {
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.Literal(2, node.astValue().charValue()));
        }

        @Override
        public boolean visitNullLiteral(NullLiteral node) {
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.Literal(17, null));
        }

        @Override
        public boolean visitStringLiteral(StringLiteral node) {
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.Literal(10, node.astValue()));
        }

        @Override
        public boolean visitIdentifier(Identifier node) {
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.Ident(JcTreeBuilder.this.toName(node)));
        }

        @Override
        public boolean visitVariableReference(VariableReference node) {
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.Ident(JcTreeBuilder.this.toName(node.astIdentifier())));
        }

        @Override
        public boolean visitCast(Cast node) {
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.TypeCast(JcTreeBuilder.this.toTree(node.rawTypeReference()), JcTreeBuilder.this.toExpression(node.astOperand())));
        }

        @Override
        public boolean visitConstructorInvocation(ConstructorInvocation node) {
            JCTree.JCNewClass jcnc = (JCTree.JCNewClass)JcTreeBuilder.this.setPos(node, JcTreeBuilder.this.treeMaker.NewClass(JcTreeBuilder.this.toExpression(node.astQualifier()), JcTreeBuilder.this.toList(JCTree.JCExpression.class, node.astConstructorTypeArguments()), JcTreeBuilder.this.toExpression(node.astTypeReference()), JcTreeBuilder.this.toList(JCTree.JCExpression.class, node.astArguments()), (JCTree.JCClassDecl)JcTreeBuilder.this.toTree(node.astAnonymousClassBody())));
            if (node.astQualifier() != null) {
                int start = JcTreeBuilder.this.posOfStructure(node, "new", true);
                JcTreeBuilder.this.setPos(start, node.getPosition().getEnd(), jcnc);
            }
            return JcTreeBuilder.this.set(node, jcnc);
        }

        @Override
        public boolean visitSelect(Select node) {
            int start = JcTreeBuilder.this.posOfStructure(node.astIdentifier(), ".", true);
            int end = node.getPosition().getEnd();
            return JcTreeBuilder.this.set(node, JcTreeBuilder.this.setPos(start, end, JcTreeBuilder.this.treeMaker.Select(JcTreeBuilder.this.toExpression(node.astOperand()), JcTreeBuilder.this.toName(node.astIdentifier()))));
        }

        @Override
        public boolean visitUnaryExpression(UnaryExpression node) {
            Expression operand = node.astOperand();
            UnaryOperator operator = node.astOperator();
            if (operator == UnaryOperator.UNARY_MINUS && operand instanceof IntegralLiteral) {
                JCTree.JCLiteral result = (JCTree.JCLiteral)JcTreeBuilder.this.toTree(operand);
                result.value = JcTreeBuilder.negative(result.value);
                return JcTreeBuilder.this.set(node, JcTreeBuilder.this.setPos(operand, result));
            }
            int start = node.getPosition().getStart();
            int end = node.getPosition().getEnd();
            if (JcTreeBuilder.this.hasSourceStructures()) {
                switch (operator) {
                    case POSTFIX_DECREMENT: 
                    case POSTFIX_INCREMENT: {
                        start = JcTreeBuilder.this.posOfStructure(node, node.astOperator().getSymbol(), true);
                        end = JcTreeBuilder.this.posOfStructure(node, node.astOperator().getSymbol(), false);
                    }
                }
            }
            return JcTreeBuilder.this.set(node, JcTreeBuilder.this.setPos(start, end, JcTreeBuilder.this.treeMaker.Unary((Integer)UNARY_OPERATORS.get((Object)operator), JcTreeBuilder.this.toExpression(operand))));
        }

        @Override
        public boolean visitAlternateConstructorInvocation(AlternateConstructorInvocation node) {
            int end;
            int start;
            Position jcThisPos = ConversionPositionInfo.getConversionPositionInfo(node, "this");
            int thisStart = jcThisPos == null ? (!node.astConstructorTypeArguments().isEmpty() ? JcTreeBuilder.this.posOfStructure(node, "<", true) : JcTreeBuilder.this.posOfStructure(node, "this", true)) : jcThisPos.getStart();
            int thisEnd = jcThisPos == null ? JcTreeBuilder.this.posOfStructure(node, "this", false) : jcThisPos.getEnd();
            JCTree.JCMethodInvocation invoke = JcTreeBuilder.this.treeMaker.Apply(JcTreeBuilder.this.toList(JCTree.JCExpression.class, node.astConstructorTypeArguments()), (JCTree.JCExpression)JcTreeBuilder.this.setPos(thisStart, thisEnd, JcTreeBuilder.this.treeMaker.Ident(((JcTreeBuilder)JcTreeBuilder.this).table._this)), JcTreeBuilder.this.toList(JCTree.JCExpression.class, node.astArguments()));
            if (JcTreeBuilder.this.hasSourceStructures()) {
                start = JcTreeBuilder.this.posOfStructure(node, "(", true);
                end = JcTreeBuilder.this.posOfStructure(node, ")", false);
            } else {
                start = node.getPosition().getStart();
                end = node.getPosition().getEnd();
            }
            JCTree.JCExpressionStatement exec = JcTreeBuilder.this.treeMaker.Exec((JCTree.JCExpression)JcTreeBuilder.this.setPos(start, end, invoke));
            Position jcExecPos = ConversionPositionInfo.getConversionPositionInfo(node, "exec");
            if (jcExecPos != null) {
                JcTreeBuilder.this.setPos(jcExecPos.getStart(), jcExecPos.getEnd(), exec);
            } else {
                JcTreeBuilder.this.setPos(node, exec);
            }
            return JcTreeBuilder.this.set(node, exec);
        }

        @Override
        public boolean visitSuperConstructorInvocation(SuperConstructorInvocation node) {
            int end;
            int start;
            Position ecjSuperPos;
            JCTree.JCExpression methodId;
            if (node.astQualifier() == null) {
                methodId = JcTreeBuilder.this.treeMaker.Ident(((JcTreeBuilder)JcTreeBuilder.this).table._super);
                ecjSuperPos = ConversionPositionInfo.getConversionPositionInfo(node, "super");
                methodId.pos = ecjSuperPos == null ? JcTreeBuilder.this.posOfStructure(node, "super", true) : ecjSuperPos.getStart();
            } else {
                methodId = JcTreeBuilder.this.treeMaker.Select(JcTreeBuilder.this.toExpression(node.astQualifier()), ((JcTreeBuilder)JcTreeBuilder.this).table._super);
                ecjSuperPos = ConversionPositionInfo.getConversionPositionInfo(node, "super");
                if (ecjSuperPos == null) {
                    JcTreeBuilder.this.setPos(JcTreeBuilder.this.posOfStructure(node, ".", true), JcTreeBuilder.this.posOfStructure(node, "super", false), methodId);
                } else {
                    JcTreeBuilder.this.setPos(ecjSuperPos.getStart(), ecjSuperPos.getEnd(), methodId);
                }
            }
            JCTree.JCMethodInvocation invoke = JcTreeBuilder.this.treeMaker.Apply(JcTreeBuilder.this.toList(JCTree.JCExpression.class, node.astConstructorTypeArguments()), methodId, JcTreeBuilder.this.toList(JCTree.JCExpression.class, node.astArguments()));
            if (JcTreeBuilder.this.hasSourceStructures()) {
                start = JcTreeBuilder.this.posOfStructure(node, "(", Integer.MAX_VALUE, true);
                end = JcTreeBuilder.this.posOfStructure(node, ")", Integer.MAX_VALUE, false);
            } else {
                start = node.getPosition().getStart();
                end = node.getPosition().getEnd();
            }
            JCTree.JCExpressionStatement exec = JcTreeBuilder.this.treeMaker.Exec((JCTree.JCExpression)JcTreeBuilder.this.setPos(start, end, invoke));
            Position jcExecPos = ConversionPositionInfo.getConversionPositionInfo(node, "exec");
            if (jcExecPos == null) {
                JcTreeBuilder.this.setPos(node, exec);
            } else {
                JcTreeBuilder.this.setPos(jcExecPos.getStart(), jcExecPos.getEnd(), exec);
            }
            return JcTreeBuilder.this.set(node, exec);
        }

        @Override
        public boolean visitSuper(Super node) {
            int start;
            JCTree.JCExpression tree;
            int end = -1;
            if (node.astQualifier() != null) {
                tree = JcTreeBuilder.this.treeMaker.Select((JCTree.JCExpression)JcTreeBuilder.this.toTree(node.astQualifier()), ((JcTreeBuilder)JcTreeBuilder.this).table._super);
                start = JcTreeBuilder.this.posOfStructure(node, ".", true);
                end = JcTreeBuilder.this.posOfStructure(node, "super", false);
            } else {
                tree = JcTreeBuilder.this.treeMaker.Ident(((JcTreeBuilder)JcTreeBuilder.this).table._super);
                start = JcTreeBuilder.this.posOfStructure(node, "super", true);
            }
            Position jcSuperPos = ConversionPositionInfo.getConversionPositionInfo(node, "super");
            if (jcSuperPos != null) {
                start = jcSuperPos.getStart();
                end = jcSuperPos.getEnd();
            }
            return JcTreeBuilder.this.set(node, JcTreeBuilder.this.setPos(start, end, tree));
        }

        @Override
        public boolean visitBinaryExpression(BinaryExpression node) {
            BinaryOperator operator = node.astOperator();
            int start = JcTreeBuilder.this.posOfStructure(node, node.rawOperator(), true);
            int end = node.getPosition().getEnd();
            if (operator == BinaryOperator.PLUS && this.tryStringCombine(node)) {
                return true;
            }
            JCTree.JCExpression lhs = JcTreeBuilder.this.toExpression(node.astLeft());
            JCTree.JCExpression rhs = JcTreeBuilder.this.toExpression(node.astRight());
            if (operator == BinaryOperator.ASSIGN) {
                return JcTreeBuilder.this.set(node, JcTreeBuilder.this.setPos(start, end, JcTreeBuilder.this.treeMaker.Assign(lhs, rhs)));
            }
            if (operator.isAssignment()) {
                return JcTreeBuilder.this.set(node, JcTreeBuilder.this.setPos(start, end, JcTreeBuilder.this.treeMaker.Assignop((Integer)BINARY_OPERATORS.get((Object)operator), lhs, rhs)));
            }
            return JcTreeBuilder.this.set(node, JcTreeBuilder.this.setPos(start, end, JcTreeBuilder.this.treeMaker.Binary((Integer)BINARY_OPERATORS.get((Object)operator), lhs, rhs)));
        }

        /*
         * Exception decompiling
         */
        private boolean tryStringCombine(BinaryExpression node) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[DOLOOP]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean visitInstanceOf(InstanceOf node) {
            int start = JcTreeBuilder.this.posOfStructure(node, "instanceof", true);
            int end = node.getPosition().getEnd();
            return JcTreeBuilder.this.set(node, JcTreeBuilder.this.setPos(start, end, JcTreeBuilder.this.treeMaker.TypeTest(JcTreeBuilder.this.toExpression(node.astObjectReference()), JcTreeBuilder.this.toExpression(node.astTypeReference()))));
        }

        @Override
        public boolean visitInlineIfExpression(InlineIfExpression node) {
            int start = JcTreeBuilder.this.posOfStructure(node, "?", true);
            int end = node.getPosition().getEnd();
            return JcTreeBuilder.this.set(node, JcTreeBuilder.this.setPos(start, end, JcTreeBuilder.this.treeMaker.Conditional(JcTreeBuilder.this.toExpression(node.astCondition()), JcTreeBuilder.this.toExpression(node.astIfTrue()), JcTreeBuilder.this.toExpression(node.astIfFalse()))));
        }

        @Override
        public boolean visitMethodInvocation(MethodInvocation node) {
            int end;
            int start;
            JCTree.JCExpression methodId;
            if (node.astOperand() == null) {
                methodId = (JCTree.JCExpression)JcTreeBuilder.this.toTree(node.astName());
            } else {
                start = JcTreeBuilder.this.hasSourceStructures() ? JcTreeBuilder.this.posOfStructure(node, ".", true) : node.astName().getPosition().getStart();
                end = node.astName().getPosition().getEnd();
                methodId = (JCTree.JCExpression)JcTreeBuilder.this.setPos(start, end, JcTreeBuilder.this.treeMaker.Select(JcTreeBuilder.this.toExpression(node.astOperand()), JcTreeBuilder.this.toName(node.astName())));
            }
            start = JcTreeBuilder.this.posOfStructure(node, "(", true);
            end = node.getPosition().getEnd();
            return JcTreeBuilder.this.set(node, JcTreeBuilder.this.setPos(start, end, JcTreeBuilder.this.treeMaker.Apply(JcTreeBuilder.this.toList(JCTree.JCExpression.class, node.astMethodTypeArguments()), methodId, JcTreeBuilder.this.toList(JCTree.JCExpression.class, node.astArguments()))));
        }

        @Override
        public boolean visitAnnotationValueArray(AnnotationValueArray node) {
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.NewArray(null, List.<JCTree.JCExpression>nil(), JcTreeBuilder.this.toList(JCTree.JCExpression.class, node.astValues())));
        }

        @Override
        public boolean visitArrayInitializer(ArrayInitializer node) {
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.NewArray(null, List.<JCTree.JCExpression>nil(), JcTreeBuilder.this.toList(JCTree.JCExpression.class, node.astExpressions())));
        }

        @Override
        public boolean visitArrayCreation(ArrayCreation node) {
            List init;
            ArrayList<Integer> typeTrees = Lists.newArrayList();
            int endPosOfTypeTree = 0;
            List<JCTree.JCExpression> dims = List.nil();
            for (ArrayDimension dim : node.astDimensions()) {
                JCTree.JCExpression e = JcTreeBuilder.this.toExpression(dim);
                if (e == null) {
                    Position p = dim.getPosition();
                    typeTrees.add(p.getStart());
                    endPosOfTypeTree = Math.max(endPosOfTypeTree, p.getEnd());
                    continue;
                }
                dims = dims.append(e);
            }
            Collections.reverse(typeTrees);
            if (node.astInitializer() == null) {
                init = null;
            } else {
                init = JcTreeBuilder.this.toList(JCTree.JCExpression.class, node.astInitializer().astExpressions());
                typeTrees.remove(typeTrees.size() - 1);
            }
            JCTree.JCExpression elementType = JcTreeBuilder.this.toExpression(node.astComponentTypeReference());
            for (Integer start : typeTrees) {
                elementType = (JCTree.JCExpression)JcTreeBuilder.this.setPos(start, endPosOfTypeTree, JcTreeBuilder.this.treeMaker.TypeArray(elementType));
            }
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.NewArray(elementType, dims, init));
        }

        @Override
        public boolean visitArrayDimension(ArrayDimension node) {
            return JcTreeBuilder.this.set(node, JcTreeBuilder.this.toTree(node.astDimension()));
        }

        @Override
        public boolean visitAssert(Assert node) {
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.Assert(JcTreeBuilder.this.toExpression(node.astAssertion()), JcTreeBuilder.this.toExpression(node.astMessage())));
        }

        @Override
        public boolean visitBreak(Break node) {
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.Break(JcTreeBuilder.this.toName(node.astLabel())));
        }

        @Override
        public boolean visitContinue(Continue node) {
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.Continue(JcTreeBuilder.this.toName(node.astLabel())));
        }

        private JCTree.JCExpression reParen(Node node, JCTree.JCExpression expr) {
            Position jcParensPos = ConversionPositionInfo.getConversionPositionInfo(node, "()");
            int start = jcParensPos == null ? JcTreeBuilder.this.posOfStructure(node, "(", true) : jcParensPos.getStart();
            int end = jcParensPos == null ? JcTreeBuilder.this.posOfStructure(node, ")", false) : jcParensPos.getEnd();
            return (JCTree.JCExpression)JcTreeBuilder.this.setPos(start, end, JcTreeBuilder.this.treeMaker.Parens(expr));
        }

        @Override
        public boolean visitDoWhile(DoWhile node) {
            JCTree.JCExpression expr = this.reParen(node, JcTreeBuilder.this.toExpression(node.astCondition()));
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.DoLoop(JcTreeBuilder.this.toStatement(node.astStatement()), expr));
        }

        @Override
        public boolean visitFor(For node) {
            Position jcExecPos;
            JCTree.JCExpressionStatement exec;
            List<JCTree.JCExpressionStatement> inits;
            if (node.isVariableDeclarationBased()) {
                inits = JcTreeBuilder.this.toList(JCTree.JCStatement.class, node.astVariableDeclaration());
            } else {
                inits = List.nil();
                for (Expression init : node.astExpressionInits()) {
                    exec = JcTreeBuilder.this.treeMaker.Exec(JcTreeBuilder.this.toExpression(init));
                    jcExecPos = ConversionPositionInfo.getConversionPositionInfo(init, "exec");
                    if (jcExecPos == null) {
                        JcTreeBuilder.this.setPos(init, exec);
                    } else {
                        JcTreeBuilder.this.setPos(jcExecPos.getStart(), jcExecPos.getEnd(), exec);
                    }
                    inits = inits.append(exec);
                }
            }
            List<JCTree.JCExpressionStatement> updates = List.nil();
            for (Expression update : node.astUpdates()) {
                exec = JcTreeBuilder.this.treeMaker.Exec(JcTreeBuilder.this.toExpression(update));
                jcExecPos = ConversionPositionInfo.getConversionPositionInfo(update, "exec");
                if (jcExecPos == null) {
                    JcTreeBuilder.this.setPos(update, exec);
                } else {
                    JcTreeBuilder.this.setPos(jcExecPos.getStart(), jcExecPos.getEnd(), exec);
                }
                updates = updates.append(exec);
            }
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.ForLoop((List<JCTree.JCStatement>)inits, JcTreeBuilder.this.toExpression(node.astCondition()), updates, JcTreeBuilder.this.toStatement(node.astStatement())));
        }

        @Override
        public boolean visitForEach(ForEach node) {
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.ForeachLoop((JCTree.JCVariableDecl)JcTreeBuilder.this.toTree(node.astVariable()), JcTreeBuilder.this.toExpression(node.astIterable()), JcTreeBuilder.this.toStatement(node.astStatement())));
        }

        @Override
        public boolean visitIf(If node) {
            JCTree.JCExpression expr = this.reParen(node, JcTreeBuilder.this.toExpression(node.astCondition()));
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.If(expr, JcTreeBuilder.this.toStatement(node.astStatement()), JcTreeBuilder.this.toStatement(node.astElseStatement())));
        }

        @Override
        public boolean visitLabelledStatement(LabelledStatement node) {
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.Labelled(JcTreeBuilder.this.toName(node.astLabel()), JcTreeBuilder.this.toStatement(node.astStatement())));
        }

        @Override
        public boolean visitModifiers(Modifiers node) {
            JCTree.JCModifiers mods = JcTreeBuilder.this.treeMaker.Modifiers(node.getExplicitModifierFlags(), JcTreeBuilder.this.toList(JCTree.JCAnnotation.class, node.astAnnotations()));
            Comment javadoc = null;
            if (node.getParent() instanceof JavadocContainer) {
                javadoc = ((JavadocContainer)node.getParent()).astJavadoc();
            } else if (node.getParent() instanceof VariableDefinition && node.getParent().getParent() instanceof VariableDeclaration) {
                javadoc = ((VariableDeclaration)node.getParent().getParent()).astJavadoc();
            }
            if (javadoc != null && javadoc.isMarkedDeprecated()) {
                mods.flags |= 0x20000L;
            }
            if (node.isEmpty() && !JcTreeBuilder.hasConversionStructureInfo(node, "converted")) {
                if (node.getParent() instanceof MethodDeclaration && ((MethodDeclaration)node.getParent()).astTypeVariables().size() > 0 || node.getParent() instanceof ConstructorDeclaration && ((ConstructorDeclaration)node.getParent()).astTypeVariables().size() > 0) {
                    mods.pos = node.getParent().getPosition().getStart();
                }
                return JcTreeBuilder.this.set(node, mods);
            }
            return JcTreeBuilder.this.posSet(node, mods);
        }

        @Override
        public boolean visitKeywordModifier(KeywordModifier node) {
            return JcTreeBuilder.this.set(node, JcTreeBuilder.this.treeMaker.Modifiers(JcTreeBuilder.this.getModifier(node)));
        }

        @Override
        public boolean visitInstanceInitializer(InstanceInitializer node) {
            return JcTreeBuilder.this.set(node, JcTreeBuilder.this.toTree(node.astBody()));
        }

        @Override
        public boolean visitStaticInitializer(StaticInitializer node) {
            JCTree.JCBlock block = (JCTree.JCBlock)JcTreeBuilder.this.toTree(node.astBody());
            block.flags |= 8L;
            return JcTreeBuilder.this.posSet(node, block);
        }

        @Override
        public boolean visitBlock(Block node) {
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.Block(0L, JcTreeBuilder.this.toList(JCTree.JCStatement.class, node.astContents())));
        }

        @Override
        public boolean visitVariableDeclaration(VariableDeclaration node) {
            List list = JcTreeBuilder.this.toList(JCTree.JCVariableDecl.class, node.astDefinition());
            JCTree.JCVariableDecl last = (JCTree.JCVariableDecl)list.get(list.size() - 1);
            JcTreeBuilder.this.endPosTable.put(last, node.getPosition().getEnd());
            return JcTreeBuilder.this.set(list);
        }

        @Override
        public boolean visitVariableDefinition(VariableDefinition node) {
            JCTree.JCModifiers mods = (JCTree.JCModifiers)JcTreeBuilder.this.toTree(node.astModifiers());
            JCTree.JCExpression vartype = JcTreeBuilder.this.toExpression(node.astTypeReference());
            if (node.astVarargs()) {
                mods.flags |= 0x400000000L;
                vartype = this.addDimensions(node, vartype, 1);
                Position jcEllipsisPos = ConversionPositionInfo.getConversionPositionInfo(node, "...");
                if (jcEllipsisPos == null) {
                    JcTreeBuilder.this.setPos(JcTreeBuilder.this.posOfStructure(node, "...", true), JcTreeBuilder.this.posOfStructure(node, "...", false), vartype);
                } else {
                    JcTreeBuilder.this.setPos(jcEllipsisPos.getStart(), jcEllipsisPos.getEnd(), vartype);
                }
            }
            List<JCTree> defs = List.nil();
            for (VariableDefinitionEntry e : node.astVariables()) {
                defs = defs.append(JcTreeBuilder.this.setPos(e, JcTreeBuilder.this.treeMaker.VarDef(mods, JcTreeBuilder.this.toName(e.astName()), this.addDimensions(e, vartype, e.astArrayDimensions()), JcTreeBuilder.this.toExpression(e.astInitializer()))));
            }
            if (JcTreeBuilder.this.hasSourceStructures()) {
                for (int i = 0; i < defs.size() - 1; ++i) {
                    JcTreeBuilder.this.endPosTable.put(defs.get(i), JcTreeBuilder.this.posOfStructure(node, ",", i, false));
                }
            }
            if (defs.isEmpty()) {
                throw new RuntimeException("Empty VariableDefinition node");
            }
            JcTreeBuilder.this.set(defs);
            return true;
        }

        @Override
        public boolean visitAnnotationDeclaration(AnnotationDeclaration node) {
            JCTree.JCModifiers modifiers = (JCTree.JCModifiers)JcTreeBuilder.this.toTree(node.astModifiers());
            modifiers.flags |= 0x2200L;
            int start = JcTreeBuilder.this.posOfStructure(node, "interface", true);
            int end = node.getPosition().getEnd();
            if (JcTreeBuilder.this.hasSourceStructures()) {
                if (modifiers.pos == -1) {
                    modifiers.pos = JcTreeBuilder.this.posOfStructure(node, "@", true);
                }
                JcTreeBuilder.this.endPosTable.put(modifiers, JcTreeBuilder.this.posOfStructure(node, "@", false));
            }
            return JcTreeBuilder.this.set(node, JcTreeBuilder.this.setPos(start, end, JcTreeBuilder.this.treeMaker.ClassDef(modifiers, JcTreeBuilder.this.toName(node.astName()), List.nil(), null, List.nil(), node.astBody() == null ? List.nil() : JcTreeBuilder.this.toList(JCTree.class, node.astBody().astMembers()))));
        }

        @Override
        public boolean visitAnnotationMethodDeclaration(AnnotationMethodDeclaration node) {
            JCTree.JCMethodDecl methodDef = JcTreeBuilder.this.treeMaker.MethodDef((JCTree.JCModifiers)JcTreeBuilder.this.toTree(node.astModifiers()), JcTreeBuilder.this.toName(node.astMethodName()), JcTreeBuilder.this.toExpression(node.astReturnTypeReference()), List.<JCTree.JCTypeParameter>nil(), List.<JCTree.JCVariableDecl>nil(), List.<JCTree.JCExpression>nil(), null, JcTreeBuilder.this.toExpression(node.astDefaultValue()));
            int start = node.astMethodName().getPosition().getStart();
            int end = node.getPosition().getEnd();
            return JcTreeBuilder.this.set(node, JcTreeBuilder.this.setPos(start, end, methodDef));
        }

        @Override
        public boolean visitClassLiteral(ClassLiteral node) {
            int start = JcTreeBuilder.this.posOfStructure(node, ".", true);
            int end = node.getPosition().getEnd();
            return JcTreeBuilder.this.set(node, JcTreeBuilder.this.setPos(start, end, JcTreeBuilder.this.treeMaker.Select((JCTree.JCExpression)JcTreeBuilder.this.toTree(node.astTypeReference()), ((JcTreeBuilder)JcTreeBuilder.this).table._class)));
        }

        @Override
        public boolean visitAnnotationElement(AnnotationElement node) {
            JCTree.JCExpression arg = JcTreeBuilder.this.toExpression(node.astValue());
            if (node.astName() != null) {
                arg = (JCTree.JCExpression)JcTreeBuilder.this.setPos(node.astValue(), JcTreeBuilder.this.treeMaker.Assign((JCTree.JCIdent)JcTreeBuilder.this.toTree(node.astName()), arg));
            }
            return JcTreeBuilder.this.set(node, arg);
        }

        @Override
        public boolean visitAnnotation(Annotation node) {
            int start = node.getPosition().getStart();
            int end = node.getPosition().getEnd();
            return JcTreeBuilder.this.set(node, JcTreeBuilder.this.setPos(start, end, JcTreeBuilder.this.treeMaker.Annotation(JcTreeBuilder.this.toTree(node.astAnnotationTypeReference()), JcTreeBuilder.this.toList(JCTree.JCExpression.class, node.astElements()))));
        }

        @Override
        public boolean visitTypeReference(TypeReference node) {
            WildcardKind wildcard = node.astWildcard();
            if (wildcard == WildcardKind.UNBOUND) {
                return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.Wildcard(JcTreeBuilder.this.treeMaker.TypeBoundKind(BoundKind.UNBOUND), null));
            }
            JCTree.JCExpression result = this.plainTypeReference(node);
            result = this.addWildcards(node, result, wildcard);
            result = this.addDimensions(node, result, node.astArrayDimensions());
            return JcTreeBuilder.this.set(node, result);
        }

        @Override
        public boolean visitArrayAccess(ArrayAccess node) {
            int start = JcTreeBuilder.this.posOfStructure(node, "[", true);
            int end = node.getPosition().getEnd();
            return JcTreeBuilder.this.set(node, JcTreeBuilder.this.setPos(start, end, JcTreeBuilder.this.treeMaker.Indexed(JcTreeBuilder.this.toExpression(node.astOperand()), JcTreeBuilder.this.toExpression(node.astIndexExpression()))));
        }

        private JCTree.JCExpression addDimensions(Node node, JCTree.JCExpression type, int dimensions) {
            JCTree.JCExpression resultingType = type;
            for (int i = 0; i < dimensions; ++i) {
                int end;
                int start;
                int currentDim = dimensions - i - 1;
                Position jcBracketPos = ConversionPositionInfo.getConversionPositionInfo(node, "[]" + i);
                if (jcBracketPos == null) {
                    start = JcTreeBuilder.this.posOfStructure(node, "[", currentDim, true);
                    end = JcTreeBuilder.this.posOfStructure(node, "]", false);
                } else {
                    start = jcBracketPos.getStart();
                    end = jcBracketPos.getEnd();
                }
                resultingType = (JCTree.JCExpression)JcTreeBuilder.this.setPos(start, end, JcTreeBuilder.this.treeMaker.TypeArray(resultingType));
            }
            return resultingType;
        }

        private JCTree.JCExpression plainTypeReference(TypeReference node) {
            if (node.isPrimitive() || node.isVoid() || node.astParts().size() == 1) {
                Identifier identifier;
                int typeTag;
                int end = node.getPosition().getEnd();
                if (node.astArrayDimensions() > 0) {
                    end = node.astParts().last().getPosition().getEnd();
                }
                if (end == node.getPosition().getStart()) {
                    end = node.getPosition().getEnd();
                }
                if ((typeTag = JcTreeBuilder.primitiveTypeTag((identifier = node.astParts().first().astIdentifier()).astValue())) > 0) {
                    return (JCTree.JCExpression)JcTreeBuilder.this.setPos(node.getPosition().getStart(), end, JcTreeBuilder.this.treeMaker.TypeIdent(typeTag));
                }
            }
            JCTree.JCExpression current = null;
            for (TypeReferencePart part : node.astParts()) {
                JCTree.JCExpression expr = (JCTree.JCExpression)JcTreeBuilder.this.toTree(part);
                if (current == null) {
                    current = expr;
                    continue;
                }
                if (expr instanceof JCTree.JCIdent) {
                    current = JcTreeBuilder.this.treeMaker.Select(current, ((JCTree.JCIdent)expr).name);
                    JcTreeBuilder.this.setPos(JcTreeBuilder.this.posOfStructure(part, ".", true), part.getPosition().getEnd(), current);
                    continue;
                }
                if (expr instanceof JCTree.JCTypeApply) {
                    JCTree.JCTypeApply apply = (JCTree.JCTypeApply)expr;
                    apply.clazz = JcTreeBuilder.this.treeMaker.Select(current, ((JCTree.JCIdent)apply.clazz).name);
                    JcTreeBuilder.this.setPos(JcTreeBuilder.this.posOfStructure(part, ".", true), part.astIdentifier().getPosition().getEnd(), apply.clazz);
                    current = apply;
                    continue;
                }
                throw new IllegalStateException("Didn't expect a " + expr.getClass().getName() + " in " + node);
            }
            return current;
        }

        private JCTree.JCExpression addWildcards(Node node, JCTree.JCExpression type, WildcardKind wildcardKind) {
            switch (wildcardKind) {
                case NONE: {
                    return type;
                }
                case EXTENDS: {
                    JCTree.TypeBoundKind typeBoundKind = JcTreeBuilder.this.treeMaker.TypeBoundKind(BoundKind.EXTENDS);
                    Position jcExtendsPos = ConversionPositionInfo.getConversionPositionInfo(node, "extends");
                    if (jcExtendsPos == null) {
                        JcTreeBuilder.this.setPos(JcTreeBuilder.this.posOfStructure(node, "extends", true), JcTreeBuilder.this.posOfStructure(node, "extends", false), typeBoundKind);
                    } else {
                        JcTreeBuilder.this.setPos(jcExtendsPos.getStart(), jcExtendsPos.getEnd(), typeBoundKind);
                    }
                    return (JCTree.JCExpression)JcTreeBuilder.this.setPos(type.pos, (Integer)JcTreeBuilder.this.endPosTable.get(type), JcTreeBuilder.this.treeMaker.Wildcard(typeBoundKind, type));
                }
                case SUPER: {
                    JCTree.TypeBoundKind typeBoundKind = JcTreeBuilder.this.treeMaker.TypeBoundKind(BoundKind.SUPER);
                    Position jcSuperPos = ConversionPositionInfo.getConversionPositionInfo(node, "super");
                    if (jcSuperPos == null) {
                        JcTreeBuilder.this.setPos(JcTreeBuilder.this.posOfStructure(node, "super", true), JcTreeBuilder.this.posOfStructure(node, "super", false), typeBoundKind);
                    } else {
                        JcTreeBuilder.this.setPos(jcSuperPos.getStart(), jcSuperPos.getEnd(), typeBoundKind);
                    }
                    return (JCTree.JCExpression)JcTreeBuilder.this.setPos(type.pos, (Integer)JcTreeBuilder.this.endPosTable.get(type), JcTreeBuilder.this.treeMaker.Wildcard(typeBoundKind, type));
                }
            }
            throw new IllegalStateException("Unexpected unbound wildcard: " + (Object)((Object)wildcardKind));
        }

        @Override
        public boolean visitTypeReferencePart(TypeReferencePart node) {
            JCTree.JCIdent ident = (JCTree.JCIdent)JcTreeBuilder.this.toTree(node.astIdentifier());
            List typeArguments = JcTreeBuilder.this.toList(JCTree.JCExpression.class, node.astTypeArguments());
            if (typeArguments.isEmpty()) {
                return JcTreeBuilder.this.set(node, ident);
            }
            JCTree.JCTypeApply typeApply = JcTreeBuilder.this.treeMaker.TypeApply(ident, typeArguments);
            Position jcOpenBracketPos = ConversionPositionInfo.getConversionPositionInfo(node, "<");
            if (jcOpenBracketPos == null) {
                JcTreeBuilder.this.setPos(JcTreeBuilder.this.posOfStructure(node, "<", true), node.getPosition().getEnd(), typeApply);
            } else {
                JcTreeBuilder.this.setPos(jcOpenBracketPos.getStart(), node.getPosition().getEnd(), typeApply);
            }
            return JcTreeBuilder.this.set(node, typeApply);
        }

        @Override
        public boolean visitTypeVariable(TypeVariable node) {
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.TypeParameter(JcTreeBuilder.this.toName(node.astName()), JcTreeBuilder.this.toList(JCTree.JCExpression.class, node.astExtending())));
        }

        @Override
        public boolean visitMethodDeclaration(MethodDeclaration node) {
            JCTree.JCMethodDecl methodDef = JcTreeBuilder.this.treeMaker.MethodDef((JCTree.JCModifiers)JcTreeBuilder.this.toTree(node.astModifiers()), JcTreeBuilder.this.toName(node.astMethodName()), JcTreeBuilder.this.toExpression(node.astReturnTypeReference()), JcTreeBuilder.this.toList(JCTree.JCTypeParameter.class, node.astTypeVariables()), JcTreeBuilder.this.toList(JCTree.JCVariableDecl.class, node.astParameters()), JcTreeBuilder.this.toList(JCTree.JCExpression.class, node.astThrownTypeReferences()), (JCTree.JCBlock)JcTreeBuilder.this.toTree(node.astBody()), null);
            for (JCTree.JCVariableDecl decl : methodDef.params) {
                decl.mods.flags |= 0x200000000L;
            }
            int start = node.astMethodName().getPosition().getStart();
            int end = node.getPosition().getEnd();
            return JcTreeBuilder.this.set(node, JcTreeBuilder.this.setPos(start, end, methodDef));
        }

        @Override
        public boolean visitConstructorDeclaration(ConstructorDeclaration node) {
            JCTree.JCMethodDecl constrDef = JcTreeBuilder.this.treeMaker.MethodDef((JCTree.JCModifiers)JcTreeBuilder.this.toTree(node.astModifiers()), ((JcTreeBuilder)JcTreeBuilder.this).table.init, null, JcTreeBuilder.this.toList(JCTree.JCTypeParameter.class, node.astTypeVariables()), JcTreeBuilder.this.toList(JCTree.JCVariableDecl.class, node.astParameters()), JcTreeBuilder.this.toList(JCTree.JCExpression.class, node.astThrownTypeReferences()), (JCTree.JCBlock)JcTreeBuilder.this.toTree(node.astBody()), null);
            for (JCTree.JCVariableDecl decl : constrDef.params) {
                decl.mods.flags |= 0x200000000L;
            }
            int start = node.astTypeName().getPosition().getStart();
            int end = node.getPosition().getEnd();
            return JcTreeBuilder.this.set(node, JcTreeBuilder.this.setPos(start, end, constrDef));
        }

        @Override
        public boolean visitReturn(Return node) {
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.Return(JcTreeBuilder.this.toExpression(node.astValue())));
        }

        @Override
        public boolean visitSwitch(Switch node) {
            List<JCTree.JCCase> cases = List.nil();
            JCTree.JCExpression currentPat = null;
            Statement currentNode = null;
            List<JCTree.JCStatement> stats = null;
            boolean preamble = true;
            for (Statement s : node.astBody().astContents()) {
                if (s instanceof Case || s instanceof Default) {
                    JCTree.JCExpression newPat;
                    JCTree.JCExpression jCExpression = newPat = s instanceof Default ? null : JcTreeBuilder.this.toExpression(((Case)s).astCondition());
                    if (preamble) {
                        preamble = false;
                    } else {
                        cases = this.addCase(cases, currentPat, currentNode, stats);
                    }
                    stats = List.nil();
                    currentPat = newPat;
                    currentNode = s;
                    continue;
                }
                if (preamble) {
                    throw new RuntimeException("switch body does not start with default/case.");
                }
                stats = stats.append(JcTreeBuilder.this.toStatement(s));
            }
            if (!preamble) {
                cases = this.addCase(cases, currentPat, currentNode, stats);
            }
            JCTree.JCExpression expr = this.reParen(node, JcTreeBuilder.this.toExpression(node.astCondition()));
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.Switch(expr, cases));
        }

        private List<JCTree.JCCase> addCase(List<JCTree.JCCase> cases, JCTree.JCExpression currentPat, Node currentNode, List<JCTree.JCStatement> stats) {
            JCTree.JCStatement last = stats.last();
            int start = currentNode.getPosition().getStart();
            int end = last == null ? currentNode.getPosition().getEnd() : ((Integer)JcTreeBuilder.this.endPosTable.get(last)).intValue();
            cases = cases.append((JCTree.JCCase)JcTreeBuilder.this.setPos(start, end, JcTreeBuilder.this.treeMaker.Case(currentPat, stats)));
            return cases;
        }

        @Override
        public boolean visitSynchronized(Synchronized node) {
            JCTree.JCExpression expr = this.reParen(node, JcTreeBuilder.this.toExpression(node.astLock()));
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.Synchronized(expr, (JCTree.JCBlock)JcTreeBuilder.this.toTree(node.astBody())));
        }

        @Override
        public boolean visitThis(This node) {
            int start;
            JCTree.JCExpression tree;
            int end = node.getPosition().getEnd();
            if (node.astQualifier() != null) {
                tree = JcTreeBuilder.this.treeMaker.Select((JCTree.JCExpression)JcTreeBuilder.this.toTree(node.astQualifier()), ((JcTreeBuilder)JcTreeBuilder.this).table._this);
                start = JcTreeBuilder.this.posOfStructure(node, ".", true);
            } else {
                tree = JcTreeBuilder.this.treeMaker.Ident(((JcTreeBuilder)JcTreeBuilder.this).table._this);
                start = node.getPosition().getStart();
            }
            Position jcThisPos = ConversionPositionInfo.getConversionPositionInfo(node, "this");
            if (jcThisPos != null) {
                start = jcThisPos.getStart();
                end = jcThisPos.getEnd();
            }
            return JcTreeBuilder.this.set(node, JcTreeBuilder.this.setPos(start, end, tree));
        }

        @Override
        public boolean visitTry(Try node) {
            List catches = JcTreeBuilder.this.toList(JCTree.JCCatch.class, node.astCatches());
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.Try((JCTree.JCBlock)JcTreeBuilder.this.toTree(node.astBody()), catches, (JCTree.JCBlock)JcTreeBuilder.this.toTree(node.astFinally())));
        }

        @Override
        public boolean visitCatch(Catch node) {
            JCTree.JCVariableDecl exceptionDeclaration = (JCTree.JCVariableDecl)JcTreeBuilder.this.toTree(node.astExceptionDeclaration());
            exceptionDeclaration.getModifiers().flags |= 0x200000000L;
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.Catch(exceptionDeclaration, (JCTree.JCBlock)JcTreeBuilder.this.toTree(node.astBody())));
        }

        @Override
        public boolean visitThrow(Throw node) {
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.Throw(JcTreeBuilder.this.toExpression(node.astThrowable())));
        }

        @Override
        public boolean visitWhile(While node) {
            JCTree.JCExpression expr = this.reParen(node, JcTreeBuilder.this.toExpression(node.astCondition()));
            return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.WhileLoop(expr, JcTreeBuilder.this.toStatement(node.astStatement())));
        }

        @Override
        public boolean visitEmptyDeclaration(EmptyDeclaration node) {
            if (node.getParent() instanceof CompilationUnit) {
                return JcTreeBuilder.this.posSet(node, JcTreeBuilder.this.treeMaker.Skip());
            }
            return JcTreeBuilder.this.set(node, JcTreeBuilder.this.posNone(JcTreeBuilder.this.treeMaker.Block(0L, List.<JCTree.JCStatement>nil())));
        }
    };
    static final BiMap<UnaryOperator, Integer> UNARY_OPERATORS = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put((Object)UnaryOperator.BINARY_NOT, (Object)49)).put((Object)UnaryOperator.LOGICAL_NOT, (Object)48)).put((Object)UnaryOperator.UNARY_PLUS, (Object)46)).put((Object)UnaryOperator.PREFIX_INCREMENT, (Object)50)).put((Object)UnaryOperator.UNARY_MINUS, (Object)47)).put((Object)UnaryOperator.PREFIX_DECREMENT, (Object)51)).put((Object)UnaryOperator.POSTFIX_INCREMENT, (Object)52)).put((Object)UnaryOperator.POSTFIX_DECREMENT, (Object)53)).build();
    static final BiMap<BinaryOperator, Integer> BINARY_OPERATORS = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put((Object)BinaryOperator.PLUS_ASSIGN, (Object)86)).put((Object)BinaryOperator.MINUS_ASSIGN, (Object)87)).put((Object)BinaryOperator.MULTIPLY_ASSIGN, (Object)88)).put((Object)BinaryOperator.DIVIDE_ASSIGN, (Object)89)).put((Object)BinaryOperator.REMAINDER_ASSIGN, (Object)90)).put((Object)BinaryOperator.AND_ASSIGN, (Object)76)).put((Object)BinaryOperator.XOR_ASSIGN, (Object)75)).put((Object)BinaryOperator.OR_ASSIGN, (Object)74)).put((Object)BinaryOperator.SHIFT_LEFT_ASSIGN, (Object)83)).put((Object)BinaryOperator.SHIFT_RIGHT_ASSIGN, (Object)84)).put((Object)BinaryOperator.BITWISE_SHIFT_RIGHT_ASSIGN, (Object)85)).put((Object)BinaryOperator.LOGICAL_OR, (Object)55)).put((Object)BinaryOperator.LOGICAL_AND, (Object)56)).put((Object)BinaryOperator.BITWISE_OR, (Object)57)).put((Object)BinaryOperator.BITWISE_XOR, (Object)58)).put((Object)BinaryOperator.BITWISE_AND, (Object)59)).put((Object)BinaryOperator.EQUALS, (Object)60)).put((Object)BinaryOperator.NOT_EQUALS, (Object)61)).put((Object)BinaryOperator.GREATER, (Object)63)).put((Object)BinaryOperator.GREATER_OR_EQUAL, (Object)65)).put((Object)BinaryOperator.LESS, (Object)62)).put((Object)BinaryOperator.LESS_OR_EQUAL, (Object)64)).put((Object)BinaryOperator.SHIFT_LEFT, (Object)66)).put((Object)BinaryOperator.SHIFT_RIGHT, (Object)67)).put((Object)BinaryOperator.BITWISE_SHIFT_RIGHT, (Object)68)).put((Object)BinaryOperator.PLUS, (Object)69)).put((Object)BinaryOperator.MINUS, (Object)70)).put((Object)BinaryOperator.MULTIPLY, (Object)71)).put((Object)BinaryOperator.DIVIDE, (Object)72)).put((Object)BinaryOperator.REMAINDER, (Object)73)).build();
    static final BiMap<String, Integer> PRIMITIVES = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put("byte", (Object)1)).put("char", (Object)2)).put("short", (Object)3)).put("int", (Object)4)).put("long", (Object)5)).put("float", (Object)6)).put("double", (Object)7)).put("boolean", (Object)8)).put("void", (Object)9)).build();

    public JcTreeBuilder() {
        this(null, JcTreeBuilder.createNewContext());
    }

    private static Context createNewContext() {
        Method m;
        Context c = new Context();
        try {
            m = Class.forName("com.sun.tools.javac.util.DefaultFileManager").getDeclaredMethod("preRegister", Context.class);
            m.invoke(null, c);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            m = Class.forName("com.sun.tools.javac.util.JavacFileManager").getDeclaredMethod("preRegister", Context.class);
            m.invoke(null, c);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return c;
    }

    public JcTreeBuilder(Source source, Context context) {
        this(source == null ? null : source.getSourceStructures(), TreeMaker.instance(context), Name.Table.instance((Context)context), Maps.newHashMap());
    }

    private JcTreeBuilder(Map<Node, Collection<SourceStructure>> structures, TreeMaker treeMaker, Name.Table nameTable, Map<JCTree, Integer> endPosTable) {
        if (treeMaker == null) {
            throw new NullPointerException("treeMaker");
        }
        if (nameTable == null) {
            throw new NullPointerException("nameTable");
        }
        this.treeMaker = treeMaker;
        this.table = nameTable;
        this.sourceStructures = structures;
        this.endPosTable = endPosTable;
    }

    private Name toName(Identifier identifier) {
        if (identifier == null) {
            return null;
        }
        return this.table.fromString(identifier.astValue());
    }

    private JCTree toTree(Node node) {
        if (node == null) {
            return null;
        }
        JcTreeBuilder builder = this.create();
        node.accept(builder.visitor);
        try {
            return builder.get();
        }
        catch (RuntimeException e) {
            System.err.printf("Node '%s' (%s) did not produce any results\n", node, node.getClass().getSimpleName());
            throw e;
        }
    }

    private JCTree.JCExpression toExpression(Node node) {
        return (JCTree.JCExpression)this.toTree(node);
    }

    private JCTree.JCStatement toStatement(Node node) {
        return (JCTree.JCStatement)this.toTree(node);
    }

    private <T extends JCTree> List<T> toList(Class<T> type, StrictListAccessor<?, ?> accessor) {
        List<T> result = List.nil();
        for (Node node : accessor) {
            List<? extends JCTree> values;
            JcTreeBuilder builder = this.create();
            node.accept(builder.visitor);
            try {
                values = builder.getAll();
                if (values.size() == 0) {
                    throw new RuntimeException();
                }
            }
            catch (RuntimeException e) {
                System.err.printf("Node '%s' (%s) did not produce any results\n", node, node.getClass().getSimpleName());
                throw e;
            }
            for (JCTree jCTree : values) {
                if (jCTree != null && !type.isInstance(jCTree)) {
                    throw new ClassCastException(jCTree.getClass().getName() + " cannot be cast to " + type.getName());
                }
                result = result.append(type.cast(jCTree));
            }
        }
        return result;
    }

    private <T extends JCTree> List<T> toList(Class<T> type, Node node) {
        if (node == null) {
            return List.nil();
        }
        JcTreeBuilder builder = this.create();
        node.accept(builder.visitor);
        List<? extends JCTree> all = builder.getAll();
        return List.nil().appendList(all);
    }

    public void visit(Node node) {
        node.accept(this.visitor);
    }

    public JCTree get() {
        if (this.result.size() > 1) {
            throw new RuntimeException("Expected only one result but got " + this.result.size());
        }
        return (JCTree)this.result.head;
    }

    public List<? extends JCTree> getAll() {
        return this.result;
    }

    private boolean set(Node node, JCTree value) {
        if (this.result != null) {
            throw new IllegalStateException("result is already set");
        }
        JCTree actualValue = value;
        if (node instanceof Expression) {
            for (int i = 0; i < ((Expression)node).getIntendedParens(); ++i) {
                actualValue = this.treeMaker.Parens((JCTree.JCExpression)actualValue);
                this.posParen(node, i, ((Expression)node).astParensPositions(), actualValue);
            }
        }
        this.result = List.of(actualValue);
        return true;
    }

    private void posParen(Node node, int iteration, java.util.List<Position> parenPositions, JCTree jcTree) {
        Position p = null;
        if (parenPositions.size() > iteration) {
            p = parenPositions.get(iteration);
        }
        int start = p == null || p.isUnplaced() || p.getStart() < 0 ? node.getPosition().getStart() - 1 - iteration : p.getStart();
        int end = p == null || p.isUnplaced() || p.getEnd() < 0 ? node.getPosition().getEnd() + 1 + iteration : p.getEnd();
        this.setPos(start, end, jcTree);
    }

    private boolean set(List<? extends JCTree> values) {
        if (this.result != null) {
            throw new IllegalStateException("result is already set");
        }
        this.result = values;
        return true;
    }

    private JcTreeBuilder create() {
        return new JcTreeBuilder(this.sourceStructures, this.treeMaker, this.table, this.endPosTable);
    }

    private static boolean hasConversionStructureInfo(Node node, String key) {
        return Position.UNPLACED == ConversionPositionInfo.getConversionPositionInfo(node, key);
    }

    static int primitiveTypeTag(String typeName) {
        Integer primitive = (Integer)PRIMITIVES.get(typeName);
        return primitive == null ? 0 : primitive;
    }

    private long getModifier(KeywordModifier keyword) {
        return keyword.asReflectModifiers();
    }

    private JCTree.JCExpression chain(Iterable<Identifier> parts) {
        JCTree.JCExpression previous = null;
        for (Identifier part : parts) {
            Name next = this.toName(part);
            if (previous == null) {
                previous = this.setPos(part, this.treeMaker.Ident(next));
                continue;
            }
            previous = this.setPos(this.posOfStructure(part, ".", true), part.getPosition().getEnd(), this.treeMaker.Select(previous, next));
        }
        return previous;
    }

    private int posOfStructure(Node node, String structure, boolean atStart) {
        return this.posOfStructure(node, structure, atStart ? 0 : Integer.MAX_VALUE, atStart);
    }

    private boolean hasSourceStructures() {
        return this.sourceStructures != null && !this.sourceStructures.isEmpty();
    }

    private int posOfStructure(Node node, String structure, int idx, boolean atStart) {
        int start = node.getPosition().getStart();
        if (this.sourceStructures != null && this.sourceStructures.containsKey(node)) {
            for (SourceStructure struct : this.sourceStructures.get(node)) {
                if (!structure.equals(struct.getContent())) continue;
                int n = start = atStart ? struct.getPosition().getStart() : struct.getPosition().getEnd();
                if (idx-- > 0) continue;
                break;
            }
        }
        return start;
    }

    private static Object negative(Object value) {
        Number num = (Number)value;
        if (num instanceof Integer) {
            return -num.intValue();
        }
        if (num instanceof Long) {
            return -num.longValue();
        }
        if (num instanceof Float) {
            return Float.valueOf(-num.floatValue());
        }
        if (num instanceof Double) {
            return -num.doubleValue();
        }
        throw new IllegalArgumentException("value should be an Integer, Long, Float or Double, not a " + value.getClass().getSimpleName());
    }

    private boolean posSet(Node node, JCTree jcTree) {
        return this.set(node, this.setPos(node, jcTree));
    }

    private <T extends JCTree> T posNone(T jcTree) {
        jcTree.pos = -1;
        this.endPosTable.remove(jcTree);
        return jcTree;
    }

    private <T extends JCTree> T setPos(Node node, T jcTree) {
        return this.setPos(node.getPosition().getStart(), node.getPosition().getEnd(), jcTree);
    }

    private <T extends JCTree> T setPos(int start, int end, T jcTree) {
        jcTree.pos = start;
        this.endPosTable.put(jcTree, end);
        return jcTree;
    }
}

