/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.com.google.common.base;

import java.io.Serializable;
import java.util.Iterator;
import javax.annotation.Nullable;
import lombok.ast.libs.com.google.common.annotations.GwtCompatible;
import lombok.ast.libs.com.google.common.base.Equivalence;
import lombok.ast.libs.com.google.common.base.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true)
final class PairwiseEquivalence<T>
implements Equivalence<Iterable<T>>,
Serializable {
    final Equivalence<? super T> elementEquivalence;
    private static final long serialVersionUID = 0L;

    PairwiseEquivalence(Equivalence<? super T> elementEquivalence) {
        this.elementEquivalence = Preconditions.checkNotNull(elementEquivalence);
    }

    @Override
    public boolean equivalent(@Nullable Iterable<T> iterableA, @Nullable Iterable<T> iterableB) {
        if (iterableA == null) {
            return iterableB == null;
        }
        if (iterableB == null) {
            return false;
        }
        Iterator<T> iteratorA = iterableA.iterator();
        Iterator<T> iteratorB = iterableB.iterator();
        while (iteratorA.hasNext() && iteratorB.hasNext()) {
            if (this.elementEquivalence.equivalent(iteratorA.next(), iteratorB.next())) continue;
            return false;
        }
        return !iteratorA.hasNext() && !iteratorB.hasNext();
    }

    @Override
    public int hash(@Nullable Iterable<T> iterable) {
        if (iterable == null) {
            return 0;
        }
        int hash = 78721;
        for (T element : iterable) {
            hash = hash * 24943 + this.elementEquivalence.hash(element);
        }
        return hash;
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof PairwiseEquivalence) {
            PairwiseEquivalence that = (PairwiseEquivalence)object;
            return this.elementEquivalence.equals(that.elementEquivalence);
        }
        return false;
    }

    public int hashCode() {
        return this.elementEquivalence.hashCode() ^ 0x46A3EB07;
    }

    public String toString() {
        return "Equivalences.pairwise(" + this.elementEquivalence + ")";
    }
}

