/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.matchers;

import java.util.List;
import lombok.ast.libs.org.parboiled.MatcherContext;
import lombok.ast.libs.org.parboiled.Rule;
import lombok.ast.libs.org.parboiled.matchers.Matcher;
import lombok.ast.libs.org.parboiled.matchers.MatcherVisitor;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyMatcher<V>
implements Matcher<V>,
Cloneable {
    private Matcher<V> target;
    private String label;
    private boolean nodeSuppressed;
    private boolean subnodesSuppressed;
    private boolean nodeSkipped;
    private boolean dirty;

    @Override
    @NotNull
    public List<Matcher<V>> getChildren() {
        if (this.dirty) {
            this.apply();
        }
        List<Matcher<V>> list = this.target.getChildren();
        if (list == null) {
            throw new IllegalStateException("@NotNull method org.parboiled.matchers.ProxyMatcher.getChildren must not return null");
        }
        return list;
    }

    public void setLabel(String label) {
        this.label = label;
        this.updateDirtyFlag();
    }

    public void setNodeSuppressed(boolean nodeSuppressed) {
        this.nodeSuppressed = nodeSuppressed;
        this.updateDirtyFlag();
    }

    public void setSubnodesSuppressed(boolean subnodesSuppressed) {
        this.subnodesSuppressed = subnodesSuppressed;
        this.updateDirtyFlag();
    }

    public void setNodeSkipped(boolean nodeSkipped) {
        this.nodeSkipped = nodeSkipped;
        this.updateDirtyFlag();
    }

    private void updateDirtyFlag() {
        this.dirty = this.label != null || this.nodeSuppressed || this.subnodesSuppressed || this.nodeSkipped;
    }

    @Override
    public boolean match(@NotNull MatcherContext<V> context) {
        if (context == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.matchers.ProxyMatcher.match(...) corresponds to @NotNull parameter and must not be null");
        }
        if (this.dirty) {
            this.apply();
        }
        return this.target.match(context);
    }

    @Override
    public String getLabel() {
        if (this.dirty) {
            this.apply();
        }
        return this.target.getLabel();
    }

    @Override
    public boolean isNodeSuppressed() {
        if (this.dirty) {
            this.apply();
        }
        return this.target.isNodeSuppressed();
    }

    @Override
    public boolean areSubnodesSuppressed() {
        if (this.dirty) {
            this.apply();
        }
        return this.target.areSubnodesSuppressed();
    }

    @Override
    public boolean isNodeSkipped() {
        if (this.dirty) {
            this.apply();
        }
        return this.target.isNodeSkipped();
    }

    @Override
    public <R> R accept(@NotNull MatcherVisitor<V, R> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.matchers.ProxyMatcher.accept(...) corresponds to @NotNull parameter and must not be null");
        }
        if (this.dirty) {
            this.apply();
        }
        return this.target.accept(visitor);
    }

    public String toString() {
        if (this.target == null) {
            return super.toString();
        }
        if (this.dirty) {
            this.apply();
        }
        return this.target.toString();
    }

    private void apply() {
        if (this.label != null) {
            this.label(this.label);
        }
        if (this.nodeSuppressed) {
            this.suppressNode();
        }
        if (this.subnodesSuppressed) {
            this.suppressSubnodes();
        }
        if (this.nodeSkipped) {
            this.skipNode();
        }
    }

    @Override
    public Rule label(String label) {
        if (this.target == null) {
            if (this.label == null) {
                this.setLabel(label);
                return this;
            }
            ProxyMatcher<V> anotherProxy = this.createClone();
            anotherProxy.setLabel(label);
            anotherProxy.arm(this);
            return anotherProxy;
        }
        Matcher<V> inner = ProxyMatcher.unwrap(this.target);
        this.target = (Matcher)inner.label(label);
        this.setLabel(null);
        return this.target;
    }

    @Override
    public Rule suppressNode() {
        if (this.target == null) {
            this.setNodeSuppressed(true);
            return this;
        }
        Matcher<V> inner = ProxyMatcher.unwrap(this.target);
        this.target = (Matcher)inner.suppressNode();
        this.setNodeSuppressed(false);
        return this.target;
    }

    @Override
    public Rule suppressSubnodes() {
        if (this.target == null) {
            this.setSubnodesSuppressed(true);
            return this;
        }
        Matcher<V> inner = ProxyMatcher.unwrap(this.target);
        this.target = (Matcher)inner.suppressSubnodes();
        this.setSubnodesSuppressed(false);
        return this.target;
    }

    @Override
    public Rule skipNode() {
        if (this.target == null) {
            this.setNodeSkipped(true);
            return this;
        }
        Matcher<V> inner = ProxyMatcher.unwrap(this.target);
        this.target = (Matcher)inner.skipNode();
        this.setNodeSkipped(false);
        return this.target;
    }

    public void arm(@NotNull Matcher<V> target) {
        if (target == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.matchers.ProxyMatcher.arm(...) corresponds to @NotNull parameter and must not be null");
        }
        this.target = target;
    }

    public static <V> Matcher<V> unwrap(Matcher<V> matcher) {
        if (matcher instanceof ProxyMatcher) {
            ProxyMatcher proxyMatcher = (ProxyMatcher)matcher;
            if (proxyMatcher.dirty) {
                proxyMatcher.apply();
            }
            return proxyMatcher.target;
        }
        return matcher;
    }

    @Override
    public MatcherContext<V> getSubContext(MatcherContext<V> context) {
        if (this.dirty) {
            this.apply();
        }
        return this.target.getSubContext(context);
    }

    private ProxyMatcher<V> createClone() {
        try {
            return (ProxyMatcher)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }
}

