/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.printer;

import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.ast.DescribedNode;
import lombok.ast.Node;
import lombok.ast.libs.com.google.common.base.Charsets;
import lombok.ast.libs.com.google.common.base.Joiner;
import lombok.ast.libs.com.google.common.collect.Lists;
import lombok.ast.libs.com.google.common.collect.Sets;
import lombok.ast.libs.com.google.common.io.ByteStreams;
import lombok.ast.printer.SourceFormatter;

public class HtmlFormatter
implements SourceFormatter {
    private final StringBuilder sb = new StringBuilder();
    private final String rawSource;
    private final List<String> errors = Lists.newArrayList();
    private String nextElementName;
    private static final String OPENERS = "{([<";
    private static final String CLOSERS = "})]>";
    private int parenCounter = 0;
    private final ArrayDeque<Integer> parenStack = new ArrayDeque();
    private static final Pattern HTML_CLASS_SIGNIFICANT_NODE = Pattern.compile("^lombok\\.ast\\.(\\w+)$");
    private String timeTaken = "(Unknown)";

    private static String escapeHtml(String in) {
        return in.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public HtmlFormatter(String rawSource) {
        this.rawSource = rawSource;
    }

    @Override
    public void fail(String fail) {
        this.sb.append("<span class=\"fail\">").append("?!?").append(HtmlFormatter.escapeHtml(fail)).append("?!?").append("</span>");
    }

    @Override
    public void property(String name, Object value) {
    }

    @Override
    public void keyword(String text) {
        this.sb.append("<span class=\"keyword\">").append(HtmlFormatter.escapeHtml(text)).append("</span>");
    }

    @Override
    public void operator(String text) {
        this.sb.append("<span class=\"operator\">").append(HtmlFormatter.escapeHtml(text)).append("</span>");
    }

    @Override
    public void verticalSpace() {
        this.sb.append("<br />");
    }

    @Override
    public void space() {
        this.sb.append(" ");
    }

    @Override
    public void append(String text) {
        if (text.length() == 1) {
            if (OPENERS.contains(text)) {
                ++this.parenCounter;
                this.parenStack.push(this.parenCounter);
                this.sb.append("<span class=\"open\" id=\"open_").append(this.parenCounter).append("\">").append(HtmlFormatter.escapeHtml(text)).append("</span>");
                return;
            }
            if (CLOSERS.contains(text)) {
                Integer n = this.parenStack.poll();
                if (n == null) {
                    n = ++this.parenCounter;
                }
                this.sb.append("<span class=\"clos\" id=\"clos_").append(n).append("\">").append(HtmlFormatter.escapeHtml(text)).append("</span>");
                return;
            }
        }
        this.sb.append(HtmlFormatter.escapeHtml(text));
    }

    @Override
    public void buildInline(Node node) {
        this.generateOpenTag(node, "span");
    }

    @Override
    public void closeInline() {
        this.sb.append("</span>");
    }

    @Override
    public void startSuppressBlock() {
        this.sb.append("<span class=\"blockSuppress\">");
    }

    @Override
    public void endSuppressBlock() {
        this.sb.append("</span>");
    }

    @Override
    public void startSuppressIndent() {
        this.sb.append("<div class=\"indentSuppress\">");
    }

    @Override
    public void endSuppressIndent() {
        this.sb.append("</div>");
    }

    @Override
    public void buildBlock(Node node) {
        this.generateOpenTag(node, "div");
    }

    private void generateOpenTag(Node node, String tagName) {
        HashSet<String> classes = Sets.newHashSet();
        AtomicReference<String> kind = new AtomicReference<String>();
        HtmlFormatter.findHtmlClassSignificantNodes(classes, kind, node == null ? null : node.getClass());
        String description = node instanceof DescribedNode ? ((DescribedNode)node).getDescription() : null;
        this.sb.append("<").append(tagName);
        if (!classes.isEmpty()) {
            this.sb.append(" class=\"");
            Joiner.on(' ').appendTo(this.sb, (Iterable<?>)classes);
            this.sb.append("\"");
        }
        if (this.nextElementName != null) {
            this.sb.append(" relation=\"").append(HtmlFormatter.escapeHtml(this.nextElementName)).append("\"");
            this.nextElementName = null;
        }
        if (kind.get() != null) {
            this.sb.append(" kind=\"").append(HtmlFormatter.escapeHtml(kind.get())).append("\"");
        }
        if (description != null) {
            this.sb.append(" description=\"").append(HtmlFormatter.escapeHtml(description)).append("\"");
        }
        this.sb.append(">");
    }

    private static void findHtmlClassSignificantNodes(Set<String> names, AtomicReference<String> kind, Class<?> c) {
        Matcher m;
        if (c == null) {
            return;
        }
        if (Modifier.isPublic(c.getModifiers()) && (m = HTML_CLASS_SIGNIFICANT_NODE.matcher(c.getName())).matches()) {
            names.add(c.getSimpleName());
            if (kind.get() == null) {
                kind.set(c.getSimpleName());
            }
        }
        HtmlFormatter.findHtmlClassSignificantNodes(names, kind, c.getSuperclass());
        for (Class<?> i : c.getInterfaces()) {
            HtmlFormatter.findHtmlClassSignificantNodes(names, kind, i);
        }
    }

    @Override
    public void closeBlock() {
        this.sb.append("</div>");
    }

    @Override
    public void addError(int errorStart, int errorEnd, String errorMessage) {
        this.errors.add(String.format("<div class=\"parseError\">%s</div>", HtmlFormatter.escapeHtml(errorMessage)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResource(String resource) {
        String string;
        block6: {
            InputStream in = this.getClass().getResourceAsStream(resource);
            try {
                string = new String(ByteStreams.toByteArray(in), Charsets.UTF_8);
                if (Collections.singletonList(in).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(in).get(0) != null) {
                    in.close();
                }
                throw throwable;
            }
            in.close();
        }
        return string;
    }

    @Override
    public String finish() {
        String template = this.readResource("web/ast.html");
        String cssContent = this.readResource("web/ast.css");
        String scriptContent = this.readResource("web/ast.js");
        String jQuery = this.readResource("web/jquery.js");
        return template.replace("{{@title}}", "AST nodes").replace("{{@file}}", "source file name goes here").replace("{{@jQuery}}", jQuery).replace("{{@script}}", scriptContent).replace("{{@css}}", cssContent).replace("{{@body}}", this.sb.toString()).replace("{{@errors}}", this.printErrors()).replace("{{@rawSource}}", HtmlFormatter.escapeHtml(this.rawSource)).replace("{{@timeTaken}}", "" + this.timeTaken);
    }

    private String printErrors() {
        if (this.errors.isEmpty()) {
            return "<div class=\"allClear\">No parse errors!</div>";
        }
        StringBuilder sb = new StringBuilder();
        for (String x : this.errors) {
            sb.append(x);
        }
        return sb.toString();
    }

    @Override
    public void setTimeTaken(long taken) {
        this.timeTaken = taken + " milliseconds.";
    }

    @Override
    public void nameNextElement(String name) {
        assert (this.nextElementName == null);
        this.nextElementName = name;
    }
}

