/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.printer;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.ast.DescribedNode;
import lombok.ast.Node;
import lombok.ast.grammar.Source;
import lombok.ast.grammar.SourceStructure;
import lombok.ast.libs.com.google.common.base.Joiner;
import lombok.ast.libs.com.google.common.collect.Lists;
import lombok.ast.libs.com.google.common.collect.Sets;
import lombok.ast.printer.SourceFormatter;

public class StructureFormatter
implements SourceFormatter {
    private static final String INDENT = "    ";
    private final StringBuilder sb = new StringBuilder();
    private final List<String> errors = Lists.newArrayList();
    private int indent;
    private final Map<Node, Collection<SourceStructure>> sourceStructures;
    private String name;
    private String currentType;
    private final String nodeFormatString;
    private Set<String> propertySkipList = Sets.newHashSet();

    public static StructureFormatter formatterWithoutPositions() {
        return new StructureFormatter(Collections.<Node, Collection<SourceStructure>>emptyMap(), false);
    }

    public static StructureFormatter formatterWithPositions() {
        return new StructureFormatter(Collections.<Node, Collection<SourceStructure>>emptyMap(), true);
    }

    public static StructureFormatter formatterWithEverything(Source source) {
        return new StructureFormatter(source.getSourceStructures(), true);
    }

    private StructureFormatter(Map<Node, Collection<SourceStructure>> sourceStructures, boolean printPositions) {
        this.sourceStructures = sourceStructures;
        this.nodeFormatString = printPositions ? "[%s %s%s (%d-%d)]\n" : "[%s %s%s]\n";
    }

    private void a(String in, Object ... args) {
        for (int i = 0; i < this.indent; ++i) {
            this.sb.append(INDENT);
        }
        if (this.name != null) {
            this.sb.append(this.name).append(": ");
            this.name = null;
        }
        if (args.length == 0) {
            this.sb.append(in);
        } else {
            this.sb.append(String.format(in, args));
        }
    }

    @Override
    public void buildInline(Node node) {
        this.buildNode("I", node);
    }

    @Override
    public void buildBlock(Node node) {
        this.buildNode("B", node);
    }

    private void buildNode(String type, Node node) {
        String name;
        if (node == null) {
            ++this.indent;
            return;
        }
        this.currentType = name = node.getClass().getSimpleName();
        String description = "";
        if (node instanceof DescribedNode) {
            description = " " + ((DescribedNode)node).getDescription();
        }
        this.a(this.nodeFormatString, type, name, description, node.getPosition().getStart(), node.getPosition().getEnd());
        ++this.indent;
        if (this.sourceStructures.containsKey(node)) {
            for (SourceStructure struct : this.sourceStructures.get(node)) {
                this.a("STRUCT: %s (%d-%d)\n", struct.getContent(), struct.getPosition().getStart(), struct.getPosition().getEnd());
            }
        }
    }

    @Override
    public void fail(String fail) {
        this.a("FAIL: " + fail, new Object[0]);
    }

    @Override
    public void property(String name, Object value) {
        if (!this.propertySkipList.contains(this.currentType + "/" + name)) {
            this.a("PROPERTY: %s = %s\n", name, value);
        }
    }

    public StructureFormatter skipProperty(Class<? extends Node> type, String propertyName) {
        this.propertySkipList.add(type.getSimpleName() + "/" + propertyName);
        return this;
    }

    @Override
    public void keyword(String text) {
    }

    @Override
    public void operator(String text) {
    }

    @Override
    public void verticalSpace() {
    }

    @Override
    public void space() {
    }

    @Override
    public void append(String text) {
    }

    @Override
    public void startSuppressBlock() {
    }

    @Override
    public void endSuppressBlock() {
    }

    @Override
    public void startSuppressIndent() {
    }

    @Override
    public void endSuppressIndent() {
    }

    @Override
    public void closeInline() {
        --this.indent;
    }

    @Override
    public void closeBlock() {
        --this.indent;
    }

    @Override
    public void addError(int errorStart, int errorEnd, String errorMessage) {
        this.errors.add(String.format("%d-%d: %s", errorStart, errorEnd, errorMessage));
    }

    @Override
    public String finish() {
        if (!this.errors.isEmpty()) {
            this.indent = 0;
            this.a("\n\n\nERRORS: \n", new Object[0]);
            this.a(Joiner.on('\n').join(this.errors), new Object[0]);
            this.errors.clear();
        }
        return this.sb.toString();
    }

    @Override
    public void setTimeTaken(long taken) {
    }

    @Override
    public void nameNextElement(String name) {
        this.name = name;
    }
}

