/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.resolve;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import lombok.ast.Annotation;
import lombok.ast.AnnotationElement;
import lombok.ast.BooleanLiteral;
import lombok.ast.CharLiteral;
import lombok.ast.ClassLiteral;
import lombok.ast.FloatingPointLiteral;
import lombok.ast.IntegralLiteral;
import lombok.ast.Node;
import lombok.ast.ResolutionException;
import lombok.ast.StringLiteral;
import lombok.ast.UnaryExpression;
import lombok.ast.UnaryOperator;
import lombok.ast.libs.com.google.common.collect.Lists;
import lombok.ast.resolve.AnnotationClassNotAvailableException;
import lombok.ast.resolve.Resolver;

class AnnotationProxy
implements InvocationHandler {
    private final Resolver resolver;
    private final Annotation node;

    AnnotationProxy(Resolver resolver, Annotation node) {
        this.resolver = resolver;
        this.node = node;
    }

    private boolean tryAsString(Node val, Class<?> expectedType, List<Object> returnValues) {
        if (expectedType != String.class) {
            return false;
        }
        if (val instanceof StringLiteral) {
            returnValues.add(((StringLiteral)val).astValue());
            return true;
        }
        throw new ResolutionException(val, "Expected string literal");
    }

    private boolean tryAsEnum(Node val, Class<?> expectedType, List<Object> returnValues) {
        if (!expectedType.isEnum()) {
            return false;
        }
        returnValues.add(this.resolver.resolveEnum(expectedType.asSubclass(Enum.class), val));
        return true;
    }

    private boolean tryAsBoolean(Node val, Class<?> expectedType, List<Object> returnValues) {
        if (expectedType != Boolean.TYPE) {
            return false;
        }
        if (val instanceof BooleanLiteral) {
            boolean v = ((BooleanLiteral)val).astValue();
            returnValues.add(v);
            return true;
        }
        throw new ResolutionException(val, "Expected boolean literal");
    }

    private boolean tryAsNumeric(Node val, Class<?> expectedType, List<Object> returnValues) {
        long iVal;
        long v;
        if (!Resolver.NUMERIC_PRIMITIVE_CLASSES.contains(expectedType)) {
            return false;
        }
        boolean negative = false;
        if (val instanceof UnaryExpression && ((UnaryExpression)val).astOperator() == UnaryOperator.UNARY_MINUS) {
            val = ((UnaryExpression)val).rawOperand();
            negative = true;
        }
        if (!(val instanceof IntegralLiteral || val instanceof FloatingPointLiteral || val instanceof CharLiteral)) {
            throw new ResolutionException(val, "Expected number or character literal");
        }
        boolean isIntegral = true;
        if (val instanceof IntegralLiteral) {
            v = ((IntegralLiteral)val).astLongValue();
            iVal = negative ? -v : v;
        } else if (val instanceof CharLiteral) {
            v = ((CharLiteral)val).astValue().charValue();
            iVal = negative ? -v : v;
        } else {
            iVal = 0L;
            isIntegral = false;
        }
        double dVal = val instanceof FloatingPointLiteral ? ((FloatingPointLiteral)val).astDoubleValue() : 0.0;
        if (expectedType == Double.TYPE) {
            returnValues.add(isIntegral ? (double)iVal : dVal);
        } else if (expectedType == Float.TYPE) {
            returnValues.add(isIntegral ? (double)iVal : dVal);
        } else if (expectedType == Long.TYPE) {
            returnValues.add(isIntegral ? iVal : (long)dVal);
        } else if (expectedType == Integer.TYPE) {
            returnValues.add(isIntegral ? (int)iVal : (int)dVal);
        } else if (expectedType == Character.TYPE) {
            returnValues.add(Character.valueOf(isIntegral ? (char)iVal : (char)dVal));
        } else if (expectedType == Short.TYPE) {
            returnValues.add(isIntegral ? (short)iVal : (short)dVal);
        } else if (expectedType == Byte.TYPE) {
            returnValues.add(isIntegral ? (byte)iVal : (byte)dVal);
        } else {
            throw new AssertionError((Object)"Forgotten primitive numeric type");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        Class<?> expectedType = method.getReturnType();
        boolean array = false;
        if (expectedType.isArray()) {
            array = true;
            expectedType = expectedType.getComponentType();
        }
        ArrayList<Object> returnValues = Lists.newArrayList();
        ArrayList<String> classNames = Lists.newArrayList();
        AnnotationClassNotAvailableException classNotAvailable = null;
        for (AnnotationElement elem : this.node.astElements()) {
            if ((elem.astName() != null || !name.equals("value")) && !name.equals(elem.astName())) continue;
            for (Node val : elem.getValues()) {
                block24: {
                    if (this.tryAsNumeric(val, expectedType, returnValues) || this.tryAsBoolean(val, expectedType, returnValues) || this.tryAsString(val, expectedType, returnValues) || this.tryAsEnum(val, expectedType, returnValues)) continue;
                    if (expectedType == Class.class) {
                        if (val instanceof ClassLiteral) {
                            String className;
                            String cName = className = ((ClassLiteral)val).astTypeReference().getTypeName();
                            int dims = 0;
                            while (cName.endsWith("[]")) {
                                ++dims;
                                cName = cName.substring(0, className.length() - 2);
                            }
                            try {
                                Class<?> c = Resolver.PRIMITIVE_CLASS_MAP.get(cName);
                                if (c == null) {
                                    ClassLoader cl = Resolver.class.getClassLoader();
                                    if (cl == null) {
                                        cl = ClassLoader.getSystemClassLoader();
                                    }
                                    c = Class.forName(cName, false, cl);
                                }
                                if (dims > 0) {
                                    int[] dimsA = new int[dims];
                                    c = Array.newInstance(c, dimsA).getClass();
                                }
                                returnValues.add(c);
                                continue;
                            }
                            catch (ClassNotFoundException e) {
                                classNotAvailable = new AnnotationClassNotAvailableException(val, className);
                                break block24;
                            }
                            finally {
                                classNames.add(className);
                                continue;
                            }
                        }
                        throw new ResolutionException(val, "Expected class literal");
                    }
                }
                if (expectedType.isAnnotation()) {
                    if (val instanceof Annotation) {
                        returnValues.add(this.resolver.toAnnotationInstance(expectedType.asSubclass(java.lang.annotation.Annotation.class), (Annotation)val));
                        continue;
                    }
                    throw new ResolutionException(val, "Expected an annotation of type " + expectedType);
                }
                throw new ResolutionException(val, "Not a valid annotation type: " + expectedType);
            }
        }
        if (classNotAvailable != null) {
            classNotAvailable.setClassNames(classNames);
            throw classNotAvailable;
        }
        if (array) {
            Object arr = Array.newInstance(expectedType, returnValues.size());
            for (int i = 0; i < returnValues.size(); ++i) {
                Array.set(arr, i, returnValues.get(i));
            }
            return arr;
        }
        switch (returnValues.size()) {
            case 0: {
                Object def = method.getDefaultValue();
                if (def != null) {
                    return def;
                }
                throw new ResolutionException(this.node, "Missing annotation method: " + method.getName());
            }
            case 1: {
                return returnValues.get(0);
            }
        }
        throw new ResolutionException(this.node, "Multiple values for a single-value annotation method: " + method.getName());
    }
}

