/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.resolve;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.ast.Annotation;
import lombok.ast.Block;
import lombok.ast.CompilationUnit;
import lombok.ast.Expression;
import lombok.ast.Identifier;
import lombok.ast.ImportDeclaration;
import lombok.ast.Node;
import lombok.ast.NullLiteral;
import lombok.ast.PackageDeclaration;
import lombok.ast.RawListAccessor;
import lombok.ast.ResolutionException;
import lombok.ast.Select;
import lombok.ast.TypeBody;
import lombok.ast.TypeDeclaration;
import lombok.ast.TypeReference;
import lombok.ast.libs.com.google.common.base.Joiner;
import lombok.ast.libs.com.google.common.collect.ImmutableList;
import lombok.ast.libs.com.google.common.collect.ImmutableMap;
import lombok.ast.libs.com.google.common.collect.Lists;
import lombok.ast.resolve.AnnotationClassNotAvailableException;
import lombok.ast.resolve.AnnotationProxy;

public class Resolver {
    static final List<Class<?>> NUMERIC_PRIMITIVE_CLASSES = ImmutableList.of(Long.TYPE, Integer.TYPE, Short.TYPE, Byte.TYPE, Double.TYPE, Float.TYPE, Character.TYPE);
    static final Map<String, Class<?>> PRIMITIVE_CLASS_MAP = ImmutableMap.builder().put("boolean", Boolean.TYPE).put("byte", Byte.TYPE).put("short", Short.TYPE).put("int", Integer.TYPE).put("long", Long.TYPE).put("char", Character.TYPE).put("float", Float.TYPE).put("double", Double.TYPE).build();

    public <E extends Enum<E>> E resolveEnum(Class<E> enumClass, Node value) {
        if (value instanceof NullLiteral) {
            return null;
        }
        String enumName = null;
        if (value instanceof Identifier) {
            enumName = ((Identifier)value).astValue();
        }
        String typeName = null;
        String packageName = null;
        if (value instanceof Select) {
            List<String> chain = this.unwrapSelectChain((Select)value);
            switch (chain.size()) {
                case 0: {
                    throw new ResolutionException(value, "empty");
                }
                default: {
                    packageName = Joiner.on('.').join(chain.subList(0, chain.size() - 2));
                }
                case 2: {
                    typeName = chain.get(chain.size() - 2);
                }
                case 1: 
            }
            enumName = chain.get(chain.size() - 1);
            boolean unexpectedType = false;
            if (packageName != null) {
                Package p = enumClass.getPackage();
                unexpectedType = p != null && !p.getName().equals(packageName);
            }
            if (unexpectedType |= typeName != null && !enumClass.getSimpleName().equals(typeName)) {
                throw new ResolutionException(value, "Expected " + enumClass.getName() + " and not " + packageName + "." + typeName);
            }
        }
        for (Enum enumConstant : (Enum[])enumClass.getEnumConstants()) {
            String target = enumConstant.name();
            if (!target.equals(enumName)) continue;
            return (E)enumConstant;
        }
        throw new ResolutionException(value, "Not a valid value for enum " + enumClass.getSimpleName() + ": " + enumName);
    }

    private ImportList getImportList(Node n) {
        ImportList il = new ImportList();
        while (n != null) {
            if (n instanceof CompilationUnit) {
                CompilationUnit cu = (CompilationUnit)n;
                PackageDeclaration pkg = cu.astPackageDeclaration();
                if (pkg != null) {
                    il.stars.add(pkg.getPackageName());
                }
                for (ImportDeclaration imp : cu.astImportDeclarations()) {
                    if (imp.astStaticImport()) continue;
                    if (imp.astStarImport()) {
                        String i = imp.asFullyQualifiedName();
                        i = i.substring(0, i.length() - 2);
                        il.stars.add(i);
                        continue;
                    }
                    il.explicits.add(imp.asFullyQualifiedName());
                }
            }
            n = n.getParent();
        }
        return il;
    }

    public boolean typesMatch(String wanted, TypeReference typeReference) {
        String wantedName;
        int dot;
        String name = this.stripGenerics(typeReference.getTypeName());
        if (name.equals(wanted = this.stripGenerics(wanted))) {
            return true;
        }
        int dims1 = typeReference.astArrayDimensions();
        int dims2 = 0;
        while (wanted.endsWith("[]")) {
            ++dims2;
            wanted = wanted.substring(0, wanted.length() - 2);
        }
        if (dims1 != dims2) {
            return false;
        }
        if (dims1 > 0) {
            name = name.substring(0, name.length() - dims1 * 2);
        }
        String wantedPkg = (dot = wanted.lastIndexOf(46)) == -1 ? "" : wanted.substring(0, dot);
        String string = wantedName = dot == -1 ? wanted : wanted.substring(dot + 1);
        if (name.indexOf(46) > -1) {
            return false;
        }
        if (!wantedName.equals(name)) {
            return false;
        }
        ImportList imports = this.getImportList(typeReference);
        String ending = "." + wantedName;
        for (String explicit : imports.explicits) {
            if (!explicit.endsWith(ending) || explicit.equals(wanted)) continue;
            return false;
        }
        if (!(wantedPkg.length() > 0 && imports.stars.contains(wantedPkg) || imports.explicits.contains(wanted))) {
            return false;
        }
        Node prevN = null;
        CompilationUnit cu = null;
        for (Node n = typeReference.getParent(); n != null; n = n.getParent()) {
            boolean stopAtSelf;
            RawListAccessor<Node, Node> list;
            if (n instanceof Block) {
                list = ((Block)n).rawContents();
                stopAtSelf = true;
            } else if (n instanceof TypeBody) {
                list = ((TypeBody)n).rawMembers();
                stopAtSelf = false;
            } else if (n instanceof CompilationUnit) {
                list = ((CompilationUnit)n).rawTypeDeclarations();
                cu = (CompilationUnit)n;
                stopAtSelf = false;
            } else {
                list = null;
                stopAtSelf = false;
            }
            if (list != null) {
                for (Node c : list) {
                    if (c instanceof TypeDeclaration && this.namesMatch(name, ((TypeDeclaration)c).astName())) {
                        return false;
                    }
                    if (!stopAtSelf || c != prevN) continue;
                    break;
                }
            }
            prevN = n;
        }
        if (wantedPkg.isEmpty()) {
            return cu == null || cu.rawPackageDeclaration() == null;
        }
        return true;
    }

    private String stripGenerics(String name) {
        int genericsStart = name.indexOf(60);
        int genericsEnd = name.lastIndexOf(62);
        if (genericsStart != -1 && genericsEnd == name.length() - 1) {
            name = name.substring(0, genericsStart);
        }
        return name;
    }

    private boolean namesMatch(String name, Identifier astName) {
        return name == null ? astName.astValue() == null : name.equals(astName.astValue());
    }

    public <A extends java.lang.annotation.Annotation> A toAnnotationInstance(Class<A> type, Annotation node) {
        return (A)((java.lang.annotation.Annotation)type.cast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new AnnotationProxy(this, node))));
    }

    public String getAnnotationClassAsString(java.lang.annotation.Annotation annotation, String methodName) {
        try {
            Method m = annotation.getClass().getMethod(methodName, new Class[0]);
            if (m.getReturnType() != Class.class) {
                throw new IllegalArgumentException("Method " + methodName + " does not have 'Class' as return type");
            }
            try {
                return ((Class)Class.class.cast(m.invoke((Object)annotation, new Object[0]))).toString();
            }
            catch (AnnotationClassNotAvailableException e) {
                return e.getClassName();
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Method " + methodName + " isn't accessible", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Method " + methodName + " cannot be invoked", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Method " + methodName + " does not exist");
        }
    }

    public List<String> getAnnotationClassesAsStrings(java.lang.annotation.Annotation annotation, String methodName) {
        try {
            boolean array;
            Method m = annotation.getClass().getMethod(methodName, new Class[0]);
            if (m.getReturnType() == Class.class) {
                array = false;
            } else if (m.getReturnType() == Class[].class) {
                array = true;
            } else {
                throw new IllegalArgumentException("Method " + methodName + " does not have 'Class' or 'Class[]' as return type");
            }
            try {
                Class[] cs = array ? (Class[])Class[].class.cast(m.invoke((Object)annotation, new Object[0])) : new Class[]{(Class)Class.class.cast(m.invoke((Object)annotation, new Object[0]))};
                ArrayList<String> result = Lists.newArrayList();
                for (Class c : cs) {
                    result.add(c.getName());
                }
                return result;
            }
            catch (AnnotationClassNotAvailableException e) {
                return e.getClassNames();
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Method " + methodName + " isn't accessible", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Method " + methodName + " cannot be invoked", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Method " + methodName + " does not exist");
        }
    }

    private List<String> unwrapSelectChain(Select s) {
        ArrayList<String> list = Lists.newArrayList();
        while (s != null) {
            list.add(s.astIdentifier().astValue());
            Expression parent = s.astOperand();
            if (parent instanceof Select) {
                s = (Select)parent;
                continue;
            }
            if (parent instanceof Identifier) {
                s = null;
                list.add(((Identifier)((Object)parent)).astValue());
                continue;
            }
            if (parent == null) break;
            throw new ResolutionException(parent, "Identifies expected here, not a " + parent.getClass().getSimpleName());
        }
        Collections.reverse(list);
        return list;
    }

    private static class ImportList {
        final List<String> explicits = new ArrayList<String>();
        final List<String> stars = new ArrayList<String>();

        ImportList() {
            this.stars.add("java.lang");
        }
    }
}

