/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.syntaxChecks;

import java.util.ArrayList;
import java.util.Map;
import lombok.ast.AnnotationDeclaration;
import lombok.ast.AnnotationMethodDeclaration;
import lombok.ast.ClassDeclaration;
import lombok.ast.CompilationUnit;
import lombok.ast.EmptyDeclaration;
import lombok.ast.EnumDeclaration;
import lombok.ast.InterfaceDeclaration;
import lombok.ast.KeywordModifier;
import lombok.ast.Message;
import lombok.ast.MethodDeclaration;
import lombok.ast.Modifiers;
import lombok.ast.Node;
import lombok.ast.StaticInitializer;
import lombok.ast.TypeDeclaration;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.libs.com.google.common.collect.ImmutableMap;
import lombok.ast.libs.com.google.common.collect.Lists;
import lombok.ast.syntaxChecks.MessageKey;

public class KeywordChecks {
    private static final int K_PUBLIC = 1;
    private static final int K_PRIVATE = 2;
    private static final int K_PROTECTED = 4;
    private static final int K_STATIC = 8;
    private static final int K_FINAL = 16;
    private static final int K_SYNCHRONIZED = 32;
    private static final int K_VOLATILE = 64;
    private static final int K_TRANSIENT = 128;
    private static final int K_NATIVE = 256;
    private static final int K_ABSTRACT = 1024;
    private static final int K_STRICTFP = 2048;
    private static final Map<String, Integer> TO_FLAG_MAP = ImmutableMap.builder().put("private", 2).put("protected", 4).put("public", 1).put("final", 16).put("native", 256).put("strictfp", 2048).put("synchronized", 32).put("abstract", 1024).put("static", 8).put("transient", 128).put("volatile", 64).build();
    private static final int[] METHOD_MODIFIERS_EXCLUSIVITY = new int[]{6, 3, 5, 2304, 1040, 1280, 1032, 3072, 1056};
    private static final int METHOD_MODIFIERS_LEGAL = 3391;
    private static final int[] FIELD_MODIFIERS_EXCLUSIVITY = new int[]{6, 3, 5, 80};
    private static final int FIELD_MODIFIERS_LEGAL = 223;
    private static final int[] TYPE_MODIFIERS_EXCLUSIVITY = new int[]{6, 3, 5, 1040};
    private static final int TYPE_MODIFIERS_LEGAL = 3103;

    public void duplicateKeywordModifierCheck(Modifiers modifiers) {
        ArrayList<String> keywords = Lists.newArrayList();
        for (KeywordModifier n : modifiers.astKeywords()) {
            String k = n.astName();
            if (k == null || k.isEmpty()) continue;
            if (keywords.contains(k)) {
                n.addMessage(Message.error(MessageKey.MODIFIERS_DUPLICATE_KEYWORD, "Duplicate modifier: " + k));
                continue;
            }
            keywords.add(k);
        }
    }

    public void methodModifiersCheck(MethodDeclaration md) {
        this.modifiersCheck(md.astModifiers(), METHOD_MODIFIERS_EXCLUSIVITY, 3391, "method declarations");
        this.checkStaticChain(md.astModifiers());
    }

    public void annotationMethodModifiersCheck(AnnotationMethodDeclaration md) {
        this.modifiersCheck(md.astModifiers(), METHOD_MODIFIERS_EXCLUSIVITY, 1343, "annotation method declarations");
        this.checkStaticChain(md.astModifiers());
    }

    public void fieldModifiersCheck(VariableDeclaration vd) {
        TypeDeclaration td = vd.upUpToTypeDeclaration();
        if (td == null) {
            return;
        }
        VariableDefinition def = vd.astDefinition();
        if (def != null) {
            Modifiers m = def.astModifiers();
            this.modifiersCheck(m, FIELD_MODIFIERS_EXCLUSIVITY, 223, "field declarations");
            boolean allFieldsHaveInitializers = true;
            for (VariableDefinitionEntry entry : def.astVariables()) {
                if (entry.rawInitializer() != null) continue;
                allFieldsHaveInitializers = false;
                break;
            }
            if (m.isStatic() && !m.isFinal() && !allFieldsHaveInitializers) {
                this.checkStaticChain(m);
            }
        }
    }

    public void localVariableModifiersCheck(VariableDefinition vd) {
        boolean applies;
        boolean bl = applies = vd.upUpIfLocalVariableToBlock() != null;
        if (!applies) {
            boolean bl2 = applies = vd.upToForEach() != null;
        }
        if (!applies) {
            boolean bl3 = applies = vd.upToFor() != null;
        }
        if (!applies) {
            return;
        }
        this.modifiersCheck(vd.astModifiers(), new int[0], 16, "local variable declarations");
    }

    public void classDeclarationModifiersCheck(ClassDeclaration cd) {
        this.typeModifiersCheck(cd, "class declarations");
    }

    public void interfaceDeclarationModifiersCheck(InterfaceDeclaration id) {
        int flags = this.typeModifiersCheck(id, "interface declarations");
        this.generateNotAllowedKeywordError(id.astModifiers(), flags, 16, "final", "Interfaces cannot be final");
    }

    public void annotationDeclarationModifiersCheck(AnnotationDeclaration ad) {
        int flags = this.typeModifiersCheck(ad, "annotation declarations");
        this.generateNotAllowedKeywordError(ad.astModifiers(), flags, 16, "final", "Annotations cannot be final");
    }

    public void enumDeclarationModifiersCheck(EnumDeclaration ad) {
        int flags = this.typeModifiersCheck(ad, "enum declarations");
        this.generateNotAllowedKeywordError(ad.astModifiers(), flags, 16, "final", "Enums cannot be marked final");
    }

    private int typeModifiersCheck(TypeDeclaration td, String desc) {
        int flags = this.modifiersCheck(td.astModifiers(), TYPE_MODIFIERS_EXCLUSIVITY, 3103, desc);
        boolean staticWarningEmitted = false;
        if (td.upIfTopLevelToCompilationUnit() != null) {
            this.generateNotAllowedKeywordError(td.astModifiers(), flags, 2, "private", "Top-level types cannot be private.");
            staticWarningEmitted |= this.generateNotAllowedKeywordError(td.astModifiers(), flags, 8, "static", "Top-level types cannot be static.");
        } else if (td.upToBlock() != null) {
            this.generateNotAllowedKeywordError(td.astModifiers(), flags, 2, "private", "Method-local types cannot be private.");
            this.generateNotAllowedKeywordError(td.astModifiers(), flags, 4, "protected", "Method-local types cannot be protected.");
            this.generateNotAllowedKeywordError(td.astModifiers(), flags, 1, "public", "Method-local types cannot be public.");
            staticWarningEmitted |= this.generateNotAllowedKeywordError(td.astModifiers(), flags, 8, "static", "Method-local types cannot be static.");
        }
        if (!staticWarningEmitted) {
            this.checkStaticChain(td.astModifiers());
        }
        return flags;
    }

    public void checkStaticInitializerInNonStaticType(StaticInitializer node) {
        TypeDeclaration parent = node.upUpToTypeDeclaration();
        if (parent != null && !parent.astModifiers().isStatic()) {
            node.addMessage(Message.error(MessageKey.INITIALIZER_STATIC_IN_NON_STATIC_TYPE, "static initializers are only allowed in top-level or static types declarations."));
        }
    }

    private void checkStaticChain(Modifiers modifiers) {
        if (!modifiers.isStatic()) {
            return;
        }
        for (Node p = modifiers.getParent(); p != null; p = p.getParent()) {
            Modifiers pMods;
            if (p instanceof CompilationUnit) {
                return;
            }
            if (!(p instanceof TypeDeclaration) || (pMods = ((TypeDeclaration)p).astModifiers()).isStatic()) continue;
            modifiers.getParent().addMessage(Message.error(MessageKey.MODIFIERS_STATIC_CHAIN, "This declaration is (effectively) static; static declarations or only legal in top-level and static declarations."));
        }
    }

    private int modifiersCheck(Modifiers modifiers, int[] exclusivity, int legality, String desc) {
        int flags = modifiers.getEffectiveModifierFlags();
        int implicits = flags & ~modifiers.getExplicitModifierFlags();
        for (Node n : modifiers.rawKeywords()) {
            if (!(n instanceof KeywordModifier)) continue;
            String k = ((KeywordModifier)n).astName();
            if (k == null || k.isEmpty()) {
                n.addMessage(Message.error(MessageKey.MODIFIERS_EMPTY_MODIFIER, "Empty/null modifier."));
            }
            if (!TO_FLAG_MAP.containsKey(k)) {
                n.addMessage(Message.error(MessageKey.MODIFIERS_UNKNOWN_MODIFIER, "Unknown modifier: " + k));
                continue;
            }
            int flag = TO_FLAG_MAP.get(k);
            if ((legality & flag) == 0) {
                n.addMessage(Message.error(MessageKey.MODIFIERS_MODIFIER_NOT_ALLOWED, "Modifier not allowed on " + desc + ": " + k));
                continue;
            }
            flags |= flag;
        }
        for (int exclusive : exclusivity) {
            if ((flags & exclusive) != exclusive) continue;
            this.generateExclusivityError(implicits, exclusive, modifiers);
        }
        return flags;
    }

    private boolean generateNotAllowedKeywordError(Modifiers modifiers, int flags, int flag, String keyword, String error) {
        if ((flags & flag) == 0) {
            return false;
        }
        for (KeywordModifier n : modifiers.astKeywords()) {
            if (!keyword.equals(n.astName())) continue;
            n.addMessage(Message.error(MessageKey.MODIFIERS_MODIFIER_NOT_ALLOWED, error));
            return true;
        }
        return false;
    }

    public void emptyDeclarationMustHaveNoModifiers(EmptyDeclaration node) {
        Modifiers modifiers = node.astModifiers();
        if (!modifiers.astKeywords().isEmpty() || !modifiers.astAnnotations().isEmpty()) {
            node.addMessage(Message.error(MessageKey.MODIFIERS_MODIFIER_NOT_ALLOWED, "Empty Declarations cannot have modifiers."));
        }
    }

    private void generateExclusivityError(int implicit, int exclusive, Modifiers modifiers) {
        String hit = null;
        int responsibleImplicit = implicit & exclusive;
        if (responsibleImplicit != 0) {
            String nameOfResponsibleImplicit = "(unknown)";
            for (Map.Entry<String, Integer> x : TO_FLAG_MAP.entrySet()) {
                if (x.getValue() != responsibleImplicit) continue;
                nameOfResponsibleImplicit = x.getKey();
            }
            for (Node n : modifiers.rawKeywords()) {
                int f;
                String k;
                if (!(n instanceof KeywordModifier) || !TO_FLAG_MAP.containsKey(k = ((KeywordModifier)n).astName()) || ((f = TO_FLAG_MAP.get(k).intValue()) & exclusive) == 0) continue;
                modifiers.addMessage(Message.error(MessageKey.MODIFIERS_MODIFIER_CONFLICT, String.format("Modifier %s cannot be used here; it is already implicitly %s.", k, nameOfResponsibleImplicit)));
            }
        } else {
            for (Node n : modifiers.rawKeywords()) {
                int f;
                String k;
                if (!(n instanceof KeywordModifier) || !TO_FLAG_MAP.containsKey(k = ((KeywordModifier)n).astName()) || ((f = TO_FLAG_MAP.get(k).intValue()) & exclusive) == 0) continue;
                if (hit == null) {
                    hit = k;
                    continue;
                }
                modifiers.addMessage(Message.error(MessageKey.MODIFIERS_MODIFIER_CONFLICT, String.format("Modifier %s cannot be used together with %s here.", k, hit)));
            }
        }
    }
}

