/*
 * Decompiled with CFR 0.152.
 */
package lombok.delombok;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import javax.tools.JavaFileObject;
import lombok.delombok.Comment;
import lombok.delombok.PrettyCommentsPrinter;

public class DelombokResult {
    private final List<Comment> comments;
    private final JCTree.JCCompilationUnit compilationUnit;
    private final boolean changed;

    public DelombokResult(List<Comment> comments, JCTree.JCCompilationUnit compilationUnit, boolean changed) {
        this.comments = comments;
        this.compilationUnit = compilationUnit;
        this.changed = changed;
    }

    public void print(Writer out) throws IOException {
        JavaFileObject sourceFile;
        if (!this.changed && (sourceFile = this.compilationUnit.getSourceFile()) != null) {
            out.write(((Object)sourceFile.getCharContent(true)).toString());
            return;
        }
        out.write("// Generated by delombok at ");
        out.write(String.valueOf(new Date()));
        out.write(System.getProperty("line.separator"));
        this.compilationUnit.accept(new PrettyCommentsPrinter(out, this.compilationUnit, this.comments));
    }

    public boolean isChanged() {
        return this.changed;
    }
}

