/*
 * Decompiled with CFR 0.152.
 */
package lombok.delombok.java6;

import com.sun.tools.javac.parser.Scanner;
import java.nio.CharBuffer;
import lombok.delombok.Comment;
import lombok.delombok.Delombok;
import lombok.delombok.java6.CommentCollectingScannerFactory;

public class CommentCollectingScanner
extends Scanner {
    private final Delombok.Comments comments;
    private int endComment = 0;

    public CommentCollectingScanner(CommentCollectingScannerFactory factory, CharBuffer charBuffer, Delombok.Comments comments) {
        super((Scanner.Factory)factory, charBuffer);
        this.comments = comments;
    }

    public CommentCollectingScanner(CommentCollectingScannerFactory factory, char[] input, int inputLength, Delombok.Comments comments) {
        super((Scanner.Factory)factory, input, inputLength);
        this.comments = comments;
    }

    protected void processComment(Scanner.CommentStyle style) {
        int endPos;
        int prevEndPos = Math.max(this.prevEndPos(), this.endComment);
        int pos = this.pos();
        this.endComment = endPos = this.endPos();
        String content = new String(this.getRawCharacters(pos, endPos));
        Comment.StartConnection start = this.determineStartConnection(prevEndPos, pos);
        Comment.EndConnection end = this.determineEndConnection(endPos);
        Comment comment = new Comment(prevEndPos, pos, endPos, content, start, end);
        this.comments.add(comment);
    }

    private Comment.EndConnection determineEndConnection(int pos) {
        boolean first = true;
        int i = pos;
        char c;
        while (!this.isNewLine(c = this.getRawCharacters(i, i + 1)[0])) {
            if (!Character.isWhitespace(c)) {
                return first ? Comment.EndConnection.DIRECT_AFTER_COMMENT : Comment.EndConnection.AFTER_COMMENT;
            }
            first = false;
            ++i;
        }
        return Comment.EndConnection.ON_NEXT_LINE;
    }

    private Comment.StartConnection determineStartConnection(int from, int to) {
        if (from == to) {
            return Comment.StartConnection.DIRECT_AFTER_PREVIOUS;
        }
        char[] between = this.getRawCharacters(from, to);
        if (this.isNewLine(between[between.length - 1])) {
            return Comment.StartConnection.START_OF_LINE;
        }
        for (char c : between) {
            if (!this.isNewLine(c)) continue;
            return Comment.StartConnection.ON_NEXT_LINE;
        }
        return Comment.StartConnection.AFTER_PREVIOUS;
    }

    private boolean isNewLine(char c) {
        return c == '\n' || c == '\r';
    }
}

