/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.TypeLibrary;
import lombok.core.TypeResolver;
import lombok.eclipse.EclipseAST;
import lombok.eclipse.EclipseNode;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Literal;
import org.eclipse.jdt.internal.compiler.ast.MarkerAnnotation;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Eclipse {
    public static final int ECLIPSE_DO_NOT_TOUCH_FLAG = 0x800000;
    private static final String DEFAULT_BUNDLE = "org.eclipse.jdt.core";
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private static Field generatedByField;
    private static Map<ASTNode, ASTNode> generatedNodes;

    private Eclipse() {
    }

    public static void error(CompilationUnitDeclaration cud, String message, Throwable error) {
        Eclipse.error(cud, message, null, error);
    }

    public static void error(CompilationUnitDeclaration cud, String message, String bundleName, Throwable error) {
        if (bundleName == null) {
            bundleName = DEFAULT_BUNDLE;
        }
        try {
            new EclipseWorkspaceLogger().error(message, bundleName, error);
        }
        catch (NoClassDefFoundError e) {
            new TerminalLogger().error(message, bundleName, error);
        }
        if (cud != null) {
            EclipseAST.addProblemToCompilationResult(cud, false, message + " - See error log.", 0, 0);
        }
    }

    public static void warning(String message, Throwable error) {
        Eclipse.warning(message, null, error);
    }

    public static void warning(String message, String bundleName, Throwable error) {
        if (bundleName == null) {
            bundleName = DEFAULT_BUNDLE;
        }
        try {
            new EclipseWorkspaceLogger().warning(message, bundleName, error);
        }
        catch (NoClassDefFoundError e) {
            new TerminalLogger().warning(message, bundleName, error);
        }
    }

    public static String toQualifiedName(char[][] typeName) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (char[] c : typeName) {
            sb.append(first ? "" : ".").append(c);
            first = false;
        }
        return sb.toString();
    }

    public static char[][] fromQualifiedName(String typeName) {
        String[] split = typeName.split("\\.");
        char[][] result = new char[split.length][];
        for (int i = 0; i < split.length; ++i) {
            result[i] = split[i].toCharArray();
        }
        return result;
    }

    public static TypeParameter[] copyTypeParams(TypeParameter[] params, ASTNode source) {
        if (params == null) {
            return null;
        }
        TypeParameter[] out = new TypeParameter[params.length];
        int idx = 0;
        for (TypeParameter param : params) {
            TypeParameter o = new TypeParameter();
            Eclipse.setGeneratedBy((ASTNode)o, source);
            o.annotations = param.annotations;
            o.bits = param.bits;
            o.modifiers = param.modifiers;
            o.name = param.name;
            o.type = Eclipse.copyType(param.type, source);
            o.sourceStart = param.sourceStart;
            o.sourceEnd = param.sourceEnd;
            o.declarationEnd = param.declarationEnd;
            o.declarationSourceStart = param.declarationSourceStart;
            o.declarationSourceEnd = param.declarationSourceEnd;
            if (param.bounds != null) {
                TypeReference[] b = new TypeReference[param.bounds.length];
                int idx2 = 0;
                for (TypeReference ref : param.bounds) {
                    b[idx2++] = Eclipse.copyType(ref, source);
                }
                o.bounds = b;
            }
            out[idx++] = o;
        }
        return out;
    }

    public static TypeReference[] copyTypes(TypeReference[] refs, ASTNode source) {
        if (refs == null) {
            return null;
        }
        TypeReference[] outs = new TypeReference[refs.length];
        int idx = 0;
        for (TypeReference ref : refs) {
            outs[idx++] = Eclipse.copyType(ref, source);
        }
        return outs;
    }

    public static TypeReference copyType(TypeReference ref, ASTNode source) {
        if (ref instanceof ParameterizedQualifiedTypeReference) {
            ParameterizedQualifiedTypeReference iRef = (ParameterizedQualifiedTypeReference)ref;
            TypeReference[][] args = null;
            if (iRef.typeArguments != null) {
                args = new TypeReference[iRef.typeArguments.length][];
                int idx = 0;
                for (TypeReference[] inRefArray : iRef.typeArguments) {
                    if (inRefArray == null) {
                        args[idx++] = null;
                        continue;
                    }
                    TypeReference[] outRefArray = new TypeReference[inRefArray.length];
                    int idx2 = 0;
                    for (TypeReference inRef : inRefArray) {
                        outRefArray[idx2++] = Eclipse.copyType(inRef, source);
                    }
                    args[idx++] = outRefArray;
                }
            }
            ParameterizedQualifiedTypeReference typeRef = new ParameterizedQualifiedTypeReference(iRef.tokens, args, iRef.dimensions(), iRef.sourcePositions);
            Eclipse.setGeneratedBy((ASTNode)typeRef, source);
            return typeRef;
        }
        if (ref instanceof ArrayQualifiedTypeReference) {
            ArrayQualifiedTypeReference iRef = (ArrayQualifiedTypeReference)ref;
            ArrayQualifiedTypeReference typeRef = new ArrayQualifiedTypeReference(iRef.tokens, iRef.dimensions(), iRef.sourcePositions);
            Eclipse.setGeneratedBy((ASTNode)typeRef, source);
            return typeRef;
        }
        if (ref instanceof QualifiedTypeReference) {
            QualifiedTypeReference iRef = (QualifiedTypeReference)ref;
            QualifiedTypeReference typeRef = new QualifiedTypeReference(iRef.tokens, iRef.sourcePositions);
            Eclipse.setGeneratedBy((ASTNode)typeRef, source);
            return typeRef;
        }
        if (ref instanceof ParameterizedSingleTypeReference) {
            ParameterizedSingleTypeReference iRef = (ParameterizedSingleTypeReference)ref;
            TypeReference[] args = null;
            if (iRef.typeArguments != null) {
                args = new TypeReference[iRef.typeArguments.length];
                int idx = 0;
                for (TypeReference inRef : iRef.typeArguments) {
                    args[idx++] = inRef == null ? null : Eclipse.copyType(inRef, source);
                }
            }
            ParameterizedSingleTypeReference typeRef = new ParameterizedSingleTypeReference(iRef.token, args, iRef.dimensions(), (long)iRef.sourceStart << 32 | (long)iRef.sourceEnd);
            Eclipse.setGeneratedBy((ASTNode)typeRef, source);
            return typeRef;
        }
        if (ref instanceof ArrayTypeReference) {
            ArrayTypeReference iRef = (ArrayTypeReference)ref;
            ArrayTypeReference typeRef = new ArrayTypeReference(iRef.token, iRef.dimensions(), (long)iRef.sourceStart << 32 | (long)iRef.sourceEnd);
            Eclipse.setGeneratedBy((ASTNode)typeRef, source);
            return typeRef;
        }
        if (ref instanceof Wildcard) {
            Wildcard original = (Wildcard)ref;
            Wildcard wildcard = new Wildcard(original.kind);
            wildcard.sourceStart = original.sourceStart;
            wildcard.sourceEnd = original.sourceEnd;
            if (original.bound != null) {
                wildcard.bound = Eclipse.copyType(original.bound, source);
            }
            Eclipse.setGeneratedBy((ASTNode)wildcard, source);
            return wildcard;
        }
        if (ref instanceof SingleTypeReference) {
            SingleTypeReference iRef = (SingleTypeReference)ref;
            SingleTypeReference typeRef = new SingleTypeReference(iRef.token, (long)iRef.sourceStart << 32 | (long)iRef.sourceEnd);
            Eclipse.setGeneratedBy((ASTNode)typeRef, source);
            return typeRef;
        }
        return ref;
    }

    public static long pos(ASTNode node) {
        return (long)node.sourceStart << 32 | (long)node.sourceEnd & 0xFFFFFFFFL;
    }

    public static long[] poss(ASTNode node, int repeat) {
        long p = (long)node.sourceStart << 32 | (long)node.sourceEnd & 0xFFFFFFFFL;
        long[] out = new long[repeat];
        Arrays.fill(out, p);
        return out;
    }

    public static TypeReference makeType(TypeBinding binding, ASTNode pos, boolean allowCompound) {
        ParameterizedSingleTypeReference result;
        char[][] parts;
        int dims = binding.dimensions();
        binding = binding.leafComponentType();
        char[] base = null;
        switch (binding.id) {
            case 10: {
                base = TypeConstants.INT;
                break;
            }
            case 7: {
                base = TypeConstants.LONG;
                break;
            }
            case 4: {
                base = TypeConstants.SHORT;
                break;
            }
            case 3: {
                base = TypeConstants.BYTE;
                break;
            }
            case 8: {
                base = TypeConstants.DOUBLE;
                break;
            }
            case 9: {
                base = TypeConstants.FLOAT;
                break;
            }
            case 5: {
                base = TypeConstants.BOOLEAN;
                break;
            }
            case 2: {
                base = TypeConstants.CHAR;
                break;
            }
            case 6: {
                base = TypeConstants.VOID;
                break;
            }
            case 12: {
                return null;
            }
        }
        if (base != null) {
            if (dims > 0) {
                ArrayTypeReference result2 = new ArrayTypeReference(base, dims, Eclipse.pos(pos));
                Eclipse.setGeneratedBy((ASTNode)result2, pos);
                return result2;
            }
            SingleTypeReference result3 = new SingleTypeReference(base, Eclipse.pos(pos));
            Eclipse.setGeneratedBy((ASTNode)result3, pos);
            return result3;
        }
        if (binding.isAnonymousType()) {
            ReferenceBinding ref = (ReferenceBinding)binding;
            ReferenceBinding[] supers = ref.superInterfaces();
            if (supers == null || supers.length == 0) {
                supers = new ReferenceBinding[]{ref.superclass()};
            }
            if (supers[0] == null) {
                QualifiedTypeReference result4 = new QualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT, Eclipse.poss(pos, 3));
                Eclipse.setGeneratedBy((ASTNode)result4, pos);
                return result4;
            }
            return Eclipse.makeType((TypeBinding)supers[0], pos, false);
        }
        if (binding instanceof CaptureBinding) {
            return Eclipse.makeType((TypeBinding)((CaptureBinding)binding).wildcard, pos, allowCompound);
        }
        if (binding.isUnboundWildcard()) {
            if (!allowCompound) {
                QualifiedTypeReference result5 = new QualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT, Eclipse.poss(pos, 3));
                Eclipse.setGeneratedBy((ASTNode)result5, pos);
                return result5;
            }
            Wildcard out = new Wildcard(0);
            Eclipse.setGeneratedBy((ASTNode)out, pos);
            out.sourceStart = pos.sourceStart;
            out.sourceEnd = pos.sourceEnd;
            return out;
        }
        if (binding.isWildcard()) {
            WildcardBinding wildcard = (WildcardBinding)binding;
            if (wildcard.boundKind == 1) {
                if (!allowCompound) {
                    return Eclipse.makeType(wildcard.bound, pos, false);
                }
                Wildcard out = new Wildcard(1);
                Eclipse.setGeneratedBy((ASTNode)out, pos);
                out.bound = Eclipse.makeType(wildcard.bound, pos, false);
                out.sourceStart = pos.sourceStart;
                out.sourceEnd = pos.sourceEnd;
                return out;
            }
            if (allowCompound && wildcard.boundKind == 2) {
                Wildcard out = new Wildcard(2);
                Eclipse.setGeneratedBy((ASTNode)out, pos);
                out.bound = Eclipse.makeType(wildcard.bound, pos, false);
                out.sourceStart = pos.sourceStart;
                out.sourceEnd = pos.sourceEnd;
                return out;
            }
            QualifiedTypeReference result6 = new QualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT, Eclipse.poss(pos, 3));
            Eclipse.setGeneratedBy((ASTNode)result6, pos);
            return result6;
        }
        if (binding.isLocalType() || binding.isTypeVariable()) {
            parts = new char[][]{binding.shortReadableName()};
        } else {
            int ptr;
            String[] pkg = new String(binding.qualifiedPackageName()).split("\\.");
            String[] name = new String(binding.qualifiedSourceName()).split("\\.");
            if (pkg.length == 1 && pkg[0].isEmpty()) {
                pkg = new String[]{};
            }
            parts = new char[pkg.length + name.length][];
            for (ptr = 0; ptr < pkg.length; ++ptr) {
                parts[ptr] = pkg[ptr].toCharArray();
            }
            while (ptr < pkg.length + name.length) {
                parts[ptr] = name[ptr - pkg.length].toCharArray();
                ++ptr;
            }
        }
        TypeReference[] params = new TypeReference[]{};
        if (binding instanceof ParameterizedTypeBinding) {
            ParameterizedTypeBinding paramized = (ParameterizedTypeBinding)binding;
            if (paramized.arguments != null) {
                params = new TypeReference[paramized.arguments.length];
                for (int i = 0; i < params.length; ++i) {
                    params[i] = Eclipse.makeType(paramized.arguments[i], pos, true);
                }
            }
        }
        if (params.length > 0) {
            if (parts.length > 1) {
                TypeReference[][] typeArguments = new TypeReference[parts.length][];
                typeArguments[typeArguments.length - 1] = params;
                ParameterizedQualifiedTypeReference result7 = new ParameterizedQualifiedTypeReference((char[][])parts, (TypeReference[][])typeArguments, dims, Eclipse.poss(pos, parts.length));
                Eclipse.setGeneratedBy((ASTNode)result7, pos);
                return result7;
            }
            result = new ParameterizedSingleTypeReference(parts[0], params, dims, Eclipse.pos(pos));
            Eclipse.setGeneratedBy((ASTNode)result, pos);
            return result;
        }
        if (dims > 0) {
            if (parts.length > 1) {
                result = new ArrayQualifiedTypeReference((char[][])parts, dims, Eclipse.poss(pos, parts.length));
                Eclipse.setGeneratedBy((ASTNode)result, pos);
                return result;
            }
            result = new ArrayTypeReference(parts[0], dims, Eclipse.pos(pos));
            Eclipse.setGeneratedBy((ASTNode)result, pos);
            return result;
        }
        if (parts.length > 1) {
            result = new QualifiedTypeReference((char[][])parts, Eclipse.poss(pos, parts.length));
            Eclipse.setGeneratedBy((ASTNode)result, pos);
            return result;
        }
        result = new SingleTypeReference(parts[0], Eclipse.pos(pos));
        Eclipse.setGeneratedBy((ASTNode)result, pos);
        return result;
    }

    public static Annotation[] copyAnnotations(ASTNode source, Annotation[] ... allAnnotations) {
        boolean allNull = true;
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Annotation[] annotations : allAnnotations) {
            if (annotations == null) continue;
            allNull = false;
            for (Annotation annotation : annotations) {
                result.add(Eclipse.copyAnnotation(annotation, source));
            }
        }
        if (allNull) {
            return null;
        }
        return result.toArray(EMPTY_ANNOTATION_ARRAY);
    }

    public static Annotation copyAnnotation(Annotation annotation, ASTNode source) {
        int pS = source.sourceStart;
        int pE = source.sourceEnd;
        if (annotation instanceof MarkerAnnotation) {
            MarkerAnnotation ann = new MarkerAnnotation(Eclipse.copyType(annotation.type, source), pS);
            Eclipse.setGeneratedBy((ASTNode)ann, source);
            ann.sourceEnd = ann.statementEnd = pE;
            ann.declarationSourceEnd = ann.statementEnd;
            return ann;
        }
        if (annotation instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation ann = new SingleMemberAnnotation(Eclipse.copyType(annotation.type, source), pS);
            Eclipse.setGeneratedBy((ASTNode)ann, source);
            ann.sourceEnd = ann.statementEnd = pE;
            ann.declarationSourceEnd = ann.statementEnd;
            ann.memberValue = ((SingleMemberAnnotation)annotation).memberValue;
            return ann;
        }
        if (annotation instanceof NormalAnnotation) {
            NormalAnnotation ann = new NormalAnnotation(Eclipse.copyType(annotation.type, source), pS);
            Eclipse.setGeneratedBy((ASTNode)ann, source);
            ann.statementEnd = ann.sourceEnd = pE;
            ann.declarationSourceEnd = ann.sourceEnd;
            ann.memberValuePairs = ((NormalAnnotation)annotation).memberValuePairs;
            return ann;
        }
        return annotation;
    }

    public static boolean annotationTypeMatches(Class<? extends java.lang.annotation.Annotation> type, EclipseNode node) {
        if (node.getKind() != AST.Kind.ANNOTATION) {
            return false;
        }
        return Eclipse.typeMatches(type, node, ((Annotation)node.get()).type);
    }

    public static boolean typeMatches(Class<?> type, EclipseNode node, TypeReference typeRef) {
        String lastPartB;
        if (typeRef == null || typeRef.getTypeName() == null || typeRef.getTypeName().length == 0) {
            return false;
        }
        String lastPartA = new String(typeRef.getTypeName()[typeRef.getTypeName().length - 1]);
        if (!lastPartA.equals(lastPartB = type.getSimpleName())) {
            return false;
        }
        String typeName = Eclipse.toQualifiedName(typeRef.getTypeName());
        TypeLibrary library = new TypeLibrary();
        library.addType(type.getName());
        TypeResolver resolver = new TypeResolver(library, node.getPackageDeclaration(), node.getImportStatements());
        Collection<String> typeMatches = resolver.findTypeMatches(node, typeName);
        for (String match : typeMatches) {
            if (!match.equals(type.getName())) continue;
            return true;
        }
        return false;
    }

    public static <A extends java.lang.annotation.Annotation> AnnotationValues<A> createAnnotation(Class<A> type, final EclipseNode annotationNode) {
        final Annotation annotation = (Annotation)annotationNode.get();
        HashMap<String, AnnotationValues.AnnotationValue> values = new HashMap<String, AnnotationValues.AnnotationValue>();
        MemberValuePair[] pairs = annotation.memberValuePairs();
        for (Method m : type.getDeclaredMethods()) {
            boolean isExplicit;
            if (!Modifier.isPublic(m.getModifiers())) continue;
            String name = m.getName();
            ArrayList<String> raws = new ArrayList<String>();
            ArrayList<Expression> expressionValues = new ArrayList<Expression>();
            ArrayList<Object> guesses = new ArrayList<Object>();
            Expression fullExpression = null;
            Expression[] expressions = null;
            if (pairs != null) {
                for (MemberValuePair pair : pairs) {
                    String mName;
                    char[] n = pair.name;
                    String string = mName = n == null ? "value" : new String(pair.name);
                    if (!mName.equals(name)) continue;
                    fullExpression = pair.value;
                }
            }
            boolean bl = isExplicit = fullExpression != null;
            if (isExplicit && (expressions = fullExpression instanceof ArrayInitializer ? ((ArrayInitializer)fullExpression).expressions : new Expression[]{fullExpression}) != null) {
                for (Expression ex : expressions) {
                    StringBuffer sb = new StringBuffer();
                    ex.print(0, sb);
                    raws.add(sb.toString());
                    expressionValues.add(ex);
                    guesses.add(Eclipse.calculateValue(ex));
                }
            }
            final Expression fullExpr = fullExpression;
            final Expression[] exprs = expressions;
            values.put(name, new AnnotationValues.AnnotationValue(annotationNode, raws, expressionValues, guesses, isExplicit){

                public void setError(String message, int valueIdx) {
                    Expression ex;
                    if (valueIdx == -1) {
                        ex = fullExpr;
                    } else {
                        Expression expression = ex = exprs != null ? exprs[valueIdx] : null;
                    }
                    if (ex == null) {
                        ex = annotation;
                    }
                    int sourceStart = ex.sourceStart;
                    int sourceEnd = ex.sourceEnd;
                    annotationNode.addError(message, sourceStart, sourceEnd);
                }

                public void setWarning(String message, int valueIdx) {
                    Expression ex;
                    if (valueIdx == -1) {
                        ex = fullExpr;
                    } else {
                        Expression expression = ex = exprs != null ? exprs[valueIdx] : null;
                    }
                    if (ex == null) {
                        ex = annotation;
                    }
                    int sourceStart = ex.sourceStart;
                    int sourceEnd = ex.sourceEnd;
                    annotationNode.addWarning(message, sourceStart, sourceEnd);
                }
            });
        }
        return new AnnotationValues<A>(type, values, annotationNode);
    }

    private static Object calculateValue(Expression e) {
        if (e instanceof Literal) {
            ((Literal)e).computeConstant();
            switch (e.constant.typeID()) {
                case 10: {
                    return e.constant.intValue();
                }
                case 3: {
                    return e.constant.byteValue();
                }
                case 4: {
                    return e.constant.shortValue();
                }
                case 2: {
                    return Character.valueOf(e.constant.charValue());
                }
                case 9: {
                    return Float.valueOf(e.constant.floatValue());
                }
                case 8: {
                    return e.constant.doubleValue();
                }
                case 5: {
                    return e.constant.booleanValue();
                }
                case 7: {
                    return e.constant.longValue();
                }
                case 11: {
                    return e.constant.stringValue();
                }
            }
            return null;
        }
        if (e instanceof ClassLiteralAccess) {
            return Eclipse.toQualifiedName(((ClassLiteralAccess)e).type.getTypeName());
        }
        if (e instanceof SingleNameReference) {
            return new String(((SingleNameReference)e).token);
        }
        if (e instanceof QualifiedNameReference) {
            String qName = Eclipse.toQualifiedName(((QualifiedNameReference)e).tokens);
            int idx = qName.lastIndexOf(46);
            return idx == -1 ? qName : qName.substring(idx + 1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ASTNode getGeneratedBy(ASTNode node) {
        if (generatedByField != null) {
            try {
                return (ASTNode)generatedByField.get(node);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Map<ASTNode, ASTNode> map = generatedNodes;
        synchronized (map) {
            return generatedNodes.get(node);
        }
    }

    public static boolean isGenerated(ASTNode node) {
        return Eclipse.getGeneratedBy(node) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ASTNode setGeneratedBy(ASTNode node, ASTNode source) {
        if (generatedByField != null) {
            try {
                generatedByField.set(node, source);
                return node;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Map<ASTNode, ASTNode> map = generatedNodes;
        synchronized (map) {
            generatedNodes.put(node, source);
        }
        return node;
    }

    static {
        try {
            generatedByField = ASTNode.class.getDeclaredField("$generatedBy");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        generatedNodes = new WeakHashMap<ASTNode, ASTNode>();
    }

    private static class EclipseWorkspaceLogger {
        private EclipseWorkspaceLogger() {
        }

        void error(String message, String bundleName, Throwable error) {
            this.msg(4, message, bundleName, error);
        }

        void warning(String message, String bundleName, Throwable error) {
            this.msg(2, message, bundleName, error);
        }

        private void msg(int msgType, String message, String bundleName, Throwable error) {
            Bundle bundle = Platform.getBundle((String)bundleName);
            if (bundle == null) {
                System.err.printf("Can't find bundle %s while trying to report error:\n%s\n", bundleName, message);
                return;
            }
            ILog log = Platform.getLog((Bundle)bundle);
            log.log((IStatus)new Status(msgType, bundleName, message, error));
        }
    }

    private static class TerminalLogger {
        private TerminalLogger() {
        }

        void error(String message, String bundleName, Throwable error) {
            System.err.println(message);
            if (error != null) {
                error.printStackTrace();
            }
        }

        void warning(String message, String bundleName, Throwable error) {
            System.err.println(message);
            if (error != null) {
                error.printStackTrace();
            }
        }
    }
}

