/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTags;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.Collection;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVisitor;
import lombok.AccessLevel;
import lombok.Setter;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.handlers.TransformationsUtil;
import lombok.javac.Javac;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.handlers.JavacHandlerUtil;

public class HandleSetter
extends JavacAnnotationHandler<Setter> {
    public void generateSetterForType(JavacNode typeNode, JavacNode errorNode, AccessLevel level, boolean checkForTypeLevelSetter) {
        boolean notAClass;
        if (checkForTypeLevelSetter && typeNode != null) {
            for (JavacNode child : typeNode.down()) {
                if (child.getKind() != AST.Kind.ANNOTATION || !Javac.annotationTypeMatches(Setter.class, child)) continue;
                return;
            }
        }
        JCTree.JCClassDecl typeDecl = null;
        if (typeNode.get() instanceof JCTree.JCClassDecl) {
            typeDecl = (JCTree.JCClassDecl)typeNode.get();
        }
        long modifiers = typeDecl == null ? 0L : typeDecl.mods.flags;
        boolean bl = notAClass = (modifiers & 0x6200L) != 0L;
        if (typeDecl == null || notAClass) {
            errorNode.addError("@Setter is only supported on a class or a field.");
            return;
        }
        for (JavacNode field : typeNode.down()) {
            if (field.getKind() != AST.Kind.FIELD) continue;
            JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)field.get();
            if (fieldDecl.name.toString().startsWith("$") || (fieldDecl.mods.flags & 8L) != 0L || (fieldDecl.mods.flags & 0x10L) != 0L) continue;
            this.generateSetterForField(field, (JCDiagnostic.DiagnosticPosition)errorNode.get(), level);
        }
    }

    public void generateSetterForField(JavacNode fieldNode, JCDiagnostic.DiagnosticPosition pos, AccessLevel level) {
        for (JavacNode child : fieldNode.down()) {
            if (child.getKind() != AST.Kind.ANNOTATION || !Javac.annotationTypeMatches(Setter.class, child)) continue;
            return;
        }
        this.createSetterForField(level, fieldNode, fieldNode, false);
    }

    @Override
    public void handle(AnnotationValues<Setter> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        Collection<JavacNode> fields = annotationNode.upFromAnnotationToFields();
        JavacHandlerUtil.deleteAnnotationIfNeccessary(annotationNode, Setter.class);
        JavacHandlerUtil.deleteImportFromCompilationUnit(annotationNode, "lombok.AccessLevel");
        JavacNode node = (JavacNode)annotationNode.up();
        AccessLevel level = annotation.getInstance().value();
        if (level == AccessLevel.NONE || node == null) {
            return;
        }
        switch (node.getKind()) {
            case FIELD: {
                this.createSetterForFields(level, fields, annotationNode, true);
                break;
            }
            case TYPE: {
                this.generateSetterForType(node, annotationNode, level, false);
            }
        }
    }

    private void createSetterForFields(AccessLevel level, Collection<JavacNode> fieldNodes, JavacNode errorNode, boolean whineIfExists) {
        for (JavacNode fieldNode : fieldNodes) {
            this.createSetterForField(level, fieldNode, errorNode, whineIfExists);
        }
    }

    private void createSetterForField(AccessLevel level, JavacNode fieldNode, JavacNode source, boolean whineIfExists) {
        if (fieldNode.getKind() != AST.Kind.FIELD) {
            fieldNode.addError("@Setter is only supported on a class or a field.");
            return;
        }
        JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)fieldNode.get();
        String methodName = JavacHandlerUtil.toSetterName(fieldDecl);
        for (String altName : JavacHandlerUtil.toAllSetterNames(fieldDecl)) {
            switch (JavacHandlerUtil.methodExists(altName, fieldNode, false)) {
                case EXISTS_BY_LOMBOK: {
                    return;
                }
                case EXISTS_BY_USER: {
                    if (whineIfExists) {
                        String altNameExpl = "";
                        if (!altName.equals(methodName)) {
                            altNameExpl = String.format(" (%s)", altName);
                        }
                        source.addWarning(String.format("Not generating %s(): A method with that name already exists%s", methodName, altNameExpl));
                    }
                    return;
                }
            }
        }
        long access = (long)JavacHandlerUtil.toJavacModifier(level) | fieldDecl.mods.flags & 8L;
        JavacHandlerUtil.injectMethod((JavacNode)fieldNode.up(), this.createSetter(access, fieldNode, fieldNode.getTreeMaker(), (JCTree)source.get()));
    }

    private JCTree.JCMethodDecl createSetter(long access, JavacNode field, TreeMaker treeMaker, JCTree source) {
        JCTree.JCStatement nullCheck;
        JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)field.get();
        JCTree.JCExpression fieldRef = JavacHandlerUtil.createFieldAccessor(treeMaker, field, JavacHandlerUtil.FieldAccess.ALWAYS_FIELD);
        JCTree.JCAssign assign = treeMaker.Assign(fieldRef, treeMaker.Ident(fieldDecl.name));
        List<JCTree.JCAnnotation> nonNulls = JavacHandlerUtil.findAnnotations(field, TransformationsUtil.NON_NULL_PATTERN);
        List<JCTree.JCAnnotation> nullables = JavacHandlerUtil.findAnnotations(field, TransformationsUtil.NULLABLE_PATTERN);
        List<JCTree.JCStatement> statements = nonNulls.isEmpty() ? List.of(treeMaker.Exec(assign)) : ((nullCheck = JavacHandlerUtil.generateNullCheck(treeMaker, field)) != null ? List.of(nullCheck, treeMaker.Exec(assign)) : List.of(treeMaker.Exec(assign)));
        JCTree.JCBlock methodBody = treeMaker.Block(0L, statements);
        Name methodName = field.toName(JavacHandlerUtil.toSetterName(fieldDecl));
        List<JCTree.JCAnnotation> annsOnParam = nonNulls.appendList(nullables);
        JCTree.JCVariableDecl param = treeMaker.VarDef(treeMaker.Modifiers(16L, annsOnParam), fieldDecl.name, fieldDecl.vartype, null);
        JCTree.JCExpression methodType = treeMaker.Type(new JCNoType(Javac.getCtcInt(TypeTags.class, "VOID")));
        List<JCTree.JCTypeParameter> methodGenericParams = List.nil();
        List<JCTree.JCVariableDecl> parameters = List.of(param);
        List<JCTree.JCExpression> throwsClauses = List.nil();
        JCTree.JCExpression annotationMethodDefaultValue = null;
        return Javac.recursiveSetGeneratedBy(treeMaker.MethodDef(treeMaker.Modifiers(access, List.<JCTree.JCAnnotation>nil()), methodName, methodType, methodGenericParams, parameters, throwsClauses, methodBody, annotationMethodDefaultValue), source);
    }

    private static class JCNoType
    extends Type
    implements NoType {
        public JCNoType(int tag) {
            super(tag, null);
        }

        @Override
        public TypeKind getKind() {
            if (this.tag == Javac.getCtcInt(TypeTags.class, "VOID")) {
                return TypeKind.VOID;
            }
            if (this.tag == Javac.getCtcInt(TypeTags.class, "NONE")) {
                return TypeKind.NONE;
            }
            throw new AssertionError((Object)("Unexpected tag: " + this.tag));
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitNoType(this, p);
        }
    }
}

