/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;
import lombok.RequiredArgsConstructor;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.TransformationsUtil;
import lombok.eclipse.Eclipse;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.EclipseHandlerUtil;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandleConstructor {
    private static final char[][] JAVA_BEANS_CONSTRUCTORPROPERTIES = new char[][]{"java".toCharArray(), "beans".toCharArray(), "ConstructorProperties".toCharArray()};

    private static List<EclipseNode> findRequiredFields(EclipseNode typeNode) {
        ArrayList<EclipseNode> fields = new ArrayList<EclipseNode>();
        for (EclipseNode child : typeNode.down()) {
            boolean isNonNull;
            FieldDeclaration fieldDecl;
            if (child.getKind() != AST.Kind.FIELD || !EclipseHandlerUtil.filterField(fieldDecl = (FieldDeclaration)child.get())) continue;
            boolean isFinal = (fieldDecl.modifiers & 0x10) != 0;
            boolean bl = isNonNull = Eclipse.findAnnotations(fieldDecl, TransformationsUtil.NON_NULL_PATTERN).length != 0;
            if (!isFinal && !isNonNull || fieldDecl.initialization != null) continue;
            fields.add(child);
        }
        return fields;
    }

    static boolean checkLegality(EclipseNode typeNode, EclipseNode errorNode, String name) {
        boolean notAClass;
        TypeDeclaration typeDecl = null;
        if (typeNode.get() instanceof TypeDeclaration) {
            typeDecl = (TypeDeclaration)typeNode.get();
        }
        int modifiers = typeDecl == null ? 0 : typeDecl.modifiers;
        boolean bl = notAClass = (modifiers & 0x2200) != 0;
        if (typeDecl == null || notAClass) {
            errorNode.addError(name + " is only supported on a class or an enum.");
            return false;
        }
        return true;
    }

    public void generateRequiredArgsConstructor(EclipseNode typeNode, AccessLevel level, String staticName, boolean skipIfConstructorExists, ASTNode source) {
        this.generateConstructor(typeNode, level, HandleConstructor.findRequiredFields(typeNode), staticName, skipIfConstructorExists, false, source);
    }

    public void generateConstructor(EclipseNode typeNode, AccessLevel level, List<EclipseNode> fields, String staticName, boolean skipIfConstructorExists, boolean suppressConstructorProperties, ASTNode source) {
        if (skipIfConstructorExists && EclipseHandlerUtil.constructorExists(typeNode) != EclipseHandlerUtil.MemberExistsResult.NOT_EXISTS) {
            return;
        }
        if (skipIfConstructorExists) {
            for (EclipseNode child : typeNode.down()) {
                if (child.getKind() != AST.Kind.ANNOTATION || !EclipseHandlerUtil.annotationTypeMatches(NoArgsConstructor.class, child) && !EclipseHandlerUtil.annotationTypeMatches(AllArgsConstructor.class, child) && !EclipseHandlerUtil.annotationTypeMatches(RequiredArgsConstructor.class, child)) continue;
                return;
            }
        }
        boolean staticConstrRequired = staticName != null && !staticName.equals("");
        ConstructorDeclaration constr = this.createConstructor(staticConstrRequired ? AccessLevel.PRIVATE : level, typeNode, fields, suppressConstructorProperties, source);
        EclipseHandlerUtil.injectMethod(typeNode, (AbstractMethodDeclaration)constr);
        if (staticConstrRequired) {
            MethodDeclaration staticConstr = this.createStaticConstructor(level, staticName, typeNode, fields, source);
            EclipseHandlerUtil.injectMethod(typeNode, (AbstractMethodDeclaration)staticConstr);
        }
    }

    private static Annotation[] createConstructorProperties(ASTNode source, Annotation[] originalAnnotationArray, Collection<EclipseNode> fields) {
        if (fields.isEmpty()) {
            return originalAnnotationArray;
        }
        int pS = source.sourceStart;
        int pE = source.sourceEnd;
        long p = (long)pS << 32 | (long)pE;
        long[] poss = new long[3];
        Arrays.fill(poss, p);
        QualifiedTypeReference constructorPropertiesType = new QualifiedTypeReference(JAVA_BEANS_CONSTRUCTORPROPERTIES, poss);
        EclipseHandlerUtil.setGeneratedBy((ASTNode)constructorPropertiesType, source);
        SingleMemberAnnotation ann = new SingleMemberAnnotation((TypeReference)constructorPropertiesType, pS);
        ann.declarationSourceEnd = pE;
        ArrayInitializer fieldNames = new ArrayInitializer();
        fieldNames.sourceStart = pS;
        fieldNames.sourceEnd = pE;
        fieldNames.expressions = new Expression[fields.size()];
        int ctr = 0;
        for (EclipseNode field : fields) {
            fieldNames.expressions[ctr] = new StringLiteral(field.getName().toCharArray(), pS, pE, 0);
            EclipseHandlerUtil.setGeneratedBy((ASTNode)fieldNames.expressions[ctr], source);
            ++ctr;
        }
        ann.memberValue = fieldNames;
        EclipseHandlerUtil.setGeneratedBy((ASTNode)ann, source);
        EclipseHandlerUtil.setGeneratedBy((ASTNode)ann.memberValue, source);
        if (originalAnnotationArray == null) {
            return new Annotation[]{ann};
        }
        Annotation[] newAnnotationArray = Arrays.copyOf(originalAnnotationArray, originalAnnotationArray.length + 1);
        newAnnotationArray[originalAnnotationArray.length] = ann;
        return newAnnotationArray;
    }

    private ConstructorDeclaration createConstructor(AccessLevel level, EclipseNode type, Collection<EclipseNode> fields, boolean suppressConstructorProperties, ASTNode source) {
        boolean isEnum;
        long p = (long)source.sourceStart << 32 | (long)source.sourceEnd;
        boolean bl = isEnum = (((TypeDeclaration)type.get()).modifiers & 0x4000) != 0;
        if (isEnum) {
            level = AccessLevel.PRIVATE;
        }
        ConstructorDeclaration constructor = new ConstructorDeclaration(((CompilationUnitDeclaration)((EclipseNode)type.top()).get()).compilationResult);
        EclipseHandlerUtil.setGeneratedBy((ASTNode)constructor, source);
        constructor.modifiers = EclipseHandlerUtil.toEclipseModifier(level);
        constructor.selector = ((TypeDeclaration)type.get()).name;
        constructor.constructorCall = new ExplicitConstructorCall(1);
        EclipseHandlerUtil.setGeneratedBy((ASTNode)constructor.constructorCall, source);
        constructor.thrownExceptions = null;
        constructor.typeParameters = null;
        constructor.bits |= 0x800000;
        constructor.declarationSourceStart = constructor.sourceStart = source.sourceStart;
        constructor.bodyStart = constructor.sourceStart;
        constructor.declarationSourceEnd = constructor.sourceEnd = source.sourceEnd;
        constructor.bodyEnd = constructor.sourceEnd;
        constructor.arguments = null;
        ArrayList<Argument> params = new ArrayList<Argument>();
        ArrayList<Assignment> assigns = new ArrayList<Assignment>();
        ArrayList<Object> nullChecks = new ArrayList<Object>();
        for (EclipseNode fieldNode : fields) {
            Annotation[] copiedAnnotations;
            Statement nullCheck;
            FieldDeclaration field = (FieldDeclaration)fieldNode.get();
            FieldReference thisX = new FieldReference(field.name, p);
            EclipseHandlerUtil.setGeneratedBy((ASTNode)thisX, source);
            thisX.receiver = new ThisReference((int)(p >> 32), (int)p);
            EclipseHandlerUtil.setGeneratedBy((ASTNode)thisX.receiver, source);
            SingleNameReference assignmentNameRef = new SingleNameReference(field.name, p);
            EclipseHandlerUtil.setGeneratedBy((ASTNode)assignmentNameRef, source);
            Assignment assignment = new Assignment((Expression)thisX, (Expression)assignmentNameRef, (int)p);
            assignment.sourceStart = (int)(p >> 32);
            assignment.sourceEnd = assignment.statementEnd = (int)(p >> 32);
            EclipseHandlerUtil.setGeneratedBy((ASTNode)assignment, source);
            assigns.add(assignment);
            long fieldPos = (long)field.sourceStart << 32 | (long)field.sourceEnd;
            Argument parameter = new Argument(field.name, fieldPos, EclipseHandlerUtil.copyType(field.type, source), 16);
            EclipseHandlerUtil.setGeneratedBy((ASTNode)parameter, source);
            Annotation[] nonNulls = Eclipse.findAnnotations(field, TransformationsUtil.NON_NULL_PATTERN);
            Annotation[] nullables = Eclipse.findAnnotations(field, TransformationsUtil.NULLABLE_PATTERN);
            if (nonNulls.length != 0 && (nullCheck = EclipseHandlerUtil.generateNullCheck((AbstractVariableDeclaration)field, source)) != null) {
                nullChecks.add(nullCheck);
            }
            if ((copiedAnnotations = EclipseHandlerUtil.copyAnnotations(source, nonNulls, nullables)).length != 0) {
                parameter.annotations = copiedAnnotations;
            }
            params.add(parameter);
        }
        nullChecks.addAll(assigns);
        constructor.statements = nullChecks.isEmpty() ? null : nullChecks.toArray(new Statement[nullChecks.size()]);
        Argument[] argumentArray = constructor.arguments = params.isEmpty() ? null : params.toArray(new Argument[params.size()]);
        if (!suppressConstructorProperties && level != AccessLevel.PRIVATE && !this.isLocalType(type)) {
            constructor.annotations = HandleConstructor.createConstructorProperties(source, constructor.annotations, fields);
        }
        return constructor;
    }

    private boolean isLocalType(EclipseNode type) {
        AST.Kind kind = ((EclipseNode)type.up()).getKind();
        if (kind == AST.Kind.COMPILATION_UNIT) {
            return false;
        }
        if (kind == AST.Kind.TYPE) {
            return this.isLocalType((EclipseNode)type.up());
        }
        return true;
    }

    private MethodDeclaration createStaticConstructor(AccessLevel level, String name, EclipseNode type, Collection<EclipseNode> fields, ASTNode source) {
        int pS = source.sourceStart;
        int pE = source.sourceEnd;
        long p = (long)pS << 32 | (long)pE;
        MethodDeclaration constructor = new MethodDeclaration(((CompilationUnitDeclaration)((EclipseNode)type.top()).get()).compilationResult);
        EclipseHandlerUtil.setGeneratedBy((ASTNode)constructor, source);
        constructor.modifiers = EclipseHandlerUtil.toEclipseModifier(level) | 8;
        TypeDeclaration typeDecl = (TypeDeclaration)type.get();
        if (typeDecl.typeParameters != null && typeDecl.typeParameters.length > 0) {
            TypeReference[] refs = new TypeReference[typeDecl.typeParameters.length];
            int idx = 0;
            for (TypeParameter param : typeDecl.typeParameters) {
                SingleTypeReference typeRef = new SingleTypeReference(param.name, (long)param.sourceStart << 32 | (long)param.sourceEnd);
                EclipseHandlerUtil.setGeneratedBy((ASTNode)typeRef, source);
                refs[idx++] = typeRef;
            }
            constructor.returnType = new ParameterizedSingleTypeReference(typeDecl.name, refs, 0, p);
        } else {
            constructor.returnType = new SingleTypeReference(((TypeDeclaration)type.get()).name, p);
        }
        EclipseHandlerUtil.setGeneratedBy((ASTNode)constructor.returnType, source);
        constructor.annotations = null;
        constructor.selector = name.toCharArray();
        constructor.thrownExceptions = null;
        constructor.typeParameters = EclipseHandlerUtil.copyTypeParams(((TypeDeclaration)type.get()).typeParameters, source);
        constructor.bits |= 0x800000;
        constructor.declarationSourceStart = constructor.sourceStart = source.sourceStart;
        constructor.bodyStart = constructor.sourceStart;
        constructor.declarationSourceEnd = constructor.sourceEnd = source.sourceEnd;
        constructor.bodyEnd = constructor.sourceEnd;
        ArrayList<Argument> params = new ArrayList<Argument>();
        ArrayList<SingleNameReference> assigns = new ArrayList<SingleNameReference>();
        AllocationExpression statement = new AllocationExpression();
        statement.sourceStart = pS;
        statement.sourceEnd = pE;
        EclipseHandlerUtil.setGeneratedBy((ASTNode)statement, source);
        statement.type = EclipseHandlerUtil.copyType(constructor.returnType, source);
        for (EclipseNode fieldNode : fields) {
            FieldDeclaration field = (FieldDeclaration)fieldNode.get();
            long fieldPos = (long)field.sourceStart << 32 | (long)field.sourceEnd;
            SingleNameReference nameRef = new SingleNameReference(field.name, fieldPos);
            EclipseHandlerUtil.setGeneratedBy((ASTNode)nameRef, source);
            assigns.add(nameRef);
            Argument parameter = new Argument(field.name, fieldPos, EclipseHandlerUtil.copyType(field.type, source), 16);
            EclipseHandlerUtil.setGeneratedBy((ASTNode)parameter, source);
            Annotation[] copiedAnnotations = EclipseHandlerUtil.copyAnnotations(source, Eclipse.findAnnotations(field, TransformationsUtil.NON_NULL_PATTERN), Eclipse.findAnnotations(field, TransformationsUtil.NULLABLE_PATTERN));
            if (copiedAnnotations.length != 0) {
                parameter.annotations = copiedAnnotations;
            }
            params.add(parameter);
        }
        statement.arguments = assigns.isEmpty() ? null : assigns.toArray(new Expression[assigns.size()]);
        constructor.arguments = params.isEmpty() ? null : params.toArray(new Argument[params.size()]);
        constructor.statements = new Statement[]{new ReturnStatement((Expression)statement, (int)(p >> 32), (int)p)};
        EclipseHandlerUtil.setGeneratedBy((ASTNode)constructor.statements[0], source);
        return constructor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HandleAllArgsConstructor
    extends EclipseAnnotationHandler<AllArgsConstructor> {
        @Override
        public void handle(AnnotationValues<AllArgsConstructor> annotation, Annotation ast, EclipseNode annotationNode) {
            EclipseNode typeNode = (EclipseNode)annotationNode.up();
            if (!HandleConstructor.checkLegality(typeNode, annotationNode, AllArgsConstructor.class.getSimpleName())) {
                return;
            }
            AllArgsConstructor ann = annotation.getInstance();
            AccessLevel level = ann.access();
            String staticName = ann.staticName();
            boolean suppressConstructorProperties = ann.suppressConstructorProperties();
            if (level == AccessLevel.NONE) {
                return;
            }
            ArrayList<EclipseNode> fields = new ArrayList<EclipseNode>();
            for (EclipseNode child : typeNode.down()) {
                FieldDeclaration fieldDecl;
                if (child.getKind() != AST.Kind.FIELD || !EclipseHandlerUtil.filterField(fieldDecl = (FieldDeclaration)child.get()) || (fieldDecl.modifiers & 0x10) != 0 && fieldDecl.initialization != null) continue;
                fields.add(child);
            }
            new HandleConstructor().generateConstructor(typeNode, level, fields, staticName, false, suppressConstructorProperties, (ASTNode)ast);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HandleRequiredArgsConstructor
    extends EclipseAnnotationHandler<RequiredArgsConstructor> {
        @Override
        public void handle(AnnotationValues<RequiredArgsConstructor> annotation, Annotation ast, EclipseNode annotationNode) {
            EclipseNode typeNode = (EclipseNode)annotationNode.up();
            if (!HandleConstructor.checkLegality(typeNode, annotationNode, RequiredArgsConstructor.class.getSimpleName())) {
                return;
            }
            RequiredArgsConstructor ann = annotation.getInstance();
            AccessLevel level = ann.access();
            String staticName = ann.staticName();
            boolean suppressConstructorProperties = ann.suppressConstructorProperties();
            if (level == AccessLevel.NONE) {
                return;
            }
            new HandleConstructor().generateConstructor(typeNode, level, HandleConstructor.findRequiredFields(typeNode), staticName, false, suppressConstructorProperties, (ASTNode)ast);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HandleNoArgsConstructor
    extends EclipseAnnotationHandler<NoArgsConstructor> {
        @Override
        public void handle(AnnotationValues<NoArgsConstructor> annotation, Annotation ast, EclipseNode annotationNode) {
            EclipseNode typeNode = (EclipseNode)annotationNode.up();
            if (!HandleConstructor.checkLegality(typeNode, annotationNode, NoArgsConstructor.class.getSimpleName())) {
                return;
            }
            NoArgsConstructor ann = annotation.getInstance();
            AccessLevel level = ann.access();
            String staticName = ann.staticName();
            if (level == AccessLevel.NONE) {
                return;
            }
            ArrayList<EclipseNode> fields = new ArrayList<EclipseNode>();
            new HandleConstructor().generateConstructor(typeNode, level, fields, staticName, false, false, (ASTNode)ast);
        }
    }
}

