/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import lombok.ToString;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.javac.Javac;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.handlers.JavacHandlerUtil;

public class HandleToString
extends JavacAnnotationHandler<ToString> {
    private void checkForBogusFieldNames(JavacNode type, AnnotationValues<ToString> annotation) {
        if (annotation.isExplicit("exclude")) {
            for (int i : JavacHandlerUtil.createListOfNonExistentFields(List.from(annotation.getInstance().exclude()), type, true, false)) {
                annotation.setWarning("exclude", "This field does not exist, or would have been excluded anyway.", i);
            }
        }
        if (annotation.isExplicit("of")) {
            for (int i : JavacHandlerUtil.createListOfNonExistentFields(List.from(annotation.getInstance().of()), type, false, false)) {
                annotation.setWarning("of", "This field does not exist.", i);
            }
        }
    }

    @Override
    public void handle(AnnotationValues<ToString> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        JavacHandlerUtil.deleteAnnotationIfNeccessary(annotationNode, ToString.class);
        ToString ann = annotation.getInstance();
        List<String> excludes = List.from(ann.exclude());
        List<String> includes = List.from(ann.of());
        JavacNode typeNode = (JavacNode)annotationNode.up();
        this.checkForBogusFieldNames(typeNode, annotation);
        Boolean callSuper = ann.callSuper();
        if (!annotation.isExplicit("callSuper")) {
            callSuper = null;
        }
        if (!annotation.isExplicit("exclude")) {
            excludes = null;
        }
        if (!annotation.isExplicit("of")) {
            includes = null;
        }
        if (excludes != null && includes != null) {
            excludes = null;
            annotation.setWarning("exclude", "exclude and of are mutually exclusive; the 'exclude' parameter will be ignored.");
        }
        JavacHandlerUtil.FieldAccess fieldAccess = ann.doNotUseGetters() ? JavacHandlerUtil.FieldAccess.PREFER_FIELD : JavacHandlerUtil.FieldAccess.GETTER;
        this.generateToString(typeNode, annotationNode, excludes, includes, ann.includeFieldNames(), callSuper, true, fieldAccess);
    }

    public void generateToStringForType(JavacNode typeNode, JavacNode errorNode) {
        for (JavacNode child : typeNode.down()) {
            if (child.getKind() != AST.Kind.ANNOTATION || !JavacHandlerUtil.annotationTypeMatches(ToString.class, child)) continue;
            return;
        }
        boolean includeFieldNames = true;
        try {
            includeFieldNames = (Boolean)ToString.class.getMethod("includeFieldNames", new Class[0]).getDefaultValue();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        this.generateToString(typeNode, errorNode, null, null, includeFieldNames, null, false, JavacHandlerUtil.FieldAccess.GETTER);
    }

    private void generateToString(JavacNode typeNode, JavacNode source, List<String> excludes, List<String> includes, boolean includeFieldNames, Boolean callSuper, boolean whineIfExists, JavacHandlerUtil.FieldAccess fieldAccess) {
        boolean notAClass = true;
        if (typeNode.get() instanceof JCTree.JCClassDecl) {
            long flags = ((JCTree.JCClassDecl)typeNode.get()).mods.flags;
            boolean bl = notAClass = (flags & 0x2200L) != 0L;
        }
        if (callSuper == null) {
            try {
                callSuper = (boolean)((Boolean)ToString.class.getMethod("callSuper", new Class[0]).getDefaultValue());
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if (notAClass) {
            source.addError("@ToString is only supported on a class or enum.");
            return;
        }
        ListBuffer nodesForToString = ListBuffer.lb();
        if (includes != null) {
            for (JavacNode child : typeNode.down()) {
                if (child.getKind() != AST.Kind.FIELD) continue;
                JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)child.get();
                if (!includes.contains(fieldDecl.name.toString())) continue;
                nodesForToString.append(child);
            }
        } else {
            for (JavacNode child : typeNode.down()) {
                if (child.getKind() != AST.Kind.FIELD) continue;
                JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)child.get();
                if ((fieldDecl.mods.flags & 8L) != 0L || excludes != null && excludes.contains(fieldDecl.name.toString()) || fieldDecl.name.toString().startsWith("$")) continue;
                nodesForToString.append(child);
            }
        }
        switch (JavacHandlerUtil.methodExists("toString", typeNode, 0)) {
            case NOT_EXISTS: {
                JCTree.JCMethodDecl method = this.createToString(typeNode, nodesForToString.toList(), includeFieldNames, callSuper, fieldAccess, (JCTree)source.get());
                JavacHandlerUtil.injectMethod(typeNode, method);
                break;
            }
            case EXISTS_BY_LOMBOK: {
                break;
            }
            default: {
                if (!whineIfExists) break;
                source.addWarning("Not generating toString(): A method with that name already exists");
            }
        }
    }

    private JCTree.JCMethodDecl createToString(JavacNode typeNode, List<JavacNode> fields, boolean includeFieldNames, boolean callSuper, JavacHandlerUtil.FieldAccess fieldAccess, JCTree source) {
        TreeMaker maker = typeNode.getTreeMaker();
        JCTree.JCAnnotation overrideAnnotation = maker.Annotation(JavacHandlerUtil.chainDots(typeNode, "java", "lang", "Override"), List.<JCTree.JCExpression>nil());
        JCTree.JCModifiers mods = maker.Modifiers(1L, List.of(overrideAnnotation));
        JCTree.JCExpression returnType = JavacHandlerUtil.chainDots(typeNode, "java", "lang", "String");
        boolean first = true;
        String typeName = this.getTypeName(typeNode);
        String infix = ", ";
        String suffix = ")";
        String prefix = callSuper ? typeName + "(super=" : (fields.isEmpty() ? typeName + "()" : (includeFieldNames ? typeName + "(" + ((JCTree.JCVariableDecl)fields.iterator().next().get()).name.toString() + "=" : typeName + "("));
        JCTree.JCExpression current = maker.Literal(prefix);
        if (callSuper) {
            JCTree.JCMethodInvocation callToSuper = maker.Apply(List.<JCTree.JCExpression>nil(), maker.Select((JCTree.JCExpression)maker.Ident(typeNode.toName("super")), typeNode.toName("toString")), List.<JCTree.JCExpression>nil());
            current = maker.Binary(Javac.getCtcInt(JCTree.class, "PLUS"), current, callToSuper);
            first = false;
        }
        for (JavacNode fieldNode : fields) {
            JCTree.JCExpression expr;
            JCTree.JCVariableDecl field = (JCTree.JCVariableDecl)fieldNode.get();
            JCTree.JCExpression fieldAccessor = JavacHandlerUtil.createFieldAccessor(maker, fieldNode, fieldAccess);
            if (JavacHandlerUtil.getFieldType(fieldNode, fieldAccess) instanceof JCTree.JCArrayTypeTree) {
                boolean multiDim = ((JCTree.JCArrayTypeTree)field.vartype).elemtype instanceof JCTree.JCArrayTypeTree;
                boolean primitiveArray = ((JCTree.JCArrayTypeTree)field.vartype).elemtype instanceof JCTree.JCPrimitiveTypeTree;
                boolean useDeepTS = multiDim || !primitiveArray;
                JCTree.JCExpression hcMethod = JavacHandlerUtil.chainDots(typeNode, "java", "util", "Arrays", useDeepTS ? "deepToString" : "toString");
                expr = maker.Apply(List.<JCTree.JCExpression>nil(), hcMethod, List.of(fieldAccessor));
            } else {
                expr = fieldAccessor;
            }
            if (first) {
                current = maker.Binary(Javac.getCtcInt(JCTree.class, "PLUS"), current, expr);
                first = false;
                continue;
            }
            current = includeFieldNames ? maker.Binary(Javac.getCtcInt(JCTree.class, "PLUS"), current, maker.Literal(infix + fieldNode.getName() + "=")) : maker.Binary(Javac.getCtcInt(JCTree.class, "PLUS"), current, maker.Literal(infix));
            current = maker.Binary(Javac.getCtcInt(JCTree.class, "PLUS"), current, expr);
        }
        if (!first) {
            current = maker.Binary(Javac.getCtcInt(JCTree.class, "PLUS"), current, maker.Literal(suffix));
        }
        JCTree.JCReturn returnStatement = maker.Return(current);
        JCTree.JCBlock body = maker.Block(0L, List.of(returnStatement));
        return JavacHandlerUtil.recursiveSetGeneratedBy(maker.MethodDef(mods, typeNode.toName("toString"), returnType, List.<JCTree.JCTypeParameter>nil(), List.<JCTree.JCVariableDecl>nil(), List.<JCTree.JCExpression>nil(), body, null), source);
    }

    private String getTypeName(JavacNode typeNode) {
        String typeName = ((JCTree.JCClassDecl)typeNode.get()).name.toString();
        JavacNode upType = (JavacNode)typeNode.up();
        while (upType.getKind() == AST.Kind.TYPE) {
            typeName = ((JCTree.JCClassDecl)upType.get()).name.toString() + "." + typeName;
            upType = (JavacNode)upType.up();
        }
        return typeName;
    }
}

