/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;
import lombok.RequiredArgsConstructor;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.handlers.TransformationsUtil;
import lombok.javac.Javac;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.handlers.JavacHandlerUtil;

public class HandleConstructor {
    private static List<JavacNode> findRequiredFields(JavacNode typeNode) {
        List<JavacNode> fields = List.nil();
        for (JavacNode child : typeNode.down()) {
            boolean isNonNull;
            long fieldFlags;
            if (child.getKind() != AST.Kind.FIELD) continue;
            JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)child.get();
            if (fieldDecl.name.toString().startsWith("$") || ((fieldFlags = fieldDecl.mods.flags) & 8L) != 0L) continue;
            boolean isFinal = (fieldFlags & 0x10L) != 0L;
            boolean bl = isNonNull = !JavacHandlerUtil.findAnnotations(child, TransformationsUtil.NON_NULL_PATTERN).isEmpty();
            if (!isFinal && !isNonNull || fieldDecl.init != null) continue;
            fields = fields.append(child);
        }
        return fields;
    }

    public void generateRequiredArgsConstructor(JavacNode typeNode, AccessLevel level, String staticName, boolean skipIfConstructorExists) {
        this.generateConstructor(typeNode, level, HandleConstructor.findRequiredFields(typeNode), staticName, skipIfConstructorExists, false);
    }

    public void generateConstructor(JavacNode typeNode, AccessLevel level, List<JavacNode> fields, String staticName, boolean skipIfConstructorExists, boolean suppressConstructorProperties) {
        if (skipIfConstructorExists && JavacHandlerUtil.constructorExists(typeNode) != JavacHandlerUtil.MemberExistsResult.NOT_EXISTS) {
            return;
        }
        if (skipIfConstructorExists) {
            for (JavacNode child : typeNode.down()) {
                if (child.getKind() != AST.Kind.ANNOTATION || !Javac.annotationTypeMatches(NoArgsConstructor.class, child) && !Javac.annotationTypeMatches(AllArgsConstructor.class, child) && !Javac.annotationTypeMatches(RequiredArgsConstructor.class, child)) continue;
                return;
            }
        }
        boolean staticConstrRequired = staticName != null && !staticName.equals("");
        JCTree.JCMethodDecl constr = this.createConstructor(staticConstrRequired ? AccessLevel.PRIVATE : level, typeNode, fields, suppressConstructorProperties);
        JavacHandlerUtil.injectMethod(typeNode, constr);
        if (staticConstrRequired) {
            JCTree.JCMethodDecl staticConstr = this.createStaticConstructor(staticName, level, typeNode, fields);
            JavacHandlerUtil.injectMethod(typeNode, staticConstr);
        }
    }

    private static void addConstructorProperties(JCTree.JCModifiers mods, JavacNode node, List<JavacNode> fields) {
        if (fields.isEmpty()) {
            return;
        }
        TreeMaker maker = node.getTreeMaker();
        JCTree.JCExpression constructorPropertiesType = JavacHandlerUtil.chainDots(maker, node, "java", "beans", "ConstructorProperties");
        List<JCTree.JCExpression> fieldNames = List.nil();
        for (JavacNode field : fields) {
            fieldNames = fieldNames.append(maker.Literal(field.getName()));
        }
        JCTree.JCNewArray fieldNamesArray = maker.NewArray(null, List.<JCTree.JCExpression>nil(), fieldNames);
        JCTree.JCAnnotation annotation = maker.Annotation(constructorPropertiesType, List.of(fieldNamesArray));
        mods.annotations = mods.annotations.append(annotation);
    }

    private JCTree.JCMethodDecl createConstructor(AccessLevel level, JavacNode typeNode, List<JavacNode> fields, boolean suppressConstructorProperties) {
        TreeMaker maker = typeNode.getTreeMaker();
        JCTree.JCClassDecl type = (JCTree.JCClassDecl)typeNode.get();
        List<JCTree.JCStatement> nullChecks = List.nil();
        List<JCTree.JCExpressionStatement> assigns = List.nil();
        List<JCTree.JCVariableDecl> params = List.nil();
        for (JavacNode fieldNode : fields) {
            JCTree.JCStatement nullCheck;
            JCTree.JCVariableDecl field = (JCTree.JCVariableDecl)fieldNode.get();
            List<JCTree.JCAnnotation> nonNulls = JavacHandlerUtil.findAnnotations(fieldNode, TransformationsUtil.NON_NULL_PATTERN);
            List<JCTree.JCAnnotation> nullables = JavacHandlerUtil.findAnnotations(fieldNode, TransformationsUtil.NULLABLE_PATTERN);
            JCTree.JCVariableDecl param = maker.VarDef(maker.Modifiers(16L, nonNulls.appendList(nullables)), field.name, field.vartype, null);
            params = params.append(param);
            JCTree.JCFieldAccess thisX = maker.Select((JCTree.JCExpression)maker.Ident(fieldNode.toName("this")), field.name);
            JCTree.JCAssign assign = maker.Assign(thisX, maker.Ident(field.name));
            assigns = assigns.append(maker.Exec(assign));
            if (nonNulls.isEmpty() || (nullCheck = JavacHandlerUtil.generateNullCheck(maker, fieldNode)) == null) continue;
            nullChecks = nullChecks.append(nullCheck);
        }
        JCTree.JCModifiers mods = maker.Modifiers(JavacHandlerUtil.toJavacModifier(level));
        if (!suppressConstructorProperties && level != AccessLevel.PRIVATE && !this.isLocalType(typeNode)) {
            HandleConstructor.addConstructorProperties(mods, typeNode, fields);
        }
        return maker.MethodDef(mods, typeNode.toName("<init>"), null, type.typarams, params, List.<JCTree.JCExpression>nil(), maker.Block(0L, nullChecks.appendList(assigns)), null);
    }

    private boolean isLocalType(JavacNode type) {
        AST.Kind kind = ((JavacNode)type.up()).getKind();
        if (kind == AST.Kind.COMPILATION_UNIT) {
            return false;
        }
        if (kind == AST.Kind.TYPE) {
            return this.isLocalType((JavacNode)type.up());
        }
        return true;
    }

    private JCTree.JCMethodDecl createStaticConstructor(String name, AccessLevel level, JavacNode typeNode, List<JavacNode> fields) {
        JCTree.JCExpression constructorType;
        JCTree.JCExpression returnType;
        TreeMaker maker = typeNode.getTreeMaker();
        JCTree.JCClassDecl type = (JCTree.JCClassDecl)typeNode.get();
        JCTree.JCModifiers mods = maker.Modifiers(8 | JavacHandlerUtil.toJavacModifier(level));
        List<JCTree.JCTypeParameter> typeParams = List.nil();
        List<JCTree.JCVariableDecl> params = List.nil();
        List<JCTree.JCExpression> typeArgs1 = List.nil();
        List<JCTree.JCExpression> typeArgs2 = List.nil();
        List<JCTree.JCExpression> args = List.nil();
        if (!type.typarams.isEmpty()) {
            for (JCTree.JCTypeParameter param : type.typarams) {
                typeArgs1 = typeArgs1.append(maker.Ident(param.name));
                typeArgs2 = typeArgs2.append(maker.Ident(param.name));
                typeParams = typeParams.append(maker.TypeParameter(param.name, param.bounds));
            }
            returnType = maker.TypeApply(maker.Ident(type.name), typeArgs1);
            constructorType = maker.TypeApply(maker.Ident(type.name), typeArgs2);
        } else {
            returnType = maker.Ident(type.name);
            constructorType = maker.Ident(type.name);
        }
        for (JavacNode fieldNode : fields) {
            JCTree.JCExpression pType;
            JCTree.JCVariableDecl field = (JCTree.JCVariableDecl)fieldNode.get();
            if (field.vartype instanceof JCTree.JCIdent) {
                pType = maker.Ident(((JCTree.JCIdent)field.vartype).name);
            } else if (field.vartype instanceof JCTree.JCTypeApply) {
                JCTree.JCTypeApply typeApply = (JCTree.JCTypeApply)field.vartype;
                List<JCTree.JCExpression> tArgs = List.nil();
                for (JCTree.JCExpression arg : typeApply.arguments) {
                    tArgs = tArgs.append(arg);
                }
                pType = maker.TypeApply(typeApply.clazz, tArgs);
            } else {
                pType = field.vartype;
            }
            List<JCTree.JCAnnotation> nonNulls = JavacHandlerUtil.findAnnotations(fieldNode, TransformationsUtil.NON_NULL_PATTERN);
            List<JCTree.JCAnnotation> nullables = JavacHandlerUtil.findAnnotations(fieldNode, TransformationsUtil.NULLABLE_PATTERN);
            JCTree.JCVariableDecl param = maker.VarDef(maker.Modifiers(16L, nonNulls.appendList(nullables)), field.name, pType, null);
            params = params.append(param);
            args = args.append(maker.Ident(field.name));
        }
        JCTree.JCReturn returnStatement = maker.Return(maker.NewClass(null, List.<JCTree.JCExpression>nil(), constructorType, args, null));
        JCTree.JCBlock body = maker.Block(0L, List.of(returnStatement));
        return maker.MethodDef(mods, typeNode.toName(name), returnType, typeParams, params, List.<JCTree.JCExpression>nil(), body, null);
    }

    public static class HandleAllArgsConstructor
    implements JavacAnnotationHandler<AllArgsConstructor> {
        @Override
        public boolean handle(AnnotationValues<AllArgsConstructor> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
            JavacHandlerUtil.markAnnotationAsProcessed(annotationNode, AllArgsConstructor.class);
            JavacHandlerUtil.deleteImportFromCompilationUnit(annotationNode, "lombok.AccessLevel");
            JavacNode typeNode = (JavacNode)annotationNode.up();
            AllArgsConstructor ann = annotation.getInstance();
            AccessLevel level = ann.access();
            String staticName = ann.staticName();
            boolean suppressConstructorProperties = ann.suppressConstructorProperties();
            if (level == AccessLevel.NONE) {
                return true;
            }
            List<JavacNode> fields = List.nil();
            for (JavacNode child : typeNode.down()) {
                long fieldFlags;
                if (child.getKind() != AST.Kind.FIELD) continue;
                JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)child.get();
                if (fieldDecl.name.toString().startsWith("$") || ((fieldFlags = fieldDecl.mods.flags) & 8L) != 0L) continue;
                fields = fields.append(child);
            }
            new HandleConstructor().generateConstructor(typeNode, level, fields, staticName, false, suppressConstructorProperties);
            return true;
        }
    }

    public static class HandleRequiredArgsConstructor
    implements JavacAnnotationHandler<RequiredArgsConstructor> {
        @Override
        public boolean handle(AnnotationValues<RequiredArgsConstructor> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
            JavacHandlerUtil.markAnnotationAsProcessed(annotationNode, RequiredArgsConstructor.class);
            JavacHandlerUtil.deleteImportFromCompilationUnit(annotationNode, "lombok.AccessLevel");
            JavacNode typeNode = (JavacNode)annotationNode.up();
            RequiredArgsConstructor ann = annotation.getInstance();
            AccessLevel level = ann.access();
            String staticName = ann.staticName();
            boolean suppressConstructorProperties = ann.suppressConstructorProperties();
            if (level == AccessLevel.NONE) {
                return true;
            }
            new HandleConstructor().generateConstructor(typeNode, level, HandleConstructor.findRequiredFields(typeNode), staticName, false, suppressConstructorProperties);
            return true;
        }
    }

    public static class HandleNoArgsConstructor
    implements JavacAnnotationHandler<NoArgsConstructor> {
        @Override
        public boolean handle(AnnotationValues<NoArgsConstructor> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
            JavacHandlerUtil.markAnnotationAsProcessed(annotationNode, NoArgsConstructor.class);
            JavacHandlerUtil.deleteImportFromCompilationUnit(annotationNode, "lombok.AccessLevel");
            JavacNode typeNode = (JavacNode)annotationNode.up();
            NoArgsConstructor ann = annotation.getInstance();
            AccessLevel level = ann.access();
            String staticName = ann.staticName();
            if (level == AccessLevel.NONE) {
                return true;
            }
            List<JavacNode> fields = List.nil();
            new HandleConstructor().generateConstructor(typeNode, level, fields, staticName, false, false);
            return true;
        }
    }
}

