/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.Collection;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.handlers.TransformationsUtil;
import lombok.javac.Javac;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.handlers.JavacHandlerUtil;

public class HandleGetter
implements JavacAnnotationHandler<Getter> {
    public boolean generateGetterForType(JavacNode typeNode, JavacNode errorNode, AccessLevel level, boolean checkForTypeLevelGetter) {
        boolean notAClass;
        if (checkForTypeLevelGetter && typeNode != null) {
            for (JavacNode child : typeNode.down()) {
                if (child.getKind() != AST.Kind.ANNOTATION || !Javac.annotationTypeMatches(Getter.class, child)) continue;
                return true;
            }
        }
        JCTree.JCClassDecl typeDecl = null;
        if (typeNode.get() instanceof JCTree.JCClassDecl) {
            typeDecl = (JCTree.JCClassDecl)typeNode.get();
        }
        long modifiers = typeDecl == null ? 0L : typeDecl.mods.flags;
        boolean bl = notAClass = (modifiers & 0x6200L) != 0L;
        if (typeDecl == null || notAClass) {
            errorNode.addError("@Getter is only supported on a class or a field.");
            return false;
        }
        for (JavacNode field : typeNode.down()) {
            if (!this.fieldQualifiesForGetterGeneration(field)) continue;
            this.generateGetterForField(field, (JCDiagnostic.DiagnosticPosition)errorNode.get(), level);
        }
        return true;
    }

    public boolean fieldQualifiesForGetterGeneration(JavacNode field) {
        if (field.getKind() != AST.Kind.FIELD) {
            return false;
        }
        JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)field.get();
        if (fieldDecl.name.toString().startsWith("$")) {
            return false;
        }
        return (fieldDecl.mods.flags & 8L) == 0L;
    }

    public void generateGetterForField(JavacNode fieldNode, JCDiagnostic.DiagnosticPosition pos, AccessLevel level) {
        for (JavacNode child : fieldNode.down()) {
            if (child.getKind() != AST.Kind.ANNOTATION || !Javac.annotationTypeMatches(Getter.class, child)) continue;
            return;
        }
        this.createGetterForField(level, fieldNode, fieldNode, false);
    }

    @Override
    public boolean handle(AnnotationValues<Getter> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        Collection<JavacNode> fields = annotationNode.upFromAnnotationToFields();
        JavacHandlerUtil.markAnnotationAsProcessed(annotationNode, Getter.class);
        JavacHandlerUtil.deleteImportFromCompilationUnit(annotationNode, "lombok.AccessLevel");
        JavacNode node = (JavacNode)annotationNode.up();
        AccessLevel level = annotation.getInstance().value();
        if (level == AccessLevel.NONE) {
            return true;
        }
        if (node == null) {
            return false;
        }
        if (node.getKind() == AST.Kind.FIELD) {
            return this.createGetterForFields(level, fields, annotationNode, true);
        }
        if (node.getKind() == AST.Kind.TYPE) {
            return this.generateGetterForType(node, annotationNode, level, false);
        }
        return false;
    }

    private boolean createGetterForFields(AccessLevel level, Collection<JavacNode> fieldNodes, JavacNode errorNode, boolean whineIfExists) {
        for (JavacNode fieldNode : fieldNodes) {
            this.createGetterForField(level, fieldNode, errorNode, whineIfExists);
        }
        return true;
    }

    private boolean createGetterForField(AccessLevel level, JavacNode fieldNode, JavacNode errorNode, boolean whineIfExists) {
        if (fieldNode.getKind() != AST.Kind.FIELD) {
            errorNode.addError("@Getter is only supported on a class or a field.");
            return true;
        }
        JCTree.JCVariableDecl fieldDecl = (JCTree.JCVariableDecl)fieldNode.get();
        String methodName = JavacHandlerUtil.toGetterName(fieldDecl);
        for (String altName : JavacHandlerUtil.toAllGetterNames(fieldDecl)) {
            switch (JavacHandlerUtil.methodExists(altName, fieldNode, false)) {
                case EXISTS_BY_LOMBOK: {
                    return true;
                }
                case EXISTS_BY_USER: {
                    if (whineIfExists) {
                        String altNameExpl = "";
                        if (!altName.equals(methodName)) {
                            altNameExpl = String.format(" (%s)", altName);
                        }
                        errorNode.addWarning(String.format("Not generating %s(): A method with that name already exists%s", methodName, altNameExpl));
                    }
                    return true;
                }
            }
        }
        long access = (long)JavacHandlerUtil.toJavacModifier(level) | fieldDecl.mods.flags & 8L;
        JavacHandlerUtil.injectMethod((JavacNode)fieldNode.up(), this.createGetter(access, fieldNode, fieldNode.getTreeMaker()));
        return true;
    }

    private JCTree.JCMethodDecl createGetter(long access, JavacNode field, TreeMaker treeMaker) {
        JCTree.JCVariableDecl fieldNode = (JCTree.JCVariableDecl)field.get();
        JCTree.JCFieldAccess thisX = treeMaker.Select((JCTree.JCExpression)treeMaker.Ident(field.toName("this")), fieldNode.name);
        JCTree.JCReturn returnStatement = treeMaker.Return(thisX);
        JCTree.JCBlock methodBody = treeMaker.Block(0L, List.of(returnStatement));
        Name methodName = field.toName(JavacHandlerUtil.toGetterName(fieldNode));
        JCTree.JCExpression methodType = fieldNode.type != null ? treeMaker.Type(fieldNode.type) : fieldNode.vartype;
        List<JCTree.JCTypeParameter> methodGenericParams = List.nil();
        List<JCTree.JCVariableDecl> parameters = List.nil();
        List<JCTree.JCExpression> throwsClauses = List.nil();
        JCTree.JCExpression annotationMethodDefaultValue = null;
        List<JCTree.JCAnnotation> nonNulls = JavacHandlerUtil.findAnnotations(field, TransformationsUtil.NON_NULL_PATTERN);
        List<JCTree.JCAnnotation> nullables = JavacHandlerUtil.findAnnotations(field, TransformationsUtil.NULLABLE_PATTERN);
        return treeMaker.MethodDef(treeMaker.Modifiers(access, nonNulls.appendList(nullables)), methodName, methodType, methodGenericParams, parameters, throwsClauses, methodBody, annotationMethodDefaultValue);
    }
}

