/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.annotationstripper.plugin;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.projectnessie.annotationstripper.core.StripAnnotations;
import org.projectnessie.annotationstripper.plugin.AnnotationStripSet;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0001\u00a2\u0006\u0002\b\u000eJ\r\u0010\u000f\u001a\u00020\u0010H\u0001\u00a2\u0006\u0002\b\u0011J\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0001\u00a2\u0006\u0002\b\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/projectnessie/annotationstripper/plugin/AnnotationStripperTask;", "Lorg/gradle/api/DefaultTask;", "stripSet", "Lorg/projectnessie/annotationstripper/plugin/AnnotationStripSet;", "fileSystemOperations", "Lorg/gradle/api/file/FileSystemOperations;", "(Lorg/projectnessie/annotationstripper/plugin/AnnotationStripSet;Lorg/gradle/api/file/FileSystemOperations;)V", "outputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "getAnnotationsToDrop", "Lorg/gradle/api/provider/ListProperty;", "Ljava/util/regex/Pattern;", "getAnnotationsToDrop$annotation_stripper_plugin", "getInputClassFiles", "Lorg/gradle/api/file/FileCollection;", "getInputClassFiles$annotation_stripper_plugin", "getUnmodifiedClassesForJavaVersion", "Lorg/gradle/api/provider/Property;", "", "getUnmodifiedClassesForJavaVersion$annotation_stripper_plugin", "stripClasses", "", "annotation-stripper-plugin"})
@SourceDebugExtension(value={"SMAP\nAnnotationStripperTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationStripperTask.kt\norg/projectnessie/annotationstripper/plugin/AnnotationStripperTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,90:1\n1549#2:91\n1620#2,3:92\n1549#2:95\n1620#2,3:96\n1855#2,2:101\n37#3,2:99\n*S KotlinDebug\n*F\n+ 1 AnnotationStripperTask.kt\norg/projectnessie/annotationstripper/plugin/AnnotationStripperTask\n*L\n68#1:91\n68#1:92,3\n69#1:95\n69#1:96,3\n73#1:101,2\n70#1:99,2\n*E\n"})
public abstract class AnnotationStripperTask
extends DefaultTask {
    @NotNull
    private final AnnotationStripSet stripSet;
    @NotNull
    private final FileSystemOperations fileSystemOperations;

    @Inject
    public AnnotationStripperTask(@NotNull AnnotationStripSet stripSet, @NotNull FileSystemOperations fileSystemOperations) {
        Intrinsics.checkNotNullParameter((Object)stripSet, (String)"stripSet");
        Intrinsics.checkNotNullParameter((Object)fileSystemOperations, (String)"fileSystemOperations");
        this.stripSet = stripSet;
        this.fileSystemOperations = fileSystemOperations;
    }

    @Input
    @NotNull
    public final ListProperty<Pattern> getAnnotationsToDrop$annotation_stripper_plugin() {
        return this.stripSet.getAnnotationsToDrop();
    }

    @Optional
    @Input
    @NotNull
    public final Property<Integer> getUnmodifiedClassesForJavaVersion$annotation_stripper_plugin() {
        return this.stripSet.getUnmodifiedClassesForJavaVersion();
    }

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDirectory();

    @InputFiles
    @NotNull
    public final FileCollection getInputClassFiles$annotation_stripper_plugin() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        SourceSet sourceSet = this.stripSet.sourceSet$annotation_stripper_plugin(project);
        FileCollection fileCollection = sourceSet.getOutput().getClassesDirs();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"sourceSet.output.classesDirs");
        return fileCollection;
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void stripClasses() {
        void $this$toTypedArray$iv;
        File f;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        SourceSet sourceSet = this.stripSet.sourceSet$annotation_stripper_plugin(project);
        this.fileSystemOperations.delete(new Action(this){
            final /* synthetic */ AnnotationStripperTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(@NotNull DeleteSpec $this$delete) {
                Intrinsics.checkNotNullParameter((Object)$this$delete, (String)"$this$delete");
                Object[] objectArray = new Object[]{this.this$0.getOutputDirectory()};
                $this$delete.delete(objectArray);
            }
        });
        Set set = sourceSet.getOutput().getClassesDirs().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"sourceSet.output.classesDirs.files");
        Set classesDirs = set;
        Object object = sourceSet.getCompileClasspath().getElements().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sourceSet.compileClasspath.elements.get()");
        Iterable $this$map$iv = (Iterable)object;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FileSystemLocation fileSystemLocation = (FileSystemLocation)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(f.getAsFile());
        }
        $this$map$iv = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)classesDirs);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            f = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(f.toURI().toURL());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        URL[] classPathUrls = thisCollection$iv.toArray(new URL[0]);
        URLClassLoader dependenciesClassLoader = new URLClassLoader(classPathUrls);
        Iterable $this$forEach$iv = classesDirs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File target;
            File it = (File)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)((Directory)this.getOutputDirectory().get()).getAsFile(), (String)"outputDirectory.get().asFile");
            this.getLogger().info("Stripping annotations for source set '" + this.stripSet.getName() + "' from " + it + " into " + target);
            StripAnnotations.Builder builder = StripAnnotations.builder().dependenciesClassLoader((ClassLoader)dependenciesClassLoader).annotationsToDrop((Iterable)this.stripSet.getAnnotationsToDrop().get()).targetDir(target.toPath()).classesSourceDir(it.toPath());
            if (this.stripSet.getUnmodifiedClassesForJavaVersion().isPresent()) {
                Object object2 = this.stripSet.getUnmodifiedClassesForJavaVersion().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"stripSet.unmodifiedClassesForJavaVersion.get()");
                builder.unmodifiedClassesForJavaVersion(((Number)object2).intValue());
            }
            builder.build().stripAnnotations();
        }
    }
}

