/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.relocated.org.agrona;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import org.projectnessie.cel.relocated.org.agrona.AsciiNumberFormatException;

public final class AsciiEncoding {
    public static final int INT_MAX_DIGITS = 10;
    public static final int LONG_MAX_DIGITS = 19;
    public static final long INTEGER_ABSOLUTE_MIN_VALUE = Math.abs(Integer.MIN_VALUE);
    public static final byte[] MIN_INTEGER_VALUE = String.valueOf(Integer.MIN_VALUE).getBytes(StandardCharsets.US_ASCII);
    public static final byte[] MAX_INTEGER_VALUE = String.valueOf(Integer.MAX_VALUE).getBytes(StandardCharsets.US_ASCII);
    public static final byte[] MIN_LONG_VALUE = String.valueOf(Long.MIN_VALUE).getBytes(StandardCharsets.US_ASCII);
    public static final byte[] MAX_LONG_VALUE = String.valueOf(Long.MAX_VALUE).getBytes(StandardCharsets.US_ASCII);
    public static final byte MINUS_SIGN = 45;
    public static final byte ZERO = 48;
    public static final byte[] ASCII_DIGITS = new byte[]{48, 48, 48, 49, 48, 50, 48, 51, 48, 52, 48, 53, 48, 54, 48, 55, 48, 56, 48, 57, 49, 48, 49, 49, 49, 50, 49, 51, 49, 52, 49, 53, 49, 54, 49, 55, 49, 56, 49, 57, 50, 48, 50, 49, 50, 50, 50, 51, 50, 52, 50, 53, 50, 54, 50, 55, 50, 56, 50, 57, 51, 48, 51, 49, 51, 50, 51, 51, 51, 52, 51, 53, 51, 54, 51, 55, 51, 56, 51, 57, 52, 48, 52, 49, 52, 50, 52, 51, 52, 52, 52, 53, 52, 54, 52, 55, 52, 56, 52, 57, 53, 48, 53, 49, 53, 50, 53, 51, 53, 52, 53, 53, 53, 54, 53, 55, 53, 56, 53, 57, 54, 48, 54, 49, 54, 50, 54, 51, 54, 52, 54, 53, 54, 54, 54, 55, 54, 56, 54, 57, 55, 48, 55, 49, 55, 50, 55, 51, 55, 52, 55, 53, 55, 54, 55, 55, 55, 56, 55, 57, 56, 48, 56, 49, 56, 50, 56, 51, 56, 52, 56, 53, 56, 54, 56, 55, 56, 56, 56, 57, 57, 48, 57, 49, 57, 50, 57, 51, 57, 52, 57, 53, 57, 54, 57, 55, 57, 56, 57, 57};
    public static final int[] LONG_MAX_VALUE_DIGITS = new int[]{92233720, 36854775, 807};
    public static final int[] LONG_MIN_VALUE_DIGITS = new int[]{92233720, 36854775, 808};
    public static final int[] INT_POW_10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    public static final long[] LONG_POW_10 = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    private static final long[] INT_DIGITS = new long[32];
    private static final long[] LONG_DIGITS = new long[64];

    private AsciiEncoding() {
    }

    @Deprecated
    public static int endOffset(int value) {
        return AsciiEncoding.digitCount(value) - 1;
    }

    @Deprecated
    public static int endOffset(long value) {
        return AsciiEncoding.digitCount(value) - 1;
    }

    public static int digitCount(int value) {
        return (int)((long)value + INT_DIGITS[31 - Integer.numberOfLeadingZeros(value | 1)] >> 32);
    }

    public static int digitCount(long value) {
        int floorLog2 = 0x3F ^ Long.numberOfLeadingZeros(value | 1L);
        return (int)(LONG_DIGITS[floorLog2] + (value >> (floorLog2 >> 2)) >> 52);
    }

    public static boolean isDigit(byte value) {
        return value >= 48 && value <= 57;
    }

    public static int getDigit(int index, byte value) {
        if (value < 48 || value > 57) {
            throw new AsciiNumberFormatException("'" + (char)value + "' is not a valid digit @ " + index);
        }
        return value - 48;
    }

    public static int getDigit(int index, char value) {
        if (value < '0' || value > '9') {
            throw new AsciiNumberFormatException("'" + value + "' is not a valid digit @ " + index);
        }
        return value - 48;
    }

    public static int parseIntAscii(CharSequence cs, int index, int length) {
        int end;
        if (length <= 0) {
            throw new AsciiNumberFormatException("empty string: index=" + index + " length=" + length);
        }
        boolean negative = '-' == cs.charAt(index);
        int i = index;
        if (negative) {
            ++i;
            if (1 == length) {
                AsciiEncoding.throwParseIntError(cs, index, length);
            }
        }
        if ((end = index + length) - i < 10) {
            int tally = AsciiEncoding.parsePositiveIntAscii(cs, index, length, i, end);
            return negative ? -tally : tally;
        }
        long tally = AsciiEncoding.parsePositiveIntAsciiOverflowCheck(cs, index, length, i, end);
        if (tally > INTEGER_ABSOLUTE_MIN_VALUE || INTEGER_ABSOLUTE_MIN_VALUE == tally && !negative) {
            AsciiEncoding.throwParseIntOverflowError(cs, index, length);
        }
        return (int)(negative ? -tally : tally);
    }

    public static long parseLongAscii(CharSequence cs, int index, int length) {
        int end;
        if (length <= 0) {
            throw new AsciiNumberFormatException("empty string: index=" + index + " length=" + length);
        }
        boolean negative = '-' == cs.charAt(index);
        int i = index;
        if (negative) {
            ++i;
            if (1 == length) {
                AsciiEncoding.throwParseLongError(cs, index, length);
            }
        }
        if ((end = index + length) - i < 19) {
            long tally = AsciiEncoding.parsePositiveLongAscii(cs, index, length, i, end);
            return negative ? -tally : tally;
        }
        if (negative) {
            return -AsciiEncoding.parseLongAsciiOverflowCheck(cs, index, length, LONG_MIN_VALUE_DIGITS, i, end);
        }
        return AsciiEncoding.parseLongAsciiOverflowCheck(cs, index, length, LONG_MAX_VALUE_DIGITS, i, end);
    }

    public static boolean isFourDigitsAsciiEncodedNumber(int value) {
        return 0 == ((value + 0x46464646 | value - 0x30303030) & 0x80808080);
    }

    public static int parseFourDigitsLittleEndian(int bytes) {
        int val = bytes & 0xF0F0F0F;
        val = val * 10 + (val >> 8);
        return (val & 0xFF00FF) * 6553601 >> 16;
    }

    public static boolean isEightDigitAsciiEncodedNumber(long value) {
        return 0L == ((value + 0x4646464646464646L | value - 0x3030303030303030L) & 0x8080808080808080L);
    }

    public static int parseEightDigitsLittleEndian(long bytes) {
        long val = bytes - 0x3030303030303030L;
        val = val * 10L + (val >> 8);
        val = (val & 0xFF000000FFL) * 4294967296000100L + (val >> 16 & 0xFF000000FFL) * 42949672960001L >> 32;
        return (int)val;
    }

    private static int parsePositiveIntAscii(CharSequence cs, int index, int length, int startIndex, int end) {
        byte digit;
        int quartet;
        int i = startIndex;
        int tally = 0;
        while (end - i >= 4 && AsciiEncoding.isFourDigitsAsciiEncodedNumber(quartet = AsciiEncoding.readFourBytesLittleEndian(cs, i))) {
            tally = tally * 10000 + AsciiEncoding.parseFourDigitsLittleEndian(quartet);
            i += 4;
        }
        while (i < end && AsciiEncoding.isDigit(digit = (byte)cs.charAt(i))) {
            tally = tally * 10 + (digit - 48);
            ++i;
        }
        if (i != end) {
            AsciiEncoding.throwParseIntError(cs, index, length);
        }
        return tally;
    }

    private static long parsePositiveIntAsciiOverflowCheck(CharSequence cs, int index, int length, int startIndex, int end) {
        if (end - startIndex > 10) {
            AsciiEncoding.throwParseIntOverflowError(cs, index, length);
        }
        int i = startIndex;
        long tally = 0L;
        long octet = AsciiEncoding.readEightBytesLittleEndian(cs, i);
        if (AsciiEncoding.isEightDigitAsciiEncodedNumber(octet)) {
            byte digit;
            tally = AsciiEncoding.parseEightDigitsLittleEndian(octet);
            i += 8;
            while (i < end && AsciiEncoding.isDigit(digit = (byte)cs.charAt(i))) {
                tally = tally * 10L + (long)(digit - 48);
                ++i;
            }
        }
        if (i != end) {
            AsciiEncoding.throwParseIntError(cs, index, length);
        }
        return tally;
    }

    private static void throwParseIntError(CharSequence cs, int index, int length) {
        throw new AsciiNumberFormatException("error parsing int: " + cs.subSequence(index, index + length));
    }

    private static void throwParseIntOverflowError(CharSequence cs, int index, int length) {
        throw new AsciiNumberFormatException("int overflow parsing: " + cs.subSequence(index, index + length));
    }

    private static long parsePositiveLongAscii(CharSequence cs, int index, int length, int startIndex, int end) {
        byte digit;
        int quartet;
        long octet;
        int i = startIndex;
        long tally = 0L;
        while (end - i >= 8 && AsciiEncoding.isEightDigitAsciiEncodedNumber(octet = AsciiEncoding.readEightBytesLittleEndian(cs, i))) {
            tally = tally * 100000000L + (long)AsciiEncoding.parseEightDigitsLittleEndian(octet);
            i += 8;
        }
        while (end - i >= 4 && AsciiEncoding.isFourDigitsAsciiEncodedNumber(quartet = AsciiEncoding.readFourBytesLittleEndian(cs, i))) {
            tally = tally * 10000L + (long)AsciiEncoding.parseFourDigitsLittleEndian(quartet);
            i += 4;
        }
        while (i < end && AsciiEncoding.isDigit(digit = (byte)cs.charAt(i))) {
            tally = tally * 10L + (long)(digit - 48);
            ++i;
        }
        if (i != end) {
            AsciiEncoding.throwParseLongError(cs, index, length);
        }
        return tally;
    }

    private static long parseLongAsciiOverflowCheck(CharSequence cs, int index, int length, int[] maxValue, int startIndex, int end) {
        byte digit;
        long octet;
        if (end - startIndex > 19) {
            AsciiEncoding.throwParseLongOverflowError(cs, index, length);
        }
        int i = startIndex;
        int k = 0;
        boolean checkOverflow = true;
        long tally = 0L;
        while (end - i >= 8 && AsciiEncoding.isEightDigitAsciiEncodedNumber(octet = AsciiEncoding.readEightBytesLittleEndian(cs, i))) {
            int eightDigits = AsciiEncoding.parseEightDigitsLittleEndian(octet);
            if (checkOverflow) {
                if (eightDigits > maxValue[k]) {
                    AsciiEncoding.throwParseLongOverflowError(cs, index, length);
                } else if (eightDigits < maxValue[k]) {
                    checkOverflow = false;
                }
                ++k;
            }
            tally = tally * 100000000L + (long)eightDigits;
            i += 8;
        }
        int lastDigits = 0;
        while (i < end && AsciiEncoding.isDigit(digit = (byte)cs.charAt(i))) {
            lastDigits = lastDigits * 10 + (digit - 48);
            ++i;
        }
        if (i != end) {
            AsciiEncoding.throwParseLongError(cs, index, length);
        } else if (checkOverflow && lastDigits > maxValue[k]) {
            AsciiEncoding.throwParseLongOverflowError(cs, index, length);
        }
        return tally * 1000L + (long)lastDigits;
    }

    private static void throwParseLongError(CharSequence cs, int index, int length) {
        throw new AsciiNumberFormatException("error parsing long: " + cs.subSequence(index, index + length));
    }

    private static void throwParseLongOverflowError(CharSequence cs, int index, int length) {
        throw new AsciiNumberFormatException("long overflow parsing: " + cs.subSequence(index, index + length));
    }

    private static int readFourBytesLittleEndian(CharSequence cs, int index) {
        return cs.charAt(index + 3) << 24 | cs.charAt(index + 2) << 16 | cs.charAt(index + 1) << 8 | cs.charAt(index);
    }

    private static long readEightBytesLittleEndian(CharSequence cs, int index) {
        return (long)cs.charAt(index + 7) << 56 | (long)cs.charAt(index + 6) << 48 | (long)cs.charAt(index + 5) << 40 | (long)cs.charAt(index + 4) << 32 | (long)cs.charAt(index + 3) << 24 | (long)cs.charAt(index + 2) << 16 | (long)(cs.charAt(index + 1) << 8) | (long)cs.charAt(index);
    }

    static {
        for (int i = 1; i < 33; ++i) {
            int smallest = 1 << i - 1;
            long smallestLog10 = (long)Math.ceil(Math.log10(smallest) / Math.log10(10.0));
            AsciiEncoding.INT_DIGITS[i - 1] = 1 == i ? 0x100000000L : (i < 31 ? 0x100000000L - LONG_POW_10[(int)smallestLog10] + (smallestLog10 << 32) : smallestLog10 << 32);
        }
        BigInteger tenToNineteen = BigInteger.TEN.pow(19);
        for (int i = 0; i < 64; ++i) {
            long value;
            if (0 == i) {
                AsciiEncoding.LONG_DIGITS[i] = 0x10000000000000L;
                continue;
            }
            int upper = (i * 0x134413 >> 22) + 1;
            long correction = upper < 19 ? LONG_POW_10[upper] >> (i >> 2) : tenToNineteen.shiftRight(i >> 2).longValueExact();
            AsciiEncoding.LONG_DIGITS[i] = value = ((long)(upper + 1) << 52) - correction;
        }
    }
}

