/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.relocated.org.agrona.collections;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import org.projectnessie.cel.relocated.org.agrona.BitUtil;
import org.projectnessie.cel.relocated.org.agrona.collections.CollectionUtil;
import org.projectnessie.cel.relocated.org.agrona.collections.Hashing;

public class ObjectHashSet<T>
extends AbstractSet<T> {
    public static final int DEFAULT_INITIAL_CAPACITY = 8;
    static final Object MISSING_VALUE = null;
    private final boolean shouldAvoidAllocation;
    private final float loadFactor;
    private int resizeThreshold;
    private int size;
    private T[] values;
    private ObjectIterator iterator;
    private IntConsumer resizeNotifier;

    public ObjectHashSet() {
        this(8);
    }

    public ObjectHashSet(int proposedCapacity) {
        this(proposedCapacity, 0.65f);
    }

    public ObjectHashSet(int proposedCapacity, float loadFactor) {
        this(proposedCapacity, loadFactor, true);
    }

    public ObjectHashSet(int proposedCapacity, float loadFactor, boolean shouldAvoidAllocation) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.shouldAvoidAllocation = shouldAvoidAllocation;
        this.loadFactor = loadFactor;
        this.size = 0;
        int capacity = BitUtil.findNextPositivePowerOfTwo(Math.max(8, proposedCapacity));
        this.resizeThreshold = (int)((float)capacity * loadFactor);
        this.values = new Object[capacity];
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.values.length;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    public void resizeNotifier(IntConsumer resizeNotifier) {
        this.resizeNotifier = resizeNotifier;
    }

    @Override
    public boolean add(T value) {
        Objects.requireNonNull(value);
        int mask = this.values.length - 1;
        int index = Hashing.hash(value.hashCode(), mask);
        while (this.values[index] != MISSING_VALUE) {
            if (this.values[index].equals(value)) {
                return false;
            }
            index = ObjectHashSet.next(index, mask);
        }
        this.values[index] = value;
        ++this.size;
        if (this.size > this.resizeThreshold) {
            this.increaseCapacity();
            if (this.resizeNotifier != null) {
                this.resizeNotifier.accept(this.resizeThreshold);
            }
        }
        return true;
    }

    private void increaseCapacity() {
        int newCapacity = this.values.length * 2;
        if (newCapacity < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size);
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int mask = newCapacity - 1;
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        Object[] tempValues = new Object[newCapacity];
        Arrays.fill(tempValues, MISSING_VALUE);
        for (T value : this.values) {
            if (value == MISSING_VALUE) continue;
            int newHash = Hashing.hash(value.hashCode(), mask);
            while (tempValues[newHash] != MISSING_VALUE) {
                ++newHash;
                newHash &= mask;
            }
            tempValues[newHash] = value;
        }
        this.values = tempValues;
    }

    @Override
    public boolean remove(Object value) {
        T[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(value.hashCode(), mask);
        while (values[index] != MISSING_VALUE) {
            if (values[index].equals(value)) {
                values[index] = MISSING_VALUE;
                this.compactChain(index);
                --this.size;
                return true;
            }
            index = ObjectHashSet.next(index, mask);
        }
        return false;
    }

    private static int next(int index, int mask) {
        return index + 1 & mask;
    }

    void compactChain(int deleteIndex) {
        T[] values = this.values;
        int mask = values.length - 1;
        int index = deleteIndex;
        while (values[index = ObjectHashSet.next(index, mask)] != MISSING_VALUE) {
            int hash = Hashing.hash(values[index].hashCode(), mask);
            if ((index >= hash || hash > deleteIndex && deleteIndex > index) && (hash > deleteIndex || deleteIndex > index)) continue;
            values[deleteIndex] = values[index];
            values[index] = MISSING_VALUE;
            deleteIndex = index;
        }
        return;
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    @Override
    public boolean contains(Object value) {
        int mask = this.values.length - 1;
        int index = Hashing.hash(value.hashCode(), mask);
        while (this.values[index] != MISSING_VALUE) {
            if (value == this.values[index] || this.values[index].equals(value)) {
                return true;
            }
            index = ObjectHashSet.next(index, mask);
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.values, MISSING_VALUE);
            this.size = 0;
        }
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        for (Object t : coll) {
            if (this.contains(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> coll) {
        return ObjectHashSet.disjunction(coll, this::add);
    }

    @Override
    public boolean addAll(ObjectHashSet<T> coll) {
        boolean acc = false;
        for (T value : coll.values) {
            if (value == MISSING_VALUE) continue;
            acc |= this.add(value);
        }
        return acc;
    }

    public ObjectHashSet<T> difference(ObjectHashSet<T> other) {
        ObjectHashSet<T> difference = null;
        for (T value : this.values) {
            if (value == MISSING_VALUE || other.contains(value)) continue;
            if (difference == null) {
                difference = new ObjectHashSet<T>(this.size);
            }
            difference.add(value);
        }
        return difference;
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        return ObjectHashSet.disjunction(coll, this::remove);
    }

    @Override
    public boolean removeAll(ObjectHashSet<T> coll) {
        boolean acc = false;
        for (T value : coll.values) {
            if (value == MISSING_VALUE) continue;
            acc |= this.remove(value);
        }
        return acc;
    }

    private static <T> boolean disjunction(Collection<T> coll, Predicate<T> predicate) {
        boolean acc = false;
        for (T t : coll) {
            acc |= predicate.test(t);
        }
        return acc;
    }

    public ObjectIterator iterator() {
        ObjectIterator iterator = this.iterator;
        if (null == iterator) {
            iterator = new ObjectIterator();
            if (this.shouldAvoidAllocation) {
                this.iterator = iterator;
            }
        }
        return iterator.reset();
    }

    public void copy(ObjectHashSet<T> that) {
        if (this.values.length != that.values.length) {
            throw new IllegalArgumentException("cannot copy object: lengths not equal");
        }
        System.arraycopy(that.values, 0, this.values, 0, this.values.length);
        this.size = that.size;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (T value : this.values) {
            if (value == MISSING_VALUE) continue;
            sb.append(value).append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ObjectHashSet) {
            ObjectHashSet otherSet = (ObjectHashSet)other;
            return otherSet.size == this.size && this.containsAll(otherSet);
        }
        if (!(other instanceof Set)) {
            return false;
        }
        Set c = (Set)other;
        if (c.size() != this.size()) {
            return false;
        }
        try {
            return this.containsAll(c);
        }
        catch (ClassCastException | NullPointerException ignore) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (T value : this.values) {
            if (value == MISSING_VALUE) continue;
            hashCode += value.hashCode();
        }
        return hashCode;
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        int remaining = this.size;
        int length = this.values.length;
        for (int i = 0; remaining > 0 && i < length; ++i) {
            if (null == this.values[i]) continue;
            action.accept(this.values[i]);
            --remaining;
        }
    }

    public final class ObjectIterator
    implements Iterator<T> {
        private int remaining;
        private int positionCounter;
        private int stopCounter;
        private boolean isPositionValid = false;

        ObjectIterator reset() {
            int length;
            this.remaining = ObjectHashSet.this.size;
            Object[] values = ObjectHashSet.this.values;
            int i = length = values.length;
            if (values[length - 1] != MISSING_VALUE) {
                for (i = 0; i < length && values[i] != MISSING_VALUE; ++i) {
                }
            }
            this.stopCounter = i;
            this.positionCounter = i + length;
            this.isPositionValid = false;
            return this;
        }

        public int remaining() {
            return this.remaining;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        @Override
        public T next() {
            return this.nextValue();
        }

        public T nextValue() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object[] values = ObjectHashSet.this.values;
            int mask = values.length - 1;
            this.isPositionValid = false;
            for (int i = this.positionCounter - 1; i >= this.stopCounter; --i) {
                int index = i & mask;
                Object value = values[index];
                if (value == MISSING_VALUE) continue;
                this.positionCounter = i;
                this.isPositionValid = true;
                --this.remaining;
                return value;
            }
            throw new IllegalStateException();
        }

        @Override
        public void remove() {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            Object[] values = ObjectHashSet.this.values;
            int position = this.position(values);
            values[position] = MISSING_VALUE;
            --ObjectHashSet.this.size;
            ObjectHashSet.this.compactChain(position);
            this.isPositionValid = false;
        }

        private int position(T[] values) {
            return this.positionCounter & values.length - 1;
        }
    }
}

