/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.relocated.org.agrona.concurrent.status;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.projectnessie.cel.relocated.org.agrona.DirectBuffer;
import org.projectnessie.cel.relocated.org.agrona.collections.IntObjConsumer;
import org.projectnessie.cel.relocated.org.agrona.concurrent.AtomicBuffer;
import org.projectnessie.cel.relocated.org.agrona.concurrent.UnsafeBuffer;

public class CountersReader {
    public static final int DEFAULT_TYPE_ID = 0;
    public static final long DEFAULT_REGISTRATION_ID = 0L;
    public static final long DEFAULT_OWNER_ID = 0L;
    public static final long DEFAULT_REFERENCE_ID = 0L;
    public static final int NULL_COUNTER_ID = -1;
    public static final int RECORD_UNUSED = 0;
    public static final int RECORD_ALLOCATED = 1;
    public static final int RECORD_RECLAIMED = -1;
    public static final long NOT_FREE_TO_REUSE = Long.MAX_VALUE;
    public static final int REGISTRATION_ID_OFFSET = 8;
    public static final int OWNER_ID_OFFSET = 16;
    public static final int REFERENCE_ID_OFFSET = 24;
    public static final int TYPE_ID_OFFSET = 4;
    public static final int FREE_FOR_REUSE_DEADLINE_OFFSET = 8;
    public static final int KEY_OFFSET = 16;
    public static final int LABEL_OFFSET = 128;
    public static final int FULL_LABEL_LENGTH = 384;
    public static final int MAX_LABEL_LENGTH = 380;
    public static final int MAX_KEY_LENGTH = 112;
    public static final int METADATA_LENGTH = 512;
    public static final int COUNTER_LENGTH = 128;
    protected final int maxCounterId;
    protected final AtomicBuffer metaDataBuffer;
    protected final AtomicBuffer valuesBuffer;
    protected final Charset labelCharset;

    public CountersReader(AtomicBuffer metaDataBuffer, AtomicBuffer valuesBuffer) {
        this(metaDataBuffer, valuesBuffer, StandardCharsets.UTF_8);
    }

    public CountersReader(AtomicBuffer metaDataBuffer, AtomicBuffer valuesBuffer, Charset labelCharset) {
        this.maxCounterId = valuesBuffer.capacity() / 128 - 1;
        this.valuesBuffer = valuesBuffer;
        this.metaDataBuffer = metaDataBuffer;
        this.labelCharset = labelCharset;
    }

    public int maxCounterId() {
        return this.maxCounterId;
    }

    public AtomicBuffer metaDataBuffer() {
        return this.metaDataBuffer;
    }

    public AtomicBuffer valuesBuffer() {
        return this.valuesBuffer;
    }

    public Charset labelCharset() {
        return this.labelCharset;
    }

    public static int counterOffset(int counterId) {
        return counterId * 128;
    }

    public static int metaDataOffset(int counterId) {
        return counterId * 512;
    }

    public void forEach(IntObjConsumer<String> consumer) {
        int counterId = 0;
        AtomicBuffer metaDataBuffer = this.metaDataBuffer;
        int capacity = metaDataBuffer.capacity();
        for (int i = 0; i < capacity; i += 512) {
            int recordStatus = metaDataBuffer.getIntVolatile(i);
            if (1 == recordStatus) {
                consumer.accept(counterId, this.labelValue(metaDataBuffer, i));
            } else if (0 == recordStatus) break;
            ++counterId;
        }
    }

    public void forEach(CounterConsumer consumer) {
        int counterId = 0;
        AtomicBuffer metaDataBuffer = this.metaDataBuffer;
        AtomicBuffer valuesBuffer = this.valuesBuffer;
        int capacity = metaDataBuffer.capacity();
        for (int offset = 0; offset < capacity; offset += 512) {
            int recordStatus = metaDataBuffer.getIntVolatile(offset);
            if (1 == recordStatus) {
                String label = this.labelValue(metaDataBuffer, offset);
                long value = valuesBuffer.getLongVolatile(CountersReader.counterOffset(counterId));
                consumer.accept(value, counterId, label);
            } else if (0 == recordStatus) break;
            ++counterId;
        }
    }

    public void forEach(MetaData metaData) {
        int counterId = 0;
        AtomicBuffer metaDataBuffer = this.metaDataBuffer;
        int capacity = metaDataBuffer.capacity();
        for (int offset = 0; offset < capacity; offset += 512) {
            int recordStatus = metaDataBuffer.getIntVolatile(offset);
            if (1 == recordStatus) {
                int typeId = metaDataBuffer.getInt(offset + 4);
                String label = this.labelValue(metaDataBuffer, offset);
                UnsafeBuffer keyBuffer = new UnsafeBuffer(metaDataBuffer, offset + 16, 112);
                metaData.accept(counterId, typeId, keyBuffer, label);
            } else if (0 == recordStatus) break;
            ++counterId;
        }
    }

    public int findByRegistrationId(long registrationId) {
        int counterId = -1;
        AtomicBuffer metaDataBuffer = this.metaDataBuffer;
        int capacity = metaDataBuffer.capacity();
        int offset = 0;
        int i = 0;
        while (offset < capacity) {
            int recordStatus = metaDataBuffer.getIntVolatile(offset);
            if (1 == recordStatus) {
                if (registrationId == this.valuesBuffer.getLongVolatile(CountersReader.counterOffset(i) + 8)) {
                    counterId = i;
                    break;
                }
            } else if (0 == recordStatus) break;
            offset += 512;
            ++i;
        }
        return counterId;
    }

    public int findByTypeIdAndRegistrationId(int typeId, long registrationId) {
        int counterId = -1;
        AtomicBuffer metaDataBuffer = this.metaDataBuffer;
        int capacity = metaDataBuffer.capacity();
        int offset = 0;
        int i = 0;
        while (offset < capacity) {
            int recordStatus = metaDataBuffer.getIntVolatile(offset);
            if (1 == recordStatus) {
                if (typeId == metaDataBuffer.getInt(offset + 4) && registrationId == this.valuesBuffer.getLongVolatile(CountersReader.counterOffset(i) + 8)) {
                    counterId = i;
                    break;
                }
            } else if (0 == recordStatus) break;
            offset += 512;
            ++i;
        }
        return counterId;
    }

    public long getCounterValue(int counterId) {
        this.validateCounterId(counterId);
        return this.valuesBuffer.getLongVolatile(CountersReader.counterOffset(counterId));
    }

    public long getCounterRegistrationId(int counterId) {
        this.validateCounterId(counterId);
        return this.valuesBuffer.getLongVolatile(CountersReader.counterOffset(counterId) + 8);
    }

    public long getCounterOwnerId(int counterId) {
        this.validateCounterId(counterId);
        return this.valuesBuffer.getLong(CountersReader.counterOffset(counterId) + 16);
    }

    public long getCounterReferenceId(int counterId) {
        this.validateCounterId(counterId);
        return this.valuesBuffer.getLong(CountersReader.counterOffset(counterId) + 24);
    }

    public int getCounterState(int counterId) {
        this.validateCounterId(counterId);
        return this.metaDataBuffer.getIntVolatile(CountersReader.metaDataOffset(counterId));
    }

    public int getCounterTypeId(int counterId) {
        this.validateCounterId(counterId);
        return this.metaDataBuffer.getInt(CountersReader.metaDataOffset(counterId) + 4);
    }

    public long getFreeForReuseDeadline(int counterId) {
        this.validateCounterId(counterId);
        return this.metaDataBuffer.getLongVolatile(CountersReader.metaDataOffset(counterId) + 8);
    }

    public String getCounterLabel(int counterId) {
        this.validateCounterId(counterId);
        return this.labelValue(this.metaDataBuffer, CountersReader.metaDataOffset(counterId));
    }

    protected void validateCounterId(int counterId) {
        if (counterId < 0 || counterId > this.maxCounterId) {
            throw new IllegalArgumentException("counter id " + counterId + " out of range: 0 - maxCounterId=" + this.maxCounterId);
        }
    }

    private String labelValue(AtomicBuffer metaDataBuffer, int recordOffset) {
        int labelLength = metaDataBuffer.getIntVolatile(recordOffset + 128);
        byte[] stringInBytes = new byte[labelLength];
        metaDataBuffer.getBytes(recordOffset + 128 + 4, stringInBytes);
        return new String(stringInBytes, this.labelCharset);
    }

    @FunctionalInterface
    public static interface CounterConsumer {
        public void accept(long var1, int var3, String var4);
    }

    @FunctionalInterface
    public static interface MetaData {
        public void accept(int var1, int var2, DirectBuffer var3, String var4);
    }
}

