/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.common.types;

import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.zone.ZoneRulesException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.projectnessie.cel.common.types.BoolT;
import org.projectnessie.cel.common.types.DurationT;
import org.projectnessie.cel.common.types.Err;
import org.projectnessie.cel.common.types.IntT;
import org.projectnessie.cel.common.types.Overflow;
import org.projectnessie.cel.common.types.StringT;
import org.projectnessie.cel.common.types.TypeT;
import org.projectnessie.cel.common.types.Types;
import org.projectnessie.cel.common.types.ref.BaseVal;
import org.projectnessie.cel.common.types.ref.Type;
import org.projectnessie.cel.common.types.ref.TypeEnum;
import org.projectnessie.cel.common.types.ref.Val;
import org.projectnessie.cel.common.types.traits.Adder;
import org.projectnessie.cel.common.types.traits.Comparer;
import org.projectnessie.cel.common.types.traits.Receiver;
import org.projectnessie.cel.common.types.traits.Subtractor;
import org.projectnessie.cel.common.types.traits.Trait;
import org.projectnessie.cel.relocated.com.google.protobuf.Any;
import org.projectnessie.cel.relocated.com.google.protobuf.StringValue;
import org.projectnessie.cel.relocated.com.google.protobuf.Timestamp;
import org.projectnessie.cel.relocated.com.google.protobuf.Value;

public final class TimestampT
extends BaseVal
implements Adder,
Comparer,
Receiver,
Subtractor {
    public static final Type TimestampType = TypeT.newTypeValue(TypeEnum.Timestamp, Trait.AdderType, Trait.ComparerType, Trait.ReceiverType, Trait.SubtractorType);
    public static final long minUnixTime = -62135596800L;
    public static final long maxUnixTime = 253402300799L;
    public static final ZoneId ZoneIdZ = ZoneId.of("Z");
    private static final Map<String, Function<ZonedDateTime, Val>> timestampZeroArgOverloads = new HashMap<String, Function<ZonedDateTime, Val>>();
    private static final Map<String, BiFunction<ZonedDateTime, Val, Val>> timestampOneArgOverloads;
    private final ZonedDateTime t;
    private static final DateTimeFormatter jsonFormatter;
    private static final DateTimeFormatter rfc3339formatter;
    private static final DateTimeFormatter rfc3339nanoFormatter;
    private static final DateTimeFormatter rfc3339fractionFormatter;

    public static TimestampT timestampOf(String s) {
        return TimestampT.timestampOf(rfc3339fractionFormatter.parse((CharSequence)s, ZonedDateTime::from));
    }

    public static TimestampT timestampOf(Instant t) {
        return new TimestampT(ZonedDateTime.ofInstant(t, ZoneIdZ));
    }

    public static TimestampT timestampOf(Timestamp t) {
        LocalDateTime ldt = LocalDateTime.ofEpochSecond(t.getSeconds(), t.getNanos(), ZoneOffset.UTC);
        ZonedDateTime zdt = ZonedDateTime.of(ldt, ZoneIdZ);
        return new TimestampT(zdt);
    }

    public static TimestampT timestampOf(ZonedDateTime t) {
        return new TimestampT(t);
    }

    private TimestampT(ZonedDateTime t) {
        this.t = t;
    }

    public Val rangeCheck() {
        long unitTime = this.t.toEpochSecond();
        if (unitTime < -62135596800L || unitTime > 253402300799L) {
            return Err.errTimestampOutOfRange;
        }
        return this;
    }

    @Override
    public Val add(Val other) {
        if (other.type().typeEnum() == TypeEnum.Duration) {
            return ((DurationT)other).add(this);
        }
        return Err.noSuchOverload(this, "add", other);
    }

    @Override
    public Val compare(Val other) {
        if (TimestampType != other.type()) {
            return Err.noSuchOverload(this, "compare", other);
        }
        ZonedDateTime ts1 = this.t;
        ZonedDateTime ts2 = ((TimestampT)other).t;
        if (ts1.isBefore(ts2)) {
            return IntT.IntNegOne;
        }
        if (ts1.isAfter(ts2)) {
            return IntT.IntOne;
        }
        return IntT.IntZero;
    }

    @Override
    public <T> T convertToNative(Class<T> typeDesc) {
        if (typeDesc == ZonedDateTime.class) {
            return (T)this.t;
        }
        if (typeDesc == Date.class) {
            return (T)new Date(this.toEpochMillis());
        }
        if (typeDesc == Calendar.class) {
            Calendar c = Calendar.getInstance(TimeZone.getTimeZone(ZoneIdZ.getId()));
            c.setTimeInMillis(this.toEpochMillis());
            return (T)c;
        }
        if (typeDesc == OffsetDateTime.class) {
            return (T)this.t.toOffsetDateTime();
        }
        if (typeDesc == LocalDateTime.class) {
            return (T)this.t.toLocalDateTime();
        }
        if (typeDesc == LocalDate.class) {
            return (T)this.t.toLocalDate();
        }
        if (typeDesc == LocalTime.class) {
            return (T)this.t.toLocalTime();
        }
        if (typeDesc == Instant.class) {
            return (T)this.t.toInstant();
        }
        if (typeDesc == Any.class) {
            return (T)Any.pack(this.toPbTimestamp());
        }
        if (typeDesc == Timestamp.class || typeDesc == Object.class) {
            return (T)this.toPbTimestamp();
        }
        if (typeDesc == Val.class || typeDesc == TimestampT.class) {
            return (T)this;
        }
        if (typeDesc == Value.class) {
            return (T)StringValue.of(jsonFormatter.format(this.t));
        }
        throw new RuntimeException(String.format("native type conversion error from '%s' to '%s'", TimestampType, typeDesc.getName()));
    }

    private long toEpochMillis() {
        return TimeUnit.SECONDS.toMillis(this.t.toEpochSecond()) + TimeUnit.NANOSECONDS.toMillis(this.t.getNano());
    }

    private Timestamp toPbTimestamp() {
        return Timestamp.newBuilder().setSeconds(this.t.toEpochSecond()).setNanos(this.t.getNano()).build();
    }

    @Override
    public Val convertToType(Type typeValue) {
        switch (typeValue.typeEnum()) {
            case String: {
                DateTimeFormatter df = (long)this.t.getNano() > 0L ? rfc3339nanoFormatter : rfc3339formatter;
                return StringT.stringOf(df.format(this.t));
            }
            case Int: {
                return IntT.intOf(this.t.toEpochSecond());
            }
            case Timestamp: {
                return this;
            }
            case Type: {
                return TimestampType;
            }
        }
        return Err.newTypeConversionError(TimestampType, typeValue);
    }

    @Override
    public Val equal(Val other) {
        switch (other.type().typeEnum()) {
            case Timestamp: {
                return Types.boolOf(this.t.equals(((TimestampT)other).t));
            }
            case Null: {
                return BoolT.False;
            }
        }
        return Err.noSuchOverload(this, "equal", other);
    }

    @Override
    public Val receive(String function, String overload, Val ... args) {
        switch (args.length) {
            case 0: {
                Function<ZonedDateTime, Val> f0 = timestampZeroArgOverloads.get(function);
                if (f0 == null) break;
                return f0.apply(this.t);
            }
            case 1: {
                BiFunction<ZonedDateTime, Val, Val> f1 = timestampOneArgOverloads.get(function);
                if (f1 == null) break;
                return f1.apply(this.t, args[0]);
            }
        }
        return Err.noSuchOverload((Val)this, function, overload, args);
    }

    @Override
    public Val subtract(Val other) {
        switch (other.type().typeEnum()) {
            case Duration: {
                Duration d = (Duration)other.value();
                try {
                    return TimestampT.timestampOf(Overflow.subtractTimeDurationChecked(this.t, d));
                }
                catch (Overflow.OverflowException e) {
                    return Err.errTimestampOverflow;
                }
            }
            case Timestamp: {
                ZonedDateTime o = (ZonedDateTime)other.value();
                try {
                    return DurationT.durationOf(Overflow.subtractTimeChecked(this.t, o)).rangeCheck();
                }
                catch (Overflow.OverflowException e) {
                    return Err.errDurationOverflow;
                }
            }
        }
        return Err.noSuchOverload(this, "subtract", other);
    }

    @Override
    public Type type() {
        return TimestampType;
    }

    @Override
    public Object value() {
        return this.t;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimestampT that = (TimestampT)o;
        return Objects.equals(this.t, that.t);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.t);
    }

    static Val timestampGetFullYear(ZonedDateTime t) {
        return IntT.intOf(t.getYear());
    }

    static Val timestampGetMonth(ZonedDateTime t) {
        return IntT.intOf(t.getMonthValue() - 1);
    }

    static Val timestampGetDayOfYear(ZonedDateTime t) {
        return IntT.intOf(t.getDayOfYear() - 1);
    }

    static Val timestampGetDayOfMonthZeroBased(ZonedDateTime t) {
        return IntT.intOf(t.getDayOfMonth() - 1);
    }

    static Val timestampGetDayOfMonthOneBased(ZonedDateTime t) {
        return IntT.intOf(t.getDayOfMonth());
    }

    static Val timestampGetDayOfWeek(ZonedDateTime t) {
        return IntT.intOf(t.getDayOfWeek().getValue());
    }

    static Val timestampGetHours(ZonedDateTime t) {
        return IntT.intOf(t.getHour());
    }

    static Val timestampGetMinutes(ZonedDateTime t) {
        return IntT.intOf(t.getMinute());
    }

    static Val timestampGetSeconds(ZonedDateTime t) {
        return IntT.intOf(t.getSecond());
    }

    static Val timestampGetMilliseconds(ZonedDateTime t) {
        return IntT.intOf(TimeUnit.NANOSECONDS.toMillis(t.getNano()));
    }

    static Val timestampGetFullYearWithTz(ZonedDateTime t, Val tz) {
        return TimestampT.timeZone(tz, TimestampT::timestampGetFullYear, t);
    }

    static Val timestampGetMonthWithTz(ZonedDateTime t, Val tz) {
        return TimestampT.timeZone(tz, TimestampT::timestampGetMonth, t);
    }

    static Val timestampGetDayOfYearWithTz(ZonedDateTime t, Val tz) {
        return TimestampT.timeZone(tz, TimestampT::timestampGetDayOfYear, t);
    }

    static Val timestampGetDayOfMonthZeroBasedWithTz(ZonedDateTime t, Val tz) {
        return TimestampT.timeZone(tz, TimestampT::timestampGetDayOfMonthZeroBased, t);
    }

    static Val timestampGetDayOfMonthOneBasedWithTz(ZonedDateTime t, Val tz) {
        return TimestampT.timeZone(tz, TimestampT::timestampGetDayOfMonthOneBased, t);
    }

    static Val timestampGetDayOfWeekWithTz(ZonedDateTime t, Val tz) {
        return TimestampT.timeZone(tz, TimestampT::timestampGetDayOfWeek, t);
    }

    static Val timestampGetHoursWithTz(ZonedDateTime t, Val tz) {
        return TimestampT.timeZone(tz, TimestampT::timestampGetHours, t);
    }

    static Val timestampGetMinutesWithTz(ZonedDateTime t, Val tz) {
        return TimestampT.timeZone(tz, TimestampT::timestampGetMinutes, t);
    }

    static Val timestampGetSecondsWithTz(ZonedDateTime t, Val tz) {
        return TimestampT.timeZone(tz, TimestampT::timestampGetSeconds, t);
    }

    static Val timestampGetMillisecondsWithTz(ZonedDateTime t, Val tz) {
        return TimestampT.timeZone(tz, TimestampT::timestampGetMilliseconds, t);
    }

    private static Val timeZone(Val tz, Function<ZonedDateTime, Val> funct, ZonedDateTime t) {
        if (tz.type().typeEnum() != TypeEnum.String) {
            return Err.noSuchOverload(TimestampType, "_op_with_timezone", tz);
        }
        String val = (String)tz.value();
        try {
            ZoneId zoneId = TimestampT.parseTz(val);
            ZonedDateTime z = t.withZoneSameInstant(zoneId);
            return funct.apply(z);
        }
        catch (Exception e) {
            return Err.newErr(e, "no conversion of '%s' to time-zone '%s': %s", t, val, e);
        }
    }

    static ZoneId parseTz(String tz) {
        if (tz.isEmpty()) {
            throw new DateTimeException("time-zone must not be empty");
        }
        char first = tz.charAt(0);
        if (first == '-' || first == '+' || first >= '0' && first <= '9') {
            boolean negate = false;
            int[] i = new int[]{0};
            if (first == '-') {
                negate = true;
                i[0] = i[0] + 1;
            } else if (first == '+') {
                i[0] = i[0] + 1;
            }
            int hours = TimestampT.parseNumber(tz, i, false);
            int minutes = TimestampT.parseNumber(tz, i, true);
            int seconds = TimestampT.parseNumber(tz, i, true);
            if (hours > 18 || minutes > 59 || seconds > 59) {
                throw new DateTimeException(String.format("invalid hour/minute/second value in time zone: '%s'", tz));
            }
            ZoneOffset offset = negate ? ZoneOffset.ofHoursMinutesSeconds(-hours, -minutes, -seconds) : ZoneOffset.ofHoursMinutesSeconds(hours, minutes, seconds);
            return ZoneId.ofOffset("UTC", offset);
        }
        try {
            return ZoneId.of(tz);
        }
        catch (ZoneRulesException e) {
            return TimeZone.getTimeZone(tz).toZoneId();
        }
    }

    private static int parseNumber(String tz, int[] i, boolean skipColon) {
        char c;
        if (skipColon && i[0] < tz.length() && (c = tz.charAt(i[0])) == ':') {
            i[0] = i[0] + 1;
        }
        if (i[0] < tz.length()) {
            c = tz.charAt(i[0]);
            if (c >= '0' && c <= '9') {
                int dig1 = c - 48;
                i[0] = i[0] + 1;
                if (i[0] < tz.length()) {
                    c = tz.charAt(i[0]);
                    if (c >= '0' && c <= '9') {
                        i[0] = i[0] + 1;
                        int dig2 = c - 48;
                        return dig1 * 10 + dig2;
                    }
                    if (c != ':') {
                        throw new DateTimeException(String.format("unexpected character '%s' at index %d", Character.valueOf(c), i[0]));
                    }
                }
                return dig1;
            }
            throw new DateTimeException(String.format("unexpected character '%s' at index %d", Character.valueOf(c), i[0]));
        }
        return 0;
    }

    static {
        timestampZeroArgOverloads.put("getFullYear", TimestampT::timestampGetFullYear);
        timestampZeroArgOverloads.put("getMonth", TimestampT::timestampGetMonth);
        timestampZeroArgOverloads.put("getDayOfYear", TimestampT::timestampGetDayOfYear);
        timestampZeroArgOverloads.put("getDate", TimestampT::timestampGetDayOfMonthOneBased);
        timestampZeroArgOverloads.put("getDayOfMonth", TimestampT::timestampGetDayOfMonthZeroBased);
        timestampZeroArgOverloads.put("getDayOfWeek", TimestampT::timestampGetDayOfWeek);
        timestampZeroArgOverloads.put("getHours", TimestampT::timestampGetHours);
        timestampZeroArgOverloads.put("getMinutes", TimestampT::timestampGetMinutes);
        timestampZeroArgOverloads.put("getSeconds", TimestampT::timestampGetSeconds);
        timestampZeroArgOverloads.put("getMilliseconds", TimestampT::timestampGetMilliseconds);
        timestampOneArgOverloads = new HashMap<String, BiFunction<ZonedDateTime, Val, Val>>();
        timestampOneArgOverloads.put("getFullYear", TimestampT::timestampGetFullYearWithTz);
        timestampOneArgOverloads.put("getMonth", TimestampT::timestampGetMonthWithTz);
        timestampOneArgOverloads.put("getDayOfYear", TimestampT::timestampGetDayOfYearWithTz);
        timestampOneArgOverloads.put("getDate", TimestampT::timestampGetDayOfMonthOneBasedWithTz);
        timestampOneArgOverloads.put("getDayOfMonth", TimestampT::timestampGetDayOfMonthZeroBasedWithTz);
        timestampOneArgOverloads.put("getDayOfWeek", TimestampT::timestampGetDayOfWeekWithTz);
        timestampOneArgOverloads.put("getHours", TimestampT::timestampGetHoursWithTz);
        timestampOneArgOverloads.put("getMinutes", TimestampT::timestampGetMinutesWithTz);
        timestampOneArgOverloads.put("getSeconds", TimestampT::timestampGetSecondsWithTz);
        timestampOneArgOverloads.put("getMilliseconds", TimestampT::timestampGetMillisecondsWithTz);
        jsonFormatter = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 5, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral('Z').toFormatter();
        rfc3339formatter = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 5, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendOffset("+HH:MM", "Z").toFormatter();
        rfc3339nanoFormatter = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 5, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral('.').appendValue(ChronoField.NANO_OF_SECOND, 9, 9, SignStyle.NOT_NEGATIVE).appendOffset("+HH:MM", "Z").toFormatter();
        rfc3339fractionFormatter = new DateTimeFormatterBuilder().parseLenient().appendValue(ChronoField.YEAR, 4, 5, SignStyle.EXCEEDS_PAD).parseStrict().appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendLiteral('.').appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, false).optionalEnd().appendOffset("+HH:MM", "Z").toFormatter();
    }
}

