/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.parser;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.projectnessie.cel.common.ErrorWithLocation;
import org.projectnessie.cel.common.Location;
import org.projectnessie.cel.common.operators.Operator;
import org.projectnessie.cel.parser.ExprHelper;
import org.projectnessie.cel.parser.MacroExpander;
import org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.Expr;

public final class Macro {
    public static final String AccumulatorName = "__result__";
    public static final List<Macro> AllMacros = Arrays.asList(Macro.newGlobalMacro(Operator.Has.id, 1, Macro::makeHas), Macro.newReceiverMacro(Operator.All.id, 2, Macro::makeAll), Macro.newReceiverMacro(Operator.Exists.id, 2, Macro::makeExists), Macro.newReceiverMacro(Operator.ExistsOne.id, 2, Macro::makeExistsOne), Macro.newReceiverMacro(Operator.Map.id, 2, Macro::makeMap), Macro.newReceiverMacro(Operator.Map.id, 3, Macro::makeMap), Macro.newReceiverMacro(Operator.Filter.id, 2, Macro::makeFilter));
    public static List<Macro> MoMacros = Collections.emptyList();
    private final String function;
    private final boolean receiverStyle;
    private final boolean varArgStyle;
    private final int argCount;
    private final MacroExpander expander;

    public Macro(String function, boolean receiverStyle, boolean varArgStyle, int argCount, MacroExpander expander) {
        this.function = function;
        this.receiverStyle = receiverStyle;
        this.varArgStyle = varArgStyle;
        this.argCount = argCount;
        this.expander = expander;
    }

    public String toString() {
        return "Macro{function='" + this.function + '\'' + ", receiverStyle=" + this.receiverStyle + ", varArgStyle=" + this.varArgStyle + ", argCount=" + this.argCount + '}';
    }

    static String makeMacroKey(String name, int args, boolean receiverStyle) {
        return String.format("%s:%d:%s", name, args, receiverStyle);
    }

    static String makeVarArgMacroKey(String name, boolean receiverStyle) {
        return String.format("%s:*:%s", name, receiverStyle);
    }

    static Macro newGlobalMacro(String function, int argCount, MacroExpander expander) {
        return new Macro(function, false, false, argCount, expander);
    }

    public static Macro newReceiverMacro(String function, int argCount, MacroExpander expander) {
        return new Macro(function, true, false, argCount, expander);
    }

    static Macro newGlobalVarArgMacro(String function, MacroExpander expander) {
        return new Macro(function, false, true, 0, expander);
    }

    static Macro newReceiverVarArgMacro(String function, MacroExpander expander) {
        return new Macro(function, true, true, 0, expander);
    }

    static Expr makeAll(ExprHelper eh, Expr target, List<Expr> args) {
        return Macro.makeQuantifier(QuantifierKind.quantifierAll, eh, target, args);
    }

    static Expr makeExists(ExprHelper eh, Expr target, List<Expr> args) {
        return Macro.makeQuantifier(QuantifierKind.quantifierExists, eh, target, args);
    }

    static Expr makeExistsOne(ExprHelper eh, Expr target, List<Expr> args) {
        return Macro.makeQuantifier(QuantifierKind.quantifierExistsOne, eh, target, args);
    }

    static Expr makeQuantifier(QuantifierKind kind, ExprHelper eh, Expr target, List<Expr> args) {
        Expr result;
        Expr step;
        Expr condition;
        Expr init;
        String v = Macro.extractIdent(args.get(0));
        if (v == null) {
            Location location = eh.offsetLocation(args.get(0).getId());
            throw new ErrorWithLocation(location, "argument must be a simple name");
        }
        Supplier<Expr> accuIdent = () -> eh.ident(AccumulatorName);
        switch (kind) {
            case quantifierAll: {
                init = eh.literalBool(true);
                condition = eh.globalCall(Operator.NotStrictlyFalse.id, accuIdent.get());
                step = eh.globalCall(Operator.LogicalAnd.id, accuIdent.get(), args.get(1));
                result = accuIdent.get();
                break;
            }
            case quantifierExists: {
                init = eh.literalBool(false);
                condition = eh.globalCall(Operator.NotStrictlyFalse.id, eh.globalCall(Operator.LogicalNot.id, accuIdent.get()));
                step = eh.globalCall(Operator.LogicalOr.id, accuIdent.get(), args.get(1));
                result = accuIdent.get();
                break;
            }
            case quantifierExistsOne: {
                Expr zeroExpr = eh.literalInt(0L);
                Expr oneExpr = eh.literalInt(1L);
                init = zeroExpr;
                condition = eh.literalBool(true);
                step = eh.globalCall(Operator.Conditional.id, args.get(1), eh.globalCall(Operator.Add.id, accuIdent.get(), oneExpr), accuIdent.get());
                result = eh.globalCall(Operator.Equals.id, accuIdent.get(), oneExpr);
                break;
            }
            default: {
                throw new ErrorWithLocation(null, String.format("unrecognized quantifier '%s'", new Object[]{kind}));
            }
        }
        return eh.fold(v, target, AccumulatorName, init, condition, step, result);
    }

    static Expr makeMap(ExprHelper eh, Expr target, List<Expr> args) {
        Expr fn;
        Expr filter;
        String v = Macro.extractIdent(args.get(0));
        if (v == null) {
            throw new ErrorWithLocation(null, "argument is not an identifier");
        }
        if (args.size() == 3) {
            filter = args.get(1);
            fn = args.get(2);
        } else {
            filter = null;
            fn = args.get(1);
        }
        Expr accuExpr = eh.ident(AccumulatorName);
        Expr init = eh.newList(new Expr[0]);
        Expr condition = eh.literalBool(true);
        Expr step = eh.globalCall(Operator.Add.id, accuExpr, eh.newList(fn));
        if (filter != null) {
            step = eh.globalCall(Operator.Conditional.id, filter, step, accuExpr);
        }
        return eh.fold(v, target, AccumulatorName, init, condition, step, accuExpr);
    }

    static Expr makeFilter(ExprHelper eh, Expr target, List<Expr> args) {
        String v = Macro.extractIdent(args.get(0));
        if (v == null) {
            throw new ErrorWithLocation(null, "argument is not an identifier");
        }
        Expr filter = args.get(1);
        Expr accuExpr = eh.ident(AccumulatorName);
        Expr init = eh.newList(new Expr[0]);
        Expr condition = eh.literalBool(true);
        Expr step = eh.globalCall(Operator.Add.id, accuExpr, eh.newList(args.get(0)));
        step = eh.globalCall(Operator.Conditional.id, filter, step, accuExpr);
        return eh.fold(v, target, AccumulatorName, init, condition, step, accuExpr);
    }

    static String extractIdent(Expr e) {
        if (e.getExprKindCase() == Expr.ExprKindCase.IDENT_EXPR) {
            return e.getIdentExpr().getName();
        }
        return null;
    }

    static Expr makeHas(ExprHelper eh, Expr target, List<Expr> args) {
        if (args.get(0).getExprKindCase() == Expr.ExprKindCase.SELECT_EXPR) {
            Expr.Select s = args.get(0).getSelectExpr();
            return eh.presenceTest(s.getOperand(), s.getField());
        }
        throw new ErrorWithLocation(null, "invalid argument to has() macro");
    }

    public String function() {
        return this.function;
    }

    public boolean isReceiverStyle() {
        return this.receiverStyle;
    }

    public boolean isVarArgStyle() {
        return this.varArgStyle;
    }

    public int argCount() {
        return this.argCount;
    }

    public MacroExpander expander() {
        return this.expander;
    }

    public String macroKey() {
        if (this.varArgStyle) {
            return Macro.makeVarArgMacroKey(this.function, this.receiverStyle);
        }
        return Macro.makeMacroKey(this.function, this.argCount, this.receiverStyle);
    }

    static enum QuantifierKind {
        quantifierAll,
        quantifierExists,
        quantifierExistsOne;

    }
}

