/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.common.types.pb;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.projectnessie.cel.common.ULong;
import org.projectnessie.cel.common.types.pb.Checked;
import org.projectnessie.cel.common.types.pb.Db;
import org.projectnessie.cel.common.types.pb.Description;
import org.projectnessie.cel.common.types.pb.PbTypeDescription;
import org.projectnessie.cel.relocated.com.google.api.expr.v1alpha1.Type;
import org.projectnessie.cel.relocated.com.google.protobuf.ByteString;
import org.projectnessie.cel.relocated.com.google.protobuf.Descriptors;
import org.projectnessie.cel.relocated.com.google.protobuf.DynamicMessage;
import org.projectnessie.cel.relocated.com.google.protobuf.EnumValue;
import org.projectnessie.cel.relocated.com.google.protobuf.MapEntry;
import org.projectnessie.cel.relocated.com.google.protobuf.Message;
import org.projectnessie.cel.relocated.com.google.protobuf.NullValue;

public final class FieldDescription
extends Description {
    final FieldDescription keyType;
    final FieldDescription valueType;
    private final Descriptors.FieldDescriptor desc;
    private final Class<?> reflectType;
    private final Message zeroMsg;

    public static FieldDescription newFieldDescription(Descriptors.FieldDescriptor fieldDesc) {
        Class reflectType;
        Objects.requireNonNull(fieldDesc);
        DynamicMessage zeroMsg = null;
        block0 : switch (fieldDesc.getJavaType()) {
            case ENUM: {
                reflectType = Enum.class;
                break;
            }
            case MESSAGE: {
                zeroMsg = DynamicMessage.getDefaultInstance(fieldDesc.getMessageType());
                reflectType = PbTypeDescription.reflectTypeOf(zeroMsg);
                break;
            }
            default: {
                reflectType = FieldDescription.reflectTypeOfField(fieldDesc);
                if (!fieldDesc.isRepeated() || fieldDesc.isMapField()) break;
                Descriptors.FieldDescriptor.Type t = fieldDesc.getType();
                switch (t.getJavaType()) {
                    case ENUM: {
                        reflectType = Enum.class;
                        break block0;
                    }
                    case MESSAGE: {
                        reflectType = fieldDesc.getMessageType().toProto().getDefaultInstanceForType().getClass();
                        break block0;
                    }
                    case BOOLEAN: {
                        reflectType = Boolean.class;
                        break block0;
                    }
                    case BYTE_STRING: {
                        reflectType = byte[].class;
                        break block0;
                    }
                    case DOUBLE: {
                        reflectType = Double.class;
                        break block0;
                    }
                    case FLOAT: {
                        reflectType = Float.class;
                        break block0;
                    }
                    case INT: {
                        if (t == Descriptors.FieldDescriptor.Type.UINT32 || t == Descriptors.FieldDescriptor.Type.FIXED32) {
                            reflectType = ULong.class;
                            break block0;
                        }
                        reflectType = Integer.class;
                        break block0;
                    }
                    case LONG: {
                        if (t == Descriptors.FieldDescriptor.Type.UINT64 || t == Descriptors.FieldDescriptor.Type.FIXED64) {
                            reflectType = ULong.class;
                            break block0;
                        }
                        reflectType = Long.class;
                        break block0;
                    }
                    case STRING: {
                        reflectType = String.class;
                    }
                }
            }
        }
        if (fieldDesc.isRepeated() && !fieldDesc.isMapField()) {
            reflectType = Array.newInstance(reflectType, 0).getClass();
        }
        FieldDescription keyType = null;
        FieldDescription valType = null;
        if (fieldDesc.isMapField()) {
            keyType = FieldDescription.newFieldDescription(fieldDesc.getMessageType().findFieldByNumber(1));
            valType = FieldDescription.newFieldDescription(fieldDesc.getMessageType().findFieldByNumber(2));
        }
        return new FieldDescription(keyType, valType, fieldDesc, reflectType, zeroMsg);
    }

    private static Class<?> reflectTypeOfField(Descriptors.FieldDescriptor fieldDesc) {
        switch (fieldDesc.getType()) {
            case DOUBLE: {
                return Double.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case STRING: {
                return String.class;
            }
            case BOOL: {
                return Boolean.class;
            }
            case BYTES: {
                return ByteString.class;
            }
            case INT32: 
            case SFIXED32: 
            case SINT32: {
                return Integer.class;
            }
            case INT64: 
            case SFIXED64: 
            case SINT64: {
                return Long.class;
            }
            case UINT32: 
            case UINT64: 
            case FIXED32: 
            case FIXED64: {
                return ULong.class;
            }
            case ENUM: {
                return Enum.class;
            }
        }
        return PbTypeDescription.reflectTypeOf(fieldDesc.getDefaultValue());
    }

    private FieldDescription(FieldDescription keyType, FieldDescription valueType, Descriptors.FieldDescriptor desc, Class<?> reflectType, Message zeroMsg) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.desc = desc;
        this.reflectType = reflectType;
        this.zeroMsg = zeroMsg;
    }

    public Type checkedType() {
        if (this.desc.isMapField()) {
            return Type.newBuilder().setMapType(Type.MapType.newBuilder().setKeyType(this.keyType.typeDefToType()).setValueType(this.valueType.typeDefToType())).build();
        }
        if (this.desc.isRepeated()) {
            return Type.newBuilder().setListType(Type.ListType.newBuilder().setElemType(this.typeDefToType())).build();
        }
        return this.typeDefToType();
    }

    public Descriptors.FieldDescriptor descriptor() {
        return this.desc;
    }

    public boolean isSet(Object target) {
        if (target instanceof Message) {
            Message v = (Message)target;
            Descriptors.Descriptor pbDesc = v.getDescriptorForType();
            if (pbDesc == this.desc.getContainingType()) {
                return FieldDescription.hasValueForField(this.desc, v);
            }
            return FieldDescription.hasValueForField(pbDesc.findFieldByName(this.name()), v);
        }
        return false;
    }

    public Object getFrom(Db db, Object target) {
        if (!(target instanceof Message)) {
            throw new IllegalArgumentException(String.format("unsupported field selection target: (%s)%s", target.getClass().getName(), target));
        }
        Message v = (Message)target;
        Descriptors.Descriptor pbDesc = v.getDescriptorForType();
        Descriptors.FieldDescriptor fd = pbDesc == this.desc.getContainingType() ? this.desc : pbDesc.findFieldByName(this.name());
        Object fieldVal = FieldDescription.getValueFromField(fd, v);
        Class<?> fieldType = fieldVal.getClass();
        if (fd.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE || fieldType.isPrimitive() || fieldType.isEnum() || fieldType == byte[].class || fieldType == Boolean.class || fieldType == Byte.class || fieldType == Short.class || fieldType == Integer.class || fieldType == Long.class || fieldType == Float.class || fieldType == Double.class || fieldType == String.class) {
            return fieldVal;
        }
        if (fieldType == ULong.class) {
            return ((ULong)fieldVal).longValue();
        }
        if (fieldVal instanceof EnumValue) {
            return (long)((EnumValue)fieldVal).getNumber();
        }
        if (fieldVal instanceof Message) {
            return this.maybeUnwrapDynamic(db, (Message)fieldVal);
        }
        throw new UnsupportedOperationException("IMPLEMENT ME");
    }

    public boolean isEnum() {
        return this.desc.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM;
    }

    public boolean isMap() {
        return this.desc.isMapField();
    }

    public boolean isMessage() {
        return this.desc.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE;
    }

    public boolean isOneof() {
        return this.desc.getContainingOneof() != null;
    }

    public boolean isList() {
        return this.desc.isRepeated() && !this.desc.isMapField();
    }

    public Object maybeUnwrapDynamic(Db db, Message msg) {
        return PbTypeDescription.unwrapDynamic(db, this, msg);
    }

    public String name() {
        return this.desc.getName();
    }

    public Class<?> reflectType() {
        boolean r = this.desc.isRepeated();
        if (r && this.desc.isMapField()) {
            return Map.class;
        }
        switch (this.desc.getJavaType()) {
            case ENUM: 
            case MESSAGE: {
                return this.reflectType;
            }
            case BOOLEAN: {
                return r ? Boolean[].class : Boolean.class;
            }
            case BYTE_STRING: {
                return r ? ByteString[].class : ByteString.class;
            }
            case DOUBLE: {
                return r ? Double[].class : Double.class;
            }
            case FLOAT: {
                return r ? Float[].class : Float.class;
            }
            case INT: {
                return r ? Integer[].class : Integer.class;
            }
            case LONG: {
                return r ? Long[].class : Long.class;
            }
            case STRING: {
                return r ? String[].class : String.class;
            }
        }
        return this.reflectType;
    }

    @Override
    public Message zero() {
        return this.zeroMsg;
    }

    public Type typeDefToType() {
        switch (this.desc.getJavaType()) {
            case MESSAGE: {
                String msgType = this.desc.getMessageType().getFullName();
                Type wk = Checked.CheckedWellKnowns.get(msgType);
                if (wk != null) {
                    return wk;
                }
                return Checked.checkedMessageType(msgType);
            }
            case ENUM: {
                return Checked.checkedInt;
            }
            case BOOLEAN: {
                return Checked.checkedBool;
            }
            case BYTE_STRING: {
                return Checked.checkedBytes;
            }
            case DOUBLE: 
            case FLOAT: {
                return Checked.checkedDouble;
            }
            case INT: {
                if (this.desc.getType() == Descriptors.FieldDescriptor.Type.UINT32 || this.desc.getType() == Descriptors.FieldDescriptor.Type.FIXED32) {
                    return Checked.checkedUint;
                }
                return Checked.checkedInt;
            }
            case LONG: {
                if (this.desc.getType() == Descriptors.FieldDescriptor.Type.UINT64 || this.desc.getType() == Descriptors.FieldDescriptor.Type.FIXED64) {
                    return Checked.checkedUint;
                }
                return Checked.checkedInt;
            }
            case STRING: {
                return Checked.checkedString;
            }
        }
        throw new UnsupportedOperationException("Unknown JavaType " + (Object)((Object)this.desc.getJavaType()));
    }

    public String toString() {
        return this.checkedType().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldDescription that = (FieldDescription)o;
        return Objects.equals(this.desc, that.desc) && Objects.equals(this.reflectType, that.reflectType);
    }

    public int hashCode() {
        return Objects.hash(this.desc, this.reflectType);
    }

    public boolean hasField(Object target) {
        return FieldDescription.hasValueForField(this.desc, (Message)target);
    }

    public Object getField(Object target) {
        return FieldDescription.getValueFromField(this.desc, (Message)target);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getValueFromField(Descriptors.FieldDescriptor desc, Message message) {
        void var2_7;
        if (FieldDescription.isWellKnownType(desc) && !message.hasField(desc)) {
            return NullValue.NULL_VALUE;
        }
        Object object = message.getField(desc);
        if (!desc.isMapField() && !desc.isRepeated()) {
            Descriptors.FieldDescriptor.Type type = desc.getType();
            if (object == null || type != Descriptors.FieldDescriptor.Type.UINT32 && type != Descriptors.FieldDescriptor.Type.UINT64 && type != Descriptors.FieldDescriptor.Type.FIXED32 && type != Descriptors.FieldDescriptor.Type.FIXED64) return var2_7;
            ULong uLong = ULong.valueOf(((Number)object).longValue());
            return var2_7;
        } else if (desc.isMapField()) {
            if (!(object instanceof List)) return var2_7;
            List lst = (List)object;
            HashMap<void, void> map = new HashMap<void, void>(lst.size() * 4 / 3 + 1);
            for (Object e : lst) {
                void var8_21;
                void var7_17;
                if (e instanceof MapEntry) {
                    Object k = ((MapEntry)e).getKey();
                    Object v = ((MapEntry)e).getValue();
                } else {
                    if (!(e instanceof DynamicMessage)) throw new IllegalArgumentException(String.format("Unexpected %s (%s) in list of map fields", e.getClass(), e));
                    DynamicMessage dynMsg = (DynamicMessage)e;
                    List<Descriptors.FieldDescriptor> fields = dynMsg.getDescriptorForType().getFields();
                    if (fields.size() != 2) throw new IllegalArgumentException(String.format("Unexpected %s (%s) in list of map fields, dynamic message with != 2 fields", e.getClass(), e));
                    Object object2 = dynMsg.getField(fields.get(0));
                    Object object3 = dynMsg.getField(fields.get(1));
                }
                map.put(var7_17, var8_21);
            }
            HashMap<void, void> hashMap = map;
            return var2_7;
        } else {
            if (!desc.isRepeated()) return var2_7;
            Descriptors.FieldDescriptor.Type type = desc.getType();
            if (object == null || type != Descriptors.FieldDescriptor.Type.UINT32 && type != Descriptors.FieldDescriptor.Type.UINT64 && type != Descriptors.FieldDescriptor.Type.FIXED32 && type != Descriptors.FieldDescriptor.Type.FIXED64) return var2_7;
            ArrayList<ULong> result = new ArrayList<ULong>();
            List repeated = (List)object;
            for (Object e : repeated) {
                ULong uLong = ULong.valueOf(((Number)e).longValue());
                result.add(uLong);
            }
            ArrayList<ULong> arrayList = result;
        }
        return var2_7;
    }

    private static boolean isWellKnownType(Descriptors.FieldDescriptor desc) {
        if (desc.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            return false;
        }
        Type wellKnown = Checked.CheckedWellKnowns.get(desc.getMessageType().getFullName());
        if (wellKnown == null) {
            return false;
        }
        return wellKnown.hasWrapper();
    }

    public static boolean hasValueForField(Descriptors.FieldDescriptor desc, Message message) {
        if (desc.isRepeated()) {
            return message.getRepeatedFieldCount(desc) > 0;
        }
        return message.hasField(desc);
    }
}

