/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.ext;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.UniqueId;
import org.projectnessie.client.ext.NessieApiVersion;
import org.projectnessie.client.ext.NessieApiVersions;
import org.projectnessie.junit.engine.MultiEnvTestExtension;

public class MultiVersionApiTest
implements MultiEnvTestExtension,
ExecutionCondition {
    public static final String API_VERSION_SEGMENT_TYPE = "nessie-api";
    private static final NessieApiVersion DEFAULT_API_VERSION = NessieApiVersion.V2;

    public String segmentType() {
        return API_VERSION_SEGMENT_TYPE;
    }

    public List<String> allEnvironmentIds(ConfigurationParameters configuration) {
        return Arrays.stream(NessieApiVersion.values()).map(Enum::name).collect(Collectors.toList());
    }

    public boolean accepts(Class<?> testClass) {
        return AnnotationUtils.findAnnotation(testClass, NessieApiVersions.class).isPresent();
    }

    static NessieApiVersion apiVersion(ExtensionContext context) {
        return UniqueId.parse((String)context.getUniqueId()).getSegments().stream().filter(s -> API_VERSION_SEGMENT_TYPE.equals(s.getType())).map(UniqueId.Segment::getValue).findFirst().map(NessieApiVersion::valueOf).orElse(DEFAULT_API_VERSION);
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        NessieApiVersion apiVersion = MultiVersionApiTest.apiVersion(context);
        boolean matches = Arrays.asList(context.getTestMethod().flatMap(m -> AnnotationUtils.findAnnotation((AnnotatedElement)m, NessieApiVersions.class)).map(NessieApiVersions::versions).orElseGet(() -> AnnotationUtils.findAnnotation((AnnotatedElement)context.getRequiredTestClass(), NessieApiVersions.class).map(NessieApiVersions::versions).orElseGet(() -> new NessieApiVersion[]{DEFAULT_API_VERSION}))).contains((Object)apiVersion);
        return matches ? ConditionEvaluationResult.enabled(null) : ConditionEvaluationResult.disabled((String)String.format("API version %s is not applicable to test context %s", new Object[]{apiVersion, context.getUniqueId()}));
    }
}

