/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client;

import java.util.OptionalInt;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.projectnessie.client.ResultStreamPaginator;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.api.PagingBuilder;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.LogResponse;

public final class StreamingUtil {
    private StreamingUtil() {
    }

    public static Stream<EntriesResponse.Entry> getEntriesStream(@NotNull NessieApiV1 api, @NotNull String ref, @Nullable String hashOnRef, @Nullable String queryExpression, OptionalInt maxRecords) throws NessieNotFoundException {
        return new ResultStreamPaginator(EntriesResponse::getEntries, (ref1, pageSize, token) -> StreamingUtil.builderWithPagedQuery(api.getEntries(), ref1, hashOnRef, pageSize, token, queryExpression).get()).generateStream(ref, maxRecords);
    }

    public static Stream<CommitMeta> getCommitLogStream(@NotNull NessieApiV1 api, @NotNull String ref, @Nullable String hashOnRef, @Nullable String untilHash, @Nullable String queryExpression, OptionalInt maxRecords) throws NessieNotFoundException {
        return new ResultStreamPaginator(LogResponse::getOperations, (reference, pageSize, token) -> StreamingUtil.builderWithPagedQuery(api.getCommitLog(), reference, hashOnRef, pageSize, token, queryExpression).untilHash(untilHash).get()).generateStream(ref, maxRecords);
    }

    private static <B extends PagingBuilder<B>> B builderWithPagedQuery(B builder, String reference, String hashOnRef, Integer pageSize, String token, String queryExpression) {
        ((PagingBuilder)((PagingBuilder)builder.refName(reference)).hashOnRef(hashOnRef)).queryExpression(queryExpression);
        if (pageSize != null) {
            builder.maxRecords(pageSize);
        }
        if (token != null) {
            builder.pageToken(token);
        }
        return builder;
    }
}

