/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import java.util.Locale;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.projectnessie.api.params.FetchOption;
import org.projectnessie.api.v1.http.HttpTreeApi;
import org.projectnessie.api.v1.params.CommitLogParams;
import org.projectnessie.api.v1.params.EntriesParams;
import org.projectnessie.api.v1.params.GetReferenceParams;
import org.projectnessie.api.v1.params.Merge;
import org.projectnessie.api.v1.params.ReferencesParams;
import org.projectnessie.api.v1.params.Transplant;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpRequest;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.MergeResponse;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferencesResponse;

class HttpTreeClient
implements HttpTreeApi {
    private final HttpClient client;

    public HttpTreeClient(HttpClient client) {
        this.client = client;
    }

    public ReferencesResponse getAllReferences(ReferencesParams params) {
        return this.client.newRequest().path("trees").queryParam("maxRecords", params.maxRecords()).queryParam("pageToken", params.pageToken()).queryParam("fetch", FetchOption.getFetchOptionName((FetchOption)params.fetchOption())).queryParam("filter", params.filter()).get().readEntity(ReferencesResponse.class);
    }

    public Reference createReference(String sourceRefName, @NotNull Reference reference) throws NessieNotFoundException, NessieConflictException {
        return this.client.newRequest().path("trees/tree").queryParam("sourceRefName", sourceRefName).post(reference).readEntity(Reference.class);
    }

    public Reference getReferenceByName(@NotNull GetReferenceParams params) throws NessieNotFoundException {
        return this.client.newRequest().path("trees/tree/{ref}").queryParam("fetch", FetchOption.getFetchOptionName((FetchOption)params.fetchOption())).resolveTemplate("ref", params.getRefName()).get().readEntity(Reference.class);
    }

    public void assignReference(@NotNull Reference.ReferenceType referenceType, @NotNull String referenceName, @NotNull String expectedHash, @Valid @NotNull Reference assignTo) throws NessieNotFoundException, NessieConflictException {
        this.client.newRequest().path("trees/{referenceType}/{referenceName}").resolveTemplate("referenceType", referenceType.name().toLowerCase(Locale.ROOT)).resolveTemplate("referenceName", referenceName).queryParam("expectedHash", expectedHash).put(assignTo);
    }

    public void deleteReference(@NotNull Reference.ReferenceType referenceType, @NotNull String referenceName, @NotNull String expectedHash) throws NessieConflictException, NessieNotFoundException {
        this.client.newRequest().path("trees/{referenceType}/{referenceName}").resolveTemplate("referenceType", referenceType.name().toLowerCase(Locale.ROOT)).resolveTemplate("referenceName", referenceName).queryParam("expectedHash", expectedHash).delete();
    }

    public Branch getDefaultBranch() {
        return this.client.newRequest().path("trees/tree").get().readEntity(Branch.class);
    }

    public LogResponse getCommitLog(@NotNull String ref, @NotNull CommitLogParams params) throws NessieNotFoundException {
        HttpRequest builder = this.client.newRequest().path("trees/tree/{ref}/log").resolveTemplate("ref", ref);
        return builder.queryParam("maxRecords", params.maxRecords()).queryParam("pageToken", params.pageToken()).queryParam("filter", params.filter()).queryParam("startHash", params.startHash()).queryParam("endHash", params.endHash()).queryParam("fetch", FetchOption.getFetchOptionName((FetchOption)params.fetchOption())).get().readEntity(LogResponse.class);
    }

    public MergeResponse transplantCommitsIntoBranch(@NotNull String branchName, @NotNull String expectedHash, String message, @Valid Transplant transplant) throws NessieNotFoundException, NessieConflictException {
        return this.client.newRequest().path("trees/branch/{branchName}/transplant").resolveTemplate("branchName", branchName).queryParam("expectedHash", expectedHash).queryParam("message", message).post(transplant).readEntity(MergeResponse.class);
    }

    public MergeResponse mergeRefIntoBranch(@NotNull String branchName, @NotNull String expectedHash, @NotNull @Valid Merge merge) throws NessieNotFoundException, NessieConflictException {
        return this.client.newRequest().path("trees/branch/{branchName}/merge").resolveTemplate("branchName", branchName).queryParam("expectedHash", expectedHash).post(merge).readEntity(MergeResponse.class);
    }

    public EntriesResponse getEntries(@NotNull String refName, @NotNull EntriesParams params) throws NessieNotFoundException {
        HttpRequest builder = this.client.newRequest().path("trees/tree/{ref}/entries").resolveTemplate("ref", refName);
        return builder.queryParam("maxRecords", params.maxRecords()).queryParam("pageToken", params.pageToken()).queryParam("filter", params.filter()).queryParam("hashOnRef", params.hashOnRef()).queryParam("namespaceDepth", params.namespaceDepth() == null ? null : String.valueOf(params.namespaceDepth())).get().readEntity(EntriesResponse.class);
    }

    public Branch commitMultipleOperations(String branch, @NotNull String expectedHash, @NotNull Operations operations) throws NessieNotFoundException, NessieConflictException {
        return this.client.newRequest().path("trees/branch/{branchName}/commit").resolveTemplate("branchName", branch).queryParam("expectedHash", expectedHash).post(operations).readEntity(Branch.class);
    }
}

