/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.util.v2api;

import java.util.HashMap;
import java.util.List;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.GetNamespaceBuilder;
import org.projectnessie.client.api.NessieApiV2;
import org.projectnessie.client.api.UpdateNamespaceResult;
import org.projectnessie.client.builder.BaseUpdateNamespaceBuilder;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNamespaceNotFoundException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.CommitResponse;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ImmutableNamespace;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Operation;

public final class ClientSideUpdateNamespace
extends BaseUpdateNamespaceBuilder {
    private final NessieApiV2 api;

    public ClientSideUpdateNamespace(NessieApiV2 api) {
        this.api = api;
    }

    @Override
    public void update() throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException {
        this.updateWithResponse();
    }

    @Override
    public UpdateNamespaceResult updateWithResponse() throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException {
        ContentKey key = ContentKey.of((List)this.namespace.getElements());
        Namespace oldNamespace = ((GetNamespaceBuilder)((GetNamespaceBuilder)((GetNamespaceBuilder)this.api.getNamespace().refName(this.refName)).hashOnRef(this.hashOnRef)).namespace(this.namespace)).get();
        HashMap newProperties = new HashMap(oldNamespace.getProperties());
        this.propertyRemovals.forEach(newProperties::remove);
        newProperties.putAll(this.propertyUpdates);
        ImmutableNamespace.Builder builder = Namespace.builder().from(oldNamespace).properties(newProperties);
        try {
            String expectedHash = this.hashOnRef;
            if (expectedHash == null) {
                expectedHash = this.api.getReference().refName(this.refName).get().getHash();
            }
            ImmutableNamespace updatedNamespace = builder.build();
            CommitResponse commit = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName(this.refName)).hash(expectedHash)).commitMeta(CommitMeta.fromMessage((String)("update namespace " + key))).operation((Operation)Operation.Put.of((ContentKey)key, (Content)updatedNamespace, (Content)oldNamespace)).commitWithResponse();
            return UpdateNamespaceResult.of((Namespace)updatedNamespace, oldNamespace, commit.getTargetBranch());
        }
        catch (NessieNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (NessieConflictException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

